const mongoose = require('mongoose');

const VendorRegistrationMap = mongoose.Schema({
    clientId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
    },
    providerId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
    },
    providerEmail: {
      type: String
    },
    clientEmail: {
      type: String
    },
    RFCId: {
        type: String,
        required: true,
        index: true
    }, 

    status: {
        type: String,
        enum:["completed","pending"],
        default: "pending"
    },

});

module.exports =  mongoose.model('vendorRegistrationMap', VendorRegistrationMap);