const mongoose = require('mongoose');

const NotificationSchema = mongoose.Schema({
    directory: {
        type: String,
    },
    sender: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
    },
    receiver: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
    },
    year: {
        type: String,
    },
    month: {
        type: String,
    },
    type: {
        type: String,
    },
    is_read: {
        type: String,
        enum: [0, 1],
        default: 0
    },
    createdOn: {
        type: Date,
        default: Date.now
    },

});

module.exports = mongoose.model('notification', NotificationSchema);