const objectId = require('mongoose').Types.ObjectId;
const Mailgun = require('mailgun-js');
const Twig = require('twig');
const User = require('../models/user');
const notificationModel = require('../models/notification');
const Montharray = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
const { getNotificationTime } = require('../helper');
const model = require("mongoose").model;
module.exports = {
  getNotifications: async (req, res) => {
    try {
      const NotificationData = await notificationModel.find({ receiver: req.user._id }).lean();
      const Notificationcount = await notificationModel.find({ receiver: req.user._id, is_read: "0" }).count();
      let notification_res = [];
      let notificationResponse = [];
      for (let rowData of NotificationData) {
        try {
          let monthno = parseInt(rowData.month) - 1;
          rowData.month = Montharray[monthno];
          const userRecord = await User.findById(objectId(rowData.sender)).lean();
          rowData.companyname = userRecord.name;
          const date = new Date(rowData.createdOn).toUTCString();
          rowData.createdOn = getNotificationTime(date);
          notificationResponse.push(rowData)
        } catch (error) {
          console.log('error22' + error);
        }
      }
      notification_res.unreadcount = Notificationcount;
      notification_res.push({ 'unreadcount': Notificationcount, 'notificationdata': notificationResponse });
      res.status(200);
      return res.send(notification_res);
    } catch (e) {
      console.log(e);
      res.status(400);
      return res.send({ Error: 'Something went wrong, Could\'nt process your request' });
    }
  },

  readNotifications: async (req, res) => {
    try {
      const Notificationcount = await notificationModel.find({ receiver: req.user._id, is_read: "0" }).lean();
      const bulkOps = Notificationcount.map(obj => {
        return {
          updateOne: {
            filter: {
              _id: obj._id
            },
            update: {
              $set: {
                is_read: 1
              }
            }
          }
        }
      });
      const update = await notificationModel.bulkWrite(bulkOps);
      res.status(200);
      return res.send(true);

    } catch (e) {
      res.status(400);
      return res.send({ Error: 'Something went wrong, Could\'nt process your request3' });
    }
  },


}




