const objectId = require('mongoose').Types.ObjectId;
const Mailgun = require('mailgun-js');
const Twig = require('twig');
const User = require('../models/user');
const facturasModel = require('../models/facturas');
const { uploadClientFiles, getFilesFromS3, deleteClientFacturasFiles, sendfacturasfileuploademail } = require('../helper');
const Montharray = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
const InvoiceStatus = ["PENDIENTE", "PAGADO"];
module.exports = {

    getClientFacturas: async (req, res) => {
        // Fetch Authenticated User Data
        const authenticatedUser = await User.findById(req.user._id);
        let relationClientId = req.user._id;
        if ((authenticatedUser.roles == "client" || authenticatedUser.roles == "subclient")) {
            relationClientId = (authenticatedUser.roles == "subclient") ? authenticatedUser.clientId : authenticatedUser._id;
        }
        facturasModel.find({ clientId: objectId(relationClientId) }).lean().then((facturasData) => {
            if (facturasData) {
                facturasData.forEach((rowData) => {
                    let monthno = parseInt(rowData.month) - 1;
                    rowData.month = Montharray[monthno];
                    rowData.invoiceStatus = InvoiceStatus[rowData.invoiceStatus];
                    rowData.amount = formatter.format(rowData.amount);
                });
                res.status(200);
                return res.send(facturasData);
            }
            res.status(400);
            return res.send({ Error: "Cannot find the requested User." });
        }).catch((err) => {
            console.log(err);
            res.status(400);
            return res.send({ Error: "Cannot Process your Request." })
        })
    },


    getClientFacturasByid: (req, res) => {
        try {
            const { id } = req.params;
            if (id) {
                facturasModel.findById(objectId(id)).then((facturasData) => {
                    if (facturasData) {
                        res.status(200);
                        return res.send(facturasData);
                    }
                    res.status(400);
                    return res.send({ Error: "Cannot find the requested User." + id });
                }).catch((err) => {
                    console.log(err);
                    res.status(400);
                    return res.send({ Error: "Cannot Process your Request." })
                })
            } else {
                res.status(400);
                return res.send({ Error: "Parameters not valid, Please Try Again" });
            }
        } catch (e) {
            console.log(e);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }
    },

    uploadClientFfacturasInvoice: async (req, res) => {
        try {

            const { id } = req.body;
            const file = req.file.file;
            const uploadAllFiles = uploadClientFiles(file, id).then((data) => {
                res.status(200);
                return res.send({ response: uploadAllFiles });
            }).catch((e) => {
                res.status(400);
                return res.send({ Error: (e) ? e : "El documento que intentas subir es incorrecto, favor de validar su fecha, RFC y formato" });
            });

        } catch (e) {
            console.log(e);
            res.status(400);
            return res.send({ Error: 'Something went wrong, Could\'nt process your request' });
        }

    },

    getFacturasFiles: async (req, res) => {
        try {
            const { id } = req.params;
            const { type } = req.params;

            if (!id) {
                res.status(400);
                return res.send({ Error: "Id is not passed as param" });
            }

            const documentRequested = await facturasModel.findById(objectId(id)).lean();

            if (!documentRequested) {
                res.status(400);
                return res.send({ Error: "Error Fetching your Document" });
            }
            let filepath = "";
            if (type == "client") {
                filepath = documentRequested.clientfilepath;
            } else if (type == "xml") {
                filepath = documentRequested.xmls3path;
            } else {
                filepath = documentRequested.pdfs3path;
            }


            const documentURL = await getFilesFromS3(filepath);
            if (!documentURL) {
                res.status(400);
                return res.send({ Error: "Error Fetching your File" });
            }

            res.status(200);
            return res.send({ response: documentURL });

        } catch (e) {
            console.log(e);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }
    },



    deleteFacturasFiles: async (req, res) => {
        try {
            const { id } = req.params;

            if (!id) {
                res.status(400);
                return res.send({ Error: "Id is not passed as param" });
            }

            const removeFile = deleteClientFacturasFiles(id).then((data) => {
                res.status(200);
                return res.send({ response: "" });
            }).catch((e) => {
                res.status(400);
                return res.send({ Error: (e) ? e : "El documento que intentas subir es incorrecto, favor de validar su fecha, RFC y formato" });
            });

        } catch (e) {
            console.log(e);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }

    },


}
const formatter = new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
});