const Directory = require('../models/directory');
const accountsRelations = require('../models/accountsRelations');
const ClientContactInformation = require('../models/clientContactInformation');
const ProviderContactInformation = require('../models/providerContactInformation');
const objectId = require('mongoose').Types.ObjectId;

const {
    checkIfDirectoryBelongsToUser,
    findIndexOnObject,
    cleanUpDocumentData,
    ParseXMLFromDocument,
    parsePDFDataFromDocument,
    checkDisperancy,
    addYearsToDirectory,
    addMonthsToDirectory,
    checkAutorizacionSTPSDocStatus,
    checkDirectoryDataStatus,
    MonthFolderLockstatus
} = require('../helper');

/* Document Function. */
module.exports = {
    getDirectories: async (req, res) => {
        try {
            const { path } = req.body;
            const { id } = req.params;

            if (id) {
                // Find if the directory belongs to a user that is authenticated.
                const isOwnedByUser = await checkIfDirectoryBelongsToUser(id, req.user._id)
                if (isOwnedByUser) {
                    // If path then different approach otherwise different 
                    if (!path) {
                        // if only directory id, then lets give them basic structure of the directory, i.e
                        Directory.findOne({ _id: id }).lean().then((directoryData) => {
                            if (!directoryData) {
                                res.status(400);
                                return res.send({ Error: "Something Went Wrong, Please Try Again " });
                            }
                            result = [];
                            for (const property in directoryData.documentStatus) {
                                directoryData.documentStatus[property].name = property;
                                result.push(directoryData.documentStatus[property]);
                            }

                            res.status(200);
                            return res.send({ data: result });
                        }).catch((err) => {
                            res.status(400);
                            return res.send({ Error: "Something Went Wrong, Please Try Again " });
                        })
                    } else {
                        const params = path.split("/");
                        Directory.findOne({ _id: id }).then(async (directoryData) => {
                            if (!directoryData) {
                                res.status(400);
                                return res.send({ Error: "Something Went Wrong, Please Try Again " });
                            }
                            switch (params.length) {
                                // Only Year or One Time upload folder Names (Autorización STPS, Estatutos,Contrato);
                                case 1:
                                    const value = params[0];
                                    // If its a Folder Name, Get Folder Contents
                                    if (isNaN(value)) {
                                        if (value != 'Documentación Mensual') {
                                            // Get the index of the folder 
                                            const indexOfFolder = findIndexOnObject(value, directoryData.toJSON().documents["nonRecurring"], "name");
                                            const pathToFolder = `documents.nonRecurring[${indexOfFolder}].value`
                                            const options = {
                                                path: pathToFolder,
                                                model: 'Document',
                                                match: { isValid: true }
                                            }
                                            Directory.populate(directoryData, options, function (err, populatedDirectoryData) {
                                                const response = cleanUpDocumentData(populatedDirectoryData.toJSON().documents.nonRecurring[indexOfFolder].value)
                                                res.status(200);
                                                return res.send({
                                                    data: response
                                                });
                                            });
                                        } else {
                                            let documents = directoryData.toJSON().documents.reccuring;
                                            documents = documents.map((documentData) => {
                                                delete documentData.months;
                                                delete documentData._id;
                                                return documentData.year;
                                            });

                                            // Run the Consistency Algorithm, To Determine if we need to add any new years to the directory.
                                            const disperancy = checkDisperancy('year', documents);

                                            // If no Disperancy found in a year, Go ahead and Send data to the service.
                                            if (!disperancy) {
                                                res.status(200);
                                                return res.send({
                                                    data: documents
                                                });
                                            }

                                            // If there is Disperancy, Then Add the year to the Directory
                                            addYearsToDirectory(id, disperancy).then((data) => {
                                                res.status(200);
                                                return res.send({
                                                    data: data
                                                });
                                            }).catch((err) => {
                                                console.log(err);
                                                res.status(400);
                                                return res.send({ Error: "Something Went Wrong, Please Try Again " });
                                            });
                                        }
                                    }
                                    break;
                                // Year, Get Month for a year, given Documentación Mensual/Year
                                case 2:
                                    if (params[0] == "Documentación Mensual") {
                                        const year = params[1];
                                        const documents = directoryData.toJSON().documents.reccuring;

                                        let monthsData = [];
                                        let monthslockedData = this;
                                        monthslockedData = [];
                                        documents.forEach((documentData) => {
                                            if (documentData.year == year) {
                                                documentData.months.map((monthsObject) => {
                                                    monthsData.push(monthsObject.month);
                                                    monthslockedData[monthsObject.month] = monthsObject.islocked;
                                                });
                                            }
                                        });

                                        const disperancy = checkDisperancy('month', monthsData);

                                        // If no Disperancy found in a month, Go ahead and Send data to the service.
                                        if (!disperancy) {
                                            res.status(200);
                                            return res.send({
                                                data: monthsData,
                                                lockedData: monthslockedData
                                            });
                                        }

                                        // If there is Disperancy, Then Add the month to the year to the Directory
                                        addMonthsToDirectory(id, year, disperancy).then((data) => {
                                            res.status(200);
                                            return res.send({
                                                data: data,
                                                lockedData: monthslockedData
                                            });
                                        }).catch((err) => {
                                            console.log(err);
                                            res.status(400);
                                            return res.send({ Error: "Something Went Wrong, Please Try Again " });
                                        });
                                    }
                                    break;
                                // Month, Get Folders & Statuses inside the Month given years & month
                                case 3:
                                    if (params[0] == "Documentación Mensual") {
                                        const year = params[1];
                                        const month = params[2];
                                        const documents = directoryData.toJSON().documents.reccuring;
                                        let folderData = [];
                                        documents.forEach((documentData) => {
                                            if (documentData.year == year) {
                                                documentData.months.map((monthsObject) => {
                                                    if (monthsObject.month == month) {
                                                        monthsObject.documents.map((document) => {
                                                            folderData.push({
                                                                name: document.name,
                                                                isValidated: document.isValidated,
                                                                isRequired: document.isRequired
                                                            })
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                        res.status(200);
                                        return res.send({
                                            data: folderData
                                        });
                                    }
                                    break;
                                // Get Documents inside the Folder, given year, month & folder name
                                case 4:
                                    if (params[0] == "Documentación Mensual" && params[3] != "Resumen de Liquidación SUA") {
                                        const year = params[1];
                                        const month = params[2];
                                        const folderName = params[3];
                                        const documents = directoryData.toJSON().documents.reccuring;
                                        documents.forEach((documentData) => {
                                            if (documentData.year == year) {
                                                documentData.months.map((monthsObject) => {
                                                    if (monthsObject.month == month) {
                                                        monthsObject.documents.map((document) => {
                                                            if (document.name == folderName) {
                                                                // Year Index
                                                                const yearIndex = findIndexOnObject(year, directoryData.toJSON().documents["reccuring"], "year");
                                                                // This is the Month Index
                                                                const monthIndex = findIndexOnObject(month, directoryData.toJSON().documents["reccuring"][yearIndex].months, "month");;
                                                                // This depends on document Type
                                                                const documentTypeIndex = findIndexOnObject(folderName, directoryData.toJSON().documents["reccuring"][yearIndex].months[monthIndex].documents, "name");
                                                                // PathToFolder For population
                                                                const pathToFolder = `documents.reccuring[${yearIndex}].months[${monthIndex}].documents[${documentTypeIndex}].value`
                                                                const options = {
                                                                    path: pathToFolder,
                                                                    model: 'Document',
                                                                    match: { isValid: true }
                                                                }
                                                                Directory.populate(directoryData, options, function (err, populatedDirectoryData) {
                                                                    const response = cleanUpDocumentData(populatedDirectoryData.toJSON().documents.reccuring[yearIndex].months[monthIndex].documents[documentTypeIndex].value)
                                                                    res.status(200);
                                                                    return res.send({
                                                                        data: response
                                                                    });
                                                                });
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    } else if (params[0] == "Documentación Mensual" && params[3] == "Resumen de Liquidación SUA") {
                                        const year = params[1];
                                        const month = params[2];
                                        const folderName = params[3];
                                        const documents = directoryData.toJSON().documents.reccuring;
                                        let folderData = [];

                                        const promises = documents.map((documentData) => {
                                            if (documentData.year == year) {
                                                documentData.months.map((monthsObject) => {
                                                    if (monthsObject.month == month) {
                                                        monthsObject.documents.map((document) => {
                                                            if (document.name == folderName) {
                                                                // Year Index
                                                                const yearIndex = findIndexOnObject(year, directoryData.toJSON().documents["reccuring"], "year");
                                                                // This is the Month Index
                                                                const monthIndex = findIndexOnObject(month, directoryData.toJSON().documents["reccuring"][yearIndex].months, "month");;
                                                                // This depends on document Type
                                                                const documentTypeIndex = findIndexOnObject(folderName, directoryData.toJSON().documents["reccuring"][yearIndex].months[monthIndex].documents, "name");

                                                                const folderDocs = directoryData.toJSON().documents["reccuring"][yearIndex].months[monthIndex].documents[documentTypeIndex].documents;

                                                                folderDocs.map((document) => {
                                                                    folderData.push({
                                                                        name: document.name,
                                                                        isValidated: document.isValidated,
                                                                        isRequired: document.isRequired
                                                                    })
                                                                });
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });

                                        await Promise.all(promises);

                                        res.status(200);
                                        return res.send({
                                            data: folderData
                                        });
                                    }
                                    break;
                                case 5:
                                    if (params[0] == "Documentación Mensual" && params[3] == "Resumen de Liquidación SUA") {
                                        const year = params[1];
                                        const month = params[2];
                                        const folderName = params[3];
                                        const subfolderName = params[4]
                                        const documents = directoryData.toJSON().documents.reccuring;
                                        documents.forEach((documentData) => {
                                            if (documentData.year == year) {
                                                documentData.months.map((monthsObject) => {
                                                    if (monthsObject.month == month) {
                                                        monthsObject.documents.map((document) => {
                                                            if (document.name == folderName) {
                                                                // Year Index
                                                                const yearIndex = findIndexOnObject(year, directoryData.toJSON().documents["reccuring"], "year");
                                                                // This is the Month Index
                                                                const monthIndex = findIndexOnObject(month, directoryData.toJSON().documents["reccuring"][yearIndex].months, "month");;
                                                                // This depends on document Type
                                                                const documentTypeIndex = findIndexOnObject(folderName, directoryData.toJSON().documents["reccuring"][yearIndex].months[monthIndex].documents, "name");
                                                                // This depends on document Type
                                                                const subDocumentTypeIndex = findIndexOnObject(subfolderName, directoryData.toJSON().documents["reccuring"][yearIndex].months[monthIndex].documents[documentTypeIndex].documents, "name");
                                                                // PathToFolder For population
                                                                const pathToFolder = `documents.reccuring[${yearIndex}].months[${monthIndex}].documents[${documentTypeIndex}].documents[${subDocumentTypeIndex}].value`
                                                                const options = {
                                                                    path: pathToFolder,
                                                                    model: 'Document',
                                                                    match: { isValid: true }
                                                                }
                                                                Directory.populate(directoryData, options, function (err, populatedDirectoryData) {
                                                                    const response = cleanUpDocumentData(populatedDirectoryData.toJSON().documents.reccuring[yearIndex].months[monthIndex].documents[documentTypeIndex].documents[subDocumentTypeIndex].value)
                                                                    res.status(200);
                                                                    return res.send({
                                                                        data: response
                                                                    });
                                                                });
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    }
                                    break;
                                default:
                                    res.status(200);
                                    return res.send({ Error: "Wrong Parameters, Please Check Correctly" })
                                    break;
                            }
                        }).catch((err) => {
                            console.log(err);
                            res.status(400);
                            return res.send({ Error: "Something Went Wrong, Please Try Again " });
                        });
                    }
                } else {
                    res.status(400);
                    return res.send({ Error: "Unauthorized, Directory Doesn't belong to the User" });
                }
            } else {
                res.status(400);
                return res.send({ Error: "Parameters not valid, Please Try Again" });
            }
        } catch (e) {
            console.log(e);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }
    },
    getCFDISasCSV: async (req, res) => {
        try {
            const { id, year, month } = req.params;
            if (id && year && month) {
                // Find if the directory belongs to a user that is authenticated.
                const isOwnedByUser = await checkIfDirectoryBelongsToUser(id, req.user._id)
                if (isOwnedByUser) {
                    Directory.findOne({ _id: id }).then((directoryData) => {
                        if (!directoryData) {
                            res.status(400);
                            return res.send({ Error: "Something Went Wrong, Please Try Again " });
                        }
                        const folderName = "CFDIs";
                        const pdfFolderName = "SUA IMSS";
                        const documents = directoryData.toJSON().documents.reccuring;
                        documents.forEach((documentData) => {
                            if (documentData.year == year) {
                                documentData.months.map((monthsObject) => {
                                    if (monthsObject.month == month) {
                                        monthsObject.documents.map(async (document) => {
                                            if (document.name == folderName) {
                                                // Year Index
                                                const yearIndex = findIndexOnObject(year, directoryData.toJSON().documents["reccuring"], "year");
                                                // This is the Month Index
                                                const monthIndex = findIndexOnObject(month, directoryData.toJSON().documents["reccuring"][yearIndex].months, "month");;
                                                // This depends on document Type
                                                const documentTypeIndex = findIndexOnObject(folderName, directoryData.toJSON().documents["reccuring"][yearIndex].months[monthIndex].documents, "name");
                                                // PathToFolder For population
                                                const pathToFolder = `documents.reccuring[${yearIndex}].months[${monthIndex}].documents[${documentTypeIndex}].value`
                                                const options = {
                                                    path: pathToFolder,
                                                    model: 'Document'
                                                }

                                                // Find Index of PDF document in directory
                                                const pdfDocumentTypeIndex = findIndexOnObject(pdfFolderName, directoryData.toJSON().documents["reccuring"][yearIndex].months[monthIndex].documents, "name");
                                                // PathToFolder For population 
                                                const pathToPdfFolder = `documents.reccuring[${yearIndex}].months[${monthIndex}].documents[${pdfDocumentTypeIndex}].value`
                                                const pdfFolderoptions = {
                                                    path: pathToPdfFolder,
                                                    model: 'Document',
                                                    match: { isValid: true }
                                                }
                                                // Get documents array
                                                const pdfpopulatedDirectoryData = await Directory.populate(directoryData, pdfFolderoptions);

                                                const pdfDocumentObjectArray = pdfpopulatedDirectoryData.toJSON().documents.reccuring[yearIndex].months[monthIndex].documents[pdfDocumentTypeIndex].value;

                                                Directory.populate(directoryData, options, async function (err, populatedDirectoryData) {
                                                    const documentObjectArray = populatedDirectoryData.toJSON().documents.reccuring[yearIndex].months[monthIndex].documents[documentTypeIndex].value;
                                                    const response = await ParseXMLFromDocument(documentObjectArray, pdfDocumentObjectArray);
                                                    res.status(200);
                                                    return res.send({
                                                        data: response
                                                    });
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }).catch((err) => {
                        res.status(400);
                        return res.send({ Error: "Something Went Wrong, Please Try Again " });
                    });
                }
                else {
                    res.status(400);
                    return res.send({ Error: "Unauthorized, Directory Doesn't belong to the User" });
                }
            }
        } catch (e) {
            console.log(e);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }
    },
    getPDFData: async (req, res) => {
        try {
            const { id, year, month } = req.params;
            if (id && year && month) {
                // Find if the directory belongs to a user that is authenticated.
                const user = req.user;
                const isOwnedByUser = await checkIfDirectoryBelongsToUser(id, req.user._id)
                if (isOwnedByUser) {
                    Directory.findOne({ _id: id }).then(async (directoryData) => {
                        if (!directoryData) {
                            console.log("Directory not found");
                            res.status(400);
                            return res.send({ Error: "Something Went Wrong, Please Try Again " });
                        }
                        // const folderName = "CFDIs";
                        let response = {};
                        const documents = directoryData.toJSON().documents;
                        const result = await parsePDFDataFromDocument(id, user, year, month, documents);
                        // console.log(result);
                        res.status(200);
                        return res.send({
                            data: result
                        });
                    }).catch((err) => {
                        console.log(err);
                        res.status(400);
                        return res.send({ Error: "Something Went Wrong, Please Try Again " });
                    });
                }
                else {
                    res.status(400);
                    return res.send({ Error: "Unauthorized, Directory Doesn't belong to the User" });
                }
            }
        } catch (e) {
            console.log(e);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }
    },
    validateDirectory: async (req, res) => {
        try {
            const { id, folder } = req.params;

            if (id && folder) {
                // Find if the directory belongs to a user that is authenticated.
                const isOwnedByUser = await checkIfDirectoryBelongsToUser(id, req.user._id)
                if (isOwnedByUser) {
                    const value = folder;
                    Directory.findOne({ _id: id }).then(async (directoryData) => {
                        if (!directoryData) {
                            res.status(400);
                            return res.send({ Error: "Something Went Wrong, Please Try Again " });
                        }

                        // Get the index of the folder 
                        const indexOfFolder = findIndexOnObject(value, directoryData.toJSON().documents["nonRecurring"], "name");
                        const pathToFolder = `documents.nonRecurring[${indexOfFolder}].value`
                        const options = {
                            path: pathToFolder,
                            model: 'Document',
                            match: { isValid: true }
                        }
                        Directory.populate(directoryData, options, async function (err, populatedDirectoryData) {
                            const response = populatedDirectoryData.toJSON().documents.nonRecurring[indexOfFolder].value;
                            let isValid = false;
                            if (response.length) isValid = await checkAutorizacionSTPSDocStatus(response, id);
                            res.status(200);
                            return res.send({
                                isValid: isValid
                            });
                        });
                    }).catch((err) => {
                        res.status(400);
                        return res.send({ Error: "Something Went Wrong, Please Try Again " });
                    });
                } else {
                    res.status(400);
                    return res.send({ Error: "Unauthorized, Directory Doesn't belong to the User" });
                }
            } else {
                res.status(400);
                return res.send({ Error: "Parameters not valid, Please Try Again" });
            }
        } catch (e) {
            console.log(e);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }
    },
    checkMonthsDirectoryStatus: async (req, res) => {
        try {
            const { id, year, month } = req.params;
            if (id && year && month) {
                // Find if the directory belongs to a user that is authenticated.
                const user = req.user;
                const isOwnedByUser = await checkIfDirectoryBelongsToUser(id, req.user._id)
                if (isOwnedByUser) {
                    Directory.findOne({ _id: id }).then(async (directoryData) => {
                        if (!directoryData) {
                            console.log("Directory not found");
                            res.status(400);
                            return res.send({ Error: "Something Went Wrong, Please Try Again " });
                        }

                        const result = await checkDirectoryDataStatus(year, month, directoryData);
                        // console.log(result);
                        res.status(200);
                        return res.send({
                            data: result
                        });
                    }).catch((err) => {
                        console.log(err);
                        res.status(400);
                        return res.send({ Error: "Something Went Wrong, Please Try Again " });
                    });
                }
                else {
                    res.status(400);
                    return res.send({ Error: "Unauthorized, Directory Doesn't belong to the User" });
                }
            } else {
                res.status(400);
                return res.send({ Error: "Invalid request" });
            }
        } catch (e) {
            console.log(e);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }
    },
    saveContactInfo: async (req, res) => {
        try {
            const { id } = req.params;
            const { userType, razonSocial, domicilio, responsable, cargo, correoElectronico, telefono_y_extension, tipo_de_servicio } = req.body;

            if (id && userType) {
                // Find if the directory belongs to a user that is authenticated.
                const isOwnedByUser = await checkIfDirectoryBelongsToUser(id, req.user._id)

                if (isOwnedByUser) {
                    const DirectoryAccountMap = await accountsRelations.findOne({ directory: objectId(id) }).lean();

                    if (DirectoryAccountMap) {
                        const clientId = DirectoryAccountMap.clientId;
                        const providerId = DirectoryAccountMap.providerId;

                        if (userType == 'client') {
                            let contactInfo = await ClientContactInformation.findOne({ clientId: objectId(clientId) });
                            if (!contactInfo) {
                                contactInfo = new ClientContactInformation();
                                contactInfo.clientId = clientId;
                            } else {

                            }

                            razonSocial ? contactInfo.razonSocial = razonSocial : '';
                            domicilio ? contactInfo.domicilio = domicilio : '';
                            responsable ? contactInfo.responsable = responsable : '';
                            cargo ? contactInfo.cargo = cargo : '';
                            correoElectronico ? contactInfo.correoElectronico = correoElectronico : '';
                            telefono_y_extension ? contactInfo.telefono_y_extension = telefono_y_extension : '';
                            tipo_de_servicio ? contactInfo.tipo_de_servicio = tipo_de_servicio : '';

                            contactInfo.save().then((sucess) => {
                                if (!sucess) {
                                    res.status(400);
                                    return res.send({ Error: "Information not saved, please try again" });
                                }

                                res.status(200);
                                return res.send({ message: 'Information saved successfully' })
                            }).catch((err) => {
                                // Console the Error
                                console.log(err);

                                res.status(400);
                                return res.send({ Error: "Cannot Process your Request." })
                            });
                        } else {
                            let contactInfo = await ProviderContactInformation.findOne({ directory: objectId(id), providerId: objectId(providerId) });
                            if (!contactInfo) {
                                contactInfo = new ProviderContactInformation();
                                contactInfo.directory = id;
                                contactInfo.providerId = providerId;
                            }

                            razonSocial ? contactInfo.razonSocial = razonSocial : '';
                            domicilio ? contactInfo.domicilio = domicilio : '';
                            responsable ? contactInfo.responsable = responsable : '';
                            cargo ? contactInfo.cargo = cargo : '';
                            correoElectronico ? contactInfo.correoElectronico = correoElectronico : '';
                            telefono_y_extension ? contactInfo.telefono_y_extension = telefono_y_extension : '';
                            tipo_de_servicio ? contactInfo.tipo_de_servicio = tipo_de_servicio : '';

                            contactInfo.save().then((sucess) => {
                                if (!sucess) {
                                    res.status(400);
                                    return res.send({ Error: "Information not saved, please try again" });
                                }

                                res.status(200);
                                return res.send({ message: 'Information saved successfully' })
                            }).catch((err) => {
                                // Console the Error
                                console.log(err);

                                res.status(400);
                                return res.send({ Error: "Cannot Process your Request." })
                            });
                        }

                    } else {
                        res.status(400);
                        return res.send({ Error: 'Something went wrong, Incorrect Params' });
                    }
                } else {
                    res.status(400);
                    return res.send({ Error: "Unauthorized, Directory Doesn't belong to the User" });
                }
            } else {
                res.status(400);
                return res.send({ Error: "Parameters not valid, Please Try Again" });
            }
        } catch (err) {
            console.log(err);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }

    },
    getContactInfo: async (req, res) => {
        try {
            const { id } = req.params;

            if (id) {
                // Find if the directory belongs to a user that is authenticated.
                const isOwnedByUser = await checkIfDirectoryBelongsToUser(id, req.user._id)

                if (isOwnedByUser) {
                    const DirectoryAccountMap = await accountsRelations.findOne({ directory: objectId(id) }).lean();

                    if (DirectoryAccountMap) {
                        const clientId = DirectoryAccountMap.clientId;
                        const providerId = DirectoryAccountMap.providerId;

                        let client = await ClientContactInformation.findOne({ clientId: objectId(clientId) }).lean();
                        let provider = await ProviderContactInformation.findOne({ directory: objectId(id), providerId: objectId(providerId) }).lean();

                        res.status(200);
                        return res.send({ client, provider });

                    } else {
                        res.status(400);
                        return res.send({ Error: 'Something went wrong, Incorrect Params' });
                    }
                } else {
                    res.status(400);
                    return res.send({ Error: "Unauthorized, Directory Doesn't belong to the User" });
                }
            } else {
                res.status(400);
                return res.send({ Error: "Parameters not valid, Please Try Again" });
            }
        } catch (err) {
            console.log(err);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }
    },

    monthLock: async (req, res) => {
        try {
            const { id } = req.params;
            const { pathYear, month } = req.body;
            if (id) {
                // Find if the directory belongs to a user that is authenticated.
                const isOwnedByUser = await checkIfDirectoryBelongsToUser(id, req.user._id)

                if (isOwnedByUser) {
                    const DirectoryAccountMap = await accountsRelations.findOne({ directory: objectId(id) }).lean();

                    if (DirectoryAccountMap) {
                        let monthfolderlockstatus = await Directory.findOne({ _id: objectId(id) }).lean();
                        // Year Index
                        const yearIndex = findIndexOnObject(pathYear, monthfolderlockstatus.documents["reccuring"], "year");
                        const monthIndex = findIndexOnObject(month, monthfolderlockstatus.documents["reccuring"][yearIndex].months, "month");
                        let monthfolderlockData = monthfolderlockstatus.documents.reccuring[yearIndex].months[monthIndex].islocked;
                        let islocked = "";
                        let notistatus = ""
                        if (monthfolderlockData == "true") {
                            islocked = false;
                            notistatus = "locked"
                        } else {
                            islocked = true;
                            notistatus = "unlocked"
                        }
                        let userId = req.user._id;
                        let islockfolder = await MonthFolderLockstatus(id, pathYear, month, islocked, userId, notistatus);

                        res.status(200);
                        return res.send({ islocked });

                    } else {
                        res.status(400);
                        return res.send({ Error: 'Something went wrong, Incorrect Params' });
                    }
                } else {
                    res.status(400);
                    return res.send({ Error: "Unauthorized, Directory Doesn't belong to the User" });
                }
            } else {
                res.status(400);
                return res.send({ Error: "Parameters not valid, Please Try Again" });
            }
        } catch (err) {
            console.log(err);
            res.status(400);
            return res.send({ Error: "Something Went wrong, Please Try Again" });
        }
    },

}