# Japanese (ja) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                      | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ---------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                                 | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                    | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                                 | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                    | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 第 1 四半期                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第 2 四半期                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 第 1 四半期                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第 2 四半期                                          | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                    | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | 2 月                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7 月                                                 | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | 2 月                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7 月                                                 | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                    | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                    | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | 2 月                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7 月                                                 | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | 2 月                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7 月                                                 | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                    | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                    | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                   | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                    | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                   | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11 日                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 日                                                | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                                  | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | 月曜日                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金曜日                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                    | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | 月曜日                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金曜日                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                    | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | 月曜日                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金曜日                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                    | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | 月曜日                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金曜日                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | 月                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 金                                                   | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 午前                                                 | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | 朝                                                   | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                                   | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                                 | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | 朝                                                   | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                                   | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                                 | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | 朝                                                   | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                                   | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                                 | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | 朝                                                   | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                                   | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                                 | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | 朝                                                   | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午後                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 夜                                                   | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 深夜                                                 | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                   | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                   | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                    | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                   | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                    | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                   | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 1987/02/11                                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29                                           | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 1987/02/11                                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29                                           | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 1987 年 2 月 11 日                                   | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 年 5 月 29 日                                   | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | 1987 年 2 月 11 日水曜日                             | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 年 5 月 29 日日曜日                             | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                                | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                             | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                       | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                       | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12 時 13 分 14 秒 GMT+00:00                          | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23 時 59 分 59 秒 GMT+00:00                          | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 1987/02/11 12:13                                     | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29 23:59                                     | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 1987/02/11 12:13:14                                  | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453/05/29 23:59:59                                  | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 1987 年 2 月 11 日 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 年 5 月 29 日 23:59:59 GMT+0                    | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | 1987 年 2 月 11 日水曜日 12 時 13 分 14 秒 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 年 5 月 29 日日曜日 23 時 59 分 59 秒 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `includeSeconds: true` | `addSuffix: true` |
| ------------------------ | --------- | ---------------------- | ----------------- |
| 2006-01-01T00:00:00.000Z | 約 6 年   | 約 6 年                | 約 6 年後         |
| 2005-01-01T00:00:00.000Z | 約 5 年   | 約 5 年                | 約 5 年後         |
| 2004-01-01T00:00:00.000Z | 約 4 年   | 約 4 年                | 約 4 年後         |
| 2003-01-01T00:00:00.000Z | 約 3 年   | 約 3 年                | 約 3 年後         |
| 2002-01-01T00:00:00.000Z | 約 2 年   | 約 2 年                | 約 2 年後         |
| 2001-06-01T00:00:00.000Z | 1 年以上  | 1 年以上               | 1 年以上後        |
| 2001-02-01T00:00:00.000Z | 約 1 年   | 約 1 年                | 約 1 年後         |
| 2001-01-01T00:00:00.000Z | 約 1 年   | 約 1 年                | 約 1 年後         |
| 2000-06-01T00:00:00.000Z | 5 か月    | 5 か月                 | 5 か月後          |
| 2000-03-01T00:00:00.000Z | 2 か月    | 2 か月                 | 2 か月後          |
| 2000-02-01T00:00:00.000Z | 約 1 か月 | 約 1 か月              | 約 1 か月後       |
| 2000-01-15T00:00:00.000Z | 14 日     | 14 日                  | 14 日後           |
| 2000-01-02T00:00:00.000Z | 1 日      | 1 日                   | 1 日後            |
| 2000-01-01T06:00:00.000Z | 約 6 時間 | 約 6 時間              | 約 6 時間後       |
| 2000-01-01T01:00:00.000Z | 約 1 時間 | 約 1 時間              | 約 1 時間後       |
| 2000-01-01T00:45:00.000Z | 約 1 時間 | 約 1 時間              | 約 1 時間後       |
| 2000-01-01T00:30:00.000Z | 30 分     | 30 分                  | 30 分後           |
| 2000-01-01T00:15:00.000Z | 15 分     | 15 分                  | 15 分後           |
| 2000-01-01T00:01:00.000Z | 1 分      | 1 分                   | 1 分後            |
| 2000-01-01T00:00:25.000Z | 1 分未満  | 30 秒                  | 約 1 分後         |
| 2000-01-01T00:00:15.000Z | 1 分未満  | 20 秒未満              | 約 1 分後         |
| 2000-01-01T00:00:05.000Z | 1 分未満  | 10 秒未満              | 約 1 分後         |
| 2000-01-01T00:00:00.000Z | 1 分未満  | 5 秒未満               | 約 1 分前         |
| 1999-12-31T23:59:55.000Z | 1 分未満  | 10 秒未満              | 約 1 分前         |
| 1999-12-31T23:59:45.000Z | 1 分未満  | 20 秒未満              | 約 1 分前         |
| 1999-12-31T23:59:35.000Z | 1 分未満  | 30 秒                  | 約 1 分前         |
| 1999-12-31T23:59:00.000Z | 1 分      | 1 分                   | 1 分前            |
| 1999-12-31T23:45:00.000Z | 15 分     | 15 分                  | 15 分前           |
| 1999-12-31T23:30:00.000Z | 30 分     | 30 分                  | 30 分前           |
| 1999-12-31T23:15:00.000Z | 約 1 時間 | 約 1 時間              | 約 1 時間前       |
| 1999-12-31T23:00:00.000Z | 約 1 時間 | 約 1 時間              | 約 1 時間前       |
| 1999-12-31T18:00:00.000Z | 約 6 時間 | 約 6 時間              | 約 6 時間前       |
| 1999-12-30T00:00:00.000Z | 2 日      | 2 日                   | 2 日前            |
| 1999-12-15T00:00:00.000Z | 17 日     | 17 日                  | 17 日前           |
| 1999-12-01T00:00:00.000Z | 約 1 か月 | 約 1 か月              | 約 1 か月前       |
| 1999-11-01T00:00:00.000Z | 2 か月    | 2 か月                 | 2 か月前          |
| 1999-06-01T00:00:00.000Z | 7 か月    | 7 か月                 | 7 か月前          |
| 1999-01-01T00:00:00.000Z | 約 1 年   | 約 1 年                | 約 1 年前         |
| 1998-12-01T00:00:00.000Z | 約 1 年   | 約 1 年                | 約 1 年前         |
| 1998-06-01T00:00:00.000Z | 1 年以上  | 1 年以上               | 1 年以上前        |
| 1998-01-01T00:00:00.000Z | 約 2 年   | 約 2 年                | 約 2 年前         |
| 1997-01-01T00:00:00.000Z | 約 3 年   | 約 3 年                | 約 3 年前         |
| 1996-01-01T00:00:00.000Z | 約 4 年   | 約 4 年                | 約 4 年前         |
| 1995-01-01T00:00:00.000Z | 約 5 年   | 約 5 年                | 約 5 年前         |
| 1994-01-01T00:00:00.000Z | 約 6 年   | 約 6 年                | 約 6 年前         |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ------ | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 年   | 6 年後            | 52608 時間                     |
| 2005-01-01T00:00:00.000Z | 5 年   | 5 年後            | 43848 時間                     |
| 2004-01-01T00:00:00.000Z | 4 年   | 4 年後            | 35064 時間                     |
| 2003-01-01T00:00:00.000Z | 3 年   | 3 年後            | 26304 時間                     |
| 2002-01-01T00:00:00.000Z | 2 年   | 2 年後            | 17544 時間                     |
| 2001-06-01T00:00:00.000Z | 1 年   | 1 年後            | 12408 時間                     |
| 2001-02-01T00:00:00.000Z | 1 年   | 1 年後            | 9528 時間                      |
| 2001-01-01T00:00:00.000Z | 1 年   | 1 年後            | 8784 時間                      |
| 2000-06-01T00:00:00.000Z | 5 か月 | 5 か月後          | 3648 時間                      |
| 2000-03-01T00:00:00.000Z | 2 か月 | 2 か月後          | 1440 時間                      |
| 2000-02-01T00:00:00.000Z | 1 か月 | 1 か月後          | 744 時間                       |
| 2000-01-15T00:00:00.000Z | 14 日  | 14 日後           | 336 時間                       |
| 2000-01-02T00:00:00.000Z | 1 日   | 1 日後            | 24 時間                        |
| 2000-01-01T06:00:00.000Z | 6 時間 | 6 時間後          | 6 時間                         |
| 2000-01-01T01:00:00.000Z | 1 時間 | 1 時間後          | 1 時間                         |
| 2000-01-01T00:45:00.000Z | 45 分  | 45 分後           | 1 時間                         |
| 2000-01-01T00:30:00.000Z | 30 分  | 30 分後           | 1 時間                         |
| 2000-01-01T00:15:00.000Z | 15 分  | 15 分後           | 0 時間                         |
| 2000-01-01T00:01:00.000Z | 1 分   | 1 分後            | 0 時間                         |
| 2000-01-01T00:00:25.000Z | 25 秒  | 25 秒後           | 0 時間                         |
| 2000-01-01T00:00:15.000Z | 15 秒  | 15 秒後           | 0 時間                         |
| 2000-01-01T00:00:05.000Z | 5 秒   | 5 秒後            | 0 時間                         |
| 2000-01-01T00:00:00.000Z | 0 秒   | 0 秒前            | 0 時間                         |
| 1999-12-31T23:59:55.000Z | 5 秒   | 5 秒前            | 0 時間                         |
| 1999-12-31T23:59:45.000Z | 15 秒  | 15 秒前           | 0 時間                         |
| 1999-12-31T23:59:35.000Z | 25 秒  | 25 秒前           | 0 時間                         |
| 1999-12-31T23:59:00.000Z | 1 分   | 1 分前            | 0 時間                         |
| 1999-12-31T23:45:00.000Z | 15 分  | 15 分前           | 0 時間                         |
| 1999-12-31T23:30:00.000Z | 30 分  | 30 分前           | 1 時間                         |
| 1999-12-31T23:15:00.000Z | 45 分  | 45 分前           | 1 時間                         |
| 1999-12-31T23:00:00.000Z | 1 時間 | 1 時間前          | 1 時間                         |
| 1999-12-31T18:00:00.000Z | 6 時間 | 6 時間前          | 6 時間                         |
| 1999-12-30T00:00:00.000Z | 2 日   | 2 日前            | 48 時間                        |
| 1999-12-15T00:00:00.000Z | 17 日  | 17 日前           | 408 時間                       |
| 1999-12-01T00:00:00.000Z | 1 か月 | 1 か月前          | 744 時間                       |
| 1999-11-01T00:00:00.000Z | 2 か月 | 2 か月前          | 1464 時間                      |
| 1999-06-01T00:00:00.000Z | 7 か月 | 7 か月前          | 5136 時間                      |
| 1999-01-01T00:00:00.000Z | 1 年   | 1 年前            | 8760 時間                      |
| 1998-12-01T00:00:00.000Z | 1 年   | 1 年前            | 9504 時間                      |
| 1998-06-01T00:00:00.000Z | 2 年   | 2 年前            | 13896 時間                     |
| 1998-01-01T00:00:00.000Z | 2 年   | 2 年前            | 17520 時間                     |
| 1997-01-01T00:00:00.000Z | 3 年   | 3 年前            | 26280 時間                     |
| 1996-01-01T00:00:00.000Z | 4 年   | 4 年前            | 35064 時間                     |
| 1995-01-01T00:00:00.000Z | 5 年   | 5 年前            | 43824 時間                     |
| 1994-01-01T00:00:00.000Z | 6 年   | 6 年前            | 52584 時間                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result              |
| ------------------------ | ------------------- |
| 2000-01-10T00:00:00.000Z | 2000/01/10          |
| 2000-01-05T00:00:00.000Z | 翌週の水曜日の 0:00 |
| 2000-01-02T00:00:00.000Z | 明日の 0:00         |
| 2000-01-01T00:00:00.000Z | 今日の 0:00         |
| 1999-12-31T00:00:00.000Z | 昨日の 0:00         |
| 1999-12-27T00:00:00.000Z | 先週の月曜日の 0:00 |
| 1999-12-21T00:00:00.000Z | 1999/12/21          |
