"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildRouter = void 0;
const tslib_1 = require("tslib");
const admin_bro_1 = require("admin-bro");
const express_1 = require("express");
const express_formidable_1 = tslib_1.__importDefault(require("express-formidable"));
const path_1 = tslib_1.__importDefault(require("path"));
const errors_1 = require("./errors");
const logger_1 = require("./logger");
const INVALID_ADMIN_BRO_INSTANCE = "You have to pass an instance of AdminBro to the buildRouter() function";
const buildRouter = (admin, predefinedRouter, formidableOptions) => {
    var _a;
    if (((_a = admin === null || admin === void 0 ? void 0 : admin.constructor) === null || _a === void 0 ? void 0 : _a.name) !== "AdminBro") {
        throw new errors_1.WrongArgumentError(INVALID_ADMIN_BRO_INSTANCE);
    }
    admin.initialize().then(() => {
        logger_1.log.debug("AdminBro: bundle ready");
    });
    const { routes, assets } = admin_bro_1.Router;
    const router = predefinedRouter !== null && predefinedRouter !== void 0 ? predefinedRouter : express_1.Router();
    router.use(express_formidable_1.default(formidableOptions));
    routes.forEach((route) => {
        // we have to change routes defined in AdminBro from {recordId} to :recordId
        const expressPath = route.path.replace(/{/g, ":").replace(/}/g, "");
        const handler = async (req, res, next) => {
            try {
                const controller = new route.Controller({ admin }, req.session && req.session.adminUser);
                const { params, query } = req;
                const method = req.method.toLowerCase();
                const payload = Object.assign(Object.assign({}, (req.fields || {})), (req.files || {}));
                const html = await controller[route.action](Object.assign(Object.assign({}, req), { params,
                    query,
                    payload,
                    method }), res);
                if (route.contentType) {
                    res.set({ "Content-Type": route.contentType });
                }
                if (html) {
                    res.send(html);
                }
            }
            catch (e) {
                next(e);
            }
        };
        if (route.method === "GET") {
            router.get(expressPath, handler);
        }
        if (route.method === "POST") {
            router.post(expressPath, handler);
        }
    });
    assets.forEach((asset) => {
        router.get(asset.path, async (req, res) => {
            res.sendFile(path_1.default.resolve(asset.src));
        });
    });
    return router;
};
exports.buildRouter = buildRouter;
//# sourceMappingURL=buildRouter.js.map