"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withLogout = void 0;
const getLogoutPath = (admin) => {
    const { logoutPath, rootPath } = admin.options;
    const normalizedLogoutPath = logoutPath.replace(rootPath, "");
    return normalizedLogoutPath.startsWith("/")
        ? normalizedLogoutPath
        : `/${normalizedLogoutPath}`;
};
const withLogout = (router, admin) => {
    const logoutPath = getLogoutPath(admin);
    router.get(logoutPath, async (request, response) => {
        request.session.destroy(() => {
            response.redirect(admin.options.loginPath);
        });
    });
};
exports.withLogout = withLogout;
//# sourceMappingURL=logout.handler.js.map