/**
 *
 * Generates class name for given component. It is used by AdminBro core to append namespaced
 * classes.
 *
 * ### example
 *
 * ```javascript
 * import { cssClass } from '@admin-bro/design-system'
 *
 * cssClass('Icon', 'my-regular-class-name')
 * // returns: 'admin-bro_Icon my-regular-class-name'
 * ```
 *
 *
 * @param {string | Array<string>} className
 * @param {string}                [regularClass]
 * @memberof module:@admin-bro/design-system
 */
declare const cssClass: (className: string | Array<string>, regularClass?: string | undefined) => string;
export { cssClass as default, cssClass, };
