import React from 'react';
/**
 * @alias PaginationProps
 * @memberof Pagination
 */
export declare type PaginationProps = {
    /**
     * Current page
     */
    page: number;
    /**
     * Items per page
     */
    perPage: number;
    /**
     * Total number of items
     */
    total: number;
    /**
     * location. You can pass window.location or the location object
     * given by ReactRouter
     */
    location?: Location;
    /**
     * Triggers when user clicks any of the button
     */
    onChange: (pageNumber: number) => void;
};
/**
 * @classdesc
 *
 * <img src="components/pagination.png" />
 *
 * Pagination component
 *
 * ### Usage
 *
 * ```javascript
 * import { Pagination, PaginationProps } from '@admin-bro/design-system'
 * ```
 *
 * @component
 * @subcategory Molecules
 * @hideconstructor
 * @see PaginationProps
 * @see {@link https://storybook.adminbro.com/?path=/story/designsystem-molecules-pagination--default Storybook}
 * @example
 * const location = { search: ''}
 * return (
 *   <Text py="xl" textAlign="center">
 *     <Pagination
 *      total={100}
 *      page={4}
 *      perPage={10}
 *      location={location}
 *      onChange={(item) => alert(`clicked ${item}`)}
 *   />
 *   </Text>
 * )
 * @section design-system
 */
declare const Pagination: React.FC<PaginationProps>;
export { Pagination };
export default Pagination;
