const mongoose = require('mongoose');

const ZipExtractedDocument = mongoose.Schema({
    directory : {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Directory'
    },
    zipDocument : {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'zipDocument'
    },
    documentType : {
        type: String
    },
    year: {
        type: String
    },
    month: {
        type: String,
        enum:[1, 2,3, 4, 5, 6, 7, 8,9, 10,11,12],
    },
    isRecurring: {
        type: Boolean,
        default: true
    },
    name  : {
        type: String
    },
    path : {
        type: String
    },
    contentType : {
        type: String
    },
    isDataExtracted: {
        type: Boolean,
        default: false
    },
    isSelected: {
        type: Boolean,
        default: false
    },
    error : {
        type: String,
        default: ''
    },
    date: {
        type: Date,
        default: new Date()
    }
});

module.exports =  mongoose.model('zipExtractedDocument', ZipExtractedDocument);