const mongoose = require('mongoose');

const ZipDocument = mongoose.Schema({
    directory : {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Directory'
    },
    documentType : {
        type: String
    },
    year: {
        type: String
    },
    month: {
        type: String,
        enum:[1, 2,3, 4, 5, 6, 7, 8,9, 10,11,12],
    },
    path: {
        type: String
    },
    isRecurring: {
        type: Boolean,
        default: true
    },
    isExtracted: {
        type: Boolean,
        default: false
    },
    date: {
        type: Date,
        default: new Date()
    }

});

module.exports =  mongoose.model('zipDocument', ZipDocument);