const mongoose = require('mongoose');
const bcrypt = require('bcrypt');

const ClientListSchema = mongoose.Schema({
  name :{
    type: String, default:""
  },

  email :{
    type: String ,
    required: true,
    lowercase: true
  },

  username :{
    type: String,
    required: true,
    lowercase: true
  },

  createdOn :{
    type: Date,
    default: Date.now
  },

  password: {
    type: String,
    required: true
  },

  roles: {
      type: String,
			enum:["client","provider","subclient","admin"],
      required: true,
  },

  rfc: {
      type:String,
      required: true,
  },

  isValid :{
    type: Boolean,
    default: true
  },

  isActive :{
    type: Boolean,
    default: false
  },

  tel: {
    type:String,
    default:""
  },

  referenceToken : {
    type:String,
  },

  activationToken : {
    type:String
  },

  clientId : {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'clientList'
}
});



module.exports =  mongoose.model('clientList', ClientListSchema);