const User = require('../models/user');
const objectId = require('mongoose').Types.ObjectId;
const AccountsRelations = require('../models/accountsRelations');
const VendorRegistrationMap = require('../models/vendorRegistrationMap');
const ChatModel = require('../models/chat');


module.exports = {
    sendMessage: async (req, res) => {
        try {
            let id = req.user._id;
            let { directory, message } = req.body;
            let account = await AccountsRelations.findOne({ directory: objectId(directory) });
            let receiverId = account.clientId;
            if (objectId(id) == account.clientId) {
                receiverId = providerId;
            }
            await ChatModel.create({ directory, receiverId, message, senderId: id, seen:false });
            return res.status(200).send({ msg: "Sent!" });
        } catch (e) {
            return res.status(400).send({ Error: "Something Went wrong, Please Try Again" });
        }
    },

    getMessage: async (req, res) => {
        // try {
            const { id } = req.params;
            let userid = req.user._id;
            let chats = await ChatModel.find({ directory: objectId(id) }).populate({path: 'senderId', select: 'name email roles rfc' });
            await ChatModel.updateMany({directory: objectId(id), receiverId: objectId(userid), seen: false },{seen: true});
            return res.status(200).send(chats);
        // } catch (e) {
        //     return res.status(400).send({ Error: "Something Went wrong, Please Try Again" });
        // }
    },

    deleteMessage: async (req, res) => {
        try {
            const { id } = req.params;
            await ChatModel.deleteOne({ _id: objectId(id) });
            return res.status(200).send({ msg: 'Deleted!' });
        } catch (e) {
            return res.status(400).send({ Error: "Something Went wrong, Please Try Again" });
        }
    },

    getCountUnseenMsg: async (req, res) => {
        try {
            const { id } = req.params;
            let userId = req.user._id;
            let count = await ChatModel.countDocuments({ directory: objectId(id), receiverId: objectId(userId), seen: false });
            return res.status(200).send({ count });
        } catch (e) {
            return res.status(400).send({ Error: "Something Went wrong, Please Try Again" });
        }
    },

}