var express = require('express');
var router = express.Router();
const {
  extractZipDocument,
  extractDataFromZipDocument
} = require('../src/controllers/document');
const {
  sendNotificationEmail
} = require('../src/controllers/user');

const { getFacturasClientList} = require('../src/controllers/facturas');

/* API ROUTE */
router.get('/', function(req, res, next) {
  res.status(200);
  res.send("<div><h3>Ebitsa API Backend,</h3><p>Please contact support to access APIs.</p></div>")
});

router.get('/heatlh', function(req, res, next) {
  res.status(200);
  res.send({Health : "OK"})
});

router.get('/extract/zip/documents',extractZipDocument);                              // Extract Documents from zip
router.get('/extract/zip/documentsData',extractDataFromZipDocument);                  // Extract Data from zip documents
router.get('/notification/email', sendNotificationEmail);                             // Send notification to supplier
router.get('/facturas/getClient',getFacturasClientList);                        

module.exports = router;