import { Theme, ThemeOverride } from './default-theme.interface';
/**
 * Applies new styles to the default theme
 *
 * ### Example
 *
 * ```jsx
 * import { combineStyles } from '@admin-bro/design-system`
 *
 * const myTheme = combineStyles({
 *   colors: {
 *     primary100: '#000'
 *   }
 * })
 * ```
 *
 * @param   {Partial<Theme>}         newTheme
 * @memberof module:@admin-bro/design-system
 *
 * @return  {Theme}
 */
declare const combineStyles: (newTheme: ThemeOverride) => Theme;
export { combineStyles };
