"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = exports.SingleButtonInGroup = void 0;
const react_1 = __importDefault(require("react"));
const box_1 = __importDefault(require("../../atoms/box/box"));
const icon_1 = __importDefault(require("../../atoms/icon"));
const button_group_styled_1 = require("./button-group.styled");
exports.SingleButtonInGroup = (props) => {
    const { icon, label, buttons, source, onClick } = props, buttonProps = __rest(props, ["icon", "label", "buttons", "source", "onClick"]);
    const onClickHandler = onClick ? (event) => onClick(event, source) : undefined;
    return (react_1.default.createElement(button_group_styled_1.StyledSingleButton, Object.assign({ as: "a", hasLabel: !!label, onClick: onClickHandler }, buttonProps),
        icon ? (react_1.default.createElement(icon_1.default, { icon: icon })) : '',
        label,
        buttons && buttons.length && label ? (react_1.default.createElement(box_1.default, { as: "span", mr: "-8px", ml: "md" },
            react_1.default.createElement(icon_1.default, { icon: "CaretDown" }))) : ''));
};
exports.default = exports.SingleButtonInGroup;
