"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = exports.DropDownItemWithButtons = void 0;
const react_1 = __importDefault(require("react"));
const icon_1 = __importDefault(require("../../atoms/icon"));
const drop_down_1 = require("../../molecules/drop-down");
const button_group_styled_1 = require("./button-group.styled");
exports.DropDownItemWithButtons = (props) => {
    const { variant, onClick, href, icon, label, buttons, source } = props, rest = __rest(props, ["variant", "onClick", "href", "icon", "label", "buttons", "source"]);
    const onClickHandler = onClick ? (event) => onClick(event, source) : undefined;
    return (react_1.default.createElement(drop_down_1.DropDownItem, { colorVariant: variant, p: 0 },
        react_1.default.createElement(button_group_styled_1.StyledDropDownItemAction, Object.assign({ onClick: onClickHandler, href: href, as: "a", hasLabel: !!label }, rest),
            buttons && buttons.length ? (react_1.default.createElement(icon_1.default, { icon: "CaretLeft", ml: "-24px", mr: "0" })) : '',
            icon ? react_1.default.createElement(icon_1.default, { icon: icon }) : '',
            label),
        buttons && buttons.length ? (react_1.default.createElement(drop_down_1.DropDownMenu, null, buttons.map((button) => (react_1.default.createElement(exports.DropDownItemWithButtons, Object.assign({}, button, { key: button.label })))))) : ''));
};
exports.default = exports.DropDownItemWithButtons;
