const bcrypt = require('bcrypt');
const { CountTotalAccount, CountTotalUploadedFiles, getClientName } = require('../helper');
const canModifyUsers = ({ currentAdmin }) => currentAdmin

const options = {
  properties: {
    name: {    isVisible: { edit: true, show: true, list: true, filter: true } },
    email: {   isVisible: { edit: true, show: true, list: true, filter: true } },
    tel: {     isVisible: { edit: true, show: true, list: true, filter: false } },
    roles: {   isVisible: { edit: false, show: true, list: true, filter: true } },
  createdOn: { isVisible: { edit: false, show: true, list: true, filter: false }},
   isActive: { isVisible: { edit: true, show: true, list: false, filter: false } },
    isValid: { isVisible: { edit: true, show: true, list: false, filter: false } },
    rfc:     { isVisible: { edit: true, show: true, list: false, filter: false } },
    password:     { isVisible: { edit: false, show: false, list: false, filter: false } },
    referenceToken:     { isVisible: { edit: false, show: false, list: false, filter: false } },
    activationToken:     { isVisible: { edit: false, show: false, list: false, filter: false } },
    TotalAccounts:     { isVisible: { edit: false, show: false, list: false, filter: false } },
    _id:     { isVisible: { edit: false, show: false, list: false, filter: false } },
    TotalProviders: {  type: 'number',  isVisible: { edit: false, show: true, list: false, filter: false }  },
    CurrentMonthDocuments: { type: 'number', isVisible: { edit: false, show: true, list: false, filter: false } },
    LastMonthDocuments: { type: 'number', isVisible: { edit: false, show: true, list: false, filter: false } },
    ClientName: { type: 'string', isVisible: { edit: false, show: true, list: false, filter: false } },
    clientId: { isVisible: { edit: false, show: false, list: false, filter: false } },
    username: { isVisible: { edit: false, show: true, list: true, filter: false } }
 },
  actions: {
        new: {
          before: async (request) => {
            if(request.payload.record.password) {
              request.payload.record = {
                ...request.payload.record,
                password: await bcrypt.hash(request.payload.record.password, 10),
              }
            }
            return request
          },
        },
        show:{
          isAccessible: canModifyUsers,
          handler: async (request, response, data) => {
            if (!data.record) {
              throw new NotFoundError([
                `Record of given id ("${request.params.recordId}") could not be found`,
              ].join('\n'), 'Action#handler')
            }
           data.record.params.TotalProviders=  await CountTotalAccount(request.params.recordId);
           data.record.params.CurrentMonthDocuments =  await CountTotalUploadedFiles(request.params.recordId,"current_month");
           data.record.params.LastMonthDocuments =  await CountTotalUploadedFiles(request.params.recordId,"last_month");
           data.record.params.ClientName =  (data.record.params.roles == "provider")? await getClientName(request.params.recordId) : '';
            return {

              record: data.record.toJSON(data.currentAdmin),
            }
          },
        },

        edit: { isAccessible: canModifyUsers },
        delete: { isAccessible: canModifyUsers },
        new: { isAccessible: canModifyUsers },
      }

};

module.exports = { options: options };