const mongoose = require('mongoose');
const bcrypt = require('bcrypt');

const ChatSchema = mongoose.Schema({
    directory: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'directories'
    },

    senderId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
    },
    receiverId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
    },
    message: {
        type: String,
    },
    seen:{
        type: Boolean,
    }
},
{
    timestamps: true,
}
);

module.exports = mongoose.model('chat', ChatSchema);