const mongoose = require('mongoose');
// const {createNewDirectory} = require('../helper');
const Directory = require('./directory');
const {monthlyDocumentsTemplate,nonRecurringDocumentsTemplate} = require('../utility');

const createNewDirectory = () => {
    return new Promise((resolve, reject) => {
        try {
            const d = new Date();
            const currentYear = d.getFullYear();
            const currentMonth = d.getMonth() + 1;

            let directory = new Directory();

            if (currentMonth == 1) {
                directory.documents.reccuring = [
                    {
                        year : currentYear - 1,
                        months : [
                            {
                                month : 11,
                                documents : monthlyDocumentsTemplate
                            },
                            {
                                month : 12,
                                documents : monthlyDocumentsTemplate
                            }
                        ]
                    },
                    {
                        year : currentYear,
                        months : [
                            {
                                month : currentMonth,
                                documents : monthlyDocumentsTemplate
                            }
                        ]
                    }
                ];
            } else if (currentMonth == 2) {
                directory.documents.reccuring = [
                    {
                        year : currentYear - 1,
                        months : [
                            {
                                month : 12,
                                documents : monthlyDocumentsTemplate
                            }
                        ]
                    },
                    {
                        year : currentYear,
                        months : [
                            {
                                month : currentMonth - 1,
                                documents : monthlyDocumentsTemplate
                            },
                            {
                                month : currentMonth,
                                documents : monthlyDocumentsTemplate
                            }
                        ]
                    }
                ];
            } else {
                directory.documents.reccuring = [
                    {
                        year : currentYear,
                        months : [
                            {
                                month : currentMonth - 2,
                                documents : monthlyDocumentsTemplate
                            },
                            {
                                month : currentMonth - 1,
                                documents : monthlyDocumentsTemplate
                            },
                            {
                                month : currentMonth,
                                documents : monthlyDocumentsTemplate
                            }
                        ]
                    }
                ];
            }
            directory.documents.nonRecurring = nonRecurringDocumentsTemplate

            directory.save().then((directory) => {
                if(!directory){
                    reject(false);
                }
                console.log("New Directory Created : ", directory._id.toString())

                resolve(directory._id);
            }).catch((err) => {
                // Console the Error
                console.log(err);

                reject(false)
            });
        }catch(e){
            console.log(e);
            reject(false);
        }
    });
}

const accountRelationsSchema = mongoose.Schema({
    clientId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    },

    providerId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    }, 

    status: {
        type: String,
        enum:["active","suspended"],
        default: "active"
    },

    directory : {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Directory'
    }

});

// Before Saving run this hook
accountRelationsSchema.pre(
    'save',
    async function(next) {
      const accountsRelations = this;
      this.directory = await createNewDirectory();
      next();
    }
    
  );

module.exports =  mongoose.model('accountsRelations', accountRelationsSchema);