const jwt = require('jsonwebtoken');
const passport = require("passport");
const generator = require('generate-password');
const {sendOTPinMail,sendResetOTPinMail} = require('../helper');
const User = require('../models/user');
const VendorRegistrationMap = require('../models/vendorRegistrationMap');
const accountsRelations = require('../models/accountsRelations');

/* Auth Controller. */

module.exports = {
    
    // Login Controller

    login : async (req, res) => {
        passport.authenticate(
        'login',
        async (err, user, errorMessage) => {
            try {
            if (err || !user) {
                res.status(400);
                return res.send({errorMessage});
            }
    
            req.login(
                user,
                { session: false },
                async (error) => {
                if (error) {
                    res.status(400);
                    return res.send({error : error});
                }
    
                const body = { _id: user._id, email: user.email };
                const token = jwt.sign({ user: body }, process.env.JWT_SECRET);
                const response = {
                    email : user.email,
                    isValid: user.isValid,
                    isActive: user.isActive,
                    createdOn: user.createdOn,
                    roles: user.roles,
                    rfc: user.rfc,
                    token: token
                }
                res.status(200);
                return res.json(response);
                }
            );
            } catch (error) {
                res.status(400);
                return res.send({error : error});
            }
        }
        )(req, res);
    }, 
    
    // Register new accounts

    registration : async (req, res) => {

        // Send Verification OTP in the email,
        sendOTPinMail(req.user.email, req.user.activationToken, req.user.username);

        res.status(200);
        return res.send({
        message: 'User Registration Successfull, Please Check for email for the OTP'
        });
    },  

     // Verify the user, Using OTP
     verify : (req, res) => {

        // Code from Body
        const {code,email} = req.body;

        if(code){
            User.findOne({email: email, activationToken: code}).then((userData) => {
                if(!userData){
                    res.status(400);
                    return res.send({Error: "No User Found."})    
                }
                userData.isActive = true;
                userData.activationToken = "";
                userData.save().then((userData) => {
                    
                    // Check if the user is a provider, if so then check if there is an entry for the provider in the vendorRegistrationMap Model
                    // If there is an entry for the user with the same RFC then map it to the client and create accountsRelation.
                    if(userData.roles = "provider"){
                        VendorRegistrationMap.findOne({RFCId: userData.rfc, providerEmail: userData.email, status: "pending"}).then((vendorRegistrationData) => {
                            if(!vendorRegistrationData){
                                res.status(200);
                                return res.send({Sucess: "User Validated Successfully"})
                            }
                            
                            // Add account relation for the same, if found.
                            // Add the provider-client relation to AccountsRelation Schema
                            let newAccountsRelations = new accountsRelations();
                            newAccountsRelations.clientId = vendorRegistrationData.clientId;
                            newAccountsRelations.providerId = userData._id;
                            newAccountsRelations.save().then((sucess) => {
                                if(!sucess) {
                                    res.status(400);
                                    return res.send({Error: "User Registration Sucessfull, But couldn't add the user to the client, Please Try Again"});
                                }

                                // Vendor Registration is sucessfull
                                vendorRegistrationData.status = "completed";
                                vendorRegistrationData.save();

                                res.status(200);
                                return res.send({message: "User Registration Sucessfull, Provider Added Successfully"});
                                
                            }).catch((err) => {
                                // Console the Error
                                console.log(err);
                    
                                res.status(400);
                                return res.send({Error: "Cannot Process your Request."})
                            });
                        }).catch((err) => {
                            // Console the Error
                            console.log(err);
                            res.status(400);
                            return res.send({Error: "User Registration Sucessfull, But couldn't add the user to the client, Please Try Again"});
                                })
                    }

                    // Check if the user is a client, if so then check if there is an entry for the client in the vendorRegistrationMap Model
                    // If there is an entry for the user with the same RFC then map it to the provider and create accountsRelation.
                    if(userData.roles = "client"){
                        VendorRegistrationMap.findOne({RFCId: userData.rfc, clientEmail: userData.email, status: "pending"}).then((vendorRegistrationData) => {
                            if(!vendorRegistrationData){
                                res.status(200);
                                return res.send({Sucess: "User Registration Successfully"})
                            }
                            
                            // Add account relation for the same, if found.
                            // Add the provider-client relation to AccountsRelation Schema
                            let newAccountsRelations = new accountsRelations();
                            newAccountsRelations.providerId  = vendorRegistrationData.providerId;
                            newAccountsRelations.clientId = userData._id;
                            newAccountsRelations.save().then((sucess) => {
                                if(!sucess) {
                                    res.status(400);
                                    return res.send({Error: "User Registration Successful, But couldn't add the user to the client, Please Try Again"});
                                }

                                // Vendor Registration is sucessfull
                                vendorRegistrationData.status = "completed";
                                vendorRegistrationData.save();

                                res.status(200);
                                return res.send({message: "User Registration Successful, Client Added Successfully"});
                                
                            }).catch((err) => {
                                // Console the Error
                                console.log(err);
                    
                                res.status(400);
                                return res.send({Error: "Cannot Process your Request."})
                            });
                        }).catch((err) => {
                            // Console the Error
                            console.log(err);
                            res.status(400);
                            return res.send({Error: "User Registration Successful, But couldn't add the user to the provider, Please Try Again"});
                        })
                    }

                }).catch((err) => {
                    // Console the Error
                    console.log(err);
                    
                    res.status(400);
                    return res.send({Error: "Cannot Process your Request."})
                });
            }).catch((err) => {
                // Console the Error
                console.log(err);
    
                res.status(400);
                return res.send({Error: "Cannot Process your Request."})
            })
        }else{
            res.status(400);
            return res.send({Error: "Please Proceed with Verification Code"});
        }
    }, 

    // Reset Password from forget password link
    resetPassword: (req,res) => {
        try{
            const {email} = req.body;
            switch(req.path){
                case '/reset_password':
                    if (email){
                        User.findOne({email: email, isActive: true}).then((userData) => {
                            if(!userData){
                                throw {custom : "Invalid User"}
                            }
                            const password = generator.generate({length: 10,numbers: true});
                            userData.password = password;
                            userData.save().then((user) => {
                                if(!user){
                                    throw {custom : "Error Reseting Password, Please Try Again."}
                                }

                                // Send the Email
                                sendResetOTPinMail(user.email, password);
                                
                                res.status(200);
                                return res.send({Sucess: "Reset Password Succesfully, Please Check Email"});
                            }).catch((e) =>{
                                res.status(400);
                                return res.send({Error: (e.custom)? e.custom : "Sorry, Something went wrong."});
                            });
                        }).catch((e) => {
                            res.status(400);
                            return res.send({Error: (e.custom)? e.custom : "Sorry, Something went wrong."});
                        });
                    }else{
                        throw {custom : "Incorrect Params, Please Specify Valid Email."}
                    }
                break;
                // Deprecitated Feature, Not needed anymore, we directly send password to the user.
                case '/reset_password/verify':
                    const {code,password} = req.body;
                    if(email && code && password){
                        User.findOne({email: email, activationToken : code , isActive: true}).then((userData) => {
                            if(!userData){
                                throw {custom : "Invalid User"}
                            }
                            userData.password = password;
                            userData.save().then((user) => {
                                if(!user){
                                    throw {custom : "Error Reseting Password, Please Try Again."}
                                }

                                res.status(200);
                                return res.send({Sucess: "Sucess, Password Resetted"});

                            }).catch((e) =>{
                                res.status(400);
                                return res.send({Error: (e.custom)? e.custom : "Sorry, Something went wrong."});
                            })
                        }).catch((e) => {
                            res.status(400);
                            return res.send({Error: (e.custom)? e.custom : "Sorry, Something went wrong."});
                        });
                    }else{
                        throw {custom : "Incorrect Params, Please Specify Valid Email,Code & Valid Password"}
                    }
                break;
                default:
                    throw {custom : "Sorry, Something went wrong."}
            }
        }catch(e){
            console.log(e);
            res.status(400);
            return res.send({Error: (e.custom)? e.custom : "Sorry, Something went wrong."});
        }
    },

    // resend OTP if requested
    resendOTP: (req,res) => {
        const {email} = req.query;
        try{
            if(!email){
                throw {custom : "Invalid User"}
            }
            User.findOne({email: email, isActive: false}).then((userData) => {
                if(!userData){
                    res.status(401);
                    return res.send({Error: "User Not Found / Already Verified"});
                }
                // Send the Email
                sendOTPinMail(userData.email, userData.activationToken);
                
                res.status(200);
                return res.send({Sucess: "OTP Send to the user"});
            }).catch((e) => {
                res.status(400);
                return res.send({Error: (e.custom)? e.custom : "Sorry, Something went wrong."});
            })
        }catch(e){
            console.log(e);
            res.status(400);
            return res.send({Error: (e.custom)? e.custom : "Sorry, Something went wrong."});
        }
    }
}