import React from 'react'
import { Props } from './props.type'

export const FlagInCog: React.FC<Props> = (props) => {
  const { width, height, theme } = props
  const svgWidth = width || '152px'
  const svgHeight = height || '169px'
  return (
    <svg width={svgWidth} height={svgHeight} viewBox="0 0 152 169" version="1.1" xmlns="http://www.w3.org/2000/svg">
      <g id="Symbols" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
        <g id="Group" transform="translate(2.000000, 2.000000)" stroke={theme.colors.primary60} strokeWidth="3">
          <path d="M74,102.060611 L74,158.723567 C74,162.037275 71.3137085,164.723567 68,164.723567 C66.9452118,164.723567 65.9090627,164.445504 64.995996,163.917406 L6.67495026,130.185774 L6.67495026,130.185774 C2.54398439,127.796512 1.42108547e-14,123.386278 1.42108547e-14,118.614125 L1.42108547e-14,48.436129 C1.42108547e-14,43.6639756 2.54398439,39.2537412 6.67495026,36.8644799 L67.3072083,1.79609278 C71.4477337,-0.598697595 76.5522663,-0.598697595 80.6927917,1.79609278 L141.32505,36.8644799 C145.456016,39.2537412 148,43.6639756 148,48.436129 L148,118.614125 C148,123.386278 145.456016,127.796512 141.32505,130.185774 L92.2812226,158.551663" id="Path-Copy-3" strokeLinecap="round" />
          <path d="M51,49 L119,49 C120.104569,49 121,49.8954305 121,51 L121,92 C121,93.1045695 120.104569,94 119,94 L51,94 L51,94" id="Path" fill={theme.colors.primary20} />
          <line x1="50.5" y1="117.664666" x2="50.5" y2="46" id="Line-2" strokeLinecap="round" />
          <path d="M90.239435,81.7782712 C90.0631269,82.1676449 89.8758447,82.5512259 89.6779671,82.9286394 L82.2989672,82.9286393 L81.8937728,82.0669236 L78.1172716,83.9875645 L76.5591632,79.8394848 C76.3961623,79.1332341 76.5739129,78.396551 77.0393222,77.8413752 L79.8721037,74.4622162 C79.8249919,73.8746857 79.8009823,73.2808202 79.8009823,72.6814838 C79.8009823,67.7927344 81.3963573,63.2674855 84.107847,59.5756058 C84.5362871,59.0098353 84.997813,58.7370453 85.4095325,58.6086382 C86.0930507,58.3954624 86.7419904,58.5264664 87.2751427,58.9131117 C90.61381,63.2761567 92.1990177,67.7991512 92.1990177,72.6814838 C92.1990177,73.2808202 92.1750081,73.8746857 92.1278963,74.4622162 L94.9606778,77.8413752 C95.3806819,78.3423882 95.5664172,78.9912204 95.4788634,79.6321076 L94.9309945,83.6424664 L90.239435,81.7782712 Z" id="Path" fill={theme.colors.white} />
          <path d="M18.4450668,124.33815 C20.3880749,122.496562 22.421736,120.749671 24.5386602,119.104867 L22.349674,115.734124 C21.7480823,114.807754 22.0113671,113.569097 22.9377371,112.967505 L31.3244427,107.521115 C32.2508127,106.919523 33.4894703,107.182808 34.0910619,108.109178 L36.2893205,111.494199 C43.9325843,107.429769 52.2997247,104.546693 61.1471982,103.088517" id="Path" strokeLinecap="round" />
          <path d="M74.5,102 C86.2343886,102 97.389559,104.479928 107.469997,108.944271 L109.522759,105.388784 C110.075043,104.432199 111.298224,104.104449 112.254809,104.656733 L125.245191,112.156733 C126.201776,112.709018 126.529526,113.932199 125.977241,114.888784 L123.825459,118.615781 C126.097192,120.345426 128.275354,122.191655 130.351025,124.145546" id="Path" strokeLinecap="round" />
          <line x1="82.5" y1="19.5" x2="82.5" y2="32.5278784" id="Line-6" strokeLinecap="round" />
          <line x1="82.5" y1="19.5" x2="82.5" y2="32.5278784" id="Line-6-Copy" strokeLinecap="round" transform="translate(82.500000, 26.000000) rotate(-270.000000) translate(-82.500000, -26.000000) " />
          <line x1="30.5" y1="40.3" x2="30.5" y2="48.1167271" id="Line-6" strokeLinecap="round" />
          <line x1="30.4916365" y1="40.2916365" x2="30.4916365" y2="48.1083635" id="Line-6-Copy" strokeLinecap="round" transform="translate(30.491636, 44.200000) rotate(-270.000000) translate(-30.491636, -44.200000) " />
          <line x1="17.5" y1="78.4333333" x2="17.5" y2="89.7241613" id="Line-6" strokeLinecap="round" />
          <line x1="17.4879193" y1="78.4212527" x2="17.4879193" y2="89.7120807" id="Line-6-Copy" strokeLinecap="round" transform="translate(17.487919, 84.066667) rotate(-270.000000) translate(-17.487919, -84.066667) " />
        </g>
      </g>
    </svg>
  )
}

export default FlagInCog
