var AdminBroDesignSystem = (function (React, PropTypes, ne, styled) {
	'use strict';

	var React__default = 'default' in React ? React['default'] : React;
	PropTypes = PropTypes && Object.prototype.hasOwnProperty.call(PropTypes, 'default') ? PropTypes['default'] : PropTypes;
	var ne__default = 'default' in ne ? ne['default'] : ne;
	var styled__default = 'default' in styled ? styled['default'] : styled;

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function unwrapExports (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	var classnames = createCommonjsModule(function (module) {
	  /*!
	    Copyright (c) 2017 Jed Watson.
	    Licensed under the MIT License (MIT), see
	    http://jedwatson.github.io/classnames
	  */

	  /* global define */
	  (function () {

	    var hasOwn = {}.hasOwnProperty;

	    function classNames() {
	      var classes = [];

	      for (var i = 0; i < arguments.length; i++) {
	        var arg = arguments[i];
	        if (!arg) continue;
	        var argType = typeof arg;

	        if (argType === 'string' || argType === 'number') {
	          classes.push(arg);
	        } else if (Array.isArray(arg) && arg.length) {
	          var inner = classNames.apply(null, arg);

	          if (inner) {
	            classes.push(inner);
	          }
	        } else if (argType === 'object') {
	          for (var key in arg) {
	            if (hasOwn.call(arg, key) && arg[key]) {
	              classes.push(key);
	            }
	          }
	        }
	      }

	      return classes.join(' ');
	    }

	    if ( module.exports) {
	      classNames.default = classNames;
	      module.exports = classNames;
	    } else {
	      window.classNames = classNames;
	    }
	  })();
	});

	function requiredArgs(required, args) {
	  if (args.length < required) {
	    throw new TypeError(required + ' argument' + (required > 1 ? 's' : '') + ' required, but only ' + args.length + ' present');
	  }
	}

	/**
	 * @name isDate
	 * @category Common Helpers
	 * @summary Is the given value a date?
	 *
	 * @description
	 * Returns true if the given value is an instance of Date. The function works for dates transferred across iframes.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {*} value - the value to check
	 * @returns {boolean} true if the given value is a date
	 * @throws {TypeError} 1 arguments required
	 *
	 * @example
	 * // For a valid date:
	 * var result = isDate(new Date())
	 * //=> true
	 *
	 * @example
	 * // For an invalid date:
	 * var result = isDate(new Date(NaN))
	 * //=> true
	 *
	 * @example
	 * // For some value:
	 * var result = isDate('2014-02-31')
	 * //=> false
	 *
	 * @example
	 * // For an object:
	 * var result = isDate({})
	 * //=> false
	 */

	function isDate(value) {
	  requiredArgs(1, arguments);
	  return value instanceof Date || typeof value === 'object' && Object.prototype.toString.call(value) === '[object Date]';
	}

	/**
	 * @name toDate
	 * @category Common Helpers
	 * @summary Convert the given argument to an instance of Date.
	 *
	 * @description
	 * Convert the given argument to an instance of Date.
	 *
	 * If the argument is an instance of Date, the function returns its clone.
	 *
	 * If the argument is a number, it is treated as a timestamp.
	 *
	 * If the argument is none of the above, the function returns Invalid Date.
	 *
	 * **Note**: *all* Date arguments passed to any *date-fns* function is processed by `toDate`.
	 *
	 * @param {Date|Number} argument - the value to convert
	 * @returns {Date} the parsed date in the local time zone
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Clone the date:
	 * const result = toDate(new Date(2014, 1, 11, 11, 30, 30))
	 * //=> Tue Feb 11 2014 11:30:30
	 *
	 * @example
	 * // Convert the timestamp to date:
	 * const result = toDate(1392098430000)
	 * //=> Tue Feb 11 2014 11:30:30
	 */

	function toDate(argument) {
	  requiredArgs(1, arguments);
	  var argStr = Object.prototype.toString.call(argument); // Clone the date

	  if (argument instanceof Date || typeof argument === 'object' && argStr === '[object Date]') {
	    // Prevent the date to lose the milliseconds when passed to new Date() in IE10
	    return new Date(argument.getTime());
	  } else if (typeof argument === 'number' || argStr === '[object Number]') {
	    return new Date(argument);
	  } else {
	    if ((typeof argument === 'string' || argStr === '[object String]') && typeof console !== 'undefined') {
	      // eslint-disable-next-line no-console
	      console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as arguments. Please use `parseISO` to parse strings. See: https://git.io/fjule"); // eslint-disable-next-line no-console

	      console.warn(new Error().stack);
	    }

	    return new Date(NaN);
	  }
	}

	/**
	 * @name isValid
	 * @category Common Helpers
	 * @summary Is the given date valid?
	 *
	 * @description
	 * Returns false if argument is Invalid Date and true otherwise.
	 * Argument is converted to Date using `toDate`. See [toDate]{@link https://date-fns.org/docs/toDate}
	 * Invalid Date is a Date, whose time value is NaN.
	 *
	 * Time value of Date: http://es5.github.io/#x15.9.1.1
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * - Now `isValid` doesn't throw an exception
	 *   if the first argument is not an instance of Date.
	 *   Instead, argument is converted beforehand using `toDate`.
	 *
	 *   Examples:
	 *
	 *   | `isValid` argument        | Before v2.0.0 | v2.0.0 onward |
	 *   |---------------------------|---------------|---------------|
	 *   | `new Date()`              | `true`        | `true`        |
	 *   | `new Date('2016-01-01')`  | `true`        | `true`        |
	 *   | `new Date('')`            | `false`       | `false`       |
	 *   | `new Date(1488370835081)` | `true`        | `true`        |
	 *   | `new Date(NaN)`           | `false`       | `false`       |
	 *   | `'2016-01-01'`            | `TypeError`   | `false`       |
	 *   | `''`                      | `TypeError`   | `false`       |
	 *   | `1488370835081`           | `TypeError`   | `true`        |
	 *   | `NaN`                     | `TypeError`   | `false`       |
	 *
	 *   We introduce this change to make *date-fns* consistent with ECMAScript behavior
	 *   that try to coerce arguments to the expected type
	 *   (which is also the case with other *date-fns* functions).
	 *
	 * @param {*} date - the date to check
	 * @returns {Boolean} the date is valid
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // For the valid date:
	 * var result = isValid(new Date(2014, 1, 31))
	 * //=> true
	 *
	 * @example
	 * // For the value, convertable into a date:
	 * var result = isValid(1393804800000)
	 * //=> true
	 *
	 * @example
	 * // For the invalid date:
	 * var result = isValid(new Date(''))
	 * //=> false
	 */

	function isValid(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  return !isNaN(date);
	}

	var formatDistanceLocale = {
	  lessThanXSeconds: {
	    one: 'less than a second',
	    other: 'less than {{count}} seconds'
	  },
	  xSeconds: {
	    one: '1 second',
	    other: '{{count}} seconds'
	  },
	  halfAMinute: 'half a minute',
	  lessThanXMinutes: {
	    one: 'less than a minute',
	    other: 'less than {{count}} minutes'
	  },
	  xMinutes: {
	    one: '1 minute',
	    other: '{{count}} minutes'
	  },
	  aboutXHours: {
	    one: 'about 1 hour',
	    other: 'about {{count}} hours'
	  },
	  xHours: {
	    one: '1 hour',
	    other: '{{count}} hours'
	  },
	  xDays: {
	    one: '1 day',
	    other: '{{count}} days'
	  },
	  aboutXWeeks: {
	    one: 'about 1 week',
	    other: 'about {{count}} weeks'
	  },
	  xWeeks: {
	    one: '1 week',
	    other: '{{count}} weeks'
	  },
	  aboutXMonths: {
	    one: 'about 1 month',
	    other: 'about {{count}} months'
	  },
	  xMonths: {
	    one: '1 month',
	    other: '{{count}} months'
	  },
	  aboutXYears: {
	    one: 'about 1 year',
	    other: 'about {{count}} years'
	  },
	  xYears: {
	    one: '1 year',
	    other: '{{count}} years'
	  },
	  overXYears: {
	    one: 'over 1 year',
	    other: 'over {{count}} years'
	  },
	  almostXYears: {
	    one: 'almost 1 year',
	    other: 'almost {{count}} years'
	  }
	};
	function formatDistance(token, count, options) {
	  options = options || {};
	  var result;

	  if (typeof formatDistanceLocale[token] === 'string') {
	    result = formatDistanceLocale[token];
	  } else if (count === 1) {
	    result = formatDistanceLocale[token].one;
	  } else {
	    result = formatDistanceLocale[token].other.replace('{{count}}', count);
	  }

	  if (options.addSuffix) {
	    if (options.comparison > 0) {
	      return 'in ' + result;
	    } else {
	      return result + ' ago';
	    }
	  }

	  return result;
	}

	function buildFormatLongFn(args) {
	  return function (dirtyOptions) {
	    var options = dirtyOptions || {};
	    var width = options.width ? String(options.width) : args.defaultWidth;
	    var format = args.formats[width] || args.formats[args.defaultWidth];
	    return format;
	  };
	}

	var dateFormats = {
	  full: 'EEEE, MMMM do, y',
	  long: 'MMMM do, y',
	  medium: 'MMM d, y',
	  short: 'MM/dd/yyyy'
	};
	var timeFormats = {
	  full: 'h:mm:ss a zzzz',
	  long: 'h:mm:ss a z',
	  medium: 'h:mm:ss a',
	  short: 'h:mm a'
	};
	var dateTimeFormats = {
	  full: "{{date}} 'at' {{time}}",
	  long: "{{date}} 'at' {{time}}",
	  medium: '{{date}}, {{time}}',
	  short: '{{date}}, {{time}}'
	};
	var formatLong = {
	  date: buildFormatLongFn({
	    formats: dateFormats,
	    defaultWidth: 'full'
	  }),
	  time: buildFormatLongFn({
	    formats: timeFormats,
	    defaultWidth: 'full'
	  }),
	  dateTime: buildFormatLongFn({
	    formats: dateTimeFormats,
	    defaultWidth: 'full'
	  })
	};

	var formatRelativeLocale = {
	  lastWeek: "'last' eeee 'at' p",
	  yesterday: "'yesterday at' p",
	  today: "'today at' p",
	  tomorrow: "'tomorrow at' p",
	  nextWeek: "eeee 'at' p",
	  other: 'P'
	};
	function formatRelative(token, _date, _baseDate, _options) {
	  return formatRelativeLocale[token];
	}

	function buildLocalizeFn(args) {
	  return function (dirtyIndex, dirtyOptions) {
	    var options = dirtyOptions || {};
	    var context = options.context ? String(options.context) : 'standalone';
	    var valuesArray;

	    if (context === 'formatting' && args.formattingValues) {
	      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
	      var width = options.width ? String(options.width) : defaultWidth;
	      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
	    } else {
	      var _defaultWidth = args.defaultWidth;

	      var _width = options.width ? String(options.width) : args.defaultWidth;

	      valuesArray = args.values[_width] || args.values[_defaultWidth];
	    }

	    var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
	    return valuesArray[index];
	  };
	}

	var eraValues = {
	  narrow: ['B', 'A'],
	  abbreviated: ['BC', 'AD'],
	  wide: ['Before Christ', 'Anno Domini']
	};
	var quarterValues = {
	  narrow: ['1', '2', '3', '4'],
	  abbreviated: ['Q1', 'Q2', 'Q3', 'Q4'],
	  wide: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'] // Note: in English, the names of days of the week and months are capitalized.
	  // If you are making a new locale based on this one, check if the same is true for the language you're working on.
	  // Generally, formatted dates should look like they are in the middle of a sentence,
	  // e.g. in Spanish language the weekdays and months should be in the lowercase.

	};
	var monthValues = {
	  narrow: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
	  abbreviated: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
	  wide: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']
	};
	var dayValues = {
	  narrow: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
	  short: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
	  abbreviated: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
	  wide: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']
	};
	var dayPeriodValues = {
	  narrow: {
	    am: 'a',
	    pm: 'p',
	    midnight: 'mi',
	    noon: 'n',
	    morning: 'morning',
	    afternoon: 'afternoon',
	    evening: 'evening',
	    night: 'night'
	  },
	  abbreviated: {
	    am: 'AM',
	    pm: 'PM',
	    midnight: 'midnight',
	    noon: 'noon',
	    morning: 'morning',
	    afternoon: 'afternoon',
	    evening: 'evening',
	    night: 'night'
	  },
	  wide: {
	    am: 'a.m.',
	    pm: 'p.m.',
	    midnight: 'midnight',
	    noon: 'noon',
	    morning: 'morning',
	    afternoon: 'afternoon',
	    evening: 'evening',
	    night: 'night'
	  }
	};
	var formattingDayPeriodValues = {
	  narrow: {
	    am: 'a',
	    pm: 'p',
	    midnight: 'mi',
	    noon: 'n',
	    morning: 'in the morning',
	    afternoon: 'in the afternoon',
	    evening: 'in the evening',
	    night: 'at night'
	  },
	  abbreviated: {
	    am: 'AM',
	    pm: 'PM',
	    midnight: 'midnight',
	    noon: 'noon',
	    morning: 'in the morning',
	    afternoon: 'in the afternoon',
	    evening: 'in the evening',
	    night: 'at night'
	  },
	  wide: {
	    am: 'a.m.',
	    pm: 'p.m.',
	    midnight: 'midnight',
	    noon: 'noon',
	    morning: 'in the morning',
	    afternoon: 'in the afternoon',
	    evening: 'in the evening',
	    night: 'at night'
	  }
	};

	function ordinalNumber(dirtyNumber, _dirtyOptions) {
	  var number = Number(dirtyNumber); // If ordinal numbers depend on context, for example,
	  // if they are different for different grammatical genders,
	  // use `options.unit`:
	  //
	  //   var options = dirtyOptions || {}
	  //   var unit = String(options.unit)
	  //
	  // where `unit` can be 'year', 'quarter', 'month', 'week', 'date', 'dayOfYear',
	  // 'day', 'hour', 'minute', 'second'

	  var rem100 = number % 100;

	  if (rem100 > 20 || rem100 < 10) {
	    switch (rem100 % 10) {
	      case 1:
	        return number + 'st';

	      case 2:
	        return number + 'nd';

	      case 3:
	        return number + 'rd';
	    }
	  }

	  return number + 'th';
	}

	var localize = {
	  ordinalNumber: ordinalNumber,
	  era: buildLocalizeFn({
	    values: eraValues,
	    defaultWidth: 'wide'
	  }),
	  quarter: buildLocalizeFn({
	    values: quarterValues,
	    defaultWidth: 'wide',
	    argumentCallback: function (quarter) {
	      return Number(quarter) - 1;
	    }
	  }),
	  month: buildLocalizeFn({
	    values: monthValues,
	    defaultWidth: 'wide'
	  }),
	  day: buildLocalizeFn({
	    values: dayValues,
	    defaultWidth: 'wide'
	  }),
	  dayPeriod: buildLocalizeFn({
	    values: dayPeriodValues,
	    defaultWidth: 'wide',
	    formattingValues: formattingDayPeriodValues,
	    defaultFormattingWidth: 'wide'
	  })
	};

	function buildMatchPatternFn(args) {
	  return function (dirtyString, dirtyOptions) {
	    var string = String(dirtyString);
	    var options = dirtyOptions || {};
	    var matchResult = string.match(args.matchPattern);

	    if (!matchResult) {
	      return null;
	    }

	    var matchedString = matchResult[0];
	    var parseResult = string.match(args.parsePattern);

	    if (!parseResult) {
	      return null;
	    }

	    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
	    value = options.valueCallback ? options.valueCallback(value) : value;
	    return {
	      value: value,
	      rest: string.slice(matchedString.length)
	    };
	  };
	}

	function buildMatchFn(args) {
	  return function (dirtyString, dirtyOptions) {
	    var string = String(dirtyString);
	    var options = dirtyOptions || {};
	    var width = options.width;
	    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
	    var matchResult = string.match(matchPattern);

	    if (!matchResult) {
	      return null;
	    }

	    var matchedString = matchResult[0];
	    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
	    var value;

	    if (Object.prototype.toString.call(parsePatterns) === '[object Array]') {
	      value = findIndex(parsePatterns, function (pattern) {
	        return pattern.test(matchedString);
	      });
	    } else {
	      value = findKey(parsePatterns, function (pattern) {
	        return pattern.test(matchedString);
	      });
	    }

	    value = args.valueCallback ? args.valueCallback(value) : value;
	    value = options.valueCallback ? options.valueCallback(value) : value;
	    return {
	      value: value,
	      rest: string.slice(matchedString.length)
	    };
	  };
	}

	function findKey(object, predicate) {
	  for (var key in object) {
	    if (object.hasOwnProperty(key) && predicate(object[key])) {
	      return key;
	    }
	  }
	}

	function findIndex(array, predicate) {
	  for (var key = 0; key < array.length; key++) {
	    if (predicate(array[key])) {
	      return key;
	    }
	  }
	}

	var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
	var parseOrdinalNumberPattern = /\d+/i;
	var matchEraPatterns = {
	  narrow: /^(b|a)/i,
	  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
	  wide: /^(before christ|before common era|anno domini|common era)/i
	};
	var parseEraPatterns = {
	  any: [/^b/i, /^(a|c)/i]
	};
	var matchQuarterPatterns = {
	  narrow: /^[1234]/i,
	  abbreviated: /^q[1234]/i,
	  wide: /^[1234](th|st|nd|rd)? quarter/i
	};
	var parseQuarterPatterns = {
	  any: [/1/i, /2/i, /3/i, /4/i]
	};
	var matchMonthPatterns = {
	  narrow: /^[jfmasond]/i,
	  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
	  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
	};
	var parseMonthPatterns = {
	  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
	  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
	};
	var matchDayPatterns = {
	  narrow: /^[smtwf]/i,
	  short: /^(su|mo|tu|we|th|fr|sa)/i,
	  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
	  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
	};
	var parseDayPatterns = {
	  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
	  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
	};
	var matchDayPeriodPatterns = {
	  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
	  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
	};
	var parseDayPeriodPatterns = {
	  any: {
	    am: /^a/i,
	    pm: /^p/i,
	    midnight: /^mi/i,
	    noon: /^no/i,
	    morning: /morning/i,
	    afternoon: /afternoon/i,
	    evening: /evening/i,
	    night: /night/i
	  }
	};
	var match = {
	  ordinalNumber: buildMatchPatternFn({
	    matchPattern: matchOrdinalNumberPattern,
	    parsePattern: parseOrdinalNumberPattern,
	    valueCallback: function (value) {
	      return parseInt(value, 10);
	    }
	  }),
	  era: buildMatchFn({
	    matchPatterns: matchEraPatterns,
	    defaultMatchWidth: 'wide',
	    parsePatterns: parseEraPatterns,
	    defaultParseWidth: 'any'
	  }),
	  quarter: buildMatchFn({
	    matchPatterns: matchQuarterPatterns,
	    defaultMatchWidth: 'wide',
	    parsePatterns: parseQuarterPatterns,
	    defaultParseWidth: 'any',
	    valueCallback: function (index) {
	      return index + 1;
	    }
	  }),
	  month: buildMatchFn({
	    matchPatterns: matchMonthPatterns,
	    defaultMatchWidth: 'wide',
	    parsePatterns: parseMonthPatterns,
	    defaultParseWidth: 'any'
	  }),
	  day: buildMatchFn({
	    matchPatterns: matchDayPatterns,
	    defaultMatchWidth: 'wide',
	    parsePatterns: parseDayPatterns,
	    defaultParseWidth: 'any'
	  }),
	  dayPeriod: buildMatchFn({
	    matchPatterns: matchDayPeriodPatterns,
	    defaultMatchWidth: 'any',
	    parsePatterns: parseDayPeriodPatterns,
	    defaultParseWidth: 'any'
	  })
	};

	/**
	 * @type {Locale}
	 * @category Locales
	 * @summary English locale (United States).
	 * @language English
	 * @iso-639-2 eng
	 * @author Sasha Koss [@kossnocorp]{@link https://github.com/kossnocorp}
	 * @author Lesha Koss [@leshakoss]{@link https://github.com/leshakoss}
	 */

	var locale = {
	  code: 'en-US',
	  formatDistance: formatDistance,
	  formatLong: formatLong,
	  formatRelative: formatRelative,
	  localize: localize,
	  match: match,
	  options: {
	    weekStartsOn: 0
	    /* Sunday */
	    ,
	    firstWeekContainsDate: 1
	  }
	};

	function toInteger(dirtyNumber) {
	  if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
	    return NaN;
	  }

	  var number = Number(dirtyNumber);

	  if (isNaN(number)) {
	    return number;
	  }

	  return number < 0 ? Math.ceil(number) : Math.floor(number);
	}

	/**
	 * @name addMilliseconds
	 * @category Millisecond Helpers
	 * @summary Add the specified number of milliseconds to the given date.
	 *
	 * @description
	 * Add the specified number of milliseconds to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of milliseconds to be added. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the milliseconds added
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Add 750 milliseconds to 10 July 2014 12:45:30.000:
	 * var result = addMilliseconds(new Date(2014, 6, 10, 12, 45, 30, 0), 750)
	 * //=> Thu Jul 10 2014 12:45:30.750
	 */

	function addMilliseconds(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var timestamp = toDate(dirtyDate).getTime();
	  var amount = toInteger(dirtyAmount);
	  return new Date(timestamp + amount);
	}

	/**
	 * @name subMilliseconds
	 * @category Millisecond Helpers
	 * @summary Subtract the specified number of milliseconds from the given date.
	 *
	 * @description
	 * Subtract the specified number of milliseconds from the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of milliseconds to be subtracted. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the milliseconds subtracted
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Subtract 750 milliseconds from 10 July 2014 12:45:30.000:
	 * var result = subMilliseconds(new Date(2014, 6, 10, 12, 45, 30, 0), 750)
	 * //=> Thu Jul 10 2014 12:45:29.250
	 */

	function subMilliseconds(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var amount = toInteger(dirtyAmount);
	  return addMilliseconds(dirtyDate, -amount);
	}

	function addLeadingZeros(number, targetLength) {
	  var sign = number < 0 ? '-' : '';
	  var output = Math.abs(number).toString();

	  while (output.length < targetLength) {
	    output = '0' + output;
	  }

	  return sign + output;
	}

	/*
	 * |     | Unit                           |     | Unit                           |
	 * |-----|--------------------------------|-----|--------------------------------|
	 * |  a  | AM, PM                         |  A* |                                |
	 * |  d  | Day of month                   |  D  |                                |
	 * |  h  | Hour [1-12]                    |  H  | Hour [0-23]                    |
	 * |  m  | Minute                         |  M  | Month                          |
	 * |  s  | Second                         |  S  | Fraction of second             |
	 * |  y  | Year (abs)                     |  Y  |                                |
	 *
	 * Letters marked by * are not implemented but reserved by Unicode standard.
	 */

	var formatters = {
	  // Year
	  y: function (date, token) {
	    // From http://www.unicode.org/reports/tr35/tr35-31/tr35-dates.html#Date_Format_tokens
	    // | Year     |     y | yy |   yyy |  yyyy | yyyyy |
	    // |----------|-------|----|-------|-------|-------|
	    // | AD 1     |     1 | 01 |   001 |  0001 | 00001 |
	    // | AD 12    |    12 | 12 |   012 |  0012 | 00012 |
	    // | AD 123   |   123 | 23 |   123 |  0123 | 00123 |
	    // | AD 1234  |  1234 | 34 |  1234 |  1234 | 01234 |
	    // | AD 12345 | 12345 | 45 | 12345 | 12345 | 12345 |
	    var signedYear = date.getUTCFullYear(); // Returns 1 for 1 BC (which is year 0 in JavaScript)

	    var year = signedYear > 0 ? signedYear : 1 - signedYear;
	    return addLeadingZeros(token === 'yy' ? year % 100 : year, token.length);
	  },
	  // Month
	  M: function (date, token) {
	    var month = date.getUTCMonth();
	    return token === 'M' ? String(month + 1) : addLeadingZeros(month + 1, 2);
	  },
	  // Day of the month
	  d: function (date, token) {
	    return addLeadingZeros(date.getUTCDate(), token.length);
	  },
	  // AM or PM
	  a: function (date, token) {
	    var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? 'pm' : 'am';

	    switch (token) {
	      case 'a':
	      case 'aa':
	      case 'aaa':
	        return dayPeriodEnumValue.toUpperCase();

	      case 'aaaaa':
	        return dayPeriodEnumValue[0];

	      case 'aaaa':
	      default:
	        return dayPeriodEnumValue === 'am' ? 'a.m.' : 'p.m.';
	    }
	  },
	  // Hour [1-12]
	  h: function (date, token) {
	    return addLeadingZeros(date.getUTCHours() % 12 || 12, token.length);
	  },
	  // Hour [0-23]
	  H: function (date, token) {
	    return addLeadingZeros(date.getUTCHours(), token.length);
	  },
	  // Minute
	  m: function (date, token) {
	    return addLeadingZeros(date.getUTCMinutes(), token.length);
	  },
	  // Second
	  s: function (date, token) {
	    return addLeadingZeros(date.getUTCSeconds(), token.length);
	  },
	  // Fraction of second
	  S: function (date, token) {
	    var numberOfDigits = token.length;
	    var milliseconds = date.getUTCMilliseconds();
	    var fractionalSeconds = Math.floor(milliseconds * Math.pow(10, numberOfDigits - 3));
	    return addLeadingZeros(fractionalSeconds, token.length);
	  }
	};

	var MILLISECONDS_IN_DAY = 86400000; // This function will be a part of public API when UTC function will be implemented.
	// See issue: https://github.com/date-fns/date-fns/issues/376

	function getUTCDayOfYear(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var timestamp = date.getTime();
	  date.setUTCMonth(0, 1);
	  date.setUTCHours(0, 0, 0, 0);
	  var startOfYearTimestamp = date.getTime();
	  var difference = timestamp - startOfYearTimestamp;
	  return Math.floor(difference / MILLISECONDS_IN_DAY) + 1;
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function startOfUTCISOWeek(dirtyDate) {
	  requiredArgs(1, arguments);
	  var weekStartsOn = 1;
	  var date = toDate(dirtyDate);
	  var day = date.getUTCDay();
	  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
	  date.setUTCDate(date.getUTCDate() - diff);
	  date.setUTCHours(0, 0, 0, 0);
	  return date;
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function getUTCISOWeekYear(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var year = date.getUTCFullYear();
	  var fourthOfJanuaryOfNextYear = new Date(0);
	  fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
	  fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
	  var startOfNextYear = startOfUTCISOWeek(fourthOfJanuaryOfNextYear);
	  var fourthOfJanuaryOfThisYear = new Date(0);
	  fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
	  fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
	  var startOfThisYear = startOfUTCISOWeek(fourthOfJanuaryOfThisYear);

	  if (date.getTime() >= startOfNextYear.getTime()) {
	    return year + 1;
	  } else if (date.getTime() >= startOfThisYear.getTime()) {
	    return year;
	  } else {
	    return year - 1;
	  }
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function startOfUTCISOWeekYear(dirtyDate) {
	  requiredArgs(1, arguments);
	  var year = getUTCISOWeekYear(dirtyDate);
	  var fourthOfJanuary = new Date(0);
	  fourthOfJanuary.setUTCFullYear(year, 0, 4);
	  fourthOfJanuary.setUTCHours(0, 0, 0, 0);
	  var date = startOfUTCISOWeek(fourthOfJanuary);
	  return date;
	}

	var MILLISECONDS_IN_WEEK = 604800000; // This function will be a part of public API when UTC function will be implemented.
	// See issue: https://github.com/date-fns/date-fns/issues/376

	function getUTCISOWeek(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var diff = startOfUTCISOWeek(date).getTime() - startOfUTCISOWeekYear(date).getTime(); // Round the number of days to the nearest integer
	  // because the number of milliseconds in a week is not constant
	  // (e.g. it's different in the week of the daylight saving time clock shift)

	  return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function startOfUTCWeek(dirtyDate, dirtyOptions) {
	  requiredArgs(1, arguments);
	  var options = dirtyOptions || {};
	  var locale = options.locale;
	  var localeWeekStartsOn = locale && locale.options && locale.options.weekStartsOn;
	  var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger(localeWeekStartsOn);
	  var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger(options.weekStartsOn); // Test if weekStartsOn is between 0 and 6 _and_ is not NaN

	  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
	    throw new RangeError('weekStartsOn must be between 0 and 6 inclusively');
	  }

	  var date = toDate(dirtyDate);
	  var day = date.getUTCDay();
	  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
	  date.setUTCDate(date.getUTCDate() - diff);
	  date.setUTCHours(0, 0, 0, 0);
	  return date;
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function getUTCWeekYear(dirtyDate, dirtyOptions) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate, dirtyOptions);
	  var year = date.getUTCFullYear();
	  var options = dirtyOptions || {};
	  var locale = options.locale;
	  var localeFirstWeekContainsDate = locale && locale.options && locale.options.firstWeekContainsDate;
	  var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger(localeFirstWeekContainsDate);
	  var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger(options.firstWeekContainsDate); // Test if weekStartsOn is between 1 and 7 _and_ is not NaN

	  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
	    throw new RangeError('firstWeekContainsDate must be between 1 and 7 inclusively');
	  }

	  var firstWeekOfNextYear = new Date(0);
	  firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
	  firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
	  var startOfNextYear = startOfUTCWeek(firstWeekOfNextYear, dirtyOptions);
	  var firstWeekOfThisYear = new Date(0);
	  firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
	  firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
	  var startOfThisYear = startOfUTCWeek(firstWeekOfThisYear, dirtyOptions);

	  if (date.getTime() >= startOfNextYear.getTime()) {
	    return year + 1;
	  } else if (date.getTime() >= startOfThisYear.getTime()) {
	    return year;
	  } else {
	    return year - 1;
	  }
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function startOfUTCWeekYear(dirtyDate, dirtyOptions) {
	  requiredArgs(1, arguments);
	  var options = dirtyOptions || {};
	  var locale = options.locale;
	  var localeFirstWeekContainsDate = locale && locale.options && locale.options.firstWeekContainsDate;
	  var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger(localeFirstWeekContainsDate);
	  var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger(options.firstWeekContainsDate);
	  var year = getUTCWeekYear(dirtyDate, dirtyOptions);
	  var firstWeek = new Date(0);
	  firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
	  firstWeek.setUTCHours(0, 0, 0, 0);
	  var date = startOfUTCWeek(firstWeek, dirtyOptions);
	  return date;
	}

	var MILLISECONDS_IN_WEEK$1 = 604800000; // This function will be a part of public API when UTC function will be implemented.
	// See issue: https://github.com/date-fns/date-fns/issues/376

	function getUTCWeek(dirtyDate, options) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var diff = startOfUTCWeek(date, options).getTime() - startOfUTCWeekYear(date, options).getTime(); // Round the number of days to the nearest integer
	  // because the number of milliseconds in a week is not constant
	  // (e.g. it's different in the week of the daylight saving time clock shift)

	  return Math.round(diff / MILLISECONDS_IN_WEEK$1) + 1;
	}

	var dayPeriodEnum = {
	  am: 'am',
	  pm: 'pm',
	  midnight: 'midnight',
	  noon: 'noon',
	  morning: 'morning',
	  afternoon: 'afternoon',
	  evening: 'evening',
	  night: 'night'
	  /*
	   * |     | Unit                           |     | Unit                           |
	   * |-----|--------------------------------|-----|--------------------------------|
	   * |  a  | AM, PM                         |  A* | Milliseconds in day            |
	   * |  b  | AM, PM, noon, midnight         |  B  | Flexible day period            |
	   * |  c  | Stand-alone local day of week  |  C* | Localized hour w/ day period   |
	   * |  d  | Day of month                   |  D  | Day of year                    |
	   * |  e  | Local day of week              |  E  | Day of week                    |
	   * |  f  |                                |  F* | Day of week in month           |
	   * |  g* | Modified Julian day            |  G  | Era                            |
	   * |  h  | Hour [1-12]                    |  H  | Hour [0-23]                    |
	   * |  i! | ISO day of week                |  I! | ISO week of year               |
	   * |  j* | Localized hour w/ day period   |  J* | Localized hour w/o day period  |
	   * |  k  | Hour [1-24]                    |  K  | Hour [0-11]                    |
	   * |  l* | (deprecated)                   |  L  | Stand-alone month              |
	   * |  m  | Minute                         |  M  | Month                          |
	   * |  n  |                                |  N  |                                |
	   * |  o! | Ordinal number modifier        |  O  | Timezone (GMT)                 |
	   * |  p! | Long localized time            |  P! | Long localized date            |
	   * |  q  | Stand-alone quarter            |  Q  | Quarter                        |
	   * |  r* | Related Gregorian year         |  R! | ISO week-numbering year        |
	   * |  s  | Second                         |  S  | Fraction of second             |
	   * |  t! | Seconds timestamp              |  T! | Milliseconds timestamp         |
	   * |  u  | Extended year                  |  U* | Cyclic year                    |
	   * |  v* | Timezone (generic non-locat.)  |  V* | Timezone (location)            |
	   * |  w  | Local week of year             |  W* | Week of month                  |
	   * |  x  | Timezone (ISO-8601 w/o Z)      |  X  | Timezone (ISO-8601)            |
	   * |  y  | Year (abs)                     |  Y  | Local week-numbering year      |
	   * |  z  | Timezone (specific non-locat.) |  Z* | Timezone (aliases)             |
	   *
	   * Letters marked by * are not implemented but reserved by Unicode standard.
	   *
	   * Letters marked by ! are non-standard, but implemented by date-fns:
	   * - `o` modifies the previous token to turn it into an ordinal (see `format` docs)
	   * - `i` is ISO day of week. For `i` and `ii` is returns numeric ISO week days,
	   *   i.e. 7 for Sunday, 1 for Monday, etc.
	   * - `I` is ISO week of year, as opposed to `w` which is local week of year.
	   * - `R` is ISO week-numbering year, as opposed to `Y` which is local week-numbering year.
	   *   `R` is supposed to be used in conjunction with `I` and `i`
	   *   for universal ISO week-numbering date, whereas
	   *   `Y` is supposed to be used in conjunction with `w` and `e`
	   *   for week-numbering date specific to the locale.
	   * - `P` is long localized date format
	   * - `p` is long localized time format
	   */

	};
	var formatters$1 = {
	  // Era
	  G: function (date, token, localize) {
	    var era = date.getUTCFullYear() > 0 ? 1 : 0;

	    switch (token) {
	      // AD, BC
	      case 'G':
	      case 'GG':
	      case 'GGG':
	        return localize.era(era, {
	          width: 'abbreviated'
	        });
	      // A, B

	      case 'GGGGG':
	        return localize.era(era, {
	          width: 'narrow'
	        });
	      // Anno Domini, Before Christ

	      case 'GGGG':
	      default:
	        return localize.era(era, {
	          width: 'wide'
	        });
	    }
	  },
	  // Year
	  y: function (date, token, localize) {
	    // Ordinal number
	    if (token === 'yo') {
	      var signedYear = date.getUTCFullYear(); // Returns 1 for 1 BC (which is year 0 in JavaScript)

	      var year = signedYear > 0 ? signedYear : 1 - signedYear;
	      return localize.ordinalNumber(year, {
	        unit: 'year'
	      });
	    }

	    return formatters.y(date, token);
	  },
	  // Local week-numbering year
	  Y: function (date, token, localize, options) {
	    var signedWeekYear = getUTCWeekYear(date, options); // Returns 1 for 1 BC (which is year 0 in JavaScript)

	    var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear; // Two digit year

	    if (token === 'YY') {
	      var twoDigitYear = weekYear % 100;
	      return addLeadingZeros(twoDigitYear, 2);
	    } // Ordinal number


	    if (token === 'Yo') {
	      return localize.ordinalNumber(weekYear, {
	        unit: 'year'
	      });
	    } // Padding


	    return addLeadingZeros(weekYear, token.length);
	  },
	  // ISO week-numbering year
	  R: function (date, token) {
	    var isoWeekYear = getUTCISOWeekYear(date); // Padding

	    return addLeadingZeros(isoWeekYear, token.length);
	  },
	  // Extended year. This is a single number designating the year of this calendar system.
	  // The main difference between `y` and `u` localizers are B.C. years:
	  // | Year | `y` | `u` |
	  // |------|-----|-----|
	  // | AC 1 |   1 |   1 |
	  // | BC 1 |   1 |   0 |
	  // | BC 2 |   2 |  -1 |
	  // Also `yy` always returns the last two digits of a year,
	  // while `uu` pads single digit years to 2 characters and returns other years unchanged.
	  u: function (date, token) {
	    var year = date.getUTCFullYear();
	    return addLeadingZeros(year, token.length);
	  },
	  // Quarter
	  Q: function (date, token, localize) {
	    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);

	    switch (token) {
	      // 1, 2, 3, 4
	      case 'Q':
	        return String(quarter);
	      // 01, 02, 03, 04

	      case 'QQ':
	        return addLeadingZeros(quarter, 2);
	      // 1st, 2nd, 3rd, 4th

	      case 'Qo':
	        return localize.ordinalNumber(quarter, {
	          unit: 'quarter'
	        });
	      // Q1, Q2, Q3, Q4

	      case 'QQQ':
	        return localize.quarter(quarter, {
	          width: 'abbreviated',
	          context: 'formatting'
	        });
	      // 1, 2, 3, 4 (narrow quarter; could be not numerical)

	      case 'QQQQQ':
	        return localize.quarter(quarter, {
	          width: 'narrow',
	          context: 'formatting'
	        });
	      // 1st quarter, 2nd quarter, ...

	      case 'QQQQ':
	      default:
	        return localize.quarter(quarter, {
	          width: 'wide',
	          context: 'formatting'
	        });
	    }
	  },
	  // Stand-alone quarter
	  q: function (date, token, localize) {
	    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);

	    switch (token) {
	      // 1, 2, 3, 4
	      case 'q':
	        return String(quarter);
	      // 01, 02, 03, 04

	      case 'qq':
	        return addLeadingZeros(quarter, 2);
	      // 1st, 2nd, 3rd, 4th

	      case 'qo':
	        return localize.ordinalNumber(quarter, {
	          unit: 'quarter'
	        });
	      // Q1, Q2, Q3, Q4

	      case 'qqq':
	        return localize.quarter(quarter, {
	          width: 'abbreviated',
	          context: 'standalone'
	        });
	      // 1, 2, 3, 4 (narrow quarter; could be not numerical)

	      case 'qqqqq':
	        return localize.quarter(quarter, {
	          width: 'narrow',
	          context: 'standalone'
	        });
	      // 1st quarter, 2nd quarter, ...

	      case 'qqqq':
	      default:
	        return localize.quarter(quarter, {
	          width: 'wide',
	          context: 'standalone'
	        });
	    }
	  },
	  // Month
	  M: function (date, token, localize) {
	    var month = date.getUTCMonth();

	    switch (token) {
	      case 'M':
	      case 'MM':
	        return formatters.M(date, token);
	      // 1st, 2nd, ..., 12th

	      case 'Mo':
	        return localize.ordinalNumber(month + 1, {
	          unit: 'month'
	        });
	      // Jan, Feb, ..., Dec

	      case 'MMM':
	        return localize.month(month, {
	          width: 'abbreviated',
	          context: 'formatting'
	        });
	      // J, F, ..., D

	      case 'MMMMM':
	        return localize.month(month, {
	          width: 'narrow',
	          context: 'formatting'
	        });
	      // January, February, ..., December

	      case 'MMMM':
	      default:
	        return localize.month(month, {
	          width: 'wide',
	          context: 'formatting'
	        });
	    }
	  },
	  // Stand-alone month
	  L: function (date, token, localize) {
	    var month = date.getUTCMonth();

	    switch (token) {
	      // 1, 2, ..., 12
	      case 'L':
	        return String(month + 1);
	      // 01, 02, ..., 12

	      case 'LL':
	        return addLeadingZeros(month + 1, 2);
	      // 1st, 2nd, ..., 12th

	      case 'Lo':
	        return localize.ordinalNumber(month + 1, {
	          unit: 'month'
	        });
	      // Jan, Feb, ..., Dec

	      case 'LLL':
	        return localize.month(month, {
	          width: 'abbreviated',
	          context: 'standalone'
	        });
	      // J, F, ..., D

	      case 'LLLLL':
	        return localize.month(month, {
	          width: 'narrow',
	          context: 'standalone'
	        });
	      // January, February, ..., December

	      case 'LLLL':
	      default:
	        return localize.month(month, {
	          width: 'wide',
	          context: 'standalone'
	        });
	    }
	  },
	  // Local week of year
	  w: function (date, token, localize, options) {
	    var week = getUTCWeek(date, options);

	    if (token === 'wo') {
	      return localize.ordinalNumber(week, {
	        unit: 'week'
	      });
	    }

	    return addLeadingZeros(week, token.length);
	  },
	  // ISO week of year
	  I: function (date, token, localize) {
	    var isoWeek = getUTCISOWeek(date);

	    if (token === 'Io') {
	      return localize.ordinalNumber(isoWeek, {
	        unit: 'week'
	      });
	    }

	    return addLeadingZeros(isoWeek, token.length);
	  },
	  // Day of the month
	  d: function (date, token, localize) {
	    if (token === 'do') {
	      return localize.ordinalNumber(date.getUTCDate(), {
	        unit: 'date'
	      });
	    }

	    return formatters.d(date, token);
	  },
	  // Day of year
	  D: function (date, token, localize) {
	    var dayOfYear = getUTCDayOfYear(date);

	    if (token === 'Do') {
	      return localize.ordinalNumber(dayOfYear, {
	        unit: 'dayOfYear'
	      });
	    }

	    return addLeadingZeros(dayOfYear, token.length);
	  },
	  // Day of week
	  E: function (date, token, localize) {
	    var dayOfWeek = date.getUTCDay();

	    switch (token) {
	      // Tue
	      case 'E':
	      case 'EE':
	      case 'EEE':
	        return localize.day(dayOfWeek, {
	          width: 'abbreviated',
	          context: 'formatting'
	        });
	      // T

	      case 'EEEEE':
	        return localize.day(dayOfWeek, {
	          width: 'narrow',
	          context: 'formatting'
	        });
	      // Tu

	      case 'EEEEEE':
	        return localize.day(dayOfWeek, {
	          width: 'short',
	          context: 'formatting'
	        });
	      // Tuesday

	      case 'EEEE':
	      default:
	        return localize.day(dayOfWeek, {
	          width: 'wide',
	          context: 'formatting'
	        });
	    }
	  },
	  // Local day of week
	  e: function (date, token, localize, options) {
	    var dayOfWeek = date.getUTCDay();
	    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;

	    switch (token) {
	      // Numerical value (Nth day of week with current locale or weekStartsOn)
	      case 'e':
	        return String(localDayOfWeek);
	      // Padded numerical value

	      case 'ee':
	        return addLeadingZeros(localDayOfWeek, 2);
	      // 1st, 2nd, ..., 7th

	      case 'eo':
	        return localize.ordinalNumber(localDayOfWeek, {
	          unit: 'day'
	        });

	      case 'eee':
	        return localize.day(dayOfWeek, {
	          width: 'abbreviated',
	          context: 'formatting'
	        });
	      // T

	      case 'eeeee':
	        return localize.day(dayOfWeek, {
	          width: 'narrow',
	          context: 'formatting'
	        });
	      // Tu

	      case 'eeeeee':
	        return localize.day(dayOfWeek, {
	          width: 'short',
	          context: 'formatting'
	        });
	      // Tuesday

	      case 'eeee':
	      default:
	        return localize.day(dayOfWeek, {
	          width: 'wide',
	          context: 'formatting'
	        });
	    }
	  },
	  // Stand-alone local day of week
	  c: function (date, token, localize, options) {
	    var dayOfWeek = date.getUTCDay();
	    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;

	    switch (token) {
	      // Numerical value (same as in `e`)
	      case 'c':
	        return String(localDayOfWeek);
	      // Padded numerical value

	      case 'cc':
	        return addLeadingZeros(localDayOfWeek, token.length);
	      // 1st, 2nd, ..., 7th

	      case 'co':
	        return localize.ordinalNumber(localDayOfWeek, {
	          unit: 'day'
	        });

	      case 'ccc':
	        return localize.day(dayOfWeek, {
	          width: 'abbreviated',
	          context: 'standalone'
	        });
	      // T

	      case 'ccccc':
	        return localize.day(dayOfWeek, {
	          width: 'narrow',
	          context: 'standalone'
	        });
	      // Tu

	      case 'cccccc':
	        return localize.day(dayOfWeek, {
	          width: 'short',
	          context: 'standalone'
	        });
	      // Tuesday

	      case 'cccc':
	      default:
	        return localize.day(dayOfWeek, {
	          width: 'wide',
	          context: 'standalone'
	        });
	    }
	  },
	  // ISO day of week
	  i: function (date, token, localize) {
	    var dayOfWeek = date.getUTCDay();
	    var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;

	    switch (token) {
	      // 2
	      case 'i':
	        return String(isoDayOfWeek);
	      // 02

	      case 'ii':
	        return addLeadingZeros(isoDayOfWeek, token.length);
	      // 2nd

	      case 'io':
	        return localize.ordinalNumber(isoDayOfWeek, {
	          unit: 'day'
	        });
	      // Tue

	      case 'iii':
	        return localize.day(dayOfWeek, {
	          width: 'abbreviated',
	          context: 'formatting'
	        });
	      // T

	      case 'iiiii':
	        return localize.day(dayOfWeek, {
	          width: 'narrow',
	          context: 'formatting'
	        });
	      // Tu

	      case 'iiiiii':
	        return localize.day(dayOfWeek, {
	          width: 'short',
	          context: 'formatting'
	        });
	      // Tuesday

	      case 'iiii':
	      default:
	        return localize.day(dayOfWeek, {
	          width: 'wide',
	          context: 'formatting'
	        });
	    }
	  },
	  // AM or PM
	  a: function (date, token, localize) {
	    var hours = date.getUTCHours();
	    var dayPeriodEnumValue = hours / 12 >= 1 ? 'pm' : 'am';

	    switch (token) {
	      case 'a':
	      case 'aa':
	      case 'aaa':
	        return localize.dayPeriod(dayPeriodEnumValue, {
	          width: 'abbreviated',
	          context: 'formatting'
	        });

	      case 'aaaaa':
	        return localize.dayPeriod(dayPeriodEnumValue, {
	          width: 'narrow',
	          context: 'formatting'
	        });

	      case 'aaaa':
	      default:
	        return localize.dayPeriod(dayPeriodEnumValue, {
	          width: 'wide',
	          context: 'formatting'
	        });
	    }
	  },
	  // AM, PM, midnight, noon
	  b: function (date, token, localize) {
	    var hours = date.getUTCHours();
	    var dayPeriodEnumValue;

	    if (hours === 12) {
	      dayPeriodEnumValue = dayPeriodEnum.noon;
	    } else if (hours === 0) {
	      dayPeriodEnumValue = dayPeriodEnum.midnight;
	    } else {
	      dayPeriodEnumValue = hours / 12 >= 1 ? 'pm' : 'am';
	    }

	    switch (token) {
	      case 'b':
	      case 'bb':
	      case 'bbb':
	        return localize.dayPeriod(dayPeriodEnumValue, {
	          width: 'abbreviated',
	          context: 'formatting'
	        });

	      case 'bbbbb':
	        return localize.dayPeriod(dayPeriodEnumValue, {
	          width: 'narrow',
	          context: 'formatting'
	        });

	      case 'bbbb':
	      default:
	        return localize.dayPeriod(dayPeriodEnumValue, {
	          width: 'wide',
	          context: 'formatting'
	        });
	    }
	  },
	  // in the morning, in the afternoon, in the evening, at night
	  B: function (date, token, localize) {
	    var hours = date.getUTCHours();
	    var dayPeriodEnumValue;

	    if (hours >= 17) {
	      dayPeriodEnumValue = dayPeriodEnum.evening;
	    } else if (hours >= 12) {
	      dayPeriodEnumValue = dayPeriodEnum.afternoon;
	    } else if (hours >= 4) {
	      dayPeriodEnumValue = dayPeriodEnum.morning;
	    } else {
	      dayPeriodEnumValue = dayPeriodEnum.night;
	    }

	    switch (token) {
	      case 'B':
	      case 'BB':
	      case 'BBB':
	        return localize.dayPeriod(dayPeriodEnumValue, {
	          width: 'abbreviated',
	          context: 'formatting'
	        });

	      case 'BBBBB':
	        return localize.dayPeriod(dayPeriodEnumValue, {
	          width: 'narrow',
	          context: 'formatting'
	        });

	      case 'BBBB':
	      default:
	        return localize.dayPeriod(dayPeriodEnumValue, {
	          width: 'wide',
	          context: 'formatting'
	        });
	    }
	  },
	  // Hour [1-12]
	  h: function (date, token, localize) {
	    if (token === 'ho') {
	      var hours = date.getUTCHours() % 12;
	      if (hours === 0) hours = 12;
	      return localize.ordinalNumber(hours, {
	        unit: 'hour'
	      });
	    }

	    return formatters.h(date, token);
	  },
	  // Hour [0-23]
	  H: function (date, token, localize) {
	    if (token === 'Ho') {
	      return localize.ordinalNumber(date.getUTCHours(), {
	        unit: 'hour'
	      });
	    }

	    return formatters.H(date, token);
	  },
	  // Hour [0-11]
	  K: function (date, token, localize) {
	    var hours = date.getUTCHours() % 12;

	    if (token === 'Ko') {
	      return localize.ordinalNumber(hours, {
	        unit: 'hour'
	      });
	    }

	    return addLeadingZeros(hours, token.length);
	  },
	  // Hour [1-24]
	  k: function (date, token, localize) {
	    var hours = date.getUTCHours();
	    if (hours === 0) hours = 24;

	    if (token === 'ko') {
	      return localize.ordinalNumber(hours, {
	        unit: 'hour'
	      });
	    }

	    return addLeadingZeros(hours, token.length);
	  },
	  // Minute
	  m: function (date, token, localize) {
	    if (token === 'mo') {
	      return localize.ordinalNumber(date.getUTCMinutes(), {
	        unit: 'minute'
	      });
	    }

	    return formatters.m(date, token);
	  },
	  // Second
	  s: function (date, token, localize) {
	    if (token === 'so') {
	      return localize.ordinalNumber(date.getUTCSeconds(), {
	        unit: 'second'
	      });
	    }

	    return formatters.s(date, token);
	  },
	  // Fraction of second
	  S: function (date, token) {
	    return formatters.S(date, token);
	  },
	  // Timezone (ISO-8601. If offset is 0, output is always `'Z'`)
	  X: function (date, token, _localize, options) {
	    var originalDate = options._originalDate || date;
	    var timezoneOffset = originalDate.getTimezoneOffset();

	    if (timezoneOffset === 0) {
	      return 'Z';
	    }

	    switch (token) {
	      // Hours and optional minutes
	      case 'X':
	        return formatTimezoneWithOptionalMinutes(timezoneOffset);
	      // Hours, minutes and optional seconds without `:` delimiter
	      // Note: neither ISO-8601 nor JavaScript supports seconds in timezone offsets
	      // so this token always has the same output as `XX`

	      case 'XXXX':
	      case 'XX':
	        // Hours and minutes without `:` delimiter
	        return formatTimezone(timezoneOffset);
	      // Hours, minutes and optional seconds with `:` delimiter
	      // Note: neither ISO-8601 nor JavaScript supports seconds in timezone offsets
	      // so this token always has the same output as `XXX`

	      case 'XXXXX':
	      case 'XXX': // Hours and minutes with `:` delimiter

	      default:
	        return formatTimezone(timezoneOffset, ':');
	    }
	  },
	  // Timezone (ISO-8601. If offset is 0, output is `'+00:00'` or equivalent)
	  x: function (date, token, _localize, options) {
	    var originalDate = options._originalDate || date;
	    var timezoneOffset = originalDate.getTimezoneOffset();

	    switch (token) {
	      // Hours and optional minutes
	      case 'x':
	        return formatTimezoneWithOptionalMinutes(timezoneOffset);
	      // Hours, minutes and optional seconds without `:` delimiter
	      // Note: neither ISO-8601 nor JavaScript supports seconds in timezone offsets
	      // so this token always has the same output as `xx`

	      case 'xxxx':
	      case 'xx':
	        // Hours and minutes without `:` delimiter
	        return formatTimezone(timezoneOffset);
	      // Hours, minutes and optional seconds with `:` delimiter
	      // Note: neither ISO-8601 nor JavaScript supports seconds in timezone offsets
	      // so this token always has the same output as `xxx`

	      case 'xxxxx':
	      case 'xxx': // Hours and minutes with `:` delimiter

	      default:
	        return formatTimezone(timezoneOffset, ':');
	    }
	  },
	  // Timezone (GMT)
	  O: function (date, token, _localize, options) {
	    var originalDate = options._originalDate || date;
	    var timezoneOffset = originalDate.getTimezoneOffset();

	    switch (token) {
	      // Short
	      case 'O':
	      case 'OO':
	      case 'OOO':
	        return 'GMT' + formatTimezoneShort(timezoneOffset, ':');
	      // Long

	      case 'OOOO':
	      default:
	        return 'GMT' + formatTimezone(timezoneOffset, ':');
	    }
	  },
	  // Timezone (specific non-location)
	  z: function (date, token, _localize, options) {
	    var originalDate = options._originalDate || date;
	    var timezoneOffset = originalDate.getTimezoneOffset();

	    switch (token) {
	      // Short
	      case 'z':
	      case 'zz':
	      case 'zzz':
	        return 'GMT' + formatTimezoneShort(timezoneOffset, ':');
	      // Long

	      case 'zzzz':
	      default:
	        return 'GMT' + formatTimezone(timezoneOffset, ':');
	    }
	  },
	  // Seconds timestamp
	  t: function (date, token, _localize, options) {
	    var originalDate = options._originalDate || date;
	    var timestamp = Math.floor(originalDate.getTime() / 1000);
	    return addLeadingZeros(timestamp, token.length);
	  },
	  // Milliseconds timestamp
	  T: function (date, token, _localize, options) {
	    var originalDate = options._originalDate || date;
	    var timestamp = originalDate.getTime();
	    return addLeadingZeros(timestamp, token.length);
	  }
	};

	function formatTimezoneShort(offset, dirtyDelimiter) {
	  var sign = offset > 0 ? '-' : '+';
	  var absOffset = Math.abs(offset);
	  var hours = Math.floor(absOffset / 60);
	  var minutes = absOffset % 60;

	  if (minutes === 0) {
	    return sign + String(hours);
	  }

	  var delimiter = dirtyDelimiter || '';
	  return sign + String(hours) + delimiter + addLeadingZeros(minutes, 2);
	}

	function formatTimezoneWithOptionalMinutes(offset, dirtyDelimiter) {
	  if (offset % 60 === 0) {
	    var sign = offset > 0 ? '-' : '+';
	    return sign + addLeadingZeros(Math.abs(offset) / 60, 2);
	  }

	  return formatTimezone(offset, dirtyDelimiter);
	}

	function formatTimezone(offset, dirtyDelimiter) {
	  var delimiter = dirtyDelimiter || '';
	  var sign = offset > 0 ? '-' : '+';
	  var absOffset = Math.abs(offset);
	  var hours = addLeadingZeros(Math.floor(absOffset / 60), 2);
	  var minutes = addLeadingZeros(absOffset % 60, 2);
	  return sign + hours + delimiter + minutes;
	}

	function dateLongFormatter(pattern, formatLong) {
	  switch (pattern) {
	    case 'P':
	      return formatLong.date({
	        width: 'short'
	      });

	    case 'PP':
	      return formatLong.date({
	        width: 'medium'
	      });

	    case 'PPP':
	      return formatLong.date({
	        width: 'long'
	      });

	    case 'PPPP':
	    default:
	      return formatLong.date({
	        width: 'full'
	      });
	  }
	}

	function timeLongFormatter(pattern, formatLong) {
	  switch (pattern) {
	    case 'p':
	      return formatLong.time({
	        width: 'short'
	      });

	    case 'pp':
	      return formatLong.time({
	        width: 'medium'
	      });

	    case 'ppp':
	      return formatLong.time({
	        width: 'long'
	      });

	    case 'pppp':
	    default:
	      return formatLong.time({
	        width: 'full'
	      });
	  }
	}

	function dateTimeLongFormatter(pattern, formatLong) {
	  var matchResult = pattern.match(/(P+)(p+)?/);
	  var datePattern = matchResult[1];
	  var timePattern = matchResult[2];

	  if (!timePattern) {
	    return dateLongFormatter(pattern, formatLong);
	  }

	  var dateTimeFormat;

	  switch (datePattern) {
	    case 'P':
	      dateTimeFormat = formatLong.dateTime({
	        width: 'short'
	      });
	      break;

	    case 'PP':
	      dateTimeFormat = formatLong.dateTime({
	        width: 'medium'
	      });
	      break;

	    case 'PPP':
	      dateTimeFormat = formatLong.dateTime({
	        width: 'long'
	      });
	      break;

	    case 'PPPP':
	    default:
	      dateTimeFormat = formatLong.dateTime({
	        width: 'full'
	      });
	      break;
	  }

	  return dateTimeFormat.replace('{{date}}', dateLongFormatter(datePattern, formatLong)).replace('{{time}}', timeLongFormatter(timePattern, formatLong));
	}

	var longFormatters = {
	  p: timeLongFormatter,
	  P: dateTimeLongFormatter
	};

	var MILLISECONDS_IN_MINUTE = 60000;

	function getDateMillisecondsPart(date) {
	  return date.getTime() % MILLISECONDS_IN_MINUTE;
	}
	/**
	 * Google Chrome as of 67.0.3396.87 introduced timezones with offset that includes seconds.
	 * They usually appear for dates that denote time before the timezones were introduced
	 * (e.g. for 'Europe/Prague' timezone the offset is GMT+00:57:44 before 1 October 1891
	 * and GMT+01:00:00 after that date)
	 *
	 * Date#getTimezoneOffset returns the offset in minutes and would return 57 for the example above,
	 * which would lead to incorrect calculations.
	 *
	 * This function returns the timezone offset in milliseconds that takes seconds in account.
	 */


	function getTimezoneOffsetInMilliseconds(dirtyDate) {
	  var date = new Date(dirtyDate.getTime());
	  var baseTimezoneOffset = Math.ceil(date.getTimezoneOffset());
	  date.setSeconds(0, 0);
	  var hasNegativeUTCOffset = baseTimezoneOffset > 0;
	  var millisecondsPartOfTimezoneOffset = hasNegativeUTCOffset ? (MILLISECONDS_IN_MINUTE + getDateMillisecondsPart(date)) % MILLISECONDS_IN_MINUTE : getDateMillisecondsPart(date);
	  return baseTimezoneOffset * MILLISECONDS_IN_MINUTE + millisecondsPartOfTimezoneOffset;
	}

	var protectedDayOfYearTokens = ['D', 'DD'];
	var protectedWeekYearTokens = ['YY', 'YYYY'];
	function isProtectedDayOfYearToken(token) {
	  return protectedDayOfYearTokens.indexOf(token) !== -1;
	}
	function isProtectedWeekYearToken(token) {
	  return protectedWeekYearTokens.indexOf(token) !== -1;
	}
	function throwProtectedError(token, format, input) {
	  if (token === 'YYYY') {
	    throw new RangeError("Use `yyyy` instead of `YYYY` (in `".concat(format, "`) for formatting years to the input `").concat(input, "`; see: https://git.io/fxCyr"));
	  } else if (token === 'YY') {
	    throw new RangeError("Use `yy` instead of `YY` (in `".concat(format, "`) for formatting years to the input `").concat(input, "`; see: https://git.io/fxCyr"));
	  } else if (token === 'D') {
	    throw new RangeError("Use `d` instead of `D` (in `".concat(format, "`) for formatting days of the month to the input `").concat(input, "`; see: https://git.io/fxCyr"));
	  } else if (token === 'DD') {
	    throw new RangeError("Use `dd` instead of `DD` (in `".concat(format, "`) for formatting days of the month to the input `").concat(input, "`; see: https://git.io/fxCyr"));
	  }
	}

	// - [yYQqMLwIdDecihHKkms]o matches any available ordinal number token
	//   (one of the certain letters followed by `o`)
	// - (\w)\1* matches any sequences of the same letter
	// - '' matches two quote characters in a row
	// - '(''|[^'])+('|$) matches anything surrounded by two quote characters ('),
	//   except a single quote symbol, which ends the sequence.
	//   Two quote characters do not end the sequence.
	//   If there is no matching single quote
	//   then the sequence will continue until the end of the string.
	// - . matches any single character unmatched by previous parts of the RegExps

	var formattingTokensRegExp = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g; // This RegExp catches symbols escaped by quotes, and also
	// sequences of symbols P, p, and the combinations like `PPPPPPPppppp`

	var longFormattingTokensRegExp = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
	var escapedStringRegExp = /^'([^]*?)'?$/;
	var doubleQuoteRegExp = /''/g;
	var unescapedLatinCharacterRegExp = /[a-zA-Z]/;
	/**
	 * @name format
	 * @category Common Helpers
	 * @summary Format the date.
	 *
	 * @description
	 * Return the formatted date string in the given format. The result may vary by locale.
	 *
	 * > ⚠️ Please note that the `format` tokens differ from Moment.js and other libraries.
	 * > See: https://git.io/fxCyr
	 *
	 * The characters wrapped between two single quotes characters (') are escaped.
	 * Two single quotes in a row, whether inside or outside a quoted sequence, represent a 'real' single quote.
	 * (see the last example)
	 *
	 * Format of the string is based on Unicode Technical Standard #35:
	 * https://www.unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table
	 * with a few additions (see note 7 below the table).
	 *
	 * Accepted patterns:
	 * | Unit                            | Pattern | Result examples                   | Notes |
	 * |---------------------------------|---------|-----------------------------------|-------|
	 * | Era                             | G..GGG  | AD, BC                            |       |
	 * |                                 | GGGG    | Anno Domini, Before Christ        | 2     |
	 * |                                 | GGGGG   | A, B                              |       |
	 * | Calendar year                   | y       | 44, 1, 1900, 2017                 | 5     |
	 * |                                 | yo      | 44th, 1st, 0th, 17th              | 5,7   |
	 * |                                 | yy      | 44, 01, 00, 17                    | 5     |
	 * |                                 | yyy     | 044, 001, 1900, 2017              | 5     |
	 * |                                 | yyyy    | 0044, 0001, 1900, 2017            | 5     |
	 * |                                 | yyyyy   | ...                               | 3,5   |
	 * | Local week-numbering year       | Y       | 44, 1, 1900, 2017                 | 5     |
	 * |                                 | Yo      | 44th, 1st, 1900th, 2017th         | 5,7   |
	 * |                                 | YY      | 44, 01, 00, 17                    | 5,8   |
	 * |                                 | YYY     | 044, 001, 1900, 2017              | 5     |
	 * |                                 | YYYY    | 0044, 0001, 1900, 2017            | 5,8   |
	 * |                                 | YYYYY   | ...                               | 3,5   |
	 * | ISO week-numbering year         | R       | -43, 0, 1, 1900, 2017             | 5,7   |
	 * |                                 | RR      | -43, 00, 01, 1900, 2017           | 5,7   |
	 * |                                 | RRR     | -043, 000, 001, 1900, 2017        | 5,7   |
	 * |                                 | RRRR    | -0043, 0000, 0001, 1900, 2017     | 5,7   |
	 * |                                 | RRRRR   | ...                               | 3,5,7 |
	 * | Extended year                   | u       | -43, 0, 1, 1900, 2017             | 5     |
	 * |                                 | uu      | -43, 01, 1900, 2017               | 5     |
	 * |                                 | uuu     | -043, 001, 1900, 2017             | 5     |
	 * |                                 | uuuu    | -0043, 0001, 1900, 2017           | 5     |
	 * |                                 | uuuuu   | ...                               | 3,5   |
	 * | Quarter (formatting)            | Q       | 1, 2, 3, 4                        |       |
	 * |                                 | Qo      | 1st, 2nd, 3rd, 4th                | 7     |
	 * |                                 | QQ      | 01, 02, 03, 04                    |       |
	 * |                                 | QQQ     | Q1, Q2, Q3, Q4                    |       |
	 * |                                 | QQQQ    | 1st quarter, 2nd quarter, ...     | 2     |
	 * |                                 | QQQQQ   | 1, 2, 3, 4                        | 4     |
	 * | Quarter (stand-alone)           | q       | 1, 2, 3, 4                        |       |
	 * |                                 | qo      | 1st, 2nd, 3rd, 4th                | 7     |
	 * |                                 | qq      | 01, 02, 03, 04                    |       |
	 * |                                 | qqq     | Q1, Q2, Q3, Q4                    |       |
	 * |                                 | qqqq    | 1st quarter, 2nd quarter, ...     | 2     |
	 * |                                 | qqqqq   | 1, 2, 3, 4                        | 4     |
	 * | Month (formatting)              | M       | 1, 2, ..., 12                     |       |
	 * |                                 | Mo      | 1st, 2nd, ..., 12th               | 7     |
	 * |                                 | MM      | 01, 02, ..., 12                   |       |
	 * |                                 | MMM     | Jan, Feb, ..., Dec                |       |
	 * |                                 | MMMM    | January, February, ..., December  | 2     |
	 * |                                 | MMMMM   | J, F, ..., D                      |       |
	 * | Month (stand-alone)             | L       | 1, 2, ..., 12                     |       |
	 * |                                 | Lo      | 1st, 2nd, ..., 12th               | 7     |
	 * |                                 | LL      | 01, 02, ..., 12                   |       |
	 * |                                 | LLL     | Jan, Feb, ..., Dec                |       |
	 * |                                 | LLLL    | January, February, ..., December  | 2     |
	 * |                                 | LLLLL   | J, F, ..., D                      |       |
	 * | Local week of year              | w       | 1, 2, ..., 53                     |       |
	 * |                                 | wo      | 1st, 2nd, ..., 53th               | 7     |
	 * |                                 | ww      | 01, 02, ..., 53                   |       |
	 * | ISO week of year                | I       | 1, 2, ..., 53                     | 7     |
	 * |                                 | Io      | 1st, 2nd, ..., 53th               | 7     |
	 * |                                 | II      | 01, 02, ..., 53                   | 7     |
	 * | Day of month                    | d       | 1, 2, ..., 31                     |       |
	 * |                                 | do      | 1st, 2nd, ..., 31st               | 7     |
	 * |                                 | dd      | 01, 02, ..., 31                   |       |
	 * | Day of year                     | D       | 1, 2, ..., 365, 366               | 9     |
	 * |                                 | Do      | 1st, 2nd, ..., 365th, 366th       | 7     |
	 * |                                 | DD      | 01, 02, ..., 365, 366             | 9     |
	 * |                                 | DDD     | 001, 002, ..., 365, 366           |       |
	 * |                                 | DDDD    | ...                               | 3     |
	 * | Day of week (formatting)        | E..EEE  | Mon, Tue, Wed, ..., Sun           |       |
	 * |                                 | EEEE    | Monday, Tuesday, ..., Sunday      | 2     |
	 * |                                 | EEEEE   | M, T, W, T, F, S, S               |       |
	 * |                                 | EEEEEE  | Mo, Tu, We, Th, Fr, Su, Sa        |       |
	 * | ISO day of week (formatting)    | i       | 1, 2, 3, ..., 7                   | 7     |
	 * |                                 | io      | 1st, 2nd, ..., 7th                | 7     |
	 * |                                 | ii      | 01, 02, ..., 07                   | 7     |
	 * |                                 | iii     | Mon, Tue, Wed, ..., Sun           | 7     |
	 * |                                 | iiii    | Monday, Tuesday, ..., Sunday      | 2,7   |
	 * |                                 | iiiii   | M, T, W, T, F, S, S               | 7     |
	 * |                                 | iiiiii  | Mo, Tu, We, Th, Fr, Su, Sa        | 7     |
	 * | Local day of week (formatting)  | e       | 2, 3, 4, ..., 1                   |       |
	 * |                                 | eo      | 2nd, 3rd, ..., 1st                | 7     |
	 * |                                 | ee      | 02, 03, ..., 01                   |       |
	 * |                                 | eee     | Mon, Tue, Wed, ..., Sun           |       |
	 * |                                 | eeee    | Monday, Tuesday, ..., Sunday      | 2     |
	 * |                                 | eeeee   | M, T, W, T, F, S, S               |       |
	 * |                                 | eeeeee  | Mo, Tu, We, Th, Fr, Su, Sa        |       |
	 * | Local day of week (stand-alone) | c       | 2, 3, 4, ..., 1                   |       |
	 * |                                 | co      | 2nd, 3rd, ..., 1st                | 7     |
	 * |                                 | cc      | 02, 03, ..., 01                   |       |
	 * |                                 | ccc     | Mon, Tue, Wed, ..., Sun           |       |
	 * |                                 | cccc    | Monday, Tuesday, ..., Sunday      | 2     |
	 * |                                 | ccccc   | M, T, W, T, F, S, S               |       |
	 * |                                 | cccccc  | Mo, Tu, We, Th, Fr, Su, Sa        |       |
	 * | AM, PM                          | a..aaa  | AM, PM                            |       |
	 * |                                 | aaaa    | a.m., p.m.                        | 2     |
	 * |                                 | aaaaa   | a, p                              |       |
	 * | AM, PM, noon, midnight          | b..bbb  | AM, PM, noon, midnight            |       |
	 * |                                 | bbbb    | a.m., p.m., noon, midnight        | 2     |
	 * |                                 | bbbbb   | a, p, n, mi                       |       |
	 * | Flexible day period             | B..BBB  | at night, in the morning, ...     |       |
	 * |                                 | BBBB    | at night, in the morning, ...     | 2     |
	 * |                                 | BBBBB   | at night, in the morning, ...     |       |
	 * | Hour [1-12]                     | h       | 1, 2, ..., 11, 12                 |       |
	 * |                                 | ho      | 1st, 2nd, ..., 11th, 12th         | 7     |
	 * |                                 | hh      | 01, 02, ..., 11, 12               |       |
	 * | Hour [0-23]                     | H       | 0, 1, 2, ..., 23                  |       |
	 * |                                 | Ho      | 0th, 1st, 2nd, ..., 23rd          | 7     |
	 * |                                 | HH      | 00, 01, 02, ..., 23               |       |
	 * | Hour [0-11]                     | K       | 1, 2, ..., 11, 0                  |       |
	 * |                                 | Ko      | 1st, 2nd, ..., 11th, 0th          | 7     |
	 * |                                 | KK      | 01, 02, ..., 11, 00               |       |
	 * | Hour [1-24]                     | k       | 24, 1, 2, ..., 23                 |       |
	 * |                                 | ko      | 24th, 1st, 2nd, ..., 23rd         | 7     |
	 * |                                 | kk      | 24, 01, 02, ..., 23               |       |
	 * | Minute                          | m       | 0, 1, ..., 59                     |       |
	 * |                                 | mo      | 0th, 1st, ..., 59th               | 7     |
	 * |                                 | mm      | 00, 01, ..., 59                   |       |
	 * | Second                          | s       | 0, 1, ..., 59                     |       |
	 * |                                 | so      | 0th, 1st, ..., 59th               | 7     |
	 * |                                 | ss      | 00, 01, ..., 59                   |       |
	 * | Fraction of second              | S       | 0, 1, ..., 9                      |       |
	 * |                                 | SS      | 00, 01, ..., 99                   |       |
	 * |                                 | SSS     | 000, 0001, ..., 999               |       |
	 * |                                 | SSSS    | ...                               | 3     |
	 * | Timezone (ISO-8601 w/ Z)        | X       | -08, +0530, Z                     |       |
	 * |                                 | XX      | -0800, +0530, Z                   |       |
	 * |                                 | XXX     | -08:00, +05:30, Z                 |       |
	 * |                                 | XXXX    | -0800, +0530, Z, +123456          | 2     |
	 * |                                 | XXXXX   | -08:00, +05:30, Z, +12:34:56      |       |
	 * | Timezone (ISO-8601 w/o Z)       | x       | -08, +0530, +00                   |       |
	 * |                                 | xx      | -0800, +0530, +0000               |       |
	 * |                                 | xxx     | -08:00, +05:30, +00:00            | 2     |
	 * |                                 | xxxx    | -0800, +0530, +0000, +123456      |       |
	 * |                                 | xxxxx   | -08:00, +05:30, +00:00, +12:34:56 |       |
	 * | Timezone (GMT)                  | O...OOO | GMT-8, GMT+5:30, GMT+0            |       |
	 * |                                 | OOOO    | GMT-08:00, GMT+05:30, GMT+00:00   | 2     |
	 * | Timezone (specific non-locat.)  | z...zzz | GMT-8, GMT+5:30, GMT+0            | 6     |
	 * |                                 | zzzz    | GMT-08:00, GMT+05:30, GMT+00:00   | 2,6   |
	 * | Seconds timestamp               | t       | 512969520                         | 7     |
	 * |                                 | tt      | ...                               | 3,7   |
	 * | Milliseconds timestamp          | T       | 512969520900                      | 7     |
	 * |                                 | TT      | ...                               | 3,7   |
	 * | Long localized date             | P       | 05/29/1453                        | 7     |
	 * |                                 | PP      | May 29, 1453                      | 7     |
	 * |                                 | PPP     | May 29th, 1453                    | 7     |
	 * |                                 | PPPP    | Sunday, May 29th, 1453            | 2,7   |
	 * | Long localized time             | p       | 12:00 AM                          | 7     |
	 * |                                 | pp      | 12:00:00 AM                       | 7     |
	 * |                                 | ppp     | 12:00:00 AM GMT+2                 | 7     |
	 * |                                 | pppp    | 12:00:00 AM GMT+02:00             | 2,7   |
	 * | Combination of date and time    | Pp      | 05/29/1453, 12:00 AM              | 7     |
	 * |                                 | PPpp    | May 29, 1453, 12:00:00 AM         | 7     |
	 * |                                 | PPPppp  | May 29th, 1453 at ...             | 7     |
	 * |                                 | PPPPpppp| Sunday, May 29th, 1453 at ...     | 2,7   |
	 * Notes:
	 * 1. "Formatting" units (e.g. formatting quarter) in the default en-US locale
	 *    are the same as "stand-alone" units, but are different in some languages.
	 *    "Formatting" units are declined according to the rules of the language
	 *    in the context of a date. "Stand-alone" units are always nominative singular:
	 *
	 *    `format(new Date(2017, 10, 6), 'do LLLL', {locale: cs}) //=> '6. listopad'`
	 *
	 *    `format(new Date(2017, 10, 6), 'do MMMM', {locale: cs}) //=> '6. listopadu'`
	 *
	 * 2. Any sequence of the identical letters is a pattern, unless it is escaped by
	 *    the single quote characters (see below).
	 *    If the sequence is longer than listed in table (e.g. `EEEEEEEEEEE`)
	 *    the output will be the same as default pattern for this unit, usually
	 *    the longest one (in case of ISO weekdays, `EEEE`). Default patterns for units
	 *    are marked with "2" in the last column of the table.
	 *
	 *    `format(new Date(2017, 10, 6), 'MMM') //=> 'Nov'`
	 *
	 *    `format(new Date(2017, 10, 6), 'MMMM') //=> 'November'`
	 *
	 *    `format(new Date(2017, 10, 6), 'MMMMM') //=> 'N'`
	 *
	 *    `format(new Date(2017, 10, 6), 'MMMMMM') //=> 'November'`
	 *
	 *    `format(new Date(2017, 10, 6), 'MMMMMMM') //=> 'November'`
	 *
	 * 3. Some patterns could be unlimited length (such as `yyyyyyyy`).
	 *    The output will be padded with zeros to match the length of the pattern.
	 *
	 *    `format(new Date(2017, 10, 6), 'yyyyyyyy') //=> '00002017'`
	 *
	 * 4. `QQQQQ` and `qqqqq` could be not strictly numerical in some locales.
	 *    These tokens represent the shortest form of the quarter.
	 *
	 * 5. The main difference between `y` and `u` patterns are B.C. years:
	 *
	 *    | Year | `y` | `u` |
	 *    |------|-----|-----|
	 *    | AC 1 |   1 |   1 |
	 *    | BC 1 |   1 |   0 |
	 *    | BC 2 |   2 |  -1 |
	 *
	 *    Also `yy` always returns the last two digits of a year,
	 *    while `uu` pads single digit years to 2 characters and returns other years unchanged:
	 *
	 *    | Year | `yy` | `uu` |
	 *    |------|------|------|
	 *    | 1    |   01 |   01 |
	 *    | 14   |   14 |   14 |
	 *    | 376  |   76 |  376 |
	 *    | 1453 |   53 | 1453 |
	 *
	 *    The same difference is true for local and ISO week-numbering years (`Y` and `R`),
	 *    except local week-numbering years are dependent on `options.weekStartsOn`
	 *    and `options.firstWeekContainsDate` (compare [getISOWeekYear]{@link https://date-fns.org/docs/getISOWeekYear}
	 *    and [getWeekYear]{@link https://date-fns.org/docs/getWeekYear}).
	 *
	 * 6. Specific non-location timezones are currently unavailable in `date-fns`,
	 *    so right now these tokens fall back to GMT timezones.
	 *
	 * 7. These patterns are not in the Unicode Technical Standard #35:
	 *    - `i`: ISO day of week
	 *    - `I`: ISO week of year
	 *    - `R`: ISO week-numbering year
	 *    - `t`: seconds timestamp
	 *    - `T`: milliseconds timestamp
	 *    - `o`: ordinal number modifier
	 *    - `P`: long localized date
	 *    - `p`: long localized time
	 *
	 * 8. `YY` and `YYYY` tokens represent week-numbering years but they are often confused with years.
	 *    You should enable `options.useAdditionalWeekYearTokens` to use them. See: https://git.io/fxCyr
	 *
	 * 9. `D` and `DD` tokens represent days of the year but they are ofthen confused with days of the month.
	 *    You should enable `options.useAdditionalDayOfYearTokens` to use them. See: https://git.io/fxCyr
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * - The second argument is now required for the sake of explicitness.
	 *
	 *   ```javascript
	 *   // Before v2.0.0
	 *   format(new Date(2016, 0, 1))
	 *
	 *   // v2.0.0 onward
	 *   format(new Date(2016, 0, 1), "yyyy-MM-dd'T'HH:mm:ss.SSSxxx")
	 *   ```
	 *
	 * - New format string API for `format` function
	 *   which is based on [Unicode Technical Standard #35](https://www.unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table).
	 *   See [this post](https://blog.date-fns.org/post/unicode-tokens-in-date-fns-v2-sreatyki91jg) for more details.
	 *
	 * - Characters are now escaped using single quote symbols (`'`) instead of square brackets.
	 *
	 * @param {Date|Number} date - the original date
	 * @param {String} format - the string of tokens
	 * @param {Object} [options] - an object with options.
	 * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
	 * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
	 * @param {Number} [options.firstWeekContainsDate=1] - the day of January, which is
	 * @param {Boolean} [options.useAdditionalWeekYearTokens=false] - if true, allows usage of the week-numbering year tokens `YY` and `YYYY`;
	 *   see: https://git.io/fxCyr
	 * @param {Boolean} [options.useAdditionalDayOfYearTokens=false] - if true, allows usage of the day of year tokens `D` and `DD`;
	 *   see: https://git.io/fxCyr
	 * @returns {String} the formatted date string
	 * @throws {TypeError} 2 arguments required
	 * @throws {RangeError} `date` must not be Invalid Date
	 * @throws {RangeError} `options.locale` must contain `localize` property
	 * @throws {RangeError} `options.locale` must contain `formatLong` property
	 * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
	 * @throws {RangeError} `options.firstWeekContainsDate` must be between 1 and 7
	 * @throws {RangeError} use `yyyy` instead of `YYYY` for formatting years using [format provided] to the input [input provided]; see: https://git.io/fxCyr
	 * @throws {RangeError} use `yy` instead of `YY` for formatting years using [format provided] to the input [input provided]; see: https://git.io/fxCyr
	 * @throws {RangeError} use `d` instead of `D` for formatting days of the month using [format provided] to the input [input provided]; see: https://git.io/fxCyr
	 * @throws {RangeError} use `dd` instead of `DD` for formatting days of the month using [format provided] to the input [input provided]; see: https://git.io/fxCyr
	 * @throws {RangeError} format string contains an unescaped latin alphabet character
	 *
	 * @example
	 * // Represent 11 February 2014 in middle-endian format:
	 * var result = format(new Date(2014, 1, 11), 'MM/dd/yyyy')
	 * //=> '02/11/2014'
	 *
	 * @example
	 * // Represent 2 July 2014 in Esperanto:
	 * import { eoLocale } from 'date-fns/locale/eo'
	 * var result = format(new Date(2014, 6, 2), "do 'de' MMMM yyyy", {
	 *   locale: eoLocale
	 * })
	 * //=> '2-a de julio 2014'
	 *
	 * @example
	 * // Escape string by single quote characters:
	 * var result = format(new Date(2014, 6, 2, 15), "h 'o''clock'")
	 * //=> "3 o'clock"
	 */

	function format(dirtyDate, dirtyFormatStr, dirtyOptions) {
	  requiredArgs(2, arguments);
	  var formatStr = String(dirtyFormatStr);
	  var options = dirtyOptions || {};
	  var locale$1 = options.locale || locale;
	  var localeFirstWeekContainsDate = locale$1.options && locale$1.options.firstWeekContainsDate;
	  var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger(localeFirstWeekContainsDate);
	  var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger(options.firstWeekContainsDate); // Test if weekStartsOn is between 1 and 7 _and_ is not NaN

	  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
	    throw new RangeError('firstWeekContainsDate must be between 1 and 7 inclusively');
	  }

	  var localeWeekStartsOn = locale$1.options && locale$1.options.weekStartsOn;
	  var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger(localeWeekStartsOn);
	  var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger(options.weekStartsOn); // Test if weekStartsOn is between 0 and 6 _and_ is not NaN

	  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
	    throw new RangeError('weekStartsOn must be between 0 and 6 inclusively');
	  }

	  if (!locale$1.localize) {
	    throw new RangeError('locale must contain localize property');
	  }

	  if (!locale$1.formatLong) {
	    throw new RangeError('locale must contain formatLong property');
	  }

	  var originalDate = toDate(dirtyDate);

	  if (!isValid(originalDate)) {
	    throw new RangeError('Invalid time value');
	  } // Convert the date in system timezone to the same date in UTC+00:00 timezone.
	  // This ensures that when UTC functions will be implemented, locales will be compatible with them.
	  // See an issue about UTC functions: https://github.com/date-fns/date-fns/issues/376


	  var timezoneOffset = getTimezoneOffsetInMilliseconds(originalDate);
	  var utcDate = subMilliseconds(originalDate, timezoneOffset);
	  var formatterOptions = {
	    firstWeekContainsDate: firstWeekContainsDate,
	    weekStartsOn: weekStartsOn,
	    locale: locale$1,
	    _originalDate: originalDate
	  };
	  var result = formatStr.match(longFormattingTokensRegExp).map(function (substring) {
	    var firstCharacter = substring[0];

	    if (firstCharacter === 'p' || firstCharacter === 'P') {
	      var longFormatter = longFormatters[firstCharacter];
	      return longFormatter(substring, locale$1.formatLong, formatterOptions);
	    }

	    return substring;
	  }).join('').match(formattingTokensRegExp).map(function (substring) {
	    // Replace two single quote characters with one single quote character
	    if (substring === "''") {
	      return "'";
	    }

	    var firstCharacter = substring[0];

	    if (firstCharacter === "'") {
	      return cleanEscapedString(substring);
	    }

	    var formatter = formatters$1[firstCharacter];

	    if (formatter) {
	      if (!options.useAdditionalWeekYearTokens && isProtectedWeekYearToken(substring)) {
	        throwProtectedError(substring, dirtyFormatStr, dirtyDate);
	      }

	      if (!options.useAdditionalDayOfYearTokens && isProtectedDayOfYearToken(substring)) {
	        throwProtectedError(substring, dirtyFormatStr, dirtyDate);
	      }

	      return formatter(utcDate, substring, locale$1.localize, formatterOptions);
	    }

	    if (firstCharacter.match(unescapedLatinCharacterRegExp)) {
	      throw new RangeError('Format string contains an unescaped latin alphabet character `' + firstCharacter + '`');
	    }

	    return substring;
	  }).join('');
	  return result;
	}

	function cleanEscapedString(input) {
	  return input.match(escapedStringRegExp)[1].replace(doubleQuoteRegExp, "'");
	}

	var MILLISECONDS_IN_MINUTE$1 = 60000;
	/**
	 * @name addMinutes
	 * @category Minute Helpers
	 * @summary Add the specified number of minutes to the given date.
	 *
	 * @description
	 * Add the specified number of minutes to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of minutes to be added. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the minutes added
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Add 30 minutes to 10 July 2014 12:00:00:
	 * var result = addMinutes(new Date(2014, 6, 10, 12, 0), 30)
	 * //=> Thu Jul 10 2014 12:30:00
	 */

	function addMinutes(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var amount = toInteger(dirtyAmount);
	  return addMilliseconds(dirtyDate, amount * MILLISECONDS_IN_MINUTE$1);
	}

	var MILLISECONDS_IN_HOUR = 3600000;
	/**
	 * @name addHours
	 * @category Hour Helpers
	 * @summary Add the specified number of hours to the given date.
	 *
	 * @description
	 * Add the specified number of hours to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of hours to be added. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the hours added
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Add 2 hours to 10 July 2014 23:00:00:
	 * var result = addHours(new Date(2014, 6, 10, 23, 0), 2)
	 * //=> Fri Jul 11 2014 01:00:00
	 */

	function addHours(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var amount = toInteger(dirtyAmount);
	  return addMilliseconds(dirtyDate, amount * MILLISECONDS_IN_HOUR);
	}

	/**
	 * @name addDays
	 * @category Day Helpers
	 * @summary Add the specified number of days to the given date.
	 *
	 * @description
	 * Add the specified number of days to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of days to be added. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the days added
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Add 10 days to 1 September 2014:
	 * var result = addDays(new Date(2014, 8, 1), 10)
	 * //=> Thu Sep 11 2014 00:00:00
	 */

	function addDays(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var amount = toInteger(dirtyAmount);

	  if (isNaN(amount)) {
	    return new Date(NaN);
	  }

	  if (!amount) {
	    // If 0 days, no-op to avoid changing times in the hour before end of DST
	    return date;
	  }

	  date.setDate(date.getDate() + amount);
	  return date;
	}

	/**
	 * @name addWeeks
	 * @category Week Helpers
	 * @summary Add the specified number of weeks to the given date.
	 *
	 * @description
	 * Add the specified number of week to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of weeks to be added. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the weeks added
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Add 4 weeks to 1 September 2014:
	 * var result = addWeeks(new Date(2014, 8, 1), 4)
	 * //=> Mon Sep 29 2014 00:00:00
	 */

	function addWeeks(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var amount = toInteger(dirtyAmount);
	  var days = amount * 7;
	  return addDays(dirtyDate, days);
	}

	/**
	 * @name addMonths
	 * @category Month Helpers
	 * @summary Add the specified number of months to the given date.
	 *
	 * @description
	 * Add the specified number of months to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of months to be added. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the months added
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Add 5 months to 1 September 2014:
	 * var result = addMonths(new Date(2014, 8, 1), 5)
	 * //=> Sun Feb 01 2015 00:00:00
	 */

	function addMonths(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var amount = toInteger(dirtyAmount);

	  if (isNaN(amount)) {
	    return new Date(NaN);
	  }

	  if (!amount) {
	    // If 0 months, no-op to avoid changing times in the hour before end of DST
	    return date;
	  }

	  var dayOfMonth = date.getDate(); // The JS Date object supports date math by accepting out-of-bounds values for
	  // month, day, etc. For example, new Date(2020, 1, 0) returns 31 Dec 2019 and
	  // new Date(2020, 13, 1) returns 1 Feb 2021.  This is *almost* the behavior we
	  // want except that dates will wrap around the end of a month, meaning that
	  // new Date(2020, 13, 31) will return 3 Mar 2021 not 28 Feb 2021 as desired. So
	  // we'll default to the end of the desired month by adding 1 to the desired
	  // month and using a date of 0 to back up one day to the end of the desired
	  // month.

	  var endOfDesiredMonth = new Date(date.getTime());
	  endOfDesiredMonth.setMonth(date.getMonth() + amount + 1, 0);
	  var daysInMonth = endOfDesiredMonth.getDate();

	  if (dayOfMonth >= daysInMonth) {
	    // If we're already at the end of the month, then this is the correct date
	    // and we're done.
	    return endOfDesiredMonth;
	  } else {
	    // Otherwise, we now know that setting the original day-of-month value won't
	    // cause an overflow, so set the desired day-of-month. Note that we can't
	    // just set the date of `endOfDesiredMonth` because that object may have had
	    // its time changed in the unusual case where where a DST transition was on
	    // the last day of the month and its local time was in the hour skipped or
	    // repeated next to a DST transition.  So we use `date` instead which is
	    // guaranteed to still have the original time.
	    date.setFullYear(endOfDesiredMonth.getFullYear(), endOfDesiredMonth.getMonth(), dayOfMonth);
	    return date;
	  }
	}

	/**
	 * @name addYears
	 * @category Year Helpers
	 * @summary Add the specified number of years to the given date.
	 *
	 * @description
	 * Add the specified number of years to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of years to be added. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the years added
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Add 5 years to 1 September 2014:
	 * var result = addYears(new Date(2014, 8, 1), 5)
	 * //=> Sun Sep 01 2019 00:00:00
	 */

	function addYears(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var amount = toInteger(dirtyAmount);
	  return addMonths(dirtyDate, amount * 12);
	}

	/**
	 * @name subDays
	 * @category Day Helpers
	 * @summary Subtract the specified number of days from the given date.
	 *
	 * @description
	 * Subtract the specified number of days from the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of days to be subtracted. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the days subtracted
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Subtract 10 days from 1 September 2014:
	 * var result = subDays(new Date(2014, 8, 1), 10)
	 * //=> Fri Aug 22 2014 00:00:00
	 */

	function subDays(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var amount = toInteger(dirtyAmount);
	  return addDays(dirtyDate, -amount);
	}

	/**
	 * @name subWeeks
	 * @category Week Helpers
	 * @summary Subtract the specified number of weeks from the given date.
	 *
	 * @description
	 * Subtract the specified number of weeks from the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of weeks to be subtracted. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the weeks subtracted
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Subtract 4 weeks from 1 September 2014:
	 * var result = subWeeks(new Date(2014, 8, 1), 4)
	 * //=> Mon Aug 04 2014 00:00:00
	 */

	function subWeeks(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var amount = toInteger(dirtyAmount);
	  return addWeeks(dirtyDate, -amount);
	}

	/**
	 * @name subMonths
	 * @category Month Helpers
	 * @summary Subtract the specified number of months from the given date.
	 *
	 * @description
	 * Subtract the specified number of months from the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of months to be subtracted. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the months subtracted
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Subtract 5 months from 1 February 2015:
	 * var result = subMonths(new Date(2015, 1, 1), 5)
	 * //=> Mon Sep 01 2014 00:00:00
	 */

	function subMonths(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var amount = toInteger(dirtyAmount);
	  return addMonths(dirtyDate, -amount);
	}

	/**
	 * @name subYears
	 * @category Year Helpers
	 * @summary Subtract the specified number of years from the given date.
	 *
	 * @description
	 * Subtract the specified number of years from the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} amount - the amount of years to be subtracted. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
	 * @returns {Date} the new date with the years subtracted
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Subtract 5 years from 1 September 2014:
	 * var result = subYears(new Date(2014, 8, 1), 5)
	 * //=> Tue Sep 01 2009 00:00:00
	 */

	function subYears(dirtyDate, dirtyAmount) {
	  requiredArgs(2, arguments);
	  var amount = toInteger(dirtyAmount);
	  return addYears(dirtyDate, -amount);
	}

	/**
	 * @name getSeconds
	 * @category Second Helpers
	 * @summary Get the seconds of the given date.
	 *
	 * @description
	 * Get the seconds of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {Number} the seconds
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Get the seconds of 29 February 2012 11:45:05.123:
	 * var result = getSeconds(new Date(2012, 1, 29, 11, 45, 5, 123))
	 * //=> 5
	 */

	function getSeconds(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var seconds = date.getSeconds();
	  return seconds;
	}

	/**
	 * @name getMinutes
	 * @category Minute Helpers
	 * @summary Get the minutes of the given date.
	 *
	 * @description
	 * Get the minutes of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {Number} the minutes
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Get the minutes of 29 February 2012 11:45:05:
	 * var result = getMinutes(new Date(2012, 1, 29, 11, 45, 5))
	 * //=> 45
	 */

	function getMinutes(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var minutes = date.getMinutes();
	  return minutes;
	}

	/**
	 * @name getHours
	 * @category Hour Helpers
	 * @summary Get the hours of the given date.
	 *
	 * @description
	 * Get the hours of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {Number} the hours
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Get the hours of 29 February 2012 11:45:00:
	 * var result = getHours(new Date(2012, 1, 29, 11, 45))
	 * //=> 11
	 */

	function getHours(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var hours = date.getHours();
	  return hours;
	}

	/**
	 * @name getDay
	 * @category Weekday Helpers
	 * @summary Get the day of the week of the given date.
	 *
	 * @description
	 * Get the day of the week of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {0|1|2|3|4|5|6} the day of week, 0 represents Sunday
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Which day of the week is 29 February 2012?
	 * var result = getDay(new Date(2012, 1, 29))
	 * //=> 3
	 */

	function getDay(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var day = date.getDay();
	  return day;
	}

	/**
	 * @name getDate
	 * @category Day Helpers
	 * @summary Get the day of the month of the given date.
	 *
	 * @description
	 * Get the day of the month of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {Number} the day of month
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Which day of the month is 29 February 2012?
	 * var result = getDate(new Date(2012, 1, 29))
	 * //=> 29
	 */

	function getDate(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var dayOfMonth = date.getDate();
	  return dayOfMonth;
	}

	/**
	 * @name startOfWeek
	 * @category Week Helpers
	 * @summary Return the start of a week for the given date.
	 *
	 * @description
	 * Return the start of a week for the given date.
	 * The result will be in the local timezone.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the original date
	 * @param {Object} [options] - an object with options.
	 * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
	 * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
	 * @returns {Date} the start of a week
	 * @throws {TypeError} 1 argument required
	 * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
	 *
	 * @example
	 * // The start of a week for 2 September 2014 11:55:00:
	 * var result = startOfWeek(new Date(2014, 8, 2, 11, 55, 0))
	 * //=> Sun Aug 31 2014 00:00:00
	 *
	 * @example
	 * // If the week starts on Monday, the start of the week for 2 September 2014 11:55:00:
	 * var result = startOfWeek(new Date(2014, 8, 2, 11, 55, 0), { weekStartsOn: 1 })
	 * //=> Mon Sep 01 2014 00:00:00
	 */

	function startOfWeek(dirtyDate, dirtyOptions) {
	  requiredArgs(1, arguments);
	  var options = dirtyOptions || {};
	  var locale = options.locale;
	  var localeWeekStartsOn = locale && locale.options && locale.options.weekStartsOn;
	  var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger(localeWeekStartsOn);
	  var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger(options.weekStartsOn); // Test if weekStartsOn is between 0 and 6 _and_ is not NaN

	  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
	    throw new RangeError('weekStartsOn must be between 0 and 6 inclusively');
	  }

	  var date = toDate(dirtyDate);
	  var day = date.getDay();
	  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
	  date.setDate(date.getDate() - diff);
	  date.setHours(0, 0, 0, 0);
	  return date;
	}

	/**
	 * @name getWeekYear
	 * @category Week-Numbering Year Helpers
	 * @summary Get the local week-numbering year of the given date.
	 *
	 * @description
	 * Get the local week-numbering year of the given date.
	 * The exact calculation depends on the values of
	 * `options.weekStartsOn` (which is the index of the first day of the week)
	 * and `options.firstWeekContainsDate` (which is the day of January, which is always in
	 * the first week of the week-numbering year)
	 *
	 * Week numbering: https://en.wikipedia.org/wiki/Week#Week_numbering
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @param {Object} [options] - an object with options.
	 * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
	 * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
	 * @param {1|2|3|4|5|6|7} [options.firstWeekContainsDate=1] - the day of January, which is always in the first week of the year
	 * @returns {Number} the local week-numbering year
	 * @throws {TypeError} 1 argument required
	 * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
	 * @throws {RangeError} `options.firstWeekContainsDate` must be between 1 and 7
	 *
	 * @example
	 * // Which week numbering year is 26 December 2004 with the default settings?
	 * var result = getWeekYear(new Date(2004, 11, 26))
	 * //=> 2005
	 *
	 * @example
	 * // Which week numbering year is 26 December 2004 if week starts on Saturday?
	 * var result = getWeekYear(new Date(2004, 11, 26), { weekStartsOn: 6 })
	 * //=> 2004
	 *
	 * @example
	 * // Which week numbering year is 26 December 2004 if the first week contains 4 January?
	 * var result = getWeekYear(new Date(2004, 11, 26), { firstWeekContainsDate: 4 })
	 * //=> 2004
	 */

	function getWeekYear(dirtyDate, dirtyOptions) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var year = date.getFullYear();
	  var options = dirtyOptions || {};
	  var locale = options.locale;
	  var localeFirstWeekContainsDate = locale && locale.options && locale.options.firstWeekContainsDate;
	  var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger(localeFirstWeekContainsDate);
	  var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger(options.firstWeekContainsDate); // Test if weekStartsOn is between 1 and 7 _and_ is not NaN

	  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
	    throw new RangeError('firstWeekContainsDate must be between 1 and 7 inclusively');
	  }

	  var firstWeekOfNextYear = new Date(0);
	  firstWeekOfNextYear.setFullYear(year + 1, 0, firstWeekContainsDate);
	  firstWeekOfNextYear.setHours(0, 0, 0, 0);
	  var startOfNextYear = startOfWeek(firstWeekOfNextYear, dirtyOptions);
	  var firstWeekOfThisYear = new Date(0);
	  firstWeekOfThisYear.setFullYear(year, 0, firstWeekContainsDate);
	  firstWeekOfThisYear.setHours(0, 0, 0, 0);
	  var startOfThisYear = startOfWeek(firstWeekOfThisYear, dirtyOptions);

	  if (date.getTime() >= startOfNextYear.getTime()) {
	    return year + 1;
	  } else if (date.getTime() >= startOfThisYear.getTime()) {
	    return year;
	  } else {
	    return year - 1;
	  }
	}

	/**
	 * @name startOfWeekYear
	 * @category Week-Numbering Year Helpers
	 * @summary Return the start of a local week-numbering year for the given date.
	 *
	 * @description
	 * Return the start of a local week-numbering year.
	 * The exact calculation depends on the values of
	 * `options.weekStartsOn` (which is the index of the first day of the week)
	 * and `options.firstWeekContainsDate` (which is the day of January, which is always in
	 * the first week of the week-numbering year)
	 *
	 * Week numbering: https://en.wikipedia.org/wiki/Week#Week_numbering
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the original date
	 * @param {Object} [options] - an object with options.
	 * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
	 * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
	 * @param {1|2|3|4|5|6|7} [options.firstWeekContainsDate=1] - the day of January, which is always in the first week of the year
	 * @returns {Date} the start of a week-numbering year
	 * @throws {TypeError} 1 argument required
	 * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
	 * @throws {RangeError} `options.firstWeekContainsDate` must be between 1 and 7
	 *
	 * @example
	 * // The start of an a week-numbering year for 2 July 2005 with default settings:
	 * var result = startOfWeekYear(new Date(2005, 6, 2))
	 * //=> Sun Dec 26 2004 00:00:00
	 *
	 * @example
	 * // The start of a week-numbering year for 2 July 2005
	 * // if Monday is the first day of week
	 * // and 4 January is always in the first week of the year:
	 * var result = startOfWeekYear(new Date(2005, 6, 2), {
	 *   weekStartsOn: 1,
	 *   firstWeekContainsDate: 4
	 * })
	 * //=> Mon Jan 03 2005 00:00:00
	 */

	function startOfWeekYear(dirtyDate, dirtyOptions) {
	  requiredArgs(1, arguments);
	  var options = dirtyOptions || {};
	  var locale = options.locale;
	  var localeFirstWeekContainsDate = locale && locale.options && locale.options.firstWeekContainsDate;
	  var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger(localeFirstWeekContainsDate);
	  var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger(options.firstWeekContainsDate);
	  var year = getWeekYear(dirtyDate, dirtyOptions);
	  var firstWeek = new Date(0);
	  firstWeek.setFullYear(year, 0, firstWeekContainsDate);
	  firstWeek.setHours(0, 0, 0, 0);
	  var date = startOfWeek(firstWeek, dirtyOptions);
	  return date;
	}

	var MILLISECONDS_IN_WEEK$2 = 604800000;
	/**
	 * @name getWeek
	 * @category Week Helpers
	 * @summary Get the local week index of the given date.
	 *
	 * @description
	 * Get the local week index of the given date.
	 * The exact calculation depends on the values of
	 * `options.weekStartsOn` (which is the index of the first day of the week)
	 * and `options.firstWeekContainsDate` (which is the day of January, which is always in
	 * the first week of the week-numbering year)
	 *
	 * Week numbering: https://en.wikipedia.org/wiki/Week#Week_numbering
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @param {Object} [options] - an object with options.
	 * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
	 * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
	 * @param {1|2|3|4|5|6|7} [options.firstWeekContainsDate=1] - the day of January, which is always in the first week of the year
	 * @returns {Number} the week
	 * @throws {TypeError} 1 argument required
	 * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
	 * @throws {RangeError} `options.firstWeekContainsDate` must be between 1 and 7
	 *
	 * @example
	 * // Which week of the local week numbering year is 2 January 2005 with default options?
	 * var result = getISOWeek(new Date(2005, 0, 2))
	 * //=> 2
	 *
	 * // Which week of the local week numbering year is 2 January 2005,
	 * // if Monday is the first day of the week,
	 * // and the first week of the year always contains 4 January?
	 * var result = getISOWeek(new Date(2005, 0, 2), {
	 *   weekStartsOn: 1,
	 *   firstWeekContainsDate: 4
	 * })
	 * //=> 53
	 */

	function getWeek(dirtyDate, options) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var diff = startOfWeek(date, options).getTime() - startOfWeekYear(date, options).getTime(); // Round the number of days to the nearest integer
	  // because the number of milliseconds in a week is not constant
	  // (e.g. it's different in the week of the daylight saving time clock shift)

	  return Math.round(diff / MILLISECONDS_IN_WEEK$2) + 1;
	}

	/**
	 * @name getMonth
	 * @category Month Helpers
	 * @summary Get the month of the given date.
	 *
	 * @description
	 * Get the month of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {Number} the month
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Which month is 29 February 2012?
	 * var result = getMonth(new Date(2012, 1, 29))
	 * //=> 1
	 */

	function getMonth(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var month = date.getMonth();
	  return month;
	}

	/**
	 * @name getQuarter
	 * @category Quarter Helpers
	 * @summary Get the year quarter of the given date.
	 *
	 * @description
	 * Get the year quarter of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {Number} the quarter
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Which quarter is 2 July 2014?
	 * var result = getQuarter(new Date(2014, 6, 2))
	 * //=> 3
	 */

	function getQuarter(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var quarter = Math.floor(date.getMonth() / 3) + 1;
	  return quarter;
	}

	/**
	 * @name getYear
	 * @category Year Helpers
	 * @summary Get the year of the given date.
	 *
	 * @description
	 * Get the year of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {Number} the year
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Which year is 2 July 2014?
	 * var result = getYear(new Date(2014, 6, 2))
	 * //=> 2014
	 */

	function getYear(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var year = date.getFullYear();
	  return year;
	}

	/**
	 * @name getTime
	 * @category Timestamp Helpers
	 * @summary Get the milliseconds timestamp of the given date.
	 *
	 * @description
	 * Get the milliseconds timestamp of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {Number} the timestamp
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Get the timestamp of 29 February 2012 11:45:05.123:
	 * var result = getTime(new Date(2012, 1, 29, 11, 45, 5, 123))
	 * //=> 1330515905123
	 */

	function getTime(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var timestamp = date.getTime();
	  return timestamp;
	}

	/**
	 * @name setSeconds
	 * @category Second Helpers
	 * @summary Set the seconds to the given date.
	 *
	 * @description
	 * Set the seconds to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} seconds - the seconds of the new date
	 * @returns {Date} the new date with the seconds set
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Set 45 seconds to 1 September 2014 11:30:40:
	 * var result = setSeconds(new Date(2014, 8, 1, 11, 30, 40), 45)
	 * //=> Mon Sep 01 2014 11:30:45
	 */

	function setSeconds(dirtyDate, dirtySeconds) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var seconds = toInteger(dirtySeconds);
	  date.setSeconds(seconds);
	  return date;
	}

	/**
	 * @name setMinutes
	 * @category Minute Helpers
	 * @summary Set the minutes to the given date.
	 *
	 * @description
	 * Set the minutes to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} minutes - the minutes of the new date
	 * @returns {Date} the new date with the minutes set
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Set 45 minutes to 1 September 2014 11:30:40:
	 * var result = setMinutes(new Date(2014, 8, 1, 11, 30, 40), 45)
	 * //=> Mon Sep 01 2014 11:45:40
	 */

	function setMinutes(dirtyDate, dirtyMinutes) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var minutes = toInteger(dirtyMinutes);
	  date.setMinutes(minutes);
	  return date;
	}

	/**
	 * @name setHours
	 * @category Hour Helpers
	 * @summary Set the hours to the given date.
	 *
	 * @description
	 * Set the hours to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} hours - the hours of the new date
	 * @returns {Date} the new date with the hours set
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Set 4 hours to 1 September 2014 11:30:00:
	 * var result = setHours(new Date(2014, 8, 1, 11, 30), 4)
	 * //=> Mon Sep 01 2014 04:30:00
	 */

	function setHours(dirtyDate, dirtyHours) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var hours = toInteger(dirtyHours);
	  date.setHours(hours);
	  return date;
	}

	/**
	 * @name getDaysInMonth
	 * @category Month Helpers
	 * @summary Get the number of days in a month of the given date.
	 *
	 * @description
	 * Get the number of days in a month of the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the given date
	 * @returns {Number} the number of days in a month
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // How many days are in February 2000?
	 * var result = getDaysInMonth(new Date(2000, 1))
	 * //=> 29
	 */

	function getDaysInMonth(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var year = date.getFullYear();
	  var monthIndex = date.getMonth();
	  var lastDayOfMonth = new Date(0);
	  lastDayOfMonth.setFullYear(year, monthIndex + 1, 0);
	  lastDayOfMonth.setHours(0, 0, 0, 0);
	  return lastDayOfMonth.getDate();
	}

	/**
	 * @name setMonth
	 * @category Month Helpers
	 * @summary Set the month to the given date.
	 *
	 * @description
	 * Set the month to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} month - the month of the new date
	 * @returns {Date} the new date with the month set
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Set February to 1 September 2014:
	 * var result = setMonth(new Date(2014, 8, 1), 1)
	 * //=> Sat Feb 01 2014 00:00:00
	 */

	function setMonth(dirtyDate, dirtyMonth) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var month = toInteger(dirtyMonth);
	  var year = date.getFullYear();
	  var day = date.getDate();
	  var dateWithDesiredMonth = new Date(0);
	  dateWithDesiredMonth.setFullYear(year, month, 15);
	  dateWithDesiredMonth.setHours(0, 0, 0, 0);
	  var daysInMonth = getDaysInMonth(dateWithDesiredMonth); // Set the last day of the new month
	  // if the original date was the last day of the longer month

	  date.setMonth(month, Math.min(day, daysInMonth));
	  return date;
	}

	/**
	 * @name setQuarter
	 * @category Quarter Helpers
	 * @summary Set the year quarter to the given date.
	 *
	 * @description
	 * Set the year quarter to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} quarter - the quarter of the new date
	 * @returns {Date} the new date with the quarter set
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Set the 2nd quarter to 2 July 2014:
	 * var result = setQuarter(new Date(2014, 6, 2), 2)
	 * //=> Wed Apr 02 2014 00:00:00
	 */

	function setQuarter(dirtyDate, dirtyQuarter) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var quarter = toInteger(dirtyQuarter);
	  var oldQuarter = Math.floor(date.getMonth() / 3) + 1;
	  var diff = quarter - oldQuarter;
	  return setMonth(date, date.getMonth() + diff * 3);
	}

	/**
	 * @name setYear
	 * @category Year Helpers
	 * @summary Set the year to the given date.
	 *
	 * @description
	 * Set the year to the given date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date to be changed
	 * @param {Number} year - the year of the new date
	 * @returns {Date} the new date with the year set
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Set year 2013 to 1 September 2014:
	 * var result = setYear(new Date(2014, 8, 1), 2013)
	 * //=> Sun Sep 01 2013 00:00:00
	 */

	function setYear(dirtyDate, dirtyYear) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var year = toInteger(dirtyYear); // Check if date is Invalid Date because Date.prototype.setFullYear ignores the value of Invalid Date

	  if (isNaN(date)) {
	    return new Date(NaN);
	  }

	  date.setFullYear(year);
	  return date;
	}

	/**
	 * @name min
	 * @category Common Helpers
	 * @summary Return the earliest of the given dates.
	 *
	 * @description
	 * Return the earliest of the given dates.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * - `min` function now accepts an array of dates rather than spread arguments.
	 *
	 *   ```javascript
	 *   // Before v2.0.0
	 *   var date1 = new Date(1989, 6, 10)
	 *   var date2 = new Date(1987, 1, 11)
	 *   var minDate = min(date1, date2)
	 *
	 *   // v2.0.0 onward:
	 *   var dates = [new Date(1989, 6, 10), new Date(1987, 1, 11)]
	 *   var minDate = min(dates)
	 *   ```
	 *
	 * @param {Date[]|Number[]} datesArray - the dates to compare
	 * @returns {Date} the earliest of the dates
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Which of these dates is the earliest?
	 * var result = min([
	 *   new Date(1989, 6, 10),
	 *   new Date(1987, 1, 11),
	 *   new Date(1995, 6, 2),
	 *   new Date(1990, 0, 1)
	 * ])
	 * //=> Wed Feb 11 1987 00:00:00
	 */

	function min(dirtyDatesArray) {
	  requiredArgs(1, arguments);
	  var datesArray; // `dirtyDatesArray` is Array, Set or Map, or object with custom `forEach` method

	  if (dirtyDatesArray && typeof dirtyDatesArray.forEach === 'function') {
	    datesArray = dirtyDatesArray; // If `dirtyDatesArray` is Array-like Object, convert to Array.
	  } else if (typeof dirtyDatesArray === 'object' && dirtyDatesArray !== null) {
	    datesArray = Array.prototype.slice.call(dirtyDatesArray);
	  } else {
	    // `dirtyDatesArray` is non-iterable, return Invalid Date
	    return new Date(NaN);
	  }

	  var result;
	  datesArray.forEach(function (dirtyDate) {
	    var currentDate = toDate(dirtyDate);

	    if (result === undefined || result > currentDate || isNaN(currentDate)) {
	      result = currentDate;
	    }
	  });
	  return result || new Date(NaN);
	}

	/**
	 * @name max
	 * @category Common Helpers
	 * @summary Return the latest of the given dates.
	 *
	 * @description
	 * Return the latest of the given dates.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * - `max` function now accepts an array of dates rather than spread arguments.
	 *
	 *   ```javascript
	 *   // Before v2.0.0
	 *   var date1 = new Date(1989, 6, 10)
	 *   var date2 = new Date(1987, 1, 11)
	 *   var maxDate = max(date1, date2)
	 *
	 *   // v2.0.0 onward:
	 *   var dates = [new Date(1989, 6, 10), new Date(1987, 1, 11)]
	 *   var maxDate = max(dates)
	 *   ```
	 *
	 * @param {Date[]|Number[]} datesArray - the dates to compare
	 * @returns {Date} the latest of the dates
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // Which of these dates is the latest?
	 * var result = max([
	 *   new Date(1989, 6, 10),
	 *   new Date(1987, 1, 11),
	 *   new Date(1995, 6, 2),
	 *   new Date(1990, 0, 1)
	 * ])
	 * //=> Sun Jul 02 1995 00:00:00
	 */

	function max(dirtyDatesArray) {
	  requiredArgs(1, arguments);
	  var datesArray; // `dirtyDatesArray` is Array, Set or Map, or object with custom `forEach` method

	  if (dirtyDatesArray && typeof dirtyDatesArray.forEach === 'function') {
	    datesArray = dirtyDatesArray; // If `dirtyDatesArray` is Array-like Object, convert to Array.
	  } else if (typeof dirtyDatesArray === 'object' && dirtyDatesArray !== null) {
	    datesArray = Array.prototype.slice.call(dirtyDatesArray);
	  } else {
	    // `dirtyDatesArray` is non-iterable, return Invalid Date
	    return new Date(NaN);
	  }

	  var result;
	  datesArray.forEach(function (dirtyDate) {
	    var currentDate = toDate(dirtyDate);

	    if (result === undefined || result < currentDate || isNaN(currentDate)) {
	      result = currentDate;
	    }
	  });
	  return result || new Date(NaN);
	}

	/**
	 * @name startOfDay
	 * @category Day Helpers
	 * @summary Return the start of a day for the given date.
	 *
	 * @description
	 * Return the start of a day for the given date.
	 * The result will be in the local timezone.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the original date
	 * @returns {Date} the start of a day
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // The start of a day for 2 September 2014 11:55:00:
	 * var result = startOfDay(new Date(2014, 8, 2, 11, 55, 0))
	 * //=> Tue Sep 02 2014 00:00:00
	 */

	function startOfDay(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  date.setHours(0, 0, 0, 0);
	  return date;
	}

	var MILLISECONDS_IN_DAY$1 = 86400000;
	/**
	 * @name differenceInCalendarDays
	 * @category Day Helpers
	 * @summary Get the number of calendar days between the given dates.
	 *
	 * @description
	 * Get the number of calendar days between the given dates. This means that the times are removed
	 * from the dates and then the difference in days is calculated.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} dateLeft - the later date
	 * @param {Date|Number} dateRight - the earlier date
	 * @returns {Number} the number of calendar days
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // How many calendar days are between
	 * // 2 July 2011 23:00:00 and 2 July 2012 00:00:00?
	 * var result = differenceInCalendarDays(
	 *   new Date(2012, 6, 2, 0, 0),
	 *   new Date(2011, 6, 2, 23, 0)
	 * )
	 * //=> 366
	 * // How many calendar days are between
	 * // 2 July 2011 23:59:00 and 3 July 2011 00:01:00?
	 * var result = differenceInCalendarDays(
	 *   new Date(2011, 6, 3, 0, 1),
	 *   new Date(2011, 6, 2, 23, 59)
	 * )
	 * //=> 1
	 */

	function differenceInCalendarDays(dirtyDateLeft, dirtyDateRight) {
	  requiredArgs(2, arguments);
	  var startOfDayLeft = startOfDay(dirtyDateLeft);
	  var startOfDayRight = startOfDay(dirtyDateRight);
	  var timestampLeft = startOfDayLeft.getTime() - getTimezoneOffsetInMilliseconds(startOfDayLeft);
	  var timestampRight = startOfDayRight.getTime() - getTimezoneOffsetInMilliseconds(startOfDayRight); // Round the number of days to the nearest integer
	  // because the number of milliseconds in a day is not constant
	  // (e.g. it's different in the day of the daylight saving time clock shift)

	  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_DAY$1);
	}

	/**
	 * @name differenceInCalendarMonths
	 * @category Month Helpers
	 * @summary Get the number of calendar months between the given dates.
	 *
	 * @description
	 * Get the number of calendar months between the given dates.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} dateLeft - the later date
	 * @param {Date|Number} dateRight - the earlier date
	 * @returns {Number} the number of calendar months
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // How many calendar months are between 31 January 2014 and 1 September 2014?
	 * var result = differenceInCalendarMonths(
	 *   new Date(2014, 8, 1),
	 *   new Date(2014, 0, 31)
	 * )
	 * //=> 8
	 */

	function differenceInCalendarMonths(dirtyDateLeft, dirtyDateRight) {
	  requiredArgs(2, arguments);
	  var dateLeft = toDate(dirtyDateLeft);
	  var dateRight = toDate(dirtyDateRight);
	  var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
	  var monthDiff = dateLeft.getMonth() - dateRight.getMonth();
	  return yearDiff * 12 + monthDiff;
	}

	/**
	 * @name differenceInCalendarYears
	 * @category Year Helpers
	 * @summary Get the number of calendar years between the given dates.
	 *
	 * @description
	 * Get the number of calendar years between the given dates.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} dateLeft - the later date
	 * @param {Date|Number} dateRight - the earlier date
	 * @returns {Number} the number of calendar years
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // How many calendar years are between 31 December 2013 and 11 February 2015?
	 * var result = differenceInCalendarYears(
	 *   new Date(2015, 1, 11),
	 *   new Date(2013, 11, 31)
	 * )
	 * //=> 2
	 */

	function differenceInCalendarYears(dirtyDateLeft, dirtyDateRight) {
	  requiredArgs(2, arguments);
	  var dateLeft = toDate(dirtyDateLeft);
	  var dateRight = toDate(dirtyDateRight);
	  return dateLeft.getFullYear() - dateRight.getFullYear();
	}

	/**
	 * @name startOfMonth
	 * @category Month Helpers
	 * @summary Return the start of a month for the given date.
	 *
	 * @description
	 * Return the start of a month for the given date.
	 * The result will be in the local timezone.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the original date
	 * @returns {Date} the start of a month
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // The start of a month for 2 September 2014 11:55:00:
	 * var result = startOfMonth(new Date(2014, 8, 2, 11, 55, 0))
	 * //=> Mon Sep 01 2014 00:00:00
	 */

	function startOfMonth(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  date.setDate(1);
	  date.setHours(0, 0, 0, 0);
	  return date;
	}

	/**
	 * @name startOfQuarter
	 * @category Quarter Helpers
	 * @summary Return the start of a year quarter for the given date.
	 *
	 * @description
	 * Return the start of a year quarter for the given date.
	 * The result will be in the local timezone.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the original date
	 * @returns {Date} the start of a quarter
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // The start of a quarter for 2 September 2014 11:55:00:
	 * var result = startOfQuarter(new Date(2014, 8, 2, 11, 55, 0))
	 * //=> Tue Jul 01 2014 00:00:00
	 */

	function startOfQuarter(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  var currentMonth = date.getMonth();
	  var month = currentMonth - currentMonth % 3;
	  date.setMonth(month, 1);
	  date.setHours(0, 0, 0, 0);
	  return date;
	}

	/**
	 * @name startOfYear
	 * @category Year Helpers
	 * @summary Return the start of a year for the given date.
	 *
	 * @description
	 * Return the start of a year for the given date.
	 * The result will be in the local timezone.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the original date
	 * @returns {Date} the start of a year
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // The start of a year for 2 September 2014 11:55:00:
	 * var result = startOfYear(new Date(2014, 8, 2, 11, 55, 00))
	 * //=> Wed Jan 01 2014 00:00:00
	 */

	function startOfYear(dirtyDate) {
	  requiredArgs(1, arguments);
	  var cleanDate = toDate(dirtyDate);
	  var date = new Date(0);
	  date.setFullYear(cleanDate.getFullYear(), 0, 1);
	  date.setHours(0, 0, 0, 0);
	  return date;
	}

	/**
	 * @name endOfDay
	 * @category Day Helpers
	 * @summary Return the end of a day for the given date.
	 *
	 * @description
	 * Return the end of a day for the given date.
	 * The result will be in the local timezone.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the original date
	 * @returns {Date} the end of a day
	 * @throws {TypeError} 1 argument required
	 *
	 * @example
	 * // The end of a day for 2 September 2014 11:55:00:
	 * var result = endOfDay(new Date(2014, 8, 2, 11, 55, 0))
	 * //=> Tue Sep 02 2014 23:59:59.999
	 */

	function endOfDay(dirtyDate) {
	  requiredArgs(1, arguments);
	  var date = toDate(dirtyDate);
	  date.setHours(23, 59, 59, 999);
	  return date;
	}

	/**
	 * @name isEqual
	 * @category Common Helpers
	 * @summary Are the given dates equal?
	 *
	 * @description
	 * Are the given dates equal?
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} dateLeft - the first date to compare
	 * @param {Date|Number} dateRight - the second date to compare
	 * @returns {Boolean} the dates are equal
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Are 2 July 2014 06:30:45.000 and 2 July 2014 06:30:45.500 equal?
	 * var result = isEqual(
	 *   new Date(2014, 6, 2, 6, 30, 45, 0),
	 *   new Date(2014, 6, 2, 6, 30, 45, 500)
	 * )
	 * //=> false
	 */

	function isEqual(dirtyLeftDate, dirtyRightDate) {
	  requiredArgs(2, arguments);
	  var dateLeft = toDate(dirtyLeftDate);
	  var dateRight = toDate(dirtyRightDate);
	  return dateLeft.getTime() === dateRight.getTime();
	}

	/**
	 * @name isSameDay
	 * @category Day Helpers
	 * @summary Are the given dates in the same day?
	 *
	 * @description
	 * Are the given dates in the same day?
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} dateLeft - the first date to check
	 * @param {Date|Number} dateRight - the second date to check
	 * @returns {Boolean} the dates are in the same day
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Are 4 September 06:00:00 and 4 September 18:00:00 in the same day?
	 * var result = isSameDay(new Date(2014, 8, 4, 6, 0), new Date(2014, 8, 4, 18, 0))
	 * //=> true
	 */

	function isSameDay(dirtyDateLeft, dirtyDateRight) {
	  requiredArgs(2, arguments);
	  var dateLeftStartOfDay = startOfDay(dirtyDateLeft);
	  var dateRightStartOfDay = startOfDay(dirtyDateRight);
	  return dateLeftStartOfDay.getTime() === dateRightStartOfDay.getTime();
	}

	/**
	 * @name isSameMonth
	 * @category Month Helpers
	 * @summary Are the given dates in the same month?
	 *
	 * @description
	 * Are the given dates in the same month?
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} dateLeft - the first date to check
	 * @param {Date|Number} dateRight - the second date to check
	 * @returns {Boolean} the dates are in the same month
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Are 2 September 2014 and 25 September 2014 in the same month?
	 * var result = isSameMonth(new Date(2014, 8, 2), new Date(2014, 8, 25))
	 * //=> true
	 */

	function isSameMonth(dirtyDateLeft, dirtyDateRight) {
	  requiredArgs(2, arguments);
	  var dateLeft = toDate(dirtyDateLeft);
	  var dateRight = toDate(dirtyDateRight);
	  return dateLeft.getFullYear() === dateRight.getFullYear() && dateLeft.getMonth() === dateRight.getMonth();
	}

	/**
	 * @name isSameYear
	 * @category Year Helpers
	 * @summary Are the given dates in the same year?
	 *
	 * @description
	 * Are the given dates in the same year?
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} dateLeft - the first date to check
	 * @param {Date|Number} dateRight - the second date to check
	 * @returns {Boolean} the dates are in the same year
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Are 2 September 2014 and 25 September 2014 in the same year?
	 * var result = isSameYear(new Date(2014, 8, 2), new Date(2014, 8, 25))
	 * //=> true
	 */

	function isSameYear(dirtyDateLeft, dirtyDateRight) {
	  requiredArgs(2, arguments);
	  var dateLeft = toDate(dirtyDateLeft);
	  var dateRight = toDate(dirtyDateRight);
	  return dateLeft.getFullYear() === dateRight.getFullYear();
	}

	/**
	 * @name isSameQuarter
	 * @category Quarter Helpers
	 * @summary Are the given dates in the same year quarter?
	 *
	 * @description
	 * Are the given dates in the same year quarter?
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} dateLeft - the first date to check
	 * @param {Date|Number} dateRight - the second date to check
	 * @returns {Boolean} the dates are in the same quarter
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Are 1 January 2014 and 8 March 2014 in the same quarter?
	 * var result = isSameQuarter(new Date(2014, 0, 1), new Date(2014, 2, 8))
	 * //=> true
	 */

	function isSameQuarter(dirtyDateLeft, dirtyDateRight) {
	  requiredArgs(2, arguments);
	  var dateLeftStartOfQuarter = startOfQuarter(dirtyDateLeft);
	  var dateRightStartOfQuarter = startOfQuarter(dirtyDateRight);
	  return dateLeftStartOfQuarter.getTime() === dateRightStartOfQuarter.getTime();
	}

	/**
	 * @name isAfter
	 * @category Common Helpers
	 * @summary Is the first date after the second one?
	 *
	 * @description
	 * Is the first date after the second one?
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date that should be after the other one to return true
	 * @param {Date|Number} dateToCompare - the date to compare with
	 * @returns {Boolean} the first date is after the second date
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Is 10 July 1989 after 11 February 1987?
	 * var result = isAfter(new Date(1989, 6, 10), new Date(1987, 1, 11))
	 * //=> true
	 */

	function isAfter(dirtyDate, dirtyDateToCompare) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var dateToCompare = toDate(dirtyDateToCompare);
	  return date.getTime() > dateToCompare.getTime();
	}

	/**
	 * @name isBefore
	 * @category Common Helpers
	 * @summary Is the first date before the second one?
	 *
	 * @description
	 * Is the first date before the second one?
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * @param {Date|Number} date - the date that should be before the other one to return true
	 * @param {Date|Number} dateToCompare - the date to compare with
	 * @returns {Boolean} the first date is before the second date
	 * @throws {TypeError} 2 arguments required
	 *
	 * @example
	 * // Is 10 July 1989 before 11 February 1987?
	 * var result = isBefore(new Date(1989, 6, 10), new Date(1987, 1, 11))
	 * //=> false
	 */

	function isBefore(dirtyDate, dirtyDateToCompare) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var dateToCompare = toDate(dirtyDateToCompare);
	  return date.getTime() < dateToCompare.getTime();
	}

	/**
	 * @name isWithinInterval
	 * @category Interval Helpers
	 * @summary Is the given date within the interval?
	 *
	 * @description
	 * Is the given date within the interval? (Including start and end.)
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * - The function was renamed from `isWithinRange` to `isWithinInterval`.
	 *   This change was made to mirror the use of the word "interval" in standard ISO 8601:2004 terminology:
	 *
	 *   ```
	 *   2.1.3
	 *   time interval
	 *   part of the time axis limited by two instants
	 *   ```
	 *
	 *   Also, this function now accepts an object with `start` and `end` properties
	 *   instead of two arguments as an interval.
	 *   This function now throws `RangeError` if the start of the interval is after its end
	 *   or if any date in the interval is `Invalid Date`.
	 *
	 *   ```javascript
	 *   // Before v2.0.0
	 *
	 *   isWithinRange(
	 *     new Date(2014, 0, 3),
	 *     new Date(2014, 0, 1), new Date(2014, 0, 7)
	 *   )
	 *
	 *   // v2.0.0 onward
	 *
	 *   isWithinInterval(
	 *     new Date(2014, 0, 3),
	 *     { start: new Date(2014, 0, 1), end: new Date(2014, 0, 7) }
	 *   )
	 *   ```
	 *
	 * @param {Date|Number} date - the date to check
	 * @param {Interval} interval - the interval to check
	 * @returns {Boolean} the date is within the interval
	 * @throws {TypeError} 2 arguments required
	 * @throws {RangeError} The start of an interval cannot be after its end
	 * @throws {RangeError} Date in interval cannot be `Invalid Date`
	 *
	 * @example
	 * // For the date within the interval:
	 * isWithinInterval(new Date(2014, 0, 3), {
	 *   start: new Date(2014, 0, 1),
	 *   end: new Date(2014, 0, 7)
	 * })
	 * //=> true
	 *
	 * @example
	 * // For the date outside of the interval:
	 * isWithinInterval(new Date(2014, 0, 10), {
	 *   start: new Date(2014, 0, 1),
	 *   end: new Date(2014, 0, 7)
	 * })
	 * //=> false
	 *
	 * @example
	 * // For date equal to interval start:
	 * isWithinInterval(date, { start, end: date }) // => true
	 *
	 * @example
	 * // For date equal to interval end:
	 * isWithinInterval(date, { start: date, end }) // => true
	 */

	function isWithinInterval(dirtyDate, dirtyInterval) {
	  requiredArgs(2, arguments);
	  var interval = dirtyInterval || {};
	  var time = toDate(dirtyDate).getTime();
	  var startTime = toDate(interval.start).getTime();
	  var endTime = toDate(interval.end).getTime(); // Throw an exception if start date is after end date or if any date is `Invalid Date`

	  if (!(startTime <= endTime)) {
	    throw new RangeError('Invalid interval');
	  }

	  return time >= startTime && time <= endTime;
	}

	function assign(target, dirtyObject) {
	  if (target == null) {
	    throw new TypeError('assign requires that input parameter not be null or undefined');
	  }

	  dirtyObject = dirtyObject || {};

	  for (var property in dirtyObject) {
	    if (dirtyObject.hasOwnProperty(property)) {
	      target[property] = dirtyObject[property];
	    }
	  }

	  return target;
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function setUTCDay(dirtyDate, dirtyDay, dirtyOptions) {
	  requiredArgs(2, arguments);
	  var options = dirtyOptions || {};
	  var locale = options.locale;
	  var localeWeekStartsOn = locale && locale.options && locale.options.weekStartsOn;
	  var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger(localeWeekStartsOn);
	  var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger(options.weekStartsOn); // Test if weekStartsOn is between 0 and 6 _and_ is not NaN

	  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
	    throw new RangeError('weekStartsOn must be between 0 and 6 inclusively');
	  }

	  var date = toDate(dirtyDate);
	  var day = toInteger(dirtyDay);
	  var currentDay = date.getUTCDay();
	  var remainder = day % 7;
	  var dayIndex = (remainder + 7) % 7;
	  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
	  date.setUTCDate(date.getUTCDate() + diff);
	  return date;
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function setUTCISODay(dirtyDate, dirtyDay) {
	  requiredArgs(2, arguments);
	  var day = toInteger(dirtyDay);

	  if (day % 7 === 0) {
	    day = day - 7;
	  }

	  var weekStartsOn = 1;
	  var date = toDate(dirtyDate);
	  var currentDay = date.getUTCDay();
	  var remainder = day % 7;
	  var dayIndex = (remainder + 7) % 7;
	  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
	  date.setUTCDate(date.getUTCDate() + diff);
	  return date;
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function setUTCISOWeek(dirtyDate, dirtyISOWeek) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var isoWeek = toInteger(dirtyISOWeek);
	  var diff = getUTCISOWeek(date) - isoWeek;
	  date.setUTCDate(date.getUTCDate() - diff * 7);
	  return date;
	}

	// See issue: https://github.com/date-fns/date-fns/issues/376

	function setUTCWeek(dirtyDate, dirtyWeek, options) {
	  requiredArgs(2, arguments);
	  var date = toDate(dirtyDate);
	  var week = toInteger(dirtyWeek);
	  var diff = getUTCWeek(date, options) - week;
	  date.setUTCDate(date.getUTCDate() - diff * 7);
	  return date;
	}

	var MILLISECONDS_IN_HOUR$1 = 3600000;
	var MILLISECONDS_IN_MINUTE$2 = 60000;
	var MILLISECONDS_IN_SECOND = 1000;
	var numericPatterns = {
	  month: /^(1[0-2]|0?\d)/,
	  // 0 to 12
	  date: /^(3[0-1]|[0-2]?\d)/,
	  // 0 to 31
	  dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
	  // 0 to 366
	  week: /^(5[0-3]|[0-4]?\d)/,
	  // 0 to 53
	  hour23h: /^(2[0-3]|[0-1]?\d)/,
	  // 0 to 23
	  hour24h: /^(2[0-4]|[0-1]?\d)/,
	  // 0 to 24
	  hour11h: /^(1[0-1]|0?\d)/,
	  // 0 to 11
	  hour12h: /^(1[0-2]|0?\d)/,
	  // 0 to 12
	  minute: /^[0-5]?\d/,
	  // 0 to 59
	  second: /^[0-5]?\d/,
	  // 0 to 59
	  singleDigit: /^\d/,
	  // 0 to 9
	  twoDigits: /^\d{1,2}/,
	  // 0 to 99
	  threeDigits: /^\d{1,3}/,
	  // 0 to 999
	  fourDigits: /^\d{1,4}/,
	  // 0 to 9999
	  anyDigitsSigned: /^-?\d+/,
	  singleDigitSigned: /^-?\d/,
	  // 0 to 9, -0 to -9
	  twoDigitsSigned: /^-?\d{1,2}/,
	  // 0 to 99, -0 to -99
	  threeDigitsSigned: /^-?\d{1,3}/,
	  // 0 to 999, -0 to -999
	  fourDigitsSigned: /^-?\d{1,4}/ // 0 to 9999, -0 to -9999

	};
	var timezonePatterns = {
	  basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
	  basic: /^([+-])(\d{2})(\d{2})|Z/,
	  basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
	  extended: /^([+-])(\d{2}):(\d{2})|Z/,
	  extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
	};

	function parseNumericPattern(pattern, string, valueCallback) {
	  var matchResult = string.match(pattern);

	  if (!matchResult) {
	    return null;
	  }

	  var value = parseInt(matchResult[0], 10);
	  return {
	    value: valueCallback ? valueCallback(value) : value,
	    rest: string.slice(matchResult[0].length)
	  };
	}

	function parseTimezonePattern(pattern, string) {
	  var matchResult = string.match(pattern);

	  if (!matchResult) {
	    return null;
	  } // Input is 'Z'


	  if (matchResult[0] === 'Z') {
	    return {
	      value: 0,
	      rest: string.slice(1)
	    };
	  }

	  var sign = matchResult[1] === '+' ? 1 : -1;
	  var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
	  var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
	  var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
	  return {
	    value: sign * (hours * MILLISECONDS_IN_HOUR$1 + minutes * MILLISECONDS_IN_MINUTE$2 + seconds * MILLISECONDS_IN_SECOND),
	    rest: string.slice(matchResult[0].length)
	  };
	}

	function parseAnyDigitsSigned(string, valueCallback) {
	  return parseNumericPattern(numericPatterns.anyDigitsSigned, string, valueCallback);
	}

	function parseNDigits(n, string, valueCallback) {
	  switch (n) {
	    case 1:
	      return parseNumericPattern(numericPatterns.singleDigit, string, valueCallback);

	    case 2:
	      return parseNumericPattern(numericPatterns.twoDigits, string, valueCallback);

	    case 3:
	      return parseNumericPattern(numericPatterns.threeDigits, string, valueCallback);

	    case 4:
	      return parseNumericPattern(numericPatterns.fourDigits, string, valueCallback);

	    default:
	      return parseNumericPattern(new RegExp('^\\d{1,' + n + '}'), string, valueCallback);
	  }
	}

	function parseNDigitsSigned(n, string, valueCallback) {
	  switch (n) {
	    case 1:
	      return parseNumericPattern(numericPatterns.singleDigitSigned, string, valueCallback);

	    case 2:
	      return parseNumericPattern(numericPatterns.twoDigitsSigned, string, valueCallback);

	    case 3:
	      return parseNumericPattern(numericPatterns.threeDigitsSigned, string, valueCallback);

	    case 4:
	      return parseNumericPattern(numericPatterns.fourDigitsSigned, string, valueCallback);

	    default:
	      return parseNumericPattern(new RegExp('^-?\\d{1,' + n + '}'), string, valueCallback);
	  }
	}

	function dayPeriodEnumToHours(enumValue) {
	  switch (enumValue) {
	    case 'morning':
	      return 4;

	    case 'evening':
	      return 17;

	    case 'pm':
	    case 'noon':
	    case 'afternoon':
	      return 12;

	    case 'am':
	    case 'midnight':
	    case 'night':
	    default:
	      return 0;
	  }
	}

	function normalizeTwoDigitYear(twoDigitYear, currentYear) {
	  var isCommonEra = currentYear > 0; // Absolute number of the current year:
	  // 1 -> 1 AC
	  // 0 -> 1 BC
	  // -1 -> 2 BC

	  var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
	  var result;

	  if (absCurrentYear <= 50) {
	    result = twoDigitYear || 100;
	  } else {
	    var rangeEnd = absCurrentYear + 50;
	    var rangeEndCentury = Math.floor(rangeEnd / 100) * 100;
	    var isPreviousCentury = twoDigitYear >= rangeEnd % 100;
	    result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
	  }

	  return isCommonEra ? result : 1 - result;
	}

	var DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
	var DAYS_IN_MONTH_LEAP_YEAR = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]; // User for validation

	function isLeapYearIndex(year) {
	  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
	}
	/*
	 * |     | Unit                           |     | Unit                           |
	 * |-----|--------------------------------|-----|--------------------------------|
	 * |  a  | AM, PM                         |  A* | Milliseconds in day            |
	 * |  b  | AM, PM, noon, midnight         |  B  | Flexible day period            |
	 * |  c  | Stand-alone local day of week  |  C* | Localized hour w/ day period   |
	 * |  d  | Day of month                   |  D  | Day of year                    |
	 * |  e  | Local day of week              |  E  | Day of week                    |
	 * |  f  |                                |  F* | Day of week in month           |
	 * |  g* | Modified Julian day            |  G  | Era                            |
	 * |  h  | Hour [1-12]                    |  H  | Hour [0-23]                    |
	 * |  i! | ISO day of week                |  I! | ISO week of year               |
	 * |  j* | Localized hour w/ day period   |  J* | Localized hour w/o day period  |
	 * |  k  | Hour [1-24]                    |  K  | Hour [0-11]                    |
	 * |  l* | (deprecated)                   |  L  | Stand-alone month              |
	 * |  m  | Minute                         |  M  | Month                          |
	 * |  n  |                                |  N  |                                |
	 * |  o! | Ordinal number modifier        |  O* | Timezone (GMT)                 |
	 * |  p  |                                |  P  |                                |
	 * |  q  | Stand-alone quarter            |  Q  | Quarter                        |
	 * |  r* | Related Gregorian year         |  R! | ISO week-numbering year        |
	 * |  s  | Second                         |  S  | Fraction of second             |
	 * |  t! | Seconds timestamp              |  T! | Milliseconds timestamp         |
	 * |  u  | Extended year                  |  U* | Cyclic year                    |
	 * |  v* | Timezone (generic non-locat.)  |  V* | Timezone (location)            |
	 * |  w  | Local week of year             |  W* | Week of month                  |
	 * |  x  | Timezone (ISO-8601 w/o Z)      |  X  | Timezone (ISO-8601)            |
	 * |  y  | Year (abs)                     |  Y  | Local week-numbering year      |
	 * |  z* | Timezone (specific non-locat.) |  Z* | Timezone (aliases)             |
	 *
	 * Letters marked by * are not implemented but reserved by Unicode standard.
	 *
	 * Letters marked by ! are non-standard, but implemented by date-fns:
	 * - `o` modifies the previous token to turn it into an ordinal (see `parse` docs)
	 * - `i` is ISO day of week. For `i` and `ii` is returns numeric ISO week days,
	 *   i.e. 7 for Sunday, 1 for Monday, etc.
	 * - `I` is ISO week of year, as opposed to `w` which is local week of year.
	 * - `R` is ISO week-numbering year, as opposed to `Y` which is local week-numbering year.
	 *   `R` is supposed to be used in conjunction with `I` and `i`
	 *   for universal ISO week-numbering date, whereas
	 *   `Y` is supposed to be used in conjunction with `w` and `e`
	 *   for week-numbering date specific to the locale.
	 */


	var parsers = {
	  // Era
	  G: {
	    priority: 140,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        // AD, BC
	        case 'G':
	        case 'GG':
	        case 'GGG':
	          return match.era(string, {
	            width: 'abbreviated'
	          }) || match.era(string, {
	            width: 'narrow'
	          });
	        // A, B

	        case 'GGGGG':
	          return match.era(string, {
	            width: 'narrow'
	          });
	        // Anno Domini, Before Christ

	        case 'GGGG':
	        default:
	          return match.era(string, {
	            width: 'wide'
	          }) || match.era(string, {
	            width: 'abbreviated'
	          }) || match.era(string, {
	            width: 'narrow'
	          });
	      }
	    },
	    set: function (date, flags, value, _options) {
	      flags.era = value;
	      date.setUTCFullYear(value, 0, 1);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['R', 'u', 't', 'T']
	  },
	  // Year
	  y: {
	    // From http://www.unicode.org/reports/tr35/tr35-31/tr35-dates.html#Date_Format_Patterns
	    // | Year     |     y | yy |   yyy |  yyyy | yyyyy |
	    // |----------|-------|----|-------|-------|-------|
	    // | AD 1     |     1 | 01 |   001 |  0001 | 00001 |
	    // | AD 12    |    12 | 12 |   012 |  0012 | 00012 |
	    // | AD 123   |   123 | 23 |   123 |  0123 | 00123 |
	    // | AD 1234  |  1234 | 34 |  1234 |  1234 | 01234 |
	    // | AD 12345 | 12345 | 45 | 12345 | 12345 | 12345 |
	    priority: 130,
	    parse: function (string, token, match, _options) {
	      var valueCallback = function (year) {
	        return {
	          year: year,
	          isTwoDigitYear: token === 'yy'
	        };
	      };

	      switch (token) {
	        case 'y':
	          return parseNDigits(4, string, valueCallback);

	        case 'yo':
	          return match.ordinalNumber(string, {
	            unit: 'year',
	            valueCallback: valueCallback
	          });

	        default:
	          return parseNDigits(token.length, string, valueCallback);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value.isTwoDigitYear || value.year > 0;
	    },
	    set: function (date, flags, value, _options) {
	      var currentYear = date.getUTCFullYear();

	      if (value.isTwoDigitYear) {
	        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
	        date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
	        date.setUTCHours(0, 0, 0, 0);
	        return date;
	      }

	      var year = !('era' in flags) || flags.era === 1 ? value.year : 1 - value.year;
	      date.setUTCFullYear(year, 0, 1);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['Y', 'R', 'u', 'w', 'I', 'i', 'e', 'c', 't', 'T']
	  },
	  // Local week-numbering year
	  Y: {
	    priority: 130,
	    parse: function (string, token, match, _options) {
	      var valueCallback = function (year) {
	        return {
	          year: year,
	          isTwoDigitYear: token === 'YY'
	        };
	      };

	      switch (token) {
	        case 'Y':
	          return parseNDigits(4, string, valueCallback);

	        case 'Yo':
	          return match.ordinalNumber(string, {
	            unit: 'year',
	            valueCallback: valueCallback
	          });

	        default:
	          return parseNDigits(token.length, string, valueCallback);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value.isTwoDigitYear || value.year > 0;
	    },
	    set: function (date, flags, value, options) {
	      var currentYear = getUTCWeekYear(date, options);

	      if (value.isTwoDigitYear) {
	        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
	        date.setUTCFullYear(normalizedTwoDigitYear, 0, options.firstWeekContainsDate);
	        date.setUTCHours(0, 0, 0, 0);
	        return startOfUTCWeek(date, options);
	      }

	      var year = !('era' in flags) || flags.era === 1 ? value.year : 1 - value.year;
	      date.setUTCFullYear(year, 0, options.firstWeekContainsDate);
	      date.setUTCHours(0, 0, 0, 0);
	      return startOfUTCWeek(date, options);
	    },
	    incompatibleTokens: ['y', 'R', 'u', 'Q', 'q', 'M', 'L', 'I', 'd', 'D', 'i', 't', 'T']
	  },
	  // ISO week-numbering year
	  R: {
	    priority: 130,
	    parse: function (string, token, _match, _options) {
	      if (token === 'R') {
	        return parseNDigitsSigned(4, string);
	      }

	      return parseNDigitsSigned(token.length, string);
	    },
	    set: function (_date, _flags, value, _options) {
	      var firstWeekOfYear = new Date(0);
	      firstWeekOfYear.setUTCFullYear(value, 0, 4);
	      firstWeekOfYear.setUTCHours(0, 0, 0, 0);
	      return startOfUTCISOWeek(firstWeekOfYear);
	    },
	    incompatibleTokens: ['G', 'y', 'Y', 'u', 'Q', 'q', 'M', 'L', 'w', 'd', 'D', 'e', 'c', 't', 'T']
	  },
	  // Extended year
	  u: {
	    priority: 130,
	    parse: function (string, token, _match, _options) {
	      if (token === 'u') {
	        return parseNDigitsSigned(4, string);
	      }

	      return parseNDigitsSigned(token.length, string);
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCFullYear(value, 0, 1);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['G', 'y', 'Y', 'R', 'w', 'I', 'i', 'e', 'c', 't', 'T']
	  },
	  // Quarter
	  Q: {
	    priority: 120,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        // 1, 2, 3, 4
	        case 'Q':
	        case 'QQ':
	          // 01, 02, 03, 04
	          return parseNDigits(token.length, string);
	        // 1st, 2nd, 3rd, 4th

	        case 'Qo':
	          return match.ordinalNumber(string, {
	            unit: 'quarter'
	          });
	        // Q1, Q2, Q3, Q4

	        case 'QQQ':
	          return match.quarter(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.quarter(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // 1, 2, 3, 4 (narrow quarter; could be not numerical)

	        case 'QQQQQ':
	          return match.quarter(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // 1st quarter, 2nd quarter, ...

	        case 'QQQQ':
	        default:
	          return match.quarter(string, {
	            width: 'wide',
	            context: 'formatting'
	          }) || match.quarter(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.quarter(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 1 && value <= 4;
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCMonth((value - 1) * 3, 1);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['Y', 'R', 'q', 'M', 'L', 'w', 'I', 'd', 'D', 'i', 'e', 'c', 't', 'T']
	  },
	  // Stand-alone quarter
	  q: {
	    priority: 120,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        // 1, 2, 3, 4
	        case 'q':
	        case 'qq':
	          // 01, 02, 03, 04
	          return parseNDigits(token.length, string);
	        // 1st, 2nd, 3rd, 4th

	        case 'qo':
	          return match.ordinalNumber(string, {
	            unit: 'quarter'
	          });
	        // Q1, Q2, Q3, Q4

	        case 'qqq':
	          return match.quarter(string, {
	            width: 'abbreviated',
	            context: 'standalone'
	          }) || match.quarter(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	        // 1, 2, 3, 4 (narrow quarter; could be not numerical)

	        case 'qqqqq':
	          return match.quarter(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	        // 1st quarter, 2nd quarter, ...

	        case 'qqqq':
	        default:
	          return match.quarter(string, {
	            width: 'wide',
	            context: 'standalone'
	          }) || match.quarter(string, {
	            width: 'abbreviated',
	            context: 'standalone'
	          }) || match.quarter(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 1 && value <= 4;
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCMonth((value - 1) * 3, 1);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['Y', 'R', 'Q', 'M', 'L', 'w', 'I', 'd', 'D', 'i', 'e', 'c', 't', 'T']
	  },
	  // Month
	  M: {
	    priority: 110,
	    parse: function (string, token, match, _options) {
	      var valueCallback = function (value) {
	        return value - 1;
	      };

	      switch (token) {
	        // 1, 2, ..., 12
	        case 'M':
	          return parseNumericPattern(numericPatterns.month, string, valueCallback);
	        // 01, 02, ..., 12

	        case 'MM':
	          return parseNDigits(2, string, valueCallback);
	        // 1st, 2nd, ..., 12th

	        case 'Mo':
	          return match.ordinalNumber(string, {
	            unit: 'month',
	            valueCallback: valueCallback
	          });
	        // Jan, Feb, ..., Dec

	        case 'MMM':
	          return match.month(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.month(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // J, F, ..., D

	        case 'MMMMM':
	          return match.month(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // January, February, ..., December

	        case 'MMMM':
	        default:
	          return match.month(string, {
	            width: 'wide',
	            context: 'formatting'
	          }) || match.month(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.month(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 0 && value <= 11;
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCMonth(value, 1);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['Y', 'R', 'q', 'Q', 'L', 'w', 'I', 'D', 'i', 'e', 'c', 't', 'T']
	  },
	  // Stand-alone month
	  L: {
	    priority: 110,
	    parse: function (string, token, match, _options) {
	      var valueCallback = function (value) {
	        return value - 1;
	      };

	      switch (token) {
	        // 1, 2, ..., 12
	        case 'L':
	          return parseNumericPattern(numericPatterns.month, string, valueCallback);
	        // 01, 02, ..., 12

	        case 'LL':
	          return parseNDigits(2, string, valueCallback);
	        // 1st, 2nd, ..., 12th

	        case 'Lo':
	          return match.ordinalNumber(string, {
	            unit: 'month',
	            valueCallback: valueCallback
	          });
	        // Jan, Feb, ..., Dec

	        case 'LLL':
	          return match.month(string, {
	            width: 'abbreviated',
	            context: 'standalone'
	          }) || match.month(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	        // J, F, ..., D

	        case 'LLLLL':
	          return match.month(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	        // January, February, ..., December

	        case 'LLLL':
	        default:
	          return match.month(string, {
	            width: 'wide',
	            context: 'standalone'
	          }) || match.month(string, {
	            width: 'abbreviated',
	            context: 'standalone'
	          }) || match.month(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 0 && value <= 11;
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCMonth(value, 1);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['Y', 'R', 'q', 'Q', 'M', 'w', 'I', 'D', 'i', 'e', 'c', 't', 'T']
	  },
	  // Local week of year
	  w: {
	    priority: 100,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'w':
	          return parseNumericPattern(numericPatterns.week, string);

	        case 'wo':
	          return match.ordinalNumber(string, {
	            unit: 'week'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 1 && value <= 53;
	    },
	    set: function (date, _flags, value, options) {
	      return startOfUTCWeek(setUTCWeek(date, value, options), options);
	    },
	    incompatibleTokens: ['y', 'R', 'u', 'q', 'Q', 'M', 'L', 'I', 'd', 'D', 'i', 't', 'T']
	  },
	  // ISO week of year
	  I: {
	    priority: 100,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'I':
	          return parseNumericPattern(numericPatterns.week, string);

	        case 'Io':
	          return match.ordinalNumber(string, {
	            unit: 'week'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 1 && value <= 53;
	    },
	    set: function (date, _flags, value, options) {
	      return startOfUTCISOWeek(setUTCISOWeek(date, value, options), options);
	    },
	    incompatibleTokens: ['y', 'Y', 'u', 'q', 'Q', 'M', 'L', 'w', 'd', 'D', 'e', 'c', 't', 'T']
	  },
	  // Day of the month
	  d: {
	    priority: 90,
	    subPriority: 1,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'd':
	          return parseNumericPattern(numericPatterns.date, string);

	        case 'do':
	          return match.ordinalNumber(string, {
	            unit: 'date'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (date, value, _options) {
	      var year = date.getUTCFullYear();
	      var isLeapYear = isLeapYearIndex(year);
	      var month = date.getUTCMonth();

	      if (isLeapYear) {
	        return value >= 1 && value <= DAYS_IN_MONTH_LEAP_YEAR[month];
	      } else {
	        return value >= 1 && value <= DAYS_IN_MONTH[month];
	      }
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCDate(value);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['Y', 'R', 'q', 'Q', 'w', 'I', 'D', 'i', 'e', 'c', 't', 'T']
	  },
	  // Day of year
	  D: {
	    priority: 90,
	    subPriority: 1,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'D':
	        case 'DD':
	          return parseNumericPattern(numericPatterns.dayOfYear, string);

	        case 'Do':
	          return match.ordinalNumber(string, {
	            unit: 'date'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (date, value, _options) {
	      var year = date.getUTCFullYear();
	      var isLeapYear = isLeapYearIndex(year);

	      if (isLeapYear) {
	        return value >= 1 && value <= 366;
	      } else {
	        return value >= 1 && value <= 365;
	      }
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCMonth(0, value);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['Y', 'R', 'q', 'Q', 'M', 'L', 'w', 'I', 'd', 'E', 'i', 'e', 'c', 't', 'T']
	  },
	  // Day of week
	  E: {
	    priority: 90,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        // Tue
	        case 'E':
	        case 'EE':
	        case 'EEE':
	          return match.day(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'short',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // T

	        case 'EEEEE':
	          return match.day(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // Tu

	        case 'EEEEEE':
	          return match.day(string, {
	            width: 'short',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // Tuesday

	        case 'EEEE':
	        default:
	          return match.day(string, {
	            width: 'wide',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'short',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 0 && value <= 6;
	    },
	    set: function (date, _flags, value, options) {
	      date = setUTCDay(date, value, options);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['D', 'i', 'e', 'c', 't', 'T']
	  },
	  // Local day of week
	  e: {
	    priority: 90,
	    parse: function (string, token, match, options) {
	      var valueCallback = function (value) {
	        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
	        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
	      };

	      switch (token) {
	        // 3
	        case 'e':
	        case 'ee':
	          // 03
	          return parseNDigits(token.length, string, valueCallback);
	        // 3rd

	        case 'eo':
	          return match.ordinalNumber(string, {
	            unit: 'day',
	            valueCallback: valueCallback
	          });
	        // Tue

	        case 'eee':
	          return match.day(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'short',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // T

	        case 'eeeee':
	          return match.day(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // Tu

	        case 'eeeeee':
	          return match.day(string, {
	            width: 'short',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	        // Tuesday

	        case 'eeee':
	        default:
	          return match.day(string, {
	            width: 'wide',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'short',
	            context: 'formatting'
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 0 && value <= 6;
	    },
	    set: function (date, _flags, value, options) {
	      date = setUTCDay(date, value, options);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['y', 'R', 'u', 'q', 'Q', 'M', 'L', 'I', 'd', 'D', 'E', 'i', 'c', 't', 'T']
	  },
	  // Stand-alone local day of week
	  c: {
	    priority: 90,
	    parse: function (string, token, match, options) {
	      var valueCallback = function (value) {
	        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
	        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
	      };

	      switch (token) {
	        // 3
	        case 'c':
	        case 'cc':
	          // 03
	          return parseNDigits(token.length, string, valueCallback);
	        // 3rd

	        case 'co':
	          return match.ordinalNumber(string, {
	            unit: 'day',
	            valueCallback: valueCallback
	          });
	        // Tue

	        case 'ccc':
	          return match.day(string, {
	            width: 'abbreviated',
	            context: 'standalone'
	          }) || match.day(string, {
	            width: 'short',
	            context: 'standalone'
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	        // T

	        case 'ccccc':
	          return match.day(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	        // Tu

	        case 'cccccc':
	          return match.day(string, {
	            width: 'short',
	            context: 'standalone'
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	        // Tuesday

	        case 'cccc':
	        default:
	          return match.day(string, {
	            width: 'wide',
	            context: 'standalone'
	          }) || match.day(string, {
	            width: 'abbreviated',
	            context: 'standalone'
	          }) || match.day(string, {
	            width: 'short',
	            context: 'standalone'
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'standalone'
	          });
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 0 && value <= 6;
	    },
	    set: function (date, _flags, value, options) {
	      date = setUTCDay(date, value, options);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['y', 'R', 'u', 'q', 'Q', 'M', 'L', 'I', 'd', 'D', 'E', 'i', 'e', 't', 'T']
	  },
	  // ISO day of week
	  i: {
	    priority: 90,
	    parse: function (string, token, match, _options) {
	      var valueCallback = function (value) {
	        if (value === 0) {
	          return 7;
	        }

	        return value;
	      };

	      switch (token) {
	        // 2
	        case 'i':
	        case 'ii':
	          // 02
	          return parseNDigits(token.length, string);
	        // 2nd

	        case 'io':
	          return match.ordinalNumber(string, {
	            unit: 'day'
	          });
	        // Tue

	        case 'iii':
	          return match.day(string, {
	            width: 'abbreviated',
	            context: 'formatting',
	            valueCallback: valueCallback
	          }) || match.day(string, {
	            width: 'short',
	            context: 'formatting',
	            valueCallback: valueCallback
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'formatting',
	            valueCallback: valueCallback
	          });
	        // T

	        case 'iiiii':
	          return match.day(string, {
	            width: 'narrow',
	            context: 'formatting',
	            valueCallback: valueCallback
	          });
	        // Tu

	        case 'iiiiii':
	          return match.day(string, {
	            width: 'short',
	            context: 'formatting',
	            valueCallback: valueCallback
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'formatting',
	            valueCallback: valueCallback
	          });
	        // Tuesday

	        case 'iiii':
	        default:
	          return match.day(string, {
	            width: 'wide',
	            context: 'formatting',
	            valueCallback: valueCallback
	          }) || match.day(string, {
	            width: 'abbreviated',
	            context: 'formatting',
	            valueCallback: valueCallback
	          }) || match.day(string, {
	            width: 'short',
	            context: 'formatting',
	            valueCallback: valueCallback
	          }) || match.day(string, {
	            width: 'narrow',
	            context: 'formatting',
	            valueCallback: valueCallback
	          });
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 1 && value <= 7;
	    },
	    set: function (date, _flags, value, options) {
	      date = setUTCISODay(date, value, options);
	      date.setUTCHours(0, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['y', 'Y', 'u', 'q', 'Q', 'M', 'L', 'w', 'd', 'D', 'E', 'e', 'c', 't', 'T']
	  },
	  // AM or PM
	  a: {
	    priority: 80,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'a':
	        case 'aa':
	        case 'aaa':
	          return match.dayPeriod(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.dayPeriod(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });

	        case 'aaaaa':
	          return match.dayPeriod(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });

	        case 'aaaa':
	        default:
	          return match.dayPeriod(string, {
	            width: 'wide',
	            context: 'formatting'
	          }) || match.dayPeriod(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.dayPeriod(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	      }
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['b', 'B', 'H', 'K', 'k', 't', 'T']
	  },
	  // AM, PM, midnight
	  b: {
	    priority: 80,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'b':
	        case 'bb':
	        case 'bbb':
	          return match.dayPeriod(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.dayPeriod(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });

	        case 'bbbbb':
	          return match.dayPeriod(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });

	        case 'bbbb':
	        default:
	          return match.dayPeriod(string, {
	            width: 'wide',
	            context: 'formatting'
	          }) || match.dayPeriod(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.dayPeriod(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	      }
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['a', 'B', 'H', 'K', 'k', 't', 'T']
	  },
	  // in the morning, in the afternoon, in the evening, at night
	  B: {
	    priority: 80,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'B':
	        case 'BB':
	        case 'BBB':
	          return match.dayPeriod(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.dayPeriod(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });

	        case 'BBBBB':
	          return match.dayPeriod(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });

	        case 'BBBB':
	        default:
	          return match.dayPeriod(string, {
	            width: 'wide',
	            context: 'formatting'
	          }) || match.dayPeriod(string, {
	            width: 'abbreviated',
	            context: 'formatting'
	          }) || match.dayPeriod(string, {
	            width: 'narrow',
	            context: 'formatting'
	          });
	      }
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['a', 'b', 't', 'T']
	  },
	  // Hour [1-12]
	  h: {
	    priority: 70,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'h':
	          return parseNumericPattern(numericPatterns.hour12h, string);

	        case 'ho':
	          return match.ordinalNumber(string, {
	            unit: 'hour'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 1 && value <= 12;
	    },
	    set: function (date, _flags, value, _options) {
	      var isPM = date.getUTCHours() >= 12;

	      if (isPM && value < 12) {
	        date.setUTCHours(value + 12, 0, 0, 0);
	      } else if (!isPM && value === 12) {
	        date.setUTCHours(0, 0, 0, 0);
	      } else {
	        date.setUTCHours(value, 0, 0, 0);
	      }

	      return date;
	    },
	    incompatibleTokens: ['H', 'K', 'k', 't', 'T']
	  },
	  // Hour [0-23]
	  H: {
	    priority: 70,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'H':
	          return parseNumericPattern(numericPatterns.hour23h, string);

	        case 'Ho':
	          return match.ordinalNumber(string, {
	            unit: 'hour'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 0 && value <= 23;
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCHours(value, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['a', 'b', 'h', 'K', 'k', 't', 'T']
	  },
	  // Hour [0-11]
	  K: {
	    priority: 70,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'K':
	          return parseNumericPattern(numericPatterns.hour11h, string);

	        case 'Ko':
	          return match.ordinalNumber(string, {
	            unit: 'hour'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 0 && value <= 11;
	    },
	    set: function (date, _flags, value, _options) {
	      var isPM = date.getUTCHours() >= 12;

	      if (isPM && value < 12) {
	        date.setUTCHours(value + 12, 0, 0, 0);
	      } else {
	        date.setUTCHours(value, 0, 0, 0);
	      }

	      return date;
	    },
	    incompatibleTokens: ['a', 'b', 'h', 'H', 'k', 't', 'T']
	  },
	  // Hour [1-24]
	  k: {
	    priority: 70,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'k':
	          return parseNumericPattern(numericPatterns.hour24h, string);

	        case 'ko':
	          return match.ordinalNumber(string, {
	            unit: 'hour'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 1 && value <= 24;
	    },
	    set: function (date, _flags, value, _options) {
	      var hours = value <= 24 ? value % 24 : value;
	      date.setUTCHours(hours, 0, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['a', 'b', 'h', 'H', 'K', 't', 'T']
	  },
	  // Minute
	  m: {
	    priority: 60,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 'm':
	          return parseNumericPattern(numericPatterns.minute, string);

	        case 'mo':
	          return match.ordinalNumber(string, {
	            unit: 'minute'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 0 && value <= 59;
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCMinutes(value, 0, 0);
	      return date;
	    },
	    incompatibleTokens: ['t', 'T']
	  },
	  // Second
	  s: {
	    priority: 50,
	    parse: function (string, token, match, _options) {
	      switch (token) {
	        case 's':
	          return parseNumericPattern(numericPatterns.second, string);

	        case 'so':
	          return match.ordinalNumber(string, {
	            unit: 'second'
	          });

	        default:
	          return parseNDigits(token.length, string);
	      }
	    },
	    validate: function (_date, value, _options) {
	      return value >= 0 && value <= 59;
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCSeconds(value, 0);
	      return date;
	    },
	    incompatibleTokens: ['t', 'T']
	  },
	  // Fraction of second
	  S: {
	    priority: 30,
	    parse: function (string, token, _match, _options) {
	      var valueCallback = function (value) {
	        return Math.floor(value * Math.pow(10, -token.length + 3));
	      };

	      return parseNDigits(token.length, string, valueCallback);
	    },
	    set: function (date, _flags, value, _options) {
	      date.setUTCMilliseconds(value);
	      return date;
	    },
	    incompatibleTokens: ['t', 'T']
	  },
	  // Timezone (ISO-8601. +00:00 is `'Z'`)
	  X: {
	    priority: 10,
	    parse: function (string, token, _match, _options) {
	      switch (token) {
	        case 'X':
	          return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, string);

	        case 'XX':
	          return parseTimezonePattern(timezonePatterns.basic, string);

	        case 'XXXX':
	          return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, string);

	        case 'XXXXX':
	          return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, string);

	        case 'XXX':
	        default:
	          return parseTimezonePattern(timezonePatterns.extended, string);
	      }
	    },
	    set: function (date, flags, value, _options) {
	      if (flags.timestampIsSet) {
	        return date;
	      }

	      return new Date(date.getTime() - value);
	    },
	    incompatibleTokens: ['t', 'T', 'x']
	  },
	  // Timezone (ISO-8601)
	  x: {
	    priority: 10,
	    parse: function (string, token, _match, _options) {
	      switch (token) {
	        case 'x':
	          return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, string);

	        case 'xx':
	          return parseTimezonePattern(timezonePatterns.basic, string);

	        case 'xxxx':
	          return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, string);

	        case 'xxxxx':
	          return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, string);

	        case 'xxx':
	        default:
	          return parseTimezonePattern(timezonePatterns.extended, string);
	      }
	    },
	    set: function (date, flags, value, _options) {
	      if (flags.timestampIsSet) {
	        return date;
	      }

	      return new Date(date.getTime() - value);
	    },
	    incompatibleTokens: ['t', 'T', 'X']
	  },
	  // Seconds timestamp
	  t: {
	    priority: 40,
	    parse: function (string, _token, _match, _options) {
	      return parseAnyDigitsSigned(string);
	    },
	    set: function (_date, _flags, value, _options) {
	      return [new Date(value * 1000), {
	        timestampIsSet: true
	      }];
	    },
	    incompatibleTokens: '*'
	  },
	  // Milliseconds timestamp
	  T: {
	    priority: 20,
	    parse: function (string, _token, _match, _options) {
	      return parseAnyDigitsSigned(string);
	    },
	    set: function (_date, _flags, value, _options) {
	      return [new Date(value), {
	        timestampIsSet: true
	      }];
	    },
	    incompatibleTokens: '*'
	  }
	};

	var TIMEZONE_UNIT_PRIORITY = 10; // This RegExp consists of three parts separated by `|`:
	// - [yYQqMLwIdDecihHKkms]o matches any available ordinal number token
	//   (one of the certain letters followed by `o`)
	// - (\w)\1* matches any sequences of the same letter
	// - '' matches two quote characters in a row
	// - '(''|[^'])+('|$) matches anything surrounded by two quote characters ('),
	//   except a single quote symbol, which ends the sequence.
	//   Two quote characters do not end the sequence.
	//   If there is no matching single quote
	//   then the sequence will continue until the end of the string.
	// - . matches any single character unmatched by previous parts of the RegExps

	var formattingTokensRegExp$1 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g; // This RegExp catches symbols escaped by quotes, and also
	// sequences of symbols P, p, and the combinations like `PPPPPPPppppp`

	var longFormattingTokensRegExp$1 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
	var escapedStringRegExp$1 = /^'([^]*?)'?$/;
	var doubleQuoteRegExp$1 = /''/g;
	var notWhitespaceRegExp = /\S/;
	var unescapedLatinCharacterRegExp$1 = /[a-zA-Z]/;
	/**
	 * @name parse
	 * @category Common Helpers
	 * @summary Parse the date.
	 *
	 * @description
	 * Return the date parsed from string using the given format string.
	 *
	 * > ⚠️ Please note that the `format` tokens differ from Moment.js and other libraries.
	 * > See: https://git.io/fxCyr
	 *
	 * The characters in the format string wrapped between two single quotes characters (') are escaped.
	 * Two single quotes in a row, whether inside or outside a quoted sequence, represent a 'real' single quote.
	 *
	 * Format of the format string is based on Unicode Technical Standard #35:
	 * https://www.unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table
	 * with a few additions (see note 5 below the table).
	 *
	 * Not all tokens are compatible. Combinations that don't make sense or could lead to bugs are prohibited
	 * and will throw `RangeError`. For example usage of 24-hour format token with AM/PM token will throw an exception:
	 *
	 * ```javascript
	 * parse('23 AM', 'HH a', new Date())
	 * //=> RangeError: The format string mustn't contain `HH` and `a` at the same time
	 * ```
	 *
	 * See the compatibility table: https://docs.google.com/spreadsheets/d/e/2PACX-1vQOPU3xUhplll6dyoMmVUXHKl_8CRDs6_ueLmex3SoqwhuolkuN3O05l4rqx5h1dKX8eb46Ul-CCSrq/pubhtml?gid=0&single=true
	 *
	 * Accepted format string patterns:
	 * | Unit                            |Prior| Pattern | Result examples                   | Notes |
	 * |---------------------------------|-----|---------|-----------------------------------|-------|
	 * | Era                             | 140 | G..GGG  | AD, BC                            |       |
	 * |                                 |     | GGGG    | Anno Domini, Before Christ        | 2     |
	 * |                                 |     | GGGGG   | A, B                              |       |
	 * | Calendar year                   | 130 | y       | 44, 1, 1900, 2017, 9999           | 4     |
	 * |                                 |     | yo      | 44th, 1st, 1900th, 9999999th      | 4,5   |
	 * |                                 |     | yy      | 44, 01, 00, 17                    | 4     |
	 * |                                 |     | yyy     | 044, 001, 123, 999                | 4     |
	 * |                                 |     | yyyy    | 0044, 0001, 1900, 2017            | 4     |
	 * |                                 |     | yyyyy   | ...                               | 2,4   |
	 * | Local week-numbering year       | 130 | Y       | 44, 1, 1900, 2017, 9000           | 4     |
	 * |                                 |     | Yo      | 44th, 1st, 1900th, 9999999th      | 4,5   |
	 * |                                 |     | YY      | 44, 01, 00, 17                    | 4,6   |
	 * |                                 |     | YYY     | 044, 001, 123, 999                | 4     |
	 * |                                 |     | YYYY    | 0044, 0001, 1900, 2017            | 4,6   |
	 * |                                 |     | YYYYY   | ...                               | 2,4   |
	 * | ISO week-numbering year         | 130 | R       | -43, 1, 1900, 2017, 9999, -9999   | 4,5   |
	 * |                                 |     | RR      | -43, 01, 00, 17                   | 4,5   |
	 * |                                 |     | RRR     | -043, 001, 123, 999, -999         | 4,5   |
	 * |                                 |     | RRRR    | -0043, 0001, 2017, 9999, -9999    | 4,5   |
	 * |                                 |     | RRRRR   | ...                               | 2,4,5 |
	 * | Extended year                   | 130 | u       | -43, 1, 1900, 2017, 9999, -999    | 4     |
	 * |                                 |     | uu      | -43, 01, 99, -99                  | 4     |
	 * |                                 |     | uuu     | -043, 001, 123, 999, -999         | 4     |
	 * |                                 |     | uuuu    | -0043, 0001, 2017, 9999, -9999    | 4     |
	 * |                                 |     | uuuuu   | ...                               | 2,4   |
	 * | Quarter (formatting)            | 120 | Q       | 1, 2, 3, 4                        |       |
	 * |                                 |     | Qo      | 1st, 2nd, 3rd, 4th                | 5     |
	 * |                                 |     | QQ      | 01, 02, 03, 04                    |       |
	 * |                                 |     | QQQ     | Q1, Q2, Q3, Q4                    |       |
	 * |                                 |     | QQQQ    | 1st quarter, 2nd quarter, ...     | 2     |
	 * |                                 |     | QQQQQ   | 1, 2, 3, 4                        | 4     |
	 * | Quarter (stand-alone)           | 120 | q       | 1, 2, 3, 4                        |       |
	 * |                                 |     | qo      | 1st, 2nd, 3rd, 4th                | 5     |
	 * |                                 |     | qq      | 01, 02, 03, 04                    |       |
	 * |                                 |     | qqq     | Q1, Q2, Q3, Q4                    |       |
	 * |                                 |     | qqqq    | 1st quarter, 2nd quarter, ...     | 2     |
	 * |                                 |     | qqqqq   | 1, 2, 3, 4                        | 3     |
	 * | Month (formatting)              | 110 | M       | 1, 2, ..., 12                     |       |
	 * |                                 |     | Mo      | 1st, 2nd, ..., 12th               | 5     |
	 * |                                 |     | MM      | 01, 02, ..., 12                   |       |
	 * |                                 |     | MMM     | Jan, Feb, ..., Dec                |       |
	 * |                                 |     | MMMM    | January, February, ..., December  | 2     |
	 * |                                 |     | MMMMM   | J, F, ..., D                      |       |
	 * | Month (stand-alone)             | 110 | L       | 1, 2, ..., 12                     |       |
	 * |                                 |     | Lo      | 1st, 2nd, ..., 12th               | 5     |
	 * |                                 |     | LL      | 01, 02, ..., 12                   |       |
	 * |                                 |     | LLL     | Jan, Feb, ..., Dec                |       |
	 * |                                 |     | LLLL    | January, February, ..., December  | 2     |
	 * |                                 |     | LLLLL   | J, F, ..., D                      |       |
	 * | Local week of year              | 100 | w       | 1, 2, ..., 53                     |       |
	 * |                                 |     | wo      | 1st, 2nd, ..., 53th               | 5     |
	 * |                                 |     | ww      | 01, 02, ..., 53                   |       |
	 * | ISO week of year                | 100 | I       | 1, 2, ..., 53                     | 5     |
	 * |                                 |     | Io      | 1st, 2nd, ..., 53th               | 5     |
	 * |                                 |     | II      | 01, 02, ..., 53                   | 5     |
	 * | Day of month                    |  90 | d       | 1, 2, ..., 31                     |       |
	 * |                                 |     | do      | 1st, 2nd, ..., 31st               | 5     |
	 * |                                 |     | dd      | 01, 02, ..., 31                   |       |
	 * | Day of year                     |  90 | D       | 1, 2, ..., 365, 366               | 7     |
	 * |                                 |     | Do      | 1st, 2nd, ..., 365th, 366th       | 5     |
	 * |                                 |     | DD      | 01, 02, ..., 365, 366             | 7     |
	 * |                                 |     | DDD     | 001, 002, ..., 365, 366           |       |
	 * |                                 |     | DDDD    | ...                               | 2     |
	 * | Day of week (formatting)        |  90 | E..EEE  | Mon, Tue, Wed, ..., Su            |       |
	 * |                                 |     | EEEE    | Monday, Tuesday, ..., Sunday      | 2     |
	 * |                                 |     | EEEEE   | M, T, W, T, F, S, S               |       |
	 * |                                 |     | EEEEEE  | Mo, Tu, We, Th, Fr, Su, Sa        |       |
	 * | ISO day of week (formatting)    |  90 | i       | 1, 2, 3, ..., 7                   | 5     |
	 * |                                 |     | io      | 1st, 2nd, ..., 7th                | 5     |
	 * |                                 |     | ii      | 01, 02, ..., 07                   | 5     |
	 * |                                 |     | iii     | Mon, Tue, Wed, ..., Su            | 5     |
	 * |                                 |     | iiii    | Monday, Tuesday, ..., Sunday      | 2,5   |
	 * |                                 |     | iiiii   | M, T, W, T, F, S, S               | 5     |
	 * |                                 |     | iiiiii  | Mo, Tu, We, Th, Fr, Su, Sa        | 5     |
	 * | Local day of week (formatting)  |  90 | e       | 2, 3, 4, ..., 1                   |       |
	 * |                                 |     | eo      | 2nd, 3rd, ..., 1st                | 5     |
	 * |                                 |     | ee      | 02, 03, ..., 01                   |       |
	 * |                                 |     | eee     | Mon, Tue, Wed, ..., Su            |       |
	 * |                                 |     | eeee    | Monday, Tuesday, ..., Sunday      | 2     |
	 * |                                 |     | eeeee   | M, T, W, T, F, S, S               |       |
	 * |                                 |     | eeeeee  | Mo, Tu, We, Th, Fr, Su, Sa        |       |
	 * | Local day of week (stand-alone) |  90 | c       | 2, 3, 4, ..., 1                   |       |
	 * |                                 |     | co      | 2nd, 3rd, ..., 1st                | 5     |
	 * |                                 |     | cc      | 02, 03, ..., 01                   |       |
	 * |                                 |     | ccc     | Mon, Tue, Wed, ..., Su            |       |
	 * |                                 |     | cccc    | Monday, Tuesday, ..., Sunday      | 2     |
	 * |                                 |     | ccccc   | M, T, W, T, F, S, S               |       |
	 * |                                 |     | cccccc  | Mo, Tu, We, Th, Fr, Su, Sa        |       |
	 * | AM, PM                          |  80 | a..aaa  | AM, PM                            |       |
	 * |                                 |     | aaaa    | a.m., p.m.                        | 2     |
	 * |                                 |     | aaaaa   | a, p                              |       |
	 * | AM, PM, noon, midnight          |  80 | b..bbb  | AM, PM, noon, midnight            |       |
	 * |                                 |     | bbbb    | a.m., p.m., noon, midnight        | 2     |
	 * |                                 |     | bbbbb   | a, p, n, mi                       |       |
	 * | Flexible day period             |  80 | B..BBB  | at night, in the morning, ...     |       |
	 * |                                 |     | BBBB    | at night, in the morning, ...     | 2     |
	 * |                                 |     | BBBBB   | at night, in the morning, ...     |       |
	 * | Hour [1-12]                     |  70 | h       | 1, 2, ..., 11, 12                 |       |
	 * |                                 |     | ho      | 1st, 2nd, ..., 11th, 12th         | 5     |
	 * |                                 |     | hh      | 01, 02, ..., 11, 12               |       |
	 * | Hour [0-23]                     |  70 | H       | 0, 1, 2, ..., 23                  |       |
	 * |                                 |     | Ho      | 0th, 1st, 2nd, ..., 23rd          | 5     |
	 * |                                 |     | HH      | 00, 01, 02, ..., 23               |       |
	 * | Hour [0-11]                     |  70 | K       | 1, 2, ..., 11, 0                  |       |
	 * |                                 |     | Ko      | 1st, 2nd, ..., 11th, 0th          | 5     |
	 * |                                 |     | KK      | 01, 02, ..., 11, 00               |       |
	 * | Hour [1-24]                     |  70 | k       | 24, 1, 2, ..., 23                 |       |
	 * |                                 |     | ko      | 24th, 1st, 2nd, ..., 23rd         | 5     |
	 * |                                 |     | kk      | 24, 01, 02, ..., 23               |       |
	 * | Minute                          |  60 | m       | 0, 1, ..., 59                     |       |
	 * |                                 |     | mo      | 0th, 1st, ..., 59th               | 5     |
	 * |                                 |     | mm      | 00, 01, ..., 59                   |       |
	 * | Second                          |  50 | s       | 0, 1, ..., 59                     |       |
	 * |                                 |     | so      | 0th, 1st, ..., 59th               | 5     |
	 * |                                 |     | ss      | 00, 01, ..., 59                   |       |
	 * | Seconds timestamp               |  40 | t       | 512969520                         |       |
	 * |                                 |     | tt      | ...                               | 2     |
	 * | Fraction of second              |  30 | S       | 0, 1, ..., 9                      |       |
	 * |                                 |     | SS      | 00, 01, ..., 99                   |       |
	 * |                                 |     | SSS     | 000, 0001, ..., 999               |       |
	 * |                                 |     | SSSS    | ...                               | 2     |
	 * | Milliseconds timestamp          |  20 | T       | 512969520900                      |       |
	 * |                                 |     | TT      | ...                               | 2     |
	 * | Timezone (ISO-8601 w/ Z)        |  10 | X       | -08, +0530, Z                     |       |
	 * |                                 |     | XX      | -0800, +0530, Z                   |       |
	 * |                                 |     | XXX     | -08:00, +05:30, Z                 |       |
	 * |                                 |     | XXXX    | -0800, +0530, Z, +123456          | 2     |
	 * |                                 |     | XXXXX   | -08:00, +05:30, Z, +12:34:56      |       |
	 * | Timezone (ISO-8601 w/o Z)       |  10 | x       | -08, +0530, +00                   |       |
	 * |                                 |     | xx      | -0800, +0530, +0000               |       |
	 * |                                 |     | xxx     | -08:00, +05:30, +00:00            | 2     |
	 * |                                 |     | xxxx    | -0800, +0530, +0000, +123456      |       |
	 * |                                 |     | xxxxx   | -08:00, +05:30, +00:00, +12:34:56 |       |
	 * | Long localized date             |  NA | P       | 05/29/1453                        | 5,8   |
	 * |                                 |     | PP      | May 29, 1453                      |       |
	 * |                                 |     | PPP     | May 29th, 1453                    |       |
	 * |                                 |     | PPPP    | Sunday, May 29th, 1453            | 2,5,8 |
	 * | Long localized time             |  NA | p       | 12:00 AM                          | 5,8   |
	 * |                                 |     | pp      | 12:00:00 AM                       |       |
	 * | Combination of date and time    |  NA | Pp      | 05/29/1453, 12:00 AM              |       |
	 * |                                 |     | PPpp    | May 29, 1453, 12:00:00 AM         |       |
	 * |                                 |     | PPPpp   | May 29th, 1453 at ...             |       |
	 * |                                 |     | PPPPpp  | Sunday, May 29th, 1453 at ...     | 2,5,8 |
	 * Notes:
	 * 1. "Formatting" units (e.g. formatting quarter) in the default en-US locale
	 *    are the same as "stand-alone" units, but are different in some languages.
	 *    "Formatting" units are declined according to the rules of the language
	 *    in the context of a date. "Stand-alone" units are always nominative singular.
	 *    In `format` function, they will produce different result:
	 *
	 *    `format(new Date(2017, 10, 6), 'do LLLL', {locale: cs}) //=> '6. listopad'`
	 *
	 *    `format(new Date(2017, 10, 6), 'do MMMM', {locale: cs}) //=> '6. listopadu'`
	 *
	 *    `parse` will try to match both formatting and stand-alone units interchangably.
	 *
	 * 2. Any sequence of the identical letters is a pattern, unless it is escaped by
	 *    the single quote characters (see below).
	 *    If the sequence is longer than listed in table:
	 *    - for numerical units (`yyyyyyyy`) `parse` will try to match a number
	 *      as wide as the sequence
	 *    - for text units (`MMMMMMMM`) `parse` will try to match the widest variation of the unit.
	 *      These variations are marked with "2" in the last column of the table.
	 *
	 * 3. `QQQQQ` and `qqqqq` could be not strictly numerical in some locales.
	 *    These tokens represent the shortest form of the quarter.
	 *
	 * 4. The main difference between `y` and `u` patterns are B.C. years:
	 *
	 *    | Year | `y` | `u` |
	 *    |------|-----|-----|
	 *    | AC 1 |   1 |   1 |
	 *    | BC 1 |   1 |   0 |
	 *    | BC 2 |   2 |  -1 |
	 *
	 *    Also `yy` will try to guess the century of two digit year by proximity with `referenceDate`:
	 *
	 *    `parse('50', 'yy', new Date(2018, 0, 1)) //=> Sat Jan 01 2050 00:00:00`
	 *
	 *    `parse('75', 'yy', new Date(2018, 0, 1)) //=> Wed Jan 01 1975 00:00:00`
	 *
	 *    while `uu` will just assign the year as is:
	 *
	 *    `parse('50', 'uu', new Date(2018, 0, 1)) //=> Sat Jan 01 0050 00:00:00`
	 *
	 *    `parse('75', 'uu', new Date(2018, 0, 1)) //=> Tue Jan 01 0075 00:00:00`
	 *
	 *    The same difference is true for local and ISO week-numbering years (`Y` and `R`),
	 *    except local week-numbering years are dependent on `options.weekStartsOn`
	 *    and `options.firstWeekContainsDate` (compare [setISOWeekYear]{@link https://date-fns.org/docs/setISOWeekYear}
	 *    and [setWeekYear]{@link https://date-fns.org/docs/setWeekYear}).
	 *
	 * 5. These patterns are not in the Unicode Technical Standard #35:
	 *    - `i`: ISO day of week
	 *    - `I`: ISO week of year
	 *    - `R`: ISO week-numbering year
	 *    - `o`: ordinal number modifier
	 *    - `P`: long localized date
	 *    - `p`: long localized time
	 *
	 * 6. `YY` and `YYYY` tokens represent week-numbering years but they are often confused with years.
	 *    You should enable `options.useAdditionalWeekYearTokens` to use them. See: https://git.io/fxCyr
	 *
	 * 7. `D` and `DD` tokens represent days of the year but they are ofthen confused with days of the month.
	 *    You should enable `options.useAdditionalDayOfYearTokens` to use them. See: https://git.io/fxCyr
	 *
	 * 8. `P+` tokens do not have a defined priority since they are merely aliases to other tokens based
	 *    on the given locale.
	 *
	 *    using `en-US` locale: `P` => `MM/dd/yyyy`
	 *    using `en-US` locale: `p` => `hh:mm a`
	 *    using `pt-BR` locale: `P` => `dd/MM/yyyy`
	 *    using `pt-BR` locale: `p` => `HH:mm`
	 *
	 * Values will be assigned to the date in the descending order of its unit's priority.
	 * Units of an equal priority overwrite each other in the order of appearance.
	 *
	 * If no values of higher priority are parsed (e.g. when parsing string 'January 1st' without a year),
	 * the values will be taken from 3rd argument `referenceDate` which works as a context of parsing.
	 *
	 * `referenceDate` must be passed for correct work of the function.
	 * If you're not sure which `referenceDate` to supply, create a new instance of Date:
	 * `parse('02/11/2014', 'MM/dd/yyyy', new Date())`
	 * In this case parsing will be done in the context of the current date.
	 * If `referenceDate` is `Invalid Date` or a value not convertible to valid `Date`,
	 * then `Invalid Date` will be returned.
	 *
	 * The result may vary by locale.
	 *
	 * If `formatString` matches with `dateString` but does not provides tokens, `referenceDate` will be returned.
	 *
	 * If parsing failed, `Invalid Date` will be returned.
	 * Invalid Date is a Date, whose time value is NaN.
	 * Time value of Date: http://es5.github.io/#x15.9.1.1
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * - Old `parse` was renamed to `toDate`.
	 *   Now `parse` is a new function which parses a string using a provided format.
	 *
	 *   ```javascript
	 *   // Before v2.0.0
	 *   parse('2016-01-01')
	 *
	 *   // v2.0.0 onward
	 *   toDate('2016-01-01')
	 *   parse('2016-01-01', 'yyyy-MM-dd', new Date())
	 *   ```
	 *
	 * @param {String} dateString - the string to parse
	 * @param {String} formatString - the string of tokens
	 * @param {Date|Number} referenceDate - defines values missing from the parsed dateString
	 * @param {Object} [options] - an object with options.
	 * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
	 * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
	 * @param {1|2|3|4|5|6|7} [options.firstWeekContainsDate=1] - the day of January, which is always in the first week of the year
	 * @param {Boolean} [options.useAdditionalWeekYearTokens=false] - if true, allows usage of the week-numbering year tokens `YY` and `YYYY`;
	 *   see: https://git.io/fxCyr
	 * @param {Boolean} [options.useAdditionalDayOfYearTokens=false] - if true, allows usage of the day of year tokens `D` and `DD`;
	 *   see: https://git.io/fxCyr
	 * @returns {Date} the parsed date
	 * @throws {TypeError} 3 arguments required
	 * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
	 * @throws {RangeError} `options.firstWeekContainsDate` must be between 1 and 7
	 * @throws {RangeError} `options.locale` must contain `match` property
	 * @throws {RangeError} use `yyyy` instead of `YYYY` for formatting years using [format provided] to the input [input provided]; see: https://git.io/fxCyr
	 * @throws {RangeError} use `yy` instead of `YY` for formatting years using [format provided] to the input [input provided]; see: https://git.io/fxCyr
	 * @throws {RangeError} use `d` instead of `D` for formatting days of the month using [format provided] to the input [input provided]; see: https://git.io/fxCyr
	 * @throws {RangeError} use `dd` instead of `DD` for formatting days of the month using [format provided] to the input [input provided]; see: https://git.io/fxCyr
	 * @throws {RangeError} format string contains an unescaped latin alphabet character
	 *
	 * @example
	 * // Parse 11 February 2014 from middle-endian format:
	 * var result = parse('02/11/2014', 'MM/dd/yyyy', new Date())
	 * //=> Tue Feb 11 2014 00:00:00
	 *
	 * @example
	 * // Parse 28th of February in Esperanto locale in the context of 2010 year:
	 * import eo from 'date-fns/locale/eo'
	 * var result = parse('28-a de februaro', "do 'de' MMMM", new Date(2010, 0, 1), {
	 *   locale: eo
	 * })
	 * //=> Sun Feb 28 2010 00:00:00
	 */

	function parse(dirtyDateString, dirtyFormatString, dirtyReferenceDate, dirtyOptions) {
	  requiredArgs(3, arguments);
	  var dateString = String(dirtyDateString);
	  var formatString = String(dirtyFormatString);
	  var options = dirtyOptions || {};
	  var locale$1 = options.locale || locale;

	  if (!locale$1.match) {
	    throw new RangeError('locale must contain match property');
	  }

	  var localeFirstWeekContainsDate = locale$1.options && locale$1.options.firstWeekContainsDate;
	  var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger(localeFirstWeekContainsDate);
	  var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger(options.firstWeekContainsDate); // Test if weekStartsOn is between 1 and 7 _and_ is not NaN

	  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
	    throw new RangeError('firstWeekContainsDate must be between 1 and 7 inclusively');
	  }

	  var localeWeekStartsOn = locale$1.options && locale$1.options.weekStartsOn;
	  var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger(localeWeekStartsOn);
	  var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger(options.weekStartsOn); // Test if weekStartsOn is between 0 and 6 _and_ is not NaN

	  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
	    throw new RangeError('weekStartsOn must be between 0 and 6 inclusively');
	  }

	  if (formatString === '') {
	    if (dateString === '') {
	      return toDate(dirtyReferenceDate);
	    } else {
	      return new Date(NaN);
	    }
	  }

	  var subFnOptions = {
	    firstWeekContainsDate: firstWeekContainsDate,
	    weekStartsOn: weekStartsOn,
	    locale: locale$1 // If timezone isn't specified, it will be set to the system timezone

	  };
	  var setters = [{
	    priority: TIMEZONE_UNIT_PRIORITY,
	    subPriority: -1,
	    set: dateToSystemTimezone,
	    index: 0
	  }];
	  var i;
	  var tokens = formatString.match(longFormattingTokensRegExp$1).map(function (substring) {
	    var firstCharacter = substring[0];

	    if (firstCharacter === 'p' || firstCharacter === 'P') {
	      var longFormatter = longFormatters[firstCharacter];
	      return longFormatter(substring, locale$1.formatLong, subFnOptions);
	    }

	    return substring;
	  }).join('').match(formattingTokensRegExp$1);
	  var usedTokens = [];

	  for (i = 0; i < tokens.length; i++) {
	    var token = tokens[i];

	    if (!options.useAdditionalWeekYearTokens && isProtectedWeekYearToken(token)) {
	      throwProtectedError(token, formatString, dirtyDateString);
	    }

	    if (!options.useAdditionalDayOfYearTokens && isProtectedDayOfYearToken(token)) {
	      throwProtectedError(token, formatString, dirtyDateString);
	    }

	    var firstCharacter = token[0];
	    var parser = parsers[firstCharacter];

	    if (parser) {
	      var incompatibleTokens = parser.incompatibleTokens;

	      if (Array.isArray(incompatibleTokens)) {
	        var incompatibleToken = void 0;

	        for (var _i = 0; _i < usedTokens.length; _i++) {
	          var usedToken = usedTokens[_i].token;

	          if (incompatibleTokens.indexOf(usedToken) !== -1 || usedToken === firstCharacter) {
	            incompatibleToken = usedTokens[_i];
	            break;
	          }
	        }

	        if (incompatibleToken) {
	          throw new RangeError("The format string mustn't contain `".concat(incompatibleToken.fullToken, "` and `").concat(token, "` at the same time"));
	        }
	      } else if (parser.incompatibleTokens === '*' && usedTokens.length) {
	        throw new RangeError("The format string mustn't contain `".concat(token, "` and any other token at the same time"));
	      }

	      usedTokens.push({
	        token: firstCharacter,
	        fullToken: token
	      });
	      var parseResult = parser.parse(dateString, token, locale$1.match, subFnOptions);

	      if (!parseResult) {
	        return new Date(NaN);
	      }

	      setters.push({
	        priority: parser.priority,
	        subPriority: parser.subPriority || 0,
	        set: parser.set,
	        validate: parser.validate,
	        value: parseResult.value,
	        index: setters.length
	      });
	      dateString = parseResult.rest;
	    } else {
	      if (firstCharacter.match(unescapedLatinCharacterRegExp$1)) {
	        throw new RangeError('Format string contains an unescaped latin alphabet character `' + firstCharacter + '`');
	      } // Replace two single quote characters with one single quote character


	      if (token === "''") {
	        token = "'";
	      } else if (firstCharacter === "'") {
	        token = cleanEscapedString$1(token);
	      } // Cut token from string, or, if string doesn't match the token, return Invalid Date


	      if (dateString.indexOf(token) === 0) {
	        dateString = dateString.slice(token.length);
	      } else {
	        return new Date(NaN);
	      }
	    }
	  } // Check if the remaining input contains something other than whitespace


	  if (dateString.length > 0 && notWhitespaceRegExp.test(dateString)) {
	    return new Date(NaN);
	  }

	  var uniquePrioritySetters = setters.map(function (setter) {
	    return setter.priority;
	  }).sort(function (a, b) {
	    return b - a;
	  }).filter(function (priority, index, array) {
	    return array.indexOf(priority) === index;
	  }).map(function (priority) {
	    return setters.filter(function (setter) {
	      return setter.priority === priority;
	    }).sort(function (a, b) {
	      return b.subPriority - a.subPriority;
	    });
	  }).map(function (setterArray) {
	    return setterArray[0];
	  });
	  var date = toDate(dirtyReferenceDate);

	  if (isNaN(date)) {
	    return new Date(NaN);
	  } // Convert the date in system timezone to the same date in UTC+00:00 timezone.
	  // This ensures that when UTC functions will be implemented, locales will be compatible with them.
	  // See an issue about UTC functions: https://github.com/date-fns/date-fns/issues/37


	  var utcDate = subMilliseconds(date, getTimezoneOffsetInMilliseconds(date));
	  var flags = {};

	  for (i = 0; i < uniquePrioritySetters.length; i++) {
	    var setter = uniquePrioritySetters[i];

	    if (setter.validate && !setter.validate(utcDate, setter.value, subFnOptions)) {
	      return new Date(NaN);
	    }

	    var result = setter.set(utcDate, flags, setter.value, subFnOptions); // Result is tuple (date, flags)

	    if (result[0]) {
	      utcDate = result[0];
	      assign(flags, result[1]); // Result is date
	    } else {
	      utcDate = result;
	    }
	  }

	  return utcDate;
	}

	function dateToSystemTimezone(date, flags) {
	  if (flags.timestampIsSet) {
	    return date;
	  }

	  var convertedDate = new Date(0);
	  convertedDate.setFullYear(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
	  convertedDate.setHours(date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
	  return convertedDate;
	}

	function cleanEscapedString$1(input) {
	  return input.match(escapedStringRegExp$1)[1].replace(doubleQuoteRegExp$1, "'");
	}

	var MILLISECONDS_IN_HOUR$2 = 3600000;
	var MILLISECONDS_IN_MINUTE$3 = 60000;
	var DEFAULT_ADDITIONAL_DIGITS = 2;
	var patterns = {
	  dateTimeDelimiter: /[T ]/,
	  timeZoneDelimiter: /[Z ]/i,
	  timezone: /([Z+-].*)$/
	};
	var dateRegex = /^-?(?:(\d{3})|(\d{2})(?:-?(\d{2}))?|W(\d{2})(?:-?(\d{1}))?|)$/;
	var timeRegex = /^(\d{2}(?:[.,]\d*)?)(?::?(\d{2}(?:[.,]\d*)?))?(?::?(\d{2}(?:[.,]\d*)?))?$/;
	var timezoneRegex = /^([+-])(\d{2})(?::?(\d{2}))?$/;
	/**
	 * @name parseISO
	 * @category Common Helpers
	 * @summary Parse ISO string
	 *
	 * @description
	 * Parse the given string in ISO 8601 format and return an instance of Date.
	 *
	 * Function accepts complete ISO 8601 formats as well as partial implementations.
	 * ISO 8601: http://en.wikipedia.org/wiki/ISO_8601
	 *
	 * If the argument isn't a string, the function cannot parse the string or
	 * the values are invalid, it returns Invalid Date.
	 *
	 * ### v2.0.0 breaking changes:
	 *
	 * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
	 *
	 * - The previous `parse` implementation was renamed to `parseISO`.
	 *
	 *   ```javascript
	 *   // Before v2.0.0
	 *   parse('2016-01-01')
	 *
	 *   // v2.0.0 onward
	 *   parseISO('2016-01-01')
	 *   ```
	 *
	 * - `parseISO` now validates separate date and time values in ISO-8601 strings
	 *   and returns `Invalid Date` if the date is invalid.
	 *
	 *   ```javascript
	 *   parseISO('2018-13-32')
	 *   //=> Invalid Date
	 *   ```
	 *
	 * - `parseISO` now doesn't fall back to `new Date` constructor
	 *   if it fails to parse a string argument. Instead, it returns `Invalid Date`.
	 *
	 * @param {String} argument - the value to convert
	 * @param {Object} [options] - an object with options.
	 * @param {0|1|2} [options.additionalDigits=2] - the additional number of digits in the extended year format
	 * @returns {Date} the parsed date in the local time zone
	 * @throws {TypeError} 1 argument required
	 * @throws {RangeError} `options.additionalDigits` must be 0, 1 or 2
	 *
	 * @example
	 * // Convert string '2014-02-11T11:30:30' to date:
	 * var result = parseISO('2014-02-11T11:30:30')
	 * //=> Tue Feb 11 2014 11:30:30
	 *
	 * @example
	 * // Convert string '+02014101' to date,
	 * // if the additional number of digits in the extended year format is 1:
	 * var result = parseISO('+02014101', { additionalDigits: 1 })
	 * //=> Fri Apr 11 2014 00:00:00
	 */

	function parseISO(argument, dirtyOptions) {
	  requiredArgs(1, arguments);
	  var options = dirtyOptions || {};
	  var additionalDigits = options.additionalDigits == null ? DEFAULT_ADDITIONAL_DIGITS : toInteger(options.additionalDigits);

	  if (additionalDigits !== 2 && additionalDigits !== 1 && additionalDigits !== 0) {
	    throw new RangeError('additionalDigits must be 0, 1 or 2');
	  }

	  if (!(typeof argument === 'string' || Object.prototype.toString.call(argument) === '[object String]')) {
	    return new Date(NaN);
	  }

	  var dateStrings = splitDateString(argument);
	  var date;

	  if (dateStrings.date) {
	    var parseYearResult = parseYear(dateStrings.date, additionalDigits);
	    date = parseDate(parseYearResult.restDateString, parseYearResult.year);
	  }

	  if (isNaN(date) || !date) {
	    return new Date(NaN);
	  }

	  var timestamp = date.getTime();
	  var time = 0;
	  var offset;

	  if (dateStrings.time) {
	    time = parseTime(dateStrings.time);

	    if (isNaN(time) || time === null) {
	      return new Date(NaN);
	    }
	  }

	  if (dateStrings.timezone) {
	    offset = parseTimezone(dateStrings.timezone);

	    if (isNaN(offset)) {
	      return new Date(NaN);
	    }
	  } else {
	    var dirtyDate = new Date(timestamp + time); // js parsed string assuming it's in UTC timezone
	    // but we need it to be parsed in our timezone
	    // so we use utc values to build date in our timezone.
	    // Year values from 0 to 99 map to the years 1900 to 1999
	    // so set year explicitly with setFullYear.

	    var result = new Date(dirtyDate.getUTCFullYear(), dirtyDate.getUTCMonth(), dirtyDate.getUTCDate(), dirtyDate.getUTCHours(), dirtyDate.getUTCMinutes(), dirtyDate.getUTCSeconds(), dirtyDate.getUTCMilliseconds());
	    result.setFullYear(dirtyDate.getUTCFullYear());
	    return result;
	  }

	  return new Date(timestamp + time + offset);
	}

	function splitDateString(dateString) {
	  var dateStrings = {};
	  var array = dateString.split(patterns.dateTimeDelimiter);
	  var timeString; // The regex match should only return at maximum two array elements.
	  // [date], [time], or [date, time].

	  if (array.length > 2) {
	    return dateStrings;
	  }

	  if (/:/.test(array[0])) {
	    dateStrings.date = null;
	    timeString = array[0];
	  } else {
	    dateStrings.date = array[0];
	    timeString = array[1];

	    if (patterns.timeZoneDelimiter.test(dateStrings.date)) {
	      dateStrings.date = dateString.split(patterns.timeZoneDelimiter)[0];
	      timeString = dateString.substr(dateStrings.date.length, dateString.length);
	    }
	  }

	  if (timeString) {
	    var token = patterns.timezone.exec(timeString);

	    if (token) {
	      dateStrings.time = timeString.replace(token[1], '');
	      dateStrings.timezone = token[1];
	    } else {
	      dateStrings.time = timeString;
	    }
	  }

	  return dateStrings;
	}

	function parseYear(dateString, additionalDigits) {
	  var regex = new RegExp('^(?:(\\d{4}|[+-]\\d{' + (4 + additionalDigits) + '})|(\\d{2}|[+-]\\d{' + (2 + additionalDigits) + '})$)');
	  var captures = dateString.match(regex); // Invalid ISO-formatted year

	  if (!captures) return {
	    year: null
	  };
	  var year = captures[1] && parseInt(captures[1]);
	  var century = captures[2] && parseInt(captures[2]);
	  return {
	    year: century == null ? year : century * 100,
	    restDateString: dateString.slice((captures[1] || captures[2]).length)
	  };
	}

	function parseDate(dateString, year) {
	  // Invalid ISO-formatted year
	  if (year === null) return null;
	  var captures = dateString.match(dateRegex); // Invalid ISO-formatted string

	  if (!captures) return null;
	  var isWeekDate = !!captures[4];
	  var dayOfYear = parseDateUnit(captures[1]);
	  var month = parseDateUnit(captures[2]) - 1;
	  var day = parseDateUnit(captures[3]);
	  var week = parseDateUnit(captures[4]);
	  var dayOfWeek = parseDateUnit(captures[5]) - 1;

	  if (isWeekDate) {
	    if (!validateWeekDate(year, week, dayOfWeek)) {
	      return new Date(NaN);
	    }

	    return dayOfISOWeekYear(year, week, dayOfWeek);
	  } else {
	    var date = new Date(0);

	    if (!validateDate(year, month, day) || !validateDayOfYearDate(year, dayOfYear)) {
	      return new Date(NaN);
	    }

	    date.setUTCFullYear(year, month, Math.max(dayOfYear, day));
	    return date;
	  }
	}

	function parseDateUnit(value) {
	  return value ? parseInt(value) : 1;
	}

	function parseTime(timeString) {
	  var captures = timeString.match(timeRegex);
	  if (!captures) return null; // Invalid ISO-formatted time

	  var hours = parseTimeUnit(captures[1]);
	  var minutes = parseTimeUnit(captures[2]);
	  var seconds = parseTimeUnit(captures[3]);

	  if (!validateTime(hours, minutes, seconds)) {
	    return NaN;
	  }

	  return hours * MILLISECONDS_IN_HOUR$2 + minutes * MILLISECONDS_IN_MINUTE$3 + seconds * 1000;
	}

	function parseTimeUnit(value) {
	  return value && parseFloat(value.replace(',', '.')) || 0;
	}

	function parseTimezone(timezoneString) {
	  if (timezoneString === 'Z') return 0;
	  var captures = timezoneString.match(timezoneRegex);
	  if (!captures) return 0;
	  var sign = captures[1] === '+' ? -1 : 1;
	  var hours = parseInt(captures[2]);
	  var minutes = captures[3] && parseInt(captures[3]) || 0;

	  if (!validateTimezone(hours, minutes)) {
	    return NaN;
	  }

	  return sign * (hours * MILLISECONDS_IN_HOUR$2 + minutes * MILLISECONDS_IN_MINUTE$3);
	}

	function dayOfISOWeekYear(isoWeekYear, week, day) {
	  var date = new Date(0);
	  date.setUTCFullYear(isoWeekYear, 0, 4);
	  var fourthOfJanuaryDay = date.getUTCDay() || 7;
	  var diff = (week - 1) * 7 + day + 1 - fourthOfJanuaryDay;
	  date.setUTCDate(date.getUTCDate() + diff);
	  return date;
	} // Validation functions
	// February is null to handle the leap year (using ||)


	var daysInMonths = [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

	function isLeapYearIndex$1(year) {
	  return year % 400 === 0 || year % 4 === 0 && year % 100;
	}

	function validateDate(year, month, date) {
	  return month >= 0 && month <= 11 && date >= 1 && date <= (daysInMonths[month] || (isLeapYearIndex$1(year) ? 29 : 28));
	}

	function validateDayOfYearDate(year, dayOfYear) {
	  return dayOfYear >= 1 && dayOfYear <= (isLeapYearIndex$1(year) ? 366 : 365);
	}

	function validateWeekDate(_year, week, day) {
	  return week >= 1 && week <= 53 && day >= 0 && day <= 6;
	}

	function validateTime(hours, minutes, seconds) {
	  if (hours === 24) {
	    return minutes === 0 && seconds === 0;
	  }

	  return seconds >= 0 && seconds < 60 && minutes >= 0 && minutes < 60 && hours >= 0 && hours < 25;
	}

	function validateTimezone(_hours, minutes) {
	  return minutes >= 0 && minutes <= 59;
	}

	function _inheritsLoose(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  subClass.__proto__ = superClass;
	}

	function _objectWithoutProperties(source, excluded) {
	  if (source == null) return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i;

	  for (i = 0; i < sourceKeys.length; i++) {
	    key = sourceKeys[i];
	    if (excluded.indexOf(key) >= 0) continue;
	    target[key] = source[key];
	  }

	  if (Object.getOwnPropertySymbols) {
	    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

	    for (i = 0; i < sourceSymbolKeys.length; i++) {
	      key = sourceSymbolKeys[i];
	      if (excluded.indexOf(key) >= 0) continue;
	      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
	      target[key] = source[key];
	    }
	  }

	  return target;
	}
	/**
	 * Check whether some DOM node is our Component's node.
	 */


	function isNodeFound(current, componentNode, ignoreClass) {
	  if (current === componentNode) {
	    return true;
	  } // SVG <use/> elements do not technically reside in the rendered DOM, so
	  // they do not have classList directly, but they offer a link to their
	  // corresponding element, which can have classList. This extra check is for
	  // that case.
	  // See: http://www.w3.org/TR/SVG11/struct.html#InterfaceSVGUseElement
	  // Discussion: https://github.com/Pomax/react-onclickoutside/pull/17


	  if (current.correspondingElement) {
	    return current.correspondingElement.classList.contains(ignoreClass);
	  }

	  return current.classList.contains(ignoreClass);
	}
	/**
	 * Try to find our node in a hierarchy of nodes, returning the document
	 * node as highest node if our node is not found in the path up.
	 */


	function findHighest(current, componentNode, ignoreClass) {
	  if (current === componentNode) {
	    return true;
	  } // If source=local then this event came from 'somewhere'
	  // inside and should be ignored. We could handle this with
	  // a layered approach, too, but that requires going back to
	  // thinking in terms of Dom node nesting, running counter
	  // to React's 'you shouldn't care about the DOM' philosophy.


	  while (current.parentNode) {
	    if (isNodeFound(current, componentNode, ignoreClass)) {
	      return true;
	    }

	    current = current.parentNode;
	  }

	  return current;
	}
	/**
	 * Check if the browser scrollbar was clicked
	 */


	function clickedScrollbar(evt) {
	  return document.documentElement.clientWidth <= evt.clientX || document.documentElement.clientHeight <= evt.clientY;
	} // ideally will get replaced with external dep
	// when rafrex/detect-passive-events#4 and rafrex/detect-passive-events#5 get merged in


	var testPassiveEventSupport = function testPassiveEventSupport() {
	  if (typeof window === 'undefined' || typeof window.addEventListener !== 'function') {
	    return;
	  }

	  var passive = false;
	  var options = Object.defineProperty({}, 'passive', {
	    get: function get() {
	      passive = true;
	    }
	  });

	  var noop = function noop() {};

	  window.addEventListener('testPassiveEventSupport', noop, options);
	  window.removeEventListener('testPassiveEventSupport', noop, options);
	  return passive;
	};

	function autoInc(seed) {
	  if (seed === void 0) {
	    seed = 0;
	  }

	  return function () {
	    return ++seed;
	  };
	}

	var uid = autoInc();
	var passiveEventSupport;
	var handlersMap = {};
	var enabledInstances = {};
	var touchEvents = ['touchstart', 'touchmove'];
	var IGNORE_CLASS_NAME = 'ignore-react-onclickoutside';
	/**
	 * Options for addEventHandler and removeEventHandler
	 */

	function getEventHandlerOptions(instance, eventName) {
	  var handlerOptions = null;
	  var isTouchEvent = touchEvents.indexOf(eventName) !== -1;

	  if (isTouchEvent && passiveEventSupport) {
	    handlerOptions = {
	      passive: !instance.props.preventDefault
	    };
	  }

	  return handlerOptions;
	}
	/**
	 * This function generates the HOC function that you'll use
	 * in order to impart onOutsideClick listening to an
	 * arbitrary component. It gets called at the end of the
	 * bootstrapping code to yield an instance of the
	 * onClickOutsideHOC function defined inside setupHOC().
	 */


	function onClickOutsideHOC(WrappedComponent, config) {
	  var _class, _temp;

	  var componentName = WrappedComponent.displayName || WrappedComponent.name || 'Component';
	  return _temp = _class = /*#__PURE__*/function (_Component) {
	    _inheritsLoose(onClickOutside, _Component);

	    function onClickOutside(props) {
	      var _this;

	      _this = _Component.call(this, props) || this;

	      _this.__outsideClickHandler = function (event) {
	        if (typeof _this.__clickOutsideHandlerProp === 'function') {
	          _this.__clickOutsideHandlerProp(event);

	          return;
	        }

	        var instance = _this.getInstance();

	        if (typeof instance.props.handleClickOutside === 'function') {
	          instance.props.handleClickOutside(event);
	          return;
	        }

	        if (typeof instance.handleClickOutside === 'function') {
	          instance.handleClickOutside(event);
	          return;
	        }

	        throw new Error("WrappedComponent: " + componentName + " lacks a handleClickOutside(event) function for processing outside click events.");
	      };

	      _this.__getComponentNode = function () {
	        var instance = _this.getInstance();

	        if (config && typeof config.setClickOutsideRef === 'function') {
	          return config.setClickOutsideRef()(instance);
	        }

	        if (typeof instance.setClickOutsideRef === 'function') {
	          return instance.setClickOutsideRef();
	        }

	        return ne.findDOMNode(instance);
	      };

	      _this.enableOnClickOutside = function () {
	        if (typeof document === 'undefined' || enabledInstances[_this._uid]) {
	          return;
	        }

	        if (typeof passiveEventSupport === 'undefined') {
	          passiveEventSupport = testPassiveEventSupport();
	        }

	        enabledInstances[_this._uid] = true;
	        var events = _this.props.eventTypes;

	        if (!events.forEach) {
	          events = [events];
	        }

	        handlersMap[_this._uid] = function (event) {
	          if (_this.componentNode === null) return;

	          if (_this.props.preventDefault) {
	            event.preventDefault();
	          }

	          if (_this.props.stopPropagation) {
	            event.stopPropagation();
	          }

	          if (_this.props.excludeScrollbar && clickedScrollbar(event)) return;
	          var current = event.target;

	          if (findHighest(current, _this.componentNode, _this.props.outsideClickIgnoreClass) !== document) {
	            return;
	          }

	          _this.__outsideClickHandler(event);
	        };

	        events.forEach(function (eventName) {
	          document.addEventListener(eventName, handlersMap[_this._uid], getEventHandlerOptions(_this, eventName));
	        });
	      };

	      _this.disableOnClickOutside = function () {
	        delete enabledInstances[_this._uid];
	        var fn = handlersMap[_this._uid];

	        if (fn && typeof document !== 'undefined') {
	          var events = _this.props.eventTypes;

	          if (!events.forEach) {
	            events = [events];
	          }

	          events.forEach(function (eventName) {
	            return document.removeEventListener(eventName, fn, getEventHandlerOptions(_this, eventName));
	          });
	          delete handlersMap[_this._uid];
	        }
	      };

	      _this.getRef = function (ref) {
	        return _this.instanceRef = ref;
	      };

	      _this._uid = uid();
	      return _this;
	    }
	    /**
	     * Access the WrappedComponent's instance.
	     */


	    var _proto = onClickOutside.prototype;

	    _proto.getInstance = function getInstance() {
	      if (!WrappedComponent.prototype.isReactComponent) {
	        return this;
	      }

	      var ref = this.instanceRef;
	      return ref.getInstance ? ref.getInstance() : ref;
	    };
	    /**
	     * Add click listeners to the current document,
	     * linked to this component's state.
	     */


	    _proto.componentDidMount = function componentDidMount() {
	      // If we are in an environment without a DOM such
	      // as shallow rendering or snapshots then we exit
	      // early to prevent any unhandled errors being thrown.
	      if (typeof document === 'undefined' || !document.createElement) {
	        return;
	      }

	      var instance = this.getInstance();

	      if (config && typeof config.handleClickOutside === 'function') {
	        this.__clickOutsideHandlerProp = config.handleClickOutside(instance);

	        if (typeof this.__clickOutsideHandlerProp !== 'function') {
	          throw new Error("WrappedComponent: " + componentName + " lacks a function for processing outside click events specified by the handleClickOutside config option.");
	        }
	      }

	      this.componentNode = this.__getComponentNode(); // return early so we dont initiate onClickOutside

	      if (this.props.disableOnClickOutside) return;
	      this.enableOnClickOutside();
	    };

	    _proto.componentDidUpdate = function componentDidUpdate() {
	      this.componentNode = this.__getComponentNode();
	    };
	    /**
	     * Remove all document's event listeners for this component
	     */


	    _proto.componentWillUnmount = function componentWillUnmount() {
	      this.disableOnClickOutside();
	    };
	    /**
	     * Can be called to explicitly enable event listening
	     * for clicks and touches outside of this element.
	     */

	    /**
	     * Pass-through render
	     */


	    _proto.render = function render() {
	      // eslint-disable-next-line no-unused-vars
	      var _props = this.props,
	          excludeScrollbar = _props.excludeScrollbar,
	          props = _objectWithoutProperties(_props, ["excludeScrollbar"]);

	      if (WrappedComponent.prototype.isReactComponent) {
	        props.ref = this.getRef;
	      } else {
	        props.wrappedRef = this.getRef;
	      }

	      props.disableOnClickOutside = this.disableOnClickOutside;
	      props.enableOnClickOutside = this.enableOnClickOutside;
	      return /*#__PURE__*/React.createElement(WrappedComponent, props);
	    };

	    return onClickOutside;
	  }(React.Component), _class.displayName = "OnClickOutside(" + componentName + ")", _class.defaultProps = {
	    eventTypes: ['mousedown', 'touchstart'],
	    excludeScrollbar: config && config.excludeScrollbar || false,
	    outsideClickIgnoreClass: IGNORE_CLASS_NAME,
	    preventDefault: false,
	    stopPropagation: false
	  }, _class.getClass = function () {
	    return WrappedComponent.getClass ? WrappedComponent.getClass() : WrappedComponent;
	  }, _temp;
	}

	function _objectWithoutPropertiesLoose(source, excluded) {
	  if (source == null) return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i;

	  for (i = 0; i < sourceKeys.length; i++) {
	    key = sourceKeys[i];
	    if (excluded.indexOf(key) >= 0) continue;
	    target[key] = source[key];
	  }

	  return target;
	}

	var objectWithoutPropertiesLoose = _objectWithoutPropertiesLoose;

	var _extends_1 = createCommonjsModule(function (module) {
	  function _extends() {
	    module.exports = _extends = Object.assign || function (target) {
	      for (var i = 1; i < arguments.length; i++) {
	        var source = arguments[i];

	        for (var key in source) {
	          if (Object.prototype.hasOwnProperty.call(source, key)) {
	            target[key] = source[key];
	          }
	        }
	      }

	      return target;
	    };

	    return _extends.apply(this, arguments);
	  }

	  module.exports = _extends;
	});

	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}

	var assertThisInitialized = _assertThisInitialized;

	function _inheritsLoose$1(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  subClass.__proto__ = superClass;
	}

	var inheritsLoose = _inheritsLoose$1;

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	var defineProperty = _defineProperty;

	var toStr = Object.prototype.toString;

	var isArguments = function isArguments(value) {
	  var str = toStr.call(value);
	  var isArgs = str === '[object Arguments]';

	  if (!isArgs) {
	    isArgs = str !== '[object Array]' && value !== null && typeof value === 'object' && typeof value.length === 'number' && value.length >= 0 && toStr.call(value.callee) === '[object Function]';
	  }

	  return isArgs;
	};

	var keysShim;

	if (!Object.keys) {
	  // modified from https://github.com/es-shims/es5-shim
	  var has = Object.prototype.hasOwnProperty;
	  var toStr$1 = Object.prototype.toString;
	  var isArgs = isArguments; // eslint-disable-line global-require

	  var isEnumerable = Object.prototype.propertyIsEnumerable;
	  var hasDontEnumBug = !isEnumerable.call({
	    toString: null
	  }, 'toString');
	  var hasProtoEnumBug = isEnumerable.call(function () {}, 'prototype');
	  var dontEnums = ['toString', 'toLocaleString', 'valueOf', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'constructor'];

	  var equalsConstructorPrototype = function (o) {
	    var ctor = o.constructor;
	    return ctor && ctor.prototype === o;
	  };

	  var excludedKeys = {
	    $applicationCache: true,
	    $console: true,
	    $external: true,
	    $frame: true,
	    $frameElement: true,
	    $frames: true,
	    $innerHeight: true,
	    $innerWidth: true,
	    $onmozfullscreenchange: true,
	    $onmozfullscreenerror: true,
	    $outerHeight: true,
	    $outerWidth: true,
	    $pageXOffset: true,
	    $pageYOffset: true,
	    $parent: true,
	    $scrollLeft: true,
	    $scrollTop: true,
	    $scrollX: true,
	    $scrollY: true,
	    $self: true,
	    $webkitIndexedDB: true,
	    $webkitStorageInfo: true,
	    $window: true
	  };

	  var hasAutomationEqualityBug = function () {
	    /* global window */
	    if (typeof window === 'undefined') {
	      return false;
	    }

	    for (var k in window) {
	      try {
	        if (!excludedKeys['$' + k] && has.call(window, k) && window[k] !== null && typeof window[k] === 'object') {
	          try {
	            equalsConstructorPrototype(window[k]);
	          } catch (e) {
	            return true;
	          }
	        }
	      } catch (e) {
	        return true;
	      }
	    }

	    return false;
	  }();

	  var equalsConstructorPrototypeIfNotBuggy = function (o) {
	    /* global window */
	    if (typeof window === 'undefined' || !hasAutomationEqualityBug) {
	      return equalsConstructorPrototype(o);
	    }

	    try {
	      return equalsConstructorPrototype(o);
	    } catch (e) {
	      return false;
	    }
	  };

	  keysShim = function keys(object) {
	    var isObject = object !== null && typeof object === 'object';
	    var isFunction = toStr$1.call(object) === '[object Function]';
	    var isArguments = isArgs(object);
	    var isString = isObject && toStr$1.call(object) === '[object String]';
	    var theKeys = [];

	    if (!isObject && !isFunction && !isArguments) {
	      throw new TypeError('Object.keys called on a non-object');
	    }

	    var skipProto = hasProtoEnumBug && isFunction;

	    if (isString && object.length > 0 && !has.call(object, 0)) {
	      for (var i = 0; i < object.length; ++i) {
	        theKeys.push(String(i));
	      }
	    }

	    if (isArguments && object.length > 0) {
	      for (var j = 0; j < object.length; ++j) {
	        theKeys.push(String(j));
	      }
	    } else {
	      for (var name in object) {
	        if (!(skipProto && name === 'prototype') && has.call(object, name)) {
	          theKeys.push(String(name));
	        }
	      }
	    }

	    if (hasDontEnumBug) {
	      var skipConstructor = equalsConstructorPrototypeIfNotBuggy(object);

	      for (var k = 0; k < dontEnums.length; ++k) {
	        if (!(skipConstructor && dontEnums[k] === 'constructor') && has.call(object, dontEnums[k])) {
	          theKeys.push(dontEnums[k]);
	        }
	      }
	    }

	    return theKeys;
	  };
	}

	var implementation = keysShim;

	var slice = Array.prototype.slice;
	var origKeys = Object.keys;
	var keysShim$1 = origKeys ? function keys(o) {
	  return origKeys(o);
	} : implementation;
	var originalKeys = Object.keys;

	keysShim$1.shim = function shimObjectKeys() {
	  if (Object.keys) {
	    var keysWorksWithArguments = function () {
	      // Safari 5.0 bug
	      var args = Object.keys(arguments);
	      return args && args.length === arguments.length;
	    }(1, 2);

	    if (!keysWorksWithArguments) {
	      Object.keys = function keys(object) {
	        // eslint-disable-line func-name-matching
	        if (isArguments(object)) {
	          return originalKeys(slice.call(object));
	        }

	        return originalKeys(object);
	      };
	    }
	  } else {
	    Object.keys = keysShim$1;
	  }

	  return Object.keys || keysShim$1;
	};

	var objectKeys = keysShim$1;

	var hasToStringTag = typeof Symbol === 'function' && typeof Symbol.toStringTag === 'symbol';
	var toStr$2 = Object.prototype.toString;

	var isStandardArguments = function isArguments(value) {
	  if (hasToStringTag && value && typeof value === 'object' && Symbol.toStringTag in value) {
	    return false;
	  }

	  return toStr$2.call(value) === '[object Arguments]';
	};

	var isLegacyArguments = function isArguments(value) {
	  if (isStandardArguments(value)) {
	    return true;
	  }

	  return value !== null && typeof value === 'object' && typeof value.length === 'number' && value.length >= 0 && toStr$2.call(value) !== '[object Array]' && toStr$2.call(value.callee) === '[object Function]';
	};

	var supportsStandardArguments = function () {
	  return isStandardArguments(arguments);
	}();

	isStandardArguments.isLegacyArguments = isLegacyArguments; // for tests

	var isArguments$1 = supportsStandardArguments ? isStandardArguments : isLegacyArguments;

	var hasSymbols = typeof Symbol === 'function' && typeof Symbol('foo') === 'symbol';
	var toStr$3 = Object.prototype.toString;
	var concat = Array.prototype.concat;
	var origDefineProperty = Object.defineProperty;

	var isFunction = function (fn) {
	  return typeof fn === 'function' && toStr$3.call(fn) === '[object Function]';
	};

	var arePropertyDescriptorsSupported = function () {
	  var obj = {};

	  try {
	    origDefineProperty(obj, 'x', {
	      enumerable: false,
	      value: obj
	    }); // eslint-disable-next-line no-unused-vars, no-restricted-syntax

	    for (var _ in obj) {
	      // jscs:ignore disallowUnusedVariables
	      return false;
	    }

	    return obj.x === obj;
	  } catch (e) {
	    /* this is IE 8. */
	    return false;
	  }
	};

	var supportsDescriptors = origDefineProperty && arePropertyDescriptorsSupported();

	var defineProperty$1 = function (object, name, value, predicate) {
	  if (name in object && (!isFunction(predicate) || !predicate())) {
	    return;
	  }

	  if (supportsDescriptors) {
	    origDefineProperty(object, name, {
	      configurable: true,
	      enumerable: false,
	      value: value,
	      writable: true
	    });
	  } else {
	    object[name] = value;
	  }
	};

	var defineProperties = function (object, map) {
	  var predicates = arguments.length > 2 ? arguments[2] : {};
	  var props = objectKeys(map);

	  if (hasSymbols) {
	    props = concat.call(props, Object.getOwnPropertySymbols(map));
	  }

	  for (var i = 0; i < props.length; i += 1) {
	    defineProperty$1(object, props[i], map[props[i]], predicates[props[i]]);
	  }
	};

	defineProperties.supportsDescriptors = !!supportsDescriptors;
	var defineProperties_1 = defineProperties;

	/* eslint no-invalid-this: 1 */

	var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
	var slice$1 = Array.prototype.slice;
	var toStr$4 = Object.prototype.toString;
	var funcType = '[object Function]';

	var implementation$1 = function bind(that) {
	  var target = this;

	  if (typeof target !== 'function' || toStr$4.call(target) !== funcType) {
	    throw new TypeError(ERROR_MESSAGE + target);
	  }

	  var args = slice$1.call(arguments, 1);
	  var bound;

	  var binder = function () {
	    if (this instanceof bound) {
	      var result = target.apply(this, args.concat(slice$1.call(arguments)));

	      if (Object(result) === result) {
	        return result;
	      }

	      return this;
	    } else {
	      return target.apply(that, args.concat(slice$1.call(arguments)));
	    }
	  };

	  var boundLength = Math.max(0, target.length - args.length);
	  var boundArgs = [];

	  for (var i = 0; i < boundLength; i++) {
	    boundArgs.push('$' + i);
	  }

	  bound = Function('binder', 'return function (' + boundArgs.join(',') + '){ return binder.apply(this,arguments); }')(binder);

	  if (target.prototype) {
	    var Empty = function Empty() {};

	    Empty.prototype = target.prototype;
	    bound.prototype = new Empty();
	    Empty.prototype = null;
	  }

	  return bound;
	};

	var functionBind = Function.prototype.bind || implementation$1;

	/* eslint complexity: [2, 18], max-statements: [2, 33] */

	var shams = function hasSymbols() {
	  if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') {
	    return false;
	  }

	  if (typeof Symbol.iterator === 'symbol') {
	    return true;
	  }

	  var obj = {};
	  var sym = Symbol('test');
	  var symObj = Object(sym);

	  if (typeof sym === 'string') {
	    return false;
	  }

	  if (Object.prototype.toString.call(sym) !== '[object Symbol]') {
	    return false;
	  }

	  if (Object.prototype.toString.call(symObj) !== '[object Symbol]') {
	    return false;
	  } // temp disabled per https://github.com/ljharb/object.assign/issues/17
	  // if (sym instanceof Symbol) { return false; }
	  // temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	  // if (!(symObj instanceof Symbol)) { return false; }
	  // if (typeof Symbol.prototype.toString !== 'function') { return false; }
	  // if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }


	  var symVal = 42;
	  obj[sym] = symVal;

	  for (sym in obj) {
	    return false;
	  } // eslint-disable-line no-restricted-syntax


	  if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) {
	    return false;
	  }

	  if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) {
	    return false;
	  }

	  var syms = Object.getOwnPropertySymbols(obj);

	  if (syms.length !== 1 || syms[0] !== sym) {
	    return false;
	  }

	  if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) {
	    return false;
	  }

	  if (typeof Object.getOwnPropertyDescriptor === 'function') {
	    var descriptor = Object.getOwnPropertyDescriptor(obj, sym);

	    if (descriptor.value !== symVal || descriptor.enumerable !== true) {
	      return false;
	    }
	  }

	  return true;
	};

	var origSymbol = commonjsGlobal.Symbol;

	var hasSymbols$1 = function hasNativeSymbols() {
	  if (typeof origSymbol !== 'function') {
	    return false;
	  }

	  if (typeof Symbol !== 'function') {
	    return false;
	  }

	  if (typeof origSymbol('foo') !== 'symbol') {
	    return false;
	  }

	  if (typeof Symbol('bar') !== 'symbol') {
	    return false;
	  }

	  return shams();
	};

	/* globals
		Atomics,
		SharedArrayBuffer,
	*/


	var undefined$1;
	var $TypeError = TypeError;
	var $gOPD = Object.getOwnPropertyDescriptor;

	if ($gOPD) {
	  try {
	    $gOPD({}, '');
	  } catch (e) {
	    $gOPD = null; // this is IE 8, which has a broken gOPD
	  }
	}

	var throwTypeError = function () {
	  throw new $TypeError();
	};

	var ThrowTypeError = $gOPD ? function () {
	  try {
	    // eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
	    arguments.callee; // IE 8 does not throw here

	    return throwTypeError;
	  } catch (calleeThrows) {
	    try {
	      // IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
	      return $gOPD(arguments, 'callee').get;
	    } catch (gOPDthrows) {
	      return throwTypeError;
	    }
	  }
	}() : throwTypeError;
	var hasSymbols$2 = hasSymbols$1();

	var getProto = Object.getPrototypeOf || function (x) {
	  return x.__proto__;
	}; // eslint-disable-line no-proto

	var generatorFunction =  undefined$1;

	var asyncFunction =  undefined$1;

	var asyncGenFunction =  undefined$1;
	var TypedArray = typeof Uint8Array === 'undefined' ? undefined$1 : getProto(Uint8Array);
	var INTRINSICS = {
	  '%Array%': Array,
	  '%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined$1 : ArrayBuffer,
	  '%ArrayBufferPrototype%': typeof ArrayBuffer === 'undefined' ? undefined$1 : ArrayBuffer.prototype,
	  '%ArrayIteratorPrototype%': hasSymbols$2 ? getProto([][Symbol.iterator]()) : undefined$1,
	  '%ArrayPrototype%': Array.prototype,
	  '%ArrayProto_entries%': Array.prototype.entries,
	  '%ArrayProto_forEach%': Array.prototype.forEach,
	  '%ArrayProto_keys%': Array.prototype.keys,
	  '%ArrayProto_values%': Array.prototype.values,
	  '%AsyncFromSyncIteratorPrototype%': undefined$1,
	  '%AsyncFunction%': asyncFunction,
	  '%AsyncFunctionPrototype%':  undefined$1,
	  '%AsyncGenerator%':  undefined$1,
	  '%AsyncGeneratorFunction%': asyncGenFunction,
	  '%AsyncGeneratorPrototype%':  undefined$1,
	  '%AsyncIteratorPrototype%':  undefined$1,
	  '%Atomics%': typeof Atomics === 'undefined' ? undefined$1 : Atomics,
	  '%Boolean%': Boolean,
	  '%BooleanPrototype%': Boolean.prototype,
	  '%DataView%': typeof DataView === 'undefined' ? undefined$1 : DataView,
	  '%DataViewPrototype%': typeof DataView === 'undefined' ? undefined$1 : DataView.prototype,
	  '%Date%': Date,
	  '%DatePrototype%': Date.prototype,
	  '%decodeURI%': decodeURI,
	  '%decodeURIComponent%': decodeURIComponent,
	  '%encodeURI%': encodeURI,
	  '%encodeURIComponent%': encodeURIComponent,
	  '%Error%': Error,
	  '%ErrorPrototype%': Error.prototype,
	  '%eval%': eval,
	  // eslint-disable-line no-eval
	  '%EvalError%': EvalError,
	  '%EvalErrorPrototype%': EvalError.prototype,
	  '%Float32Array%': typeof Float32Array === 'undefined' ? undefined$1 : Float32Array,
	  '%Float32ArrayPrototype%': typeof Float32Array === 'undefined' ? undefined$1 : Float32Array.prototype,
	  '%Float64Array%': typeof Float64Array === 'undefined' ? undefined$1 : Float64Array,
	  '%Float64ArrayPrototype%': typeof Float64Array === 'undefined' ? undefined$1 : Float64Array.prototype,
	  '%Function%': Function,
	  '%FunctionPrototype%': Function.prototype,
	  '%Generator%':  undefined$1,
	  '%GeneratorFunction%': generatorFunction,
	  '%GeneratorPrototype%':  undefined$1,
	  '%Int8Array%': typeof Int8Array === 'undefined' ? undefined$1 : Int8Array,
	  '%Int8ArrayPrototype%': typeof Int8Array === 'undefined' ? undefined$1 : Int8Array.prototype,
	  '%Int16Array%': typeof Int16Array === 'undefined' ? undefined$1 : Int16Array,
	  '%Int16ArrayPrototype%': typeof Int16Array === 'undefined' ? undefined$1 : Int8Array.prototype,
	  '%Int32Array%': typeof Int32Array === 'undefined' ? undefined$1 : Int32Array,
	  '%Int32ArrayPrototype%': typeof Int32Array === 'undefined' ? undefined$1 : Int32Array.prototype,
	  '%isFinite%': isFinite,
	  '%isNaN%': isNaN,
	  '%IteratorPrototype%': hasSymbols$2 ? getProto(getProto([][Symbol.iterator]())) : undefined$1,
	  '%JSON%': typeof JSON === 'object' ? JSON : undefined$1,
	  '%JSONParse%': typeof JSON === 'object' ? JSON.parse : undefined$1,
	  '%Map%': typeof Map === 'undefined' ? undefined$1 : Map,
	  '%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols$2 ? undefined$1 : getProto(new Map()[Symbol.iterator]()),
	  '%MapPrototype%': typeof Map === 'undefined' ? undefined$1 : Map.prototype,
	  '%Math%': Math,
	  '%Number%': Number,
	  '%NumberPrototype%': Number.prototype,
	  '%Object%': Object,
	  '%ObjectPrototype%': Object.prototype,
	  '%ObjProto_toString%': Object.prototype.toString,
	  '%ObjProto_valueOf%': Object.prototype.valueOf,
	  '%parseFloat%': parseFloat,
	  '%parseInt%': parseInt,
	  '%Promise%': typeof Promise === 'undefined' ? undefined$1 : Promise,
	  '%PromisePrototype%': typeof Promise === 'undefined' ? undefined$1 : Promise.prototype,
	  '%PromiseProto_then%': typeof Promise === 'undefined' ? undefined$1 : Promise.prototype.then,
	  '%Promise_all%': typeof Promise === 'undefined' ? undefined$1 : Promise.all,
	  '%Promise_reject%': typeof Promise === 'undefined' ? undefined$1 : Promise.reject,
	  '%Promise_resolve%': typeof Promise === 'undefined' ? undefined$1 : Promise.resolve,
	  '%Proxy%': typeof Proxy === 'undefined' ? undefined$1 : Proxy,
	  '%RangeError%': RangeError,
	  '%RangeErrorPrototype%': RangeError.prototype,
	  '%ReferenceError%': ReferenceError,
	  '%ReferenceErrorPrototype%': ReferenceError.prototype,
	  '%Reflect%': typeof Reflect === 'undefined' ? undefined$1 : Reflect,
	  '%RegExp%': RegExp,
	  '%RegExpPrototype%': RegExp.prototype,
	  '%Set%': typeof Set === 'undefined' ? undefined$1 : Set,
	  '%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols$2 ? undefined$1 : getProto(new Set()[Symbol.iterator]()),
	  '%SetPrototype%': typeof Set === 'undefined' ? undefined$1 : Set.prototype,
	  '%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined$1 : SharedArrayBuffer,
	  '%SharedArrayBufferPrototype%': typeof SharedArrayBuffer === 'undefined' ? undefined$1 : SharedArrayBuffer.prototype,
	  '%String%': String,
	  '%StringIteratorPrototype%': hasSymbols$2 ? getProto(''[Symbol.iterator]()) : undefined$1,
	  '%StringPrototype%': String.prototype,
	  '%Symbol%': hasSymbols$2 ? Symbol : undefined$1,
	  '%SymbolPrototype%': hasSymbols$2 ? Symbol.prototype : undefined$1,
	  '%SyntaxError%': SyntaxError,
	  '%SyntaxErrorPrototype%': SyntaxError.prototype,
	  '%ThrowTypeError%': ThrowTypeError,
	  '%TypedArray%': TypedArray,
	  '%TypedArrayPrototype%': TypedArray ? TypedArray.prototype : undefined$1,
	  '%TypeError%': $TypeError,
	  '%TypeErrorPrototype%': $TypeError.prototype,
	  '%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined$1 : Uint8Array,
	  '%Uint8ArrayPrototype%': typeof Uint8Array === 'undefined' ? undefined$1 : Uint8Array.prototype,
	  '%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined$1 : Uint8ClampedArray,
	  '%Uint8ClampedArrayPrototype%': typeof Uint8ClampedArray === 'undefined' ? undefined$1 : Uint8ClampedArray.prototype,
	  '%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined$1 : Uint16Array,
	  '%Uint16ArrayPrototype%': typeof Uint16Array === 'undefined' ? undefined$1 : Uint16Array.prototype,
	  '%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined$1 : Uint32Array,
	  '%Uint32ArrayPrototype%': typeof Uint32Array === 'undefined' ? undefined$1 : Uint32Array.prototype,
	  '%URIError%': URIError,
	  '%URIErrorPrototype%': URIError.prototype,
	  '%WeakMap%': typeof WeakMap === 'undefined' ? undefined$1 : WeakMap,
	  '%WeakMapPrototype%': typeof WeakMap === 'undefined' ? undefined$1 : WeakMap.prototype,
	  '%WeakSet%': typeof WeakSet === 'undefined' ? undefined$1 : WeakSet,
	  '%WeakSetPrototype%': typeof WeakSet === 'undefined' ? undefined$1 : WeakSet.prototype
	};
	var $replace = functionBind.call(Function.call, String.prototype.replace);
	/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */

	var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
	var reEscapeChar = /\\(\\)?/g;
	/** Used to match backslashes in property paths. */

	var stringToPath = function stringToPath(string) {
	  var result = [];
	  $replace(string, rePropName, function (match, number, quote, subString) {
	    result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	  });
	  return result;
	};
	/* end adaptation */


	var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	  if (!(name in INTRINSICS)) {
	    throw new SyntaxError('intrinsic ' + name + ' does not exist!');
	  } // istanbul ignore if // hopefully this is impossible to test :-)


	  if (typeof INTRINSICS[name] === 'undefined' && !allowMissing) {
	    throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
	  }

	  return INTRINSICS[name];
	};

	var GetIntrinsic = function GetIntrinsic(name, allowMissing) {
	  if (typeof name !== 'string' || name.length === 0) {
	    throw new TypeError('intrinsic name must be a non-empty string');
	  }

	  if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
	    throw new TypeError('"allowMissing" argument must be a boolean');
	  }

	  var parts = stringToPath(name);
	  var value = getBaseIntrinsic('%' + (parts.length > 0 ? parts[0] : '') + '%', allowMissing);

	  for (var i = 1; i < parts.length; i += 1) {
	    if (value != null) {
	      if ($gOPD && i + 1 >= parts.length) {
	        var desc = $gOPD(value, parts[i]);

	        if (!allowMissing && !(parts[i] in value)) {
	          throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
	        }

	        value = desc ? desc.get || desc.value : value[parts[i]];
	      } else {
	        value = value[parts[i]];
	      }
	    }
	  }

	  return value;
	};

	var $apply = GetIntrinsic('%Function.prototype.apply%');
	var $call = GetIntrinsic('%Function.prototype.call%');
	var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || functionBind.call($call, $apply);

	var callBind = function callBind() {
	  return $reflectApply(functionBind, $call, arguments);
	};

	var apply = function applyBind() {
	  return $reflectApply(functionBind, $apply, arguments);
	};
	callBind.apply = apply;

	var numberIsNaN = function (value) {
	  return value !== value;
	};

	var implementation$2 = function is(a, b) {
	  if (a === 0 && b === 0) {
	    return 1 / a === 1 / b;
	  }

	  if (a === b) {
	    return true;
	  }

	  if (numberIsNaN(a) && numberIsNaN(b)) {
	    return true;
	  }

	  return false;
	};

	var polyfill = function getPolyfill() {
	  return typeof Object.is === 'function' ? Object.is : implementation$2;
	};

	var shim = function shimObjectIs() {
	  var polyfill$1 = polyfill();
	  defineProperties_1(Object, {
	    is: polyfill$1
	  }, {
	    is: function testObjectIs() {
	      return Object.is !== polyfill$1;
	    }
	  });
	  return polyfill$1;
	};

	var polyfill$1 = callBind(polyfill(), Object);
	defineProperties_1(polyfill$1, {
	  getPolyfill: polyfill,
	  implementation: implementation$2,
	  shim: shim
	});
	var objectIs = polyfill$1;

	var hasSymbols$3 = hasSymbols$1();
	var hasToStringTag$1 = hasSymbols$3 && typeof Symbol.toStringTag === 'symbol';
	var regexExec;
	var isRegexMarker;
	var badStringifier;

	if (hasToStringTag$1) {
	  regexExec = Function.call.bind(RegExp.prototype.exec);
	  isRegexMarker = {};

	  var throwRegexMarker = function () {
	    throw isRegexMarker;
	  };

	  badStringifier = {
	    toString: throwRegexMarker,
	    valueOf: throwRegexMarker
	  };

	  if (typeof Symbol.toPrimitive === 'symbol') {
	    badStringifier[Symbol.toPrimitive] = throwRegexMarker;
	  }
	}

	var toStr$5 = Object.prototype.toString;
	var regexClass = '[object RegExp]';
	var isRegex = hasToStringTag$1 // eslint-disable-next-line consistent-return
	? function isRegex(value) {
	  if (!value || typeof value !== 'object') {
	    return false;
	  }

	  try {
	    regexExec(value, badStringifier);
	  } catch (e) {
	    return e === isRegexMarker;
	  }
	} : function isRegex(value) {
	  // In older browsers, typeof regex incorrectly returns 'function'
	  if (!value || typeof value !== 'object' && typeof value !== 'function') {
	    return false;
	  }

	  return toStr$5.call(value) === regexClass;
	};

	var $Object = Object;
	var $TypeError$1 = TypeError;

	var implementation$3 = function flags() {
	  if (this != null && this !== $Object(this)) {
	    throw new $TypeError$1('RegExp.prototype.flags getter called on non-object');
	  }

	  var result = '';

	  if (this.global) {
	    result += 'g';
	  }

	  if (this.ignoreCase) {
	    result += 'i';
	  }

	  if (this.multiline) {
	    result += 'm';
	  }

	  if (this.dotAll) {
	    result += 's';
	  }

	  if (this.unicode) {
	    result += 'u';
	  }

	  if (this.sticky) {
	    result += 'y';
	  }

	  return result;
	};

	var supportsDescriptors$1 = defineProperties_1.supportsDescriptors;
	var $gOPD$1 = Object.getOwnPropertyDescriptor;
	var $TypeError$2 = TypeError;

	var polyfill$2 = function getPolyfill() {
	  if (!supportsDescriptors$1) {
	    throw new $TypeError$2('RegExp.prototype.flags requires a true ES5 environment that supports property descriptors');
	  }

	  if (/a/mig.flags === 'gim') {
	    var descriptor = $gOPD$1(RegExp.prototype, 'flags');

	    if (descriptor && typeof descriptor.get === 'function' && typeof /a/.dotAll === 'boolean') {
	      return descriptor.get;
	    }
	  }

	  return implementation$3;
	};

	var supportsDescriptors$2 = defineProperties_1.supportsDescriptors;
	var gOPD = Object.getOwnPropertyDescriptor;
	var defineProperty$2 = Object.defineProperty;
	var TypeErr = TypeError;
	var getProto$1 = Object.getPrototypeOf;
	var regex = /a/;

	var shim$1 = function shimFlags() {
	  if (!supportsDescriptors$2 || !getProto$1) {
	    throw new TypeErr('RegExp.prototype.flags requires a true ES5 environment that supports property descriptors');
	  }

	  var polyfill = polyfill$2();
	  var proto = getProto$1(regex);
	  var descriptor = gOPD(proto, 'flags');

	  if (!descriptor || descriptor.get !== polyfill) {
	    defineProperty$2(proto, 'flags', {
	      configurable: true,
	      enumerable: false,
	      get: polyfill
	    });
	  }

	  return polyfill;
	};

	var flagsBound = callBind(implementation$3);
	defineProperties_1(flagsBound, {
	  getPolyfill: polyfill$2,
	  implementation: implementation$3,
	  shim: shim$1
	});
	var regexp_prototype_flags = flagsBound;

	var getDay$1 = Date.prototype.getDay;

	var tryDateObject = function tryDateGetDayCall(value) {
	  try {
	    getDay$1.call(value);
	    return true;
	  } catch (e) {
	    return false;
	  }
	};

	var toStr$6 = Object.prototype.toString;
	var dateClass = '[object Date]';
	var hasToStringTag$2 = typeof Symbol === 'function' && typeof Symbol.toStringTag === 'symbol';

	var isDateObject = function isDateObject(value) {
	  if (typeof value !== 'object' || value === null) {
	    return false;
	  }

	  return hasToStringTag$2 ? tryDateObject(value) : toStr$6.call(value) === dateClass;
	};

	var getTime$1 = Date.prototype.getTime;

	function deepEqual(actual, expected, options) {
	  var opts = options || {}; // 7.1. All identical values are equivalent, as determined by ===.

	  if (opts.strict ? objectIs(actual, expected) : actual === expected) {
	    return true;
	  } // 7.3. Other pairs that do not both pass typeof value == 'object', equivalence is determined by ==.


	  if (!actual || !expected || typeof actual !== 'object' && typeof expected !== 'object') {
	    return opts.strict ? objectIs(actual, expected) : actual == expected;
	  }
	  /*
	   * 7.4. For all other Object pairs, including Array objects, equivalence is
	   * determined by having the same number of owned properties (as verified
	   * with Object.prototype.hasOwnProperty.call), the same set of keys
	   * (although not necessarily the same order), equivalent values for every
	   * corresponding key, and an identical 'prototype' property. Note: this
	   * accounts for both named and indexed properties on Arrays.
	   */
	  // eslint-disable-next-line no-use-before-define


	  return objEquiv(actual, expected, opts);
	}

	function isUndefinedOrNull(value) {
	  return value === null || value === undefined;
	}

	function isBuffer(x) {
	  if (!x || typeof x !== 'object' || typeof x.length !== 'number') {
	    return false;
	  }

	  if (typeof x.copy !== 'function' || typeof x.slice !== 'function') {
	    return false;
	  }

	  if (x.length > 0 && typeof x[0] !== 'number') {
	    return false;
	  }

	  return true;
	}

	function objEquiv(a, b, opts) {
	  /* eslint max-statements: [2, 50] */
	  var i, key;

	  if (typeof a !== typeof b) {
	    return false;
	  }

	  if (isUndefinedOrNull(a) || isUndefinedOrNull(b)) {
	    return false;
	  } // an identical 'prototype' property.


	  if (a.prototype !== b.prototype) {
	    return false;
	  }

	  if (isArguments$1(a) !== isArguments$1(b)) {
	    return false;
	  }

	  var aIsRegex = isRegex(a);
	  var bIsRegex = isRegex(b);

	  if (aIsRegex !== bIsRegex) {
	    return false;
	  }

	  if (aIsRegex || bIsRegex) {
	    return a.source === b.source && regexp_prototype_flags(a) === regexp_prototype_flags(b);
	  }

	  if (isDateObject(a) && isDateObject(b)) {
	    return getTime$1.call(a) === getTime$1.call(b);
	  }

	  var aIsBuffer = isBuffer(a);
	  var bIsBuffer = isBuffer(b);

	  if (aIsBuffer !== bIsBuffer) {
	    return false;
	  }

	  if (aIsBuffer || bIsBuffer) {
	    // && would work too, because both are true or both false here
	    if (a.length !== b.length) {
	      return false;
	    }

	    for (i = 0; i < a.length; i++) {
	      if (a[i] !== b[i]) {
	        return false;
	      }
	    }

	    return true;
	  }

	  if (typeof a !== typeof b) {
	    return false;
	  }

	  try {
	    var ka = objectKeys(a);
	    var kb = objectKeys(b);
	  } catch (e) {
	    // happens when one is a string literal and the other isn't
	    return false;
	  } // having the same number of owned properties (keys incorporates hasOwnProperty)


	  if (ka.length !== kb.length) {
	    return false;
	  } // the same set of keys (although not necessarily the same order),


	  ka.sort();
	  kb.sort(); // ~~~cheap key test

	  for (i = ka.length - 1; i >= 0; i--) {
	    if (ka[i] != kb[i]) {
	      return false;
	    }
	  } // equivalent values for every corresponding key, and ~~~possibly expensive deep test


	  for (i = ka.length - 1; i >= 0; i--) {
	    key = ka[i];

	    if (!deepEqual(a[key], b[key], opts)) {
	      return false;
	    }
	  }

	  return true;
	}

	var deepEqual_1 = deepEqual;

	/**!
	 * @fileOverview Kickass library to create and place poppers near their reference elements.
	 * @version 1.16.1
	 * @license
	 * Copyright (c) 2016 Federico Zivolo and contributors
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining a copy
	 * of this software and associated documentation files (the "Software"), to deal
	 * in the Software without restriction, including without limitation the rights
	 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	 * copies of the Software, and to permit persons to whom the Software is
	 * furnished to do so, subject to the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be included in all
	 * copies or substantial portions of the Software.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	 * SOFTWARE.
	 */
	var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined' && typeof navigator !== 'undefined';

	var timeoutDuration = function () {
	  var longerTimeoutBrowsers = ['Edge', 'Trident', 'Firefox'];

	  for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
	    if (isBrowser && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
	      return 1;
	    }
	  }

	  return 0;
	}();

	function microtaskDebounce(fn) {
	  var called = false;
	  return function () {
	    if (called) {
	      return;
	    }

	    called = true;
	    window.Promise.resolve().then(function () {
	      called = false;
	      fn();
	    });
	  };
	}

	function taskDebounce(fn) {
	  var scheduled = false;
	  return function () {
	    if (!scheduled) {
	      scheduled = true;
	      setTimeout(function () {
	        scheduled = false;
	        fn();
	      }, timeoutDuration);
	    }
	  };
	}

	var supportsMicroTasks = isBrowser && window.Promise;
	/**
	* Create a debounced version of a method, that's asynchronously deferred
	* but called in the minimum time possible.
	*
	* @method
	* @memberof Popper.Utils
	* @argument {Function} fn
	* @returns {Function}
	*/

	var debounce = supportsMicroTasks ? microtaskDebounce : taskDebounce;
	/**
	 * Check if the given variable is a function
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Any} functionToCheck - variable to check
	 * @returns {Boolean} answer to: is a function?
	 */

	function isFunction$1(functionToCheck) {
	  var getType = {};
	  return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
	}
	/**
	 * Get CSS computed property of the given element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Eement} element
	 * @argument {String} property
	 */


	function getStyleComputedProperty(element, property) {
	  if (element.nodeType !== 1) {
	    return [];
	  } // NOTE: 1 DOM access here


	  var window = element.ownerDocument.defaultView;
	  var css = window.getComputedStyle(element, null);
	  return property ? css[property] : css;
	}
	/**
	 * Returns the parentNode or the host of the element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Element} parent
	 */


	function getParentNode(element) {
	  if (element.nodeName === 'HTML') {
	    return element;
	  }

	  return element.parentNode || element.host;
	}
	/**
	 * Returns the scrolling parent of the given element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Element} scroll parent
	 */


	function getScrollParent(element) {
	  // Return body, `getScroll` will take care to get the correct `scrollTop` from it
	  if (!element) {
	    return document.body;
	  }

	  switch (element.nodeName) {
	    case 'HTML':
	    case 'BODY':
	      return element.ownerDocument.body;

	    case '#document':
	      return element.body;
	  } // Firefox want us to check `-x` and `-y` variations as well


	  var _getStyleComputedProp = getStyleComputedProperty(element),
	      overflow = _getStyleComputedProp.overflow,
	      overflowX = _getStyleComputedProp.overflowX,
	      overflowY = _getStyleComputedProp.overflowY;

	  if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
	    return element;
	  }

	  return getScrollParent(getParentNode(element));
	}
	/**
	 * Returns the reference node of the reference object, or the reference object itself.
	 * @method
	 * @memberof Popper.Utils
	 * @param {Element|Object} reference - the reference element (the popper will be relative to this)
	 * @returns {Element} parent
	 */


	function getReferenceNode(reference) {
	  return reference && reference.referenceNode ? reference.referenceNode : reference;
	}

	var isIE11 = isBrowser && !!(window.MSInputMethodContext && document.documentMode);
	var isIE10 = isBrowser && /MSIE 10/.test(navigator.userAgent);
	/**
	 * Determines if the browser is Internet Explorer
	 * @method
	 * @memberof Popper.Utils
	 * @param {Number} version to check
	 * @returns {Boolean} isIE
	 */

	function isIE(version) {
	  if (version === 11) {
	    return isIE11;
	  }

	  if (version === 10) {
	    return isIE10;
	  }

	  return isIE11 || isIE10;
	}
	/**
	 * Returns the offset parent of the given element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Element} offset parent
	 */


	function getOffsetParent(element) {
	  if (!element) {
	    return document.documentElement;
	  }

	  var noOffsetParent = isIE(10) ? document.body : null; // NOTE: 1 DOM access here

	  var offsetParent = element.offsetParent || null; // Skip hidden elements which don't have an offsetParent

	  while (offsetParent === noOffsetParent && element.nextElementSibling) {
	    offsetParent = (element = element.nextElementSibling).offsetParent;
	  }

	  var nodeName = offsetParent && offsetParent.nodeName;

	  if (!nodeName || nodeName === 'BODY' || nodeName === 'HTML') {
	    return element ? element.ownerDocument.documentElement : document.documentElement;
	  } // .offsetParent will return the closest TH, TD or TABLE in case
	  // no offsetParent is present, I hate this job...


	  if (['TH', 'TD', 'TABLE'].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, 'position') === 'static') {
	    return getOffsetParent(offsetParent);
	  }

	  return offsetParent;
	}

	function isOffsetContainer(element) {
	  var nodeName = element.nodeName;

	  if (nodeName === 'BODY') {
	    return false;
	  }

	  return nodeName === 'HTML' || getOffsetParent(element.firstElementChild) === element;
	}
	/**
	 * Finds the root node (document, shadowDOM root) of the given element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} node
	 * @returns {Element} root node
	 */


	function getRoot(node) {
	  if (node.parentNode !== null) {
	    return getRoot(node.parentNode);
	  }

	  return node;
	}
	/**
	 * Finds the offset parent common to the two provided nodes
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element1
	 * @argument {Element} element2
	 * @returns {Element} common offset parent
	 */


	function findCommonOffsetParent(element1, element2) {
	  // This check is needed to avoid errors in case one of the elements isn't defined for any reason
	  if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
	    return document.documentElement;
	  } // Here we make sure to give as "start" the element that comes first in the DOM


	  var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
	  var start = order ? element1 : element2;
	  var end = order ? element2 : element1; // Get common ancestor container

	  var range = document.createRange();
	  range.setStart(start, 0);
	  range.setEnd(end, 0);
	  var commonAncestorContainer = range.commonAncestorContainer; // Both nodes are inside #document

	  if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
	    if (isOffsetContainer(commonAncestorContainer)) {
	      return commonAncestorContainer;
	    }

	    return getOffsetParent(commonAncestorContainer);
	  } // one of the nodes is inside shadowDOM, find which one


	  var element1root = getRoot(element1);

	  if (element1root.host) {
	    return findCommonOffsetParent(element1root.host, element2);
	  } else {
	    return findCommonOffsetParent(element1, getRoot(element2).host);
	  }
	}
	/**
	 * Gets the scroll value of the given element in the given side (top and left)
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @argument {String} side `top` or `left`
	 * @returns {number} amount of scrolled pixels
	 */


	function getScroll(element) {
	  var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top';
	  var upperSide = side === 'top' ? 'scrollTop' : 'scrollLeft';
	  var nodeName = element.nodeName;

	  if (nodeName === 'BODY' || nodeName === 'HTML') {
	    var html = element.ownerDocument.documentElement;
	    var scrollingElement = element.ownerDocument.scrollingElement || html;
	    return scrollingElement[upperSide];
	  }

	  return element[upperSide];
	}
	/*
	 * Sum or subtract the element scroll values (left and top) from a given rect object
	 * @method
	 * @memberof Popper.Utils
	 * @param {Object} rect - Rect object you want to change
	 * @param {HTMLElement} element - The element from the function reads the scroll values
	 * @param {Boolean} subtract - set to true if you want to subtract the scroll values
	 * @return {Object} rect - The modifier rect object
	 */


	function includeScroll(rect, element) {
	  var subtract = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  var scrollTop = getScroll(element, 'top');
	  var scrollLeft = getScroll(element, 'left');
	  var modifier = subtract ? -1 : 1;
	  rect.top += scrollTop * modifier;
	  rect.bottom += scrollTop * modifier;
	  rect.left += scrollLeft * modifier;
	  rect.right += scrollLeft * modifier;
	  return rect;
	}
	/*
	 * Helper to detect borders of a given element
	 * @method
	 * @memberof Popper.Utils
	 * @param {CSSStyleDeclaration} styles
	 * Result of `getStyleComputedProperty` on the given element
	 * @param {String} axis - `x` or `y`
	 * @return {number} borders - The borders size of the given axis
	 */


	function getBordersSize(styles, axis) {
	  var sideA = axis === 'x' ? 'Left' : 'Top';
	  var sideB = sideA === 'Left' ? 'Right' : 'Bottom';
	  return parseFloat(styles['border' + sideA + 'Width']) + parseFloat(styles['border' + sideB + 'Width']);
	}

	function getSize(axis, body, html, computedStyle) {
	  return Math.max(body['offset' + axis], body['scroll' + axis], html['client' + axis], html['offset' + axis], html['scroll' + axis], isIE(10) ? parseInt(html['offset' + axis]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Top' : 'Left')]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Bottom' : 'Right')]) : 0);
	}

	function getWindowSizes(document) {
	  var body = document.body;
	  var html = document.documentElement;
	  var computedStyle = isIE(10) && getComputedStyle(html);
	  return {
	    height: getSize('Height', body, html, computedStyle),
	    width: getSize('Width', body, html, computedStyle)
	  };
	}

	var classCallCheck = function (instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	};

	var createClass = function () {
	  function defineProperties(target, props) {
	    for (var i = 0; i < props.length; i++) {
	      var descriptor = props[i];
	      descriptor.enumerable = descriptor.enumerable || false;
	      descriptor.configurable = true;
	      if ("value" in descriptor) descriptor.writable = true;
	      Object.defineProperty(target, descriptor.key, descriptor);
	    }
	  }

	  return function (Constructor, protoProps, staticProps) {
	    if (protoProps) defineProperties(Constructor.prototype, protoProps);
	    if (staticProps) defineProperties(Constructor, staticProps);
	    return Constructor;
	  };
	}();

	var defineProperty$3 = function (obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	};

	var _extends = Object.assign || function (target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments[i];

	    for (var key in source) {
	      if (Object.prototype.hasOwnProperty.call(source, key)) {
	        target[key] = source[key];
	      }
	    }
	  }

	  return target;
	};
	/**
	 * Given element offsets, generate an output similar to getBoundingClientRect
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Object} offsets
	 * @returns {Object} ClientRect like output
	 */


	function getClientRect(offsets) {
	  return _extends({}, offsets, {
	    right: offsets.left + offsets.width,
	    bottom: offsets.top + offsets.height
	  });
	}
	/**
	 * Get bounding client rect of given element
	 * @method
	 * @memberof Popper.Utils
	 * @param {HTMLElement} element
	 * @return {Object} client rect
	 */


	function getBoundingClientRect(element) {
	  var rect = {}; // IE10 10 FIX: Please, don't ask, the element isn't
	  // considered in DOM in some circumstances...
	  // This isn't reproducible in IE10 compatibility mode of IE11

	  try {
	    if (isIE(10)) {
	      rect = element.getBoundingClientRect();
	      var scrollTop = getScroll(element, 'top');
	      var scrollLeft = getScroll(element, 'left');
	      rect.top += scrollTop;
	      rect.left += scrollLeft;
	      rect.bottom += scrollTop;
	      rect.right += scrollLeft;
	    } else {
	      rect = element.getBoundingClientRect();
	    }
	  } catch (e) {}

	  var result = {
	    left: rect.left,
	    top: rect.top,
	    width: rect.right - rect.left,
	    height: rect.bottom - rect.top
	  }; // subtract scrollbar size from sizes

	  var sizes = element.nodeName === 'HTML' ? getWindowSizes(element.ownerDocument) : {};
	  var width = sizes.width || element.clientWidth || result.width;
	  var height = sizes.height || element.clientHeight || result.height;
	  var horizScrollbar = element.offsetWidth - width;
	  var vertScrollbar = element.offsetHeight - height; // if an hypothetical scrollbar is detected, we must be sure it's not a `border`
	  // we make this check conditional for performance reasons

	  if (horizScrollbar || vertScrollbar) {
	    var styles = getStyleComputedProperty(element);
	    horizScrollbar -= getBordersSize(styles, 'x');
	    vertScrollbar -= getBordersSize(styles, 'y');
	    result.width -= horizScrollbar;
	    result.height -= vertScrollbar;
	  }

	  return getClientRect(result);
	}

	function getOffsetRectRelativeToArbitraryNode(children, parent) {
	  var fixedPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  var isIE10 = isIE(10);
	  var isHTML = parent.nodeName === 'HTML';
	  var childrenRect = getBoundingClientRect(children);
	  var parentRect = getBoundingClientRect(parent);
	  var scrollParent = getScrollParent(children);
	  var styles = getStyleComputedProperty(parent);
	  var borderTopWidth = parseFloat(styles.borderTopWidth);
	  var borderLeftWidth = parseFloat(styles.borderLeftWidth); // In cases where the parent is fixed, we must ignore negative scroll in offset calc

	  if (fixedPosition && isHTML) {
	    parentRect.top = Math.max(parentRect.top, 0);
	    parentRect.left = Math.max(parentRect.left, 0);
	  }

	  var offsets = getClientRect({
	    top: childrenRect.top - parentRect.top - borderTopWidth,
	    left: childrenRect.left - parentRect.left - borderLeftWidth,
	    width: childrenRect.width,
	    height: childrenRect.height
	  });
	  offsets.marginTop = 0;
	  offsets.marginLeft = 0; // Subtract margins of documentElement in case it's being used as parent
	  // we do this only on HTML because it's the only element that behaves
	  // differently when margins are applied to it. The margins are included in
	  // the box of the documentElement, in the other cases not.

	  if (!isIE10 && isHTML) {
	    var marginTop = parseFloat(styles.marginTop);
	    var marginLeft = parseFloat(styles.marginLeft);
	    offsets.top -= borderTopWidth - marginTop;
	    offsets.bottom -= borderTopWidth - marginTop;
	    offsets.left -= borderLeftWidth - marginLeft;
	    offsets.right -= borderLeftWidth - marginLeft; // Attach marginTop and marginLeft because in some circumstances we may need them

	    offsets.marginTop = marginTop;
	    offsets.marginLeft = marginLeft;
	  }

	  if (isIE10 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== 'BODY') {
	    offsets = includeScroll(offsets, parent);
	  }

	  return offsets;
	}

	function getViewportOffsetRectRelativeToArtbitraryNode(element) {
	  var excludeScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	  var html = element.ownerDocument.documentElement;
	  var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
	  var width = Math.max(html.clientWidth, window.innerWidth || 0);
	  var height = Math.max(html.clientHeight, window.innerHeight || 0);
	  var scrollTop = !excludeScroll ? getScroll(html) : 0;
	  var scrollLeft = !excludeScroll ? getScroll(html, 'left') : 0;
	  var offset = {
	    top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
	    left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
	    width: width,
	    height: height
	  };
	  return getClientRect(offset);
	}
	/**
	 * Check if the given element is fixed or is inside a fixed parent
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @argument {Element} customContainer
	 * @returns {Boolean} answer to "isFixed?"
	 */


	function isFixed(element) {
	  var nodeName = element.nodeName;

	  if (nodeName === 'BODY' || nodeName === 'HTML') {
	    return false;
	  }

	  if (getStyleComputedProperty(element, 'position') === 'fixed') {
	    return true;
	  }

	  var parentNode = getParentNode(element);

	  if (!parentNode) {
	    return false;
	  }

	  return isFixed(parentNode);
	}
	/**
	 * Finds the first parent of an element that has a transformed property defined
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Element} first transformed parent or documentElement
	 */


	function getFixedPositionOffsetParent(element) {
	  // This check is needed to avoid errors in case one of the elements isn't defined for any reason
	  if (!element || !element.parentElement || isIE()) {
	    return document.documentElement;
	  }

	  var el = element.parentElement;

	  while (el && getStyleComputedProperty(el, 'transform') === 'none') {
	    el = el.parentElement;
	  }

	  return el || document.documentElement;
	}
	/**
	 * Computed the boundaries limits and return them
	 * @method
	 * @memberof Popper.Utils
	 * @param {HTMLElement} popper
	 * @param {HTMLElement} reference
	 * @param {number} padding
	 * @param {HTMLElement} boundariesElement - Element used to define the boundaries
	 * @param {Boolean} fixedPosition - Is in fixed position mode
	 * @returns {Object} Coordinates of the boundaries
	 */


	function getBoundaries(popper, reference, padding, boundariesElement) {
	  var fixedPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false; // NOTE: 1 DOM access here

	  var boundaries = {
	    top: 0,
	    left: 0
	  };
	  var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference)); // Handle viewport case

	  if (boundariesElement === 'viewport') {
	    boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
	  } else {
	    // Handle other cases based on DOM element used as boundaries
	    var boundariesNode = void 0;

	    if (boundariesElement === 'scrollParent') {
	      boundariesNode = getScrollParent(getParentNode(reference));

	      if (boundariesNode.nodeName === 'BODY') {
	        boundariesNode = popper.ownerDocument.documentElement;
	      }
	    } else if (boundariesElement === 'window') {
	      boundariesNode = popper.ownerDocument.documentElement;
	    } else {
	      boundariesNode = boundariesElement;
	    }

	    var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition); // In case of HTML, we need a different computation

	    if (boundariesNode.nodeName === 'HTML' && !isFixed(offsetParent)) {
	      var _getWindowSizes = getWindowSizes(popper.ownerDocument),
	          height = _getWindowSizes.height,
	          width = _getWindowSizes.width;

	      boundaries.top += offsets.top - offsets.marginTop;
	      boundaries.bottom = height + offsets.top;
	      boundaries.left += offsets.left - offsets.marginLeft;
	      boundaries.right = width + offsets.left;
	    } else {
	      // for all the other DOM elements, this one is good
	      boundaries = offsets;
	    }
	  } // Add paddings


	  padding = padding || 0;
	  var isPaddingNumber = typeof padding === 'number';
	  boundaries.left += isPaddingNumber ? padding : padding.left || 0;
	  boundaries.top += isPaddingNumber ? padding : padding.top || 0;
	  boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
	  boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;
	  return boundaries;
	}

	function getArea(_ref) {
	  var width = _ref.width,
	      height = _ref.height;
	  return width * height;
	}
	/**
	 * Utility used to transform the `auto` placement to the placement with more
	 * available space.
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
	  var padding = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;

	  if (placement.indexOf('auto') === -1) {
	    return placement;
	  }

	  var boundaries = getBoundaries(popper, reference, padding, boundariesElement);
	  var rects = {
	    top: {
	      width: boundaries.width,
	      height: refRect.top - boundaries.top
	    },
	    right: {
	      width: boundaries.right - refRect.right,
	      height: boundaries.height
	    },
	    bottom: {
	      width: boundaries.width,
	      height: boundaries.bottom - refRect.bottom
	    },
	    left: {
	      width: refRect.left - boundaries.left,
	      height: boundaries.height
	    }
	  };
	  var sortedAreas = Object.keys(rects).map(function (key) {
	    return _extends({
	      key: key
	    }, rects[key], {
	      area: getArea(rects[key])
	    });
	  }).sort(function (a, b) {
	    return b.area - a.area;
	  });
	  var filteredAreas = sortedAreas.filter(function (_ref2) {
	    var width = _ref2.width,
	        height = _ref2.height;
	    return width >= popper.clientWidth && height >= popper.clientHeight;
	  });
	  var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;
	  var variation = placement.split('-')[1];
	  return computedPlacement + (variation ? '-' + variation : '');
	}
	/**
	 * Get offsets to the reference element
	 * @method
	 * @memberof Popper.Utils
	 * @param {Object} state
	 * @param {Element} popper - the popper element
	 * @param {Element} reference - the reference element (the popper will be relative to this)
	 * @param {Element} fixedPosition - is in fixed position mode
	 * @returns {Object} An object containing the offsets which will be applied to the popper
	 */


	function getReferenceOffsets(state, popper, reference) {
	  var fixedPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
	  var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference));
	  return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
	}
	/**
	 * Get the outer sizes of the given element (offset size + margins)
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Object} object containing width and height properties
	 */


	function getOuterSizes(element) {
	  var window = element.ownerDocument.defaultView;
	  var styles = window.getComputedStyle(element);
	  var x = parseFloat(styles.marginTop || 0) + parseFloat(styles.marginBottom || 0);
	  var y = parseFloat(styles.marginLeft || 0) + parseFloat(styles.marginRight || 0);
	  var result = {
	    width: element.offsetWidth + y,
	    height: element.offsetHeight + x
	  };
	  return result;
	}
	/**
	 * Get the opposite placement of the given one
	 * @method
	 * @memberof Popper.Utils
	 * @argument {String} placement
	 * @returns {String} flipped placement
	 */


	function getOppositePlacement(placement) {
	  var hash = {
	    left: 'right',
	    right: 'left',
	    bottom: 'top',
	    top: 'bottom'
	  };
	  return placement.replace(/left|right|bottom|top/g, function (matched) {
	    return hash[matched];
	  });
	}
	/**
	 * Get offsets to the popper
	 * @method
	 * @memberof Popper.Utils
	 * @param {Object} position - CSS position the Popper will get applied
	 * @param {HTMLElement} popper - the popper element
	 * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
	 * @param {String} placement - one of the valid placement options
	 * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
	 */


	function getPopperOffsets(popper, referenceOffsets, placement) {
	  placement = placement.split('-')[0]; // Get popper node sizes

	  var popperRect = getOuterSizes(popper); // Add position, width and height to our offsets object

	  var popperOffsets = {
	    width: popperRect.width,
	    height: popperRect.height
	  }; // depending by the popper placement we have to compute its offsets slightly differently

	  var isHoriz = ['right', 'left'].indexOf(placement) !== -1;
	  var mainSide = isHoriz ? 'top' : 'left';
	  var secondarySide = isHoriz ? 'left' : 'top';
	  var measurement = isHoriz ? 'height' : 'width';
	  var secondaryMeasurement = !isHoriz ? 'height' : 'width';
	  popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;

	  if (placement === secondarySide) {
	    popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
	  } else {
	    popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
	  }

	  return popperOffsets;
	}
	/**
	 * Mimics the `find` method of Array
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Array} arr
	 * @argument prop
	 * @argument value
	 * @returns index or -1
	 */


	function find(arr, check) {
	  // use native find if supported
	  if (Array.prototype.find) {
	    return arr.find(check);
	  } // use `filter` to obtain the same behavior of `find`


	  return arr.filter(check)[0];
	}
	/**
	 * Return the index of the matching object
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Array} arr
	 * @argument prop
	 * @argument value
	 * @returns index or -1
	 */


	function findIndex$1(arr, prop, value) {
	  // use native findIndex if supported
	  if (Array.prototype.findIndex) {
	    return arr.findIndex(function (cur) {
	      return cur[prop] === value;
	    });
	  } // use `find` + `indexOf` if `findIndex` isn't supported


	  var match = find(arr, function (obj) {
	    return obj[prop] === value;
	  });
	  return arr.indexOf(match);
	}
	/**
	 * Loop trough the list of modifiers and run them in order,
	 * each of them will then edit the data object.
	 * @method
	 * @memberof Popper.Utils
	 * @param {dataObject} data
	 * @param {Array} modifiers
	 * @param {String} ends - Optional modifier name used as stopper
	 * @returns {dataObject}
	 */


	function runModifiers(modifiers, data, ends) {
	  var modifiersToRun = ends === undefined ? modifiers : modifiers.slice(0, findIndex$1(modifiers, 'name', ends));
	  modifiersToRun.forEach(function (modifier) {
	    if (modifier['function']) {
	      // eslint-disable-line dot-notation
	      console.warn('`modifier.function` is deprecated, use `modifier.fn`!');
	    }

	    var fn = modifier['function'] || modifier.fn; // eslint-disable-line dot-notation

	    if (modifier.enabled && isFunction$1(fn)) {
	      // Add properties to offsets to make them a complete clientRect object
	      // we do this before each modifier to make sure the previous one doesn't
	      // mess with these values
	      data.offsets.popper = getClientRect(data.offsets.popper);
	      data.offsets.reference = getClientRect(data.offsets.reference);
	      data = fn(data, modifier);
	    }
	  });
	  return data;
	}
	/**
	 * Updates the position of the popper, computing the new offsets and applying
	 * the new style.<br />
	 * Prefer `scheduleUpdate` over `update` because of performance reasons.
	 * @method
	 * @memberof Popper
	 */


	function update() {
	  // if popper is destroyed, don't perform any further update
	  if (this.state.isDestroyed) {
	    return;
	  }

	  var data = {
	    instance: this,
	    styles: {},
	    arrowStyles: {},
	    attributes: {},
	    flipped: false,
	    offsets: {}
	  }; // compute reference element offsets

	  data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed); // compute auto placement, store placement inside the data object,
	  // modifiers will be able to edit `placement` if needed
	  // and refer to originalPlacement to know the original value

	  data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding); // store the computed placement inside `originalPlacement`

	  data.originalPlacement = data.placement;
	  data.positionFixed = this.options.positionFixed; // compute the popper offsets

	  data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);
	  data.offsets.popper.position = this.options.positionFixed ? 'fixed' : 'absolute'; // run the modifiers

	  data = runModifiers(this.modifiers, data); // the first `update` will call `onCreate` callback
	  // the other ones will call `onUpdate` callback

	  if (!this.state.isCreated) {
	    this.state.isCreated = true;
	    this.options.onCreate(data);
	  } else {
	    this.options.onUpdate(data);
	  }
	}
	/**
	 * Helper used to know if the given modifier is enabled.
	 * @method
	 * @memberof Popper.Utils
	 * @returns {Boolean}
	 */


	function isModifierEnabled(modifiers, modifierName) {
	  return modifiers.some(function (_ref) {
	    var name = _ref.name,
	        enabled = _ref.enabled;
	    return enabled && name === modifierName;
	  });
	}
	/**
	 * Get the prefixed supported property name
	 * @method
	 * @memberof Popper.Utils
	 * @argument {String} property (camelCase)
	 * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
	 */


	function getSupportedPropertyName(property) {
	  var prefixes = [false, 'ms', 'Webkit', 'Moz', 'O'];
	  var upperProp = property.charAt(0).toUpperCase() + property.slice(1);

	  for (var i = 0; i < prefixes.length; i++) {
	    var prefix = prefixes[i];
	    var toCheck = prefix ? '' + prefix + upperProp : property;

	    if (typeof document.body.style[toCheck] !== 'undefined') {
	      return toCheck;
	    }
	  }

	  return null;
	}
	/**
	 * Destroys the popper.
	 * @method
	 * @memberof Popper
	 */


	function destroy() {
	  this.state.isDestroyed = true; // touch DOM only if `applyStyle` modifier is enabled

	  if (isModifierEnabled(this.modifiers, 'applyStyle')) {
	    this.popper.removeAttribute('x-placement');
	    this.popper.style.position = '';
	    this.popper.style.top = '';
	    this.popper.style.left = '';
	    this.popper.style.right = '';
	    this.popper.style.bottom = '';
	    this.popper.style.willChange = '';
	    this.popper.style[getSupportedPropertyName('transform')] = '';
	  }

	  this.disableEventListeners(); // remove the popper if user explicitly asked for the deletion on destroy
	  // do not use `remove` because IE11 doesn't support it

	  if (this.options.removeOnDestroy) {
	    this.popper.parentNode.removeChild(this.popper);
	  }

	  return this;
	}
	/**
	 * Get the window associated with the element
	 * @argument {Element} element
	 * @returns {Window}
	 */


	function getWindow(element) {
	  var ownerDocument = element.ownerDocument;
	  return ownerDocument ? ownerDocument.defaultView : window;
	}

	function attachToScrollParents(scrollParent, event, callback, scrollParents) {
	  var isBody = scrollParent.nodeName === 'BODY';
	  var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
	  target.addEventListener(event, callback, {
	    passive: true
	  });

	  if (!isBody) {
	    attachToScrollParents(getScrollParent(target.parentNode), event, callback, scrollParents);
	  }

	  scrollParents.push(target);
	}
	/**
	 * Setup needed event listeners used to update the popper position
	 * @method
	 * @memberof Popper.Utils
	 * @private
	 */


	function setupEventListeners(reference, options, state, updateBound) {
	  // Resize event listener on window
	  state.updateBound = updateBound;
	  getWindow(reference).addEventListener('resize', state.updateBound, {
	    passive: true
	  }); // Scroll event listener on scroll parents

	  var scrollElement = getScrollParent(reference);
	  attachToScrollParents(scrollElement, 'scroll', state.updateBound, state.scrollParents);
	  state.scrollElement = scrollElement;
	  state.eventsEnabled = true;
	  return state;
	}
	/**
	 * It will add resize/scroll events and start recalculating
	 * position of the popper element when they are triggered.
	 * @method
	 * @memberof Popper
	 */


	function enableEventListeners() {
	  if (!this.state.eventsEnabled) {
	    this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
	  }
	}
	/**
	 * Remove event listeners used to update the popper position
	 * @method
	 * @memberof Popper.Utils
	 * @private
	 */


	function removeEventListeners(reference, state) {
	  // Remove resize event listener on window
	  getWindow(reference).removeEventListener('resize', state.updateBound); // Remove scroll event listener on scroll parents

	  state.scrollParents.forEach(function (target) {
	    target.removeEventListener('scroll', state.updateBound);
	  }); // Reset state

	  state.updateBound = null;
	  state.scrollParents = [];
	  state.scrollElement = null;
	  state.eventsEnabled = false;
	  return state;
	}
	/**
	 * It will remove resize/scroll events and won't recalculate popper position
	 * when they are triggered. It also won't trigger `onUpdate` callback anymore,
	 * unless you call `update` method manually.
	 * @method
	 * @memberof Popper
	 */


	function disableEventListeners() {
	  if (this.state.eventsEnabled) {
	    cancelAnimationFrame(this.scheduleUpdate);
	    this.state = removeEventListeners(this.reference, this.state);
	  }
	}
	/**
	 * Tells if a given input is a number
	 * @method
	 * @memberof Popper.Utils
	 * @param {*} input to check
	 * @return {Boolean}
	 */


	function isNumeric(n) {
	  return n !== '' && !isNaN(parseFloat(n)) && isFinite(n);
	}
	/**
	 * Set the style to the given popper
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element - Element to apply the style to
	 * @argument {Object} styles
	 * Object with a list of properties and values which will be applied to the element
	 */


	function setStyles(element, styles) {
	  Object.keys(styles).forEach(function (prop) {
	    var unit = ''; // add unit if the value is numeric and is one of the following

	    if (['width', 'height', 'top', 'right', 'bottom', 'left'].indexOf(prop) !== -1 && isNumeric(styles[prop])) {
	      unit = 'px';
	    }

	    element.style[prop] = styles[prop] + unit;
	  });
	}
	/**
	 * Set the attributes to the given popper
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element - Element to apply the attributes to
	 * @argument {Object} styles
	 * Object with a list of properties and values which will be applied to the element
	 */


	function setAttributes(element, attributes) {
	  Object.keys(attributes).forEach(function (prop) {
	    var value = attributes[prop];

	    if (value !== false) {
	      element.setAttribute(prop, attributes[prop]);
	    } else {
	      element.removeAttribute(prop);
	    }
	  });
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} data.styles - List of style properties - values to apply to popper element
	 * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The same data object
	 */


	function applyStyle(data) {
	  // any property present in `data.styles` will be applied to the popper,
	  // in this way we can make the 3rd party modifiers add custom styles to it
	  // Be aware, modifiers could override the properties defined in the previous
	  // lines of this modifier!
	  setStyles(data.instance.popper, data.styles); // any property present in `data.attributes` will be applied to the popper,
	  // they will be set as HTML attributes of the element

	  setAttributes(data.instance.popper, data.attributes); // if arrowElement is defined and arrowStyles has some properties

	  if (data.arrowElement && Object.keys(data.arrowStyles).length) {
	    setStyles(data.arrowElement, data.arrowStyles);
	  }

	  return data;
	}
	/**
	 * Set the x-placement attribute before everything else because it could be used
	 * to add margins to the popper margins needs to be calculated to get the
	 * correct popper offsets.
	 * @method
	 * @memberof Popper.modifiers
	 * @param {HTMLElement} reference - The reference element used to position the popper
	 * @param {HTMLElement} popper - The HTML element used as popper
	 * @param {Object} options - Popper.js options
	 */


	function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
	  // compute reference element offsets
	  var referenceOffsets = getReferenceOffsets(state, popper, reference, options.positionFixed); // compute auto placement, store placement inside the data object,
	  // modifiers will be able to edit `placement` if needed
	  // and refer to originalPlacement to know the original value

	  var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);
	  popper.setAttribute('x-placement', placement); // Apply `position` to popper before anything else because
	  // without the position applied we can't guarantee correct computations

	  setStyles(popper, {
	    position: options.positionFixed ? 'fixed' : 'absolute'
	  });
	  return options;
	}
	/**
	 * @function
	 * @memberof Popper.Utils
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Boolean} shouldRound - If the offsets should be rounded at all
	 * @returns {Object} The popper's position offsets rounded
	 *
	 * The tale of pixel-perfect positioning. It's still not 100% perfect, but as
	 * good as it can be within reason.
	 * Discussion here: https://github.com/FezVrasta/popper.js/pull/715
	 *
	 * Low DPI screens cause a popper to be blurry if not using full pixels (Safari
	 * as well on High DPI screens).
	 *
	 * Firefox prefers no rounding for positioning and does not have blurriness on
	 * high DPI screens.
	 *
	 * Only horizontal placement and left/right values need to be considered.
	 */


	function getRoundedOffsets(data, shouldRound) {
	  var _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var round = Math.round,
	      floor = Math.floor;

	  var noRound = function noRound(v) {
	    return v;
	  };

	  var referenceWidth = round(reference.width);
	  var popperWidth = round(popper.width);
	  var isVertical = ['left', 'right'].indexOf(data.placement) !== -1;
	  var isVariation = data.placement.indexOf('-') !== -1;
	  var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
	  var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;
	  var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthParity ? round : floor;
	  var verticalToInteger = !shouldRound ? noRound : round;
	  return {
	    left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper.left - 1 : popper.left),
	    top: verticalToInteger(popper.top),
	    bottom: verticalToInteger(popper.bottom),
	    right: horizontalToInteger(popper.right)
	  };
	}

	var isFirefox = isBrowser && /Firefox/i.test(navigator.userAgent);
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */

	function computeStyle(data, options) {
	  var x = options.x,
	      y = options.y;
	  var popper = data.offsets.popper; // Remove this legacy support in Popper.js v2

	  var legacyGpuAccelerationOption = find(data.instance.modifiers, function (modifier) {
	    return modifier.name === 'applyStyle';
	  }).gpuAcceleration;

	  if (legacyGpuAccelerationOption !== undefined) {
	    console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');
	  }

	  var gpuAcceleration = legacyGpuAccelerationOption !== undefined ? legacyGpuAccelerationOption : options.gpuAcceleration;
	  var offsetParent = getOffsetParent(data.instance.popper);
	  var offsetParentRect = getBoundingClientRect(offsetParent); // Styles

	  var styles = {
	    position: popper.position
	  };
	  var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);
	  var sideA = x === 'bottom' ? 'top' : 'bottom';
	  var sideB = y === 'right' ? 'left' : 'right'; // if gpuAcceleration is set to `true` and transform is supported,
	  //  we use `translate3d` to apply the position to the popper we
	  // automatically use the supported prefixed version if needed

	  var prefixedProperty = getSupportedPropertyName('transform'); // now, let's make a step back and look at this code closely (wtf?)
	  // If the content of the popper grows once it's been positioned, it
	  // may happen that the popper gets misplaced because of the new content
	  // overflowing its reference element
	  // To avoid this problem, we provide two options (x and y), which allow
	  // the consumer to define the offset origin.
	  // If we position a popper on top of a reference element, we can set
	  // `x` to `top` to make the popper grow towards its top instead of
	  // its bottom.

	  var left = void 0,
	      top = void 0;

	  if (sideA === 'bottom') {
	    // when offsetParent is <html> the positioning is relative to the bottom of the screen (excluding the scrollbar)
	    // and not the bottom of the html element
	    if (offsetParent.nodeName === 'HTML') {
	      top = -offsetParent.clientHeight + offsets.bottom;
	    } else {
	      top = -offsetParentRect.height + offsets.bottom;
	    }
	  } else {
	    top = offsets.top;
	  }

	  if (sideB === 'right') {
	    if (offsetParent.nodeName === 'HTML') {
	      left = -offsetParent.clientWidth + offsets.right;
	    } else {
	      left = -offsetParentRect.width + offsets.right;
	    }
	  } else {
	    left = offsets.left;
	  }

	  if (gpuAcceleration && prefixedProperty) {
	    styles[prefixedProperty] = 'translate3d(' + left + 'px, ' + top + 'px, 0)';
	    styles[sideA] = 0;
	    styles[sideB] = 0;
	    styles.willChange = 'transform';
	  } else {
	    // othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
	    var invertTop = sideA === 'bottom' ? -1 : 1;
	    var invertLeft = sideB === 'right' ? -1 : 1;
	    styles[sideA] = top * invertTop;
	    styles[sideB] = left * invertLeft;
	    styles.willChange = sideA + ', ' + sideB;
	  } // Attributes


	  var attributes = {
	    'x-placement': data.placement
	  }; // Update `data` attributes, styles and arrowStyles

	  data.attributes = _extends({}, attributes, data.attributes);
	  data.styles = _extends({}, styles, data.styles);
	  data.arrowStyles = _extends({}, data.offsets.arrow, data.arrowStyles);
	  return data;
	}
	/**
	 * Helper used to know if the given modifier depends from another one.<br />
	 * It checks if the needed modifier is listed and enabled.
	 * @method
	 * @memberof Popper.Utils
	 * @param {Array} modifiers - list of modifiers
	 * @param {String} requestingName - name of requesting modifier
	 * @param {String} requestedName - name of requested modifier
	 * @returns {Boolean}
	 */


	function isModifierRequired(modifiers, requestingName, requestedName) {
	  var requesting = find(modifiers, function (_ref) {
	    var name = _ref.name;
	    return name === requestingName;
	  });
	  var isRequired = !!requesting && modifiers.some(function (modifier) {
	    return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
	  });

	  if (!isRequired) {
	    var _requesting = '`' + requestingName + '`';

	    var requested = '`' + requestedName + '`';
	    console.warn(requested + ' modifier is required by ' + _requesting + ' modifier in order to work, be sure to include it before ' + _requesting + '!');
	  }

	  return isRequired;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function arrow(data, options) {
	  var _data$offsets$arrow; // arrow depends on keepTogether in order to work


	  if (!isModifierRequired(data.instance.modifiers, 'arrow', 'keepTogether')) {
	    return data;
	  }

	  var arrowElement = options.element; // if arrowElement is a string, suppose it's a CSS selector

	  if (typeof arrowElement === 'string') {
	    arrowElement = data.instance.popper.querySelector(arrowElement); // if arrowElement is not found, don't run the modifier

	    if (!arrowElement) {
	      return data;
	    }
	  } else {
	    // if the arrowElement isn't a query selector we must check that the
	    // provided DOM node is child of its popper node
	    if (!data.instance.popper.contains(arrowElement)) {
	      console.warn('WARNING: `arrow.element` must be child of its popper element!');
	      return data;
	    }
	  }

	  var placement = data.placement.split('-')[0];
	  var _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var isVertical = ['left', 'right'].indexOf(placement) !== -1;
	  var len = isVertical ? 'height' : 'width';
	  var sideCapitalized = isVertical ? 'Top' : 'Left';
	  var side = sideCapitalized.toLowerCase();
	  var altSide = isVertical ? 'left' : 'top';
	  var opSide = isVertical ? 'bottom' : 'right';
	  var arrowElementSize = getOuterSizes(arrowElement)[len]; //
	  // extends keepTogether behavior making sure the popper and its
	  // reference have enough pixels in conjunction
	  //
	  // top/left side

	  if (reference[opSide] - arrowElementSize < popper[side]) {
	    data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
	  } // bottom/right side


	  if (reference[side] + arrowElementSize > popper[opSide]) {
	    data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
	  }

	  data.offsets.popper = getClientRect(data.offsets.popper); // compute center of the popper

	  var center = reference[side] + reference[len] / 2 - arrowElementSize / 2; // Compute the sideValue using the updated popper offsets
	  // take popper margin in account because we don't have this info available

	  var css = getStyleComputedProperty(data.instance.popper);
	  var popperMarginSide = parseFloat(css['margin' + sideCapitalized]);
	  var popperBorderSide = parseFloat(css['border' + sideCapitalized + 'Width']);
	  var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide; // prevent arrowElement from being placed not contiguously to its popper

	  sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);
	  data.arrowElement = arrowElement;
	  data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty$3(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty$3(_data$offsets$arrow, altSide, ''), _data$offsets$arrow);
	  return data;
	}
	/**
	 * Get the opposite placement variation of the given one
	 * @method
	 * @memberof Popper.Utils
	 * @argument {String} placement variation
	 * @returns {String} flipped placement variation
	 */


	function getOppositeVariation(variation) {
	  if (variation === 'end') {
	    return 'start';
	  } else if (variation === 'start') {
	    return 'end';
	  }

	  return variation;
	}
	/**
	 * List of accepted placements to use as values of the `placement` option.<br />
	 * Valid placements are:
	 * - `auto`
	 * - `top`
	 * - `right`
	 * - `bottom`
	 * - `left`
	 *
	 * Each placement can have a variation from this list:
	 * - `-start`
	 * - `-end`
	 *
	 * Variations are interpreted easily if you think of them as the left to right
	 * written languages. Horizontally (`top` and `bottom`), `start` is left and `end`
	 * is right.<br />
	 * Vertically (`left` and `right`), `start` is top and `end` is bottom.
	 *
	 * Some valid examples are:
	 * - `top-end` (on top of reference, right aligned)
	 * - `right-start` (on right of reference, top aligned)
	 * - `bottom` (on bottom, centered)
	 * - `auto-end` (on the side with more space available, alignment depends by placement)
	 *
	 * @static
	 * @type {Array}
	 * @enum {String}
	 * @readonly
	 * @method placements
	 * @memberof Popper
	 */


	var placements = ['auto-start', 'auto', 'auto-end', 'top-start', 'top', 'top-end', 'right-start', 'right', 'right-end', 'bottom-end', 'bottom', 'bottom-start', 'left-end', 'left', 'left-start']; // Get rid of `auto` `auto-start` and `auto-end`

	var validPlacements = placements.slice(3);
	/**
	 * Given an initial placement, returns all the subsequent placements
	 * clockwise (or counter-clockwise).
	 *
	 * @method
	 * @memberof Popper.Utils
	 * @argument {String} placement - A valid placement (it accepts variations)
	 * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
	 * @returns {Array} placements including their variations
	 */

	function clockwise(placement) {
	  var counter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	  var index = validPlacements.indexOf(placement);
	  var arr = validPlacements.slice(index + 1).concat(validPlacements.slice(0, index));
	  return counter ? arr.reverse() : arr;
	}

	var BEHAVIORS = {
	  FLIP: 'flip',
	  CLOCKWISE: 'clockwise',
	  COUNTERCLOCKWISE: 'counterclockwise'
	};
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */

	function flip(data, options) {
	  // if `inner` modifier is enabled, we can't use the `flip` modifier
	  if (isModifierEnabled(data.instance.modifiers, 'inner')) {
	    return data;
	  }

	  if (data.flipped && data.placement === data.originalPlacement) {
	    // seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
	    return data;
	  }

	  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);
	  var placement = data.placement.split('-')[0];
	  var placementOpposite = getOppositePlacement(placement);
	  var variation = data.placement.split('-')[1] || '';
	  var flipOrder = [];

	  switch (options.behavior) {
	    case BEHAVIORS.FLIP:
	      flipOrder = [placement, placementOpposite];
	      break;

	    case BEHAVIORS.CLOCKWISE:
	      flipOrder = clockwise(placement);
	      break;

	    case BEHAVIORS.COUNTERCLOCKWISE:
	      flipOrder = clockwise(placement, true);
	      break;

	    default:
	      flipOrder = options.behavior;
	  }

	  flipOrder.forEach(function (step, index) {
	    if (placement !== step || flipOrder.length === index + 1) {
	      return data;
	    }

	    placement = data.placement.split('-')[0];
	    placementOpposite = getOppositePlacement(placement);
	    var popperOffsets = data.offsets.popper;
	    var refOffsets = data.offsets.reference; // using floor because the reference offsets may contain decimals we are not going to consider here

	    var floor = Math.floor;
	    var overlapsRef = placement === 'left' && floor(popperOffsets.right) > floor(refOffsets.left) || placement === 'right' && floor(popperOffsets.left) < floor(refOffsets.right) || placement === 'top' && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === 'bottom' && floor(popperOffsets.top) < floor(refOffsets.bottom);
	    var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
	    var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
	    var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
	    var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);
	    var overflowsBoundaries = placement === 'left' && overflowsLeft || placement === 'right' && overflowsRight || placement === 'top' && overflowsTop || placement === 'bottom' && overflowsBottom; // flip the variation if required

	    var isVertical = ['top', 'bottom'].indexOf(placement) !== -1; // flips variation if reference element overflows boundaries

	    var flippedVariationByRef = !!options.flipVariations && (isVertical && variation === 'start' && overflowsLeft || isVertical && variation === 'end' && overflowsRight || !isVertical && variation === 'start' && overflowsTop || !isVertical && variation === 'end' && overflowsBottom); // flips variation if popper content overflows boundaries

	    var flippedVariationByContent = !!options.flipVariationsByContent && (isVertical && variation === 'start' && overflowsRight || isVertical && variation === 'end' && overflowsLeft || !isVertical && variation === 'start' && overflowsBottom || !isVertical && variation === 'end' && overflowsTop);
	    var flippedVariation = flippedVariationByRef || flippedVariationByContent;

	    if (overlapsRef || overflowsBoundaries || flippedVariation) {
	      // this boolean to detect any flip loop
	      data.flipped = true;

	      if (overlapsRef || overflowsBoundaries) {
	        placement = flipOrder[index + 1];
	      }

	      if (flippedVariation) {
	        variation = getOppositeVariation(variation);
	      }

	      data.placement = placement + (variation ? '-' + variation : ''); // this object contains `position`, we want to preserve it along with
	      // any additional property we may add in the future

	      data.offsets.popper = _extends({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));
	      data = runModifiers(data.instance.modifiers, data, 'flip');
	    }
	  });
	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function keepTogether(data) {
	  var _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var placement = data.placement.split('-')[0];
	  var floor = Math.floor;
	  var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
	  var side = isVertical ? 'right' : 'bottom';
	  var opSide = isVertical ? 'left' : 'top';
	  var measurement = isVertical ? 'width' : 'height';

	  if (popper[side] < floor(reference[opSide])) {
	    data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
	  }

	  if (popper[opSide] > floor(reference[side])) {
	    data.offsets.popper[opSide] = floor(reference[side]);
	  }

	  return data;
	}
	/**
	 * Converts a string containing value + unit into a px value number
	 * @function
	 * @memberof {modifiers~offset}
	 * @private
	 * @argument {String} str - Value + unit string
	 * @argument {String} measurement - `height` or `width`
	 * @argument {Object} popperOffsets
	 * @argument {Object} referenceOffsets
	 * @returns {Number|String}
	 * Value in pixels, or original string if no values were extracted
	 */


	function toValue(str, measurement, popperOffsets, referenceOffsets) {
	  // separate value from unit
	  var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
	  var value = +split[1];
	  var unit = split[2]; // If it's not a number it's an operator, I guess

	  if (!value) {
	    return str;
	  }

	  if (unit.indexOf('%') === 0) {
	    var element = void 0;

	    switch (unit) {
	      case '%p':
	        element = popperOffsets;
	        break;

	      case '%':
	      case '%r':
	      default:
	        element = referenceOffsets;
	    }

	    var rect = getClientRect(element);
	    return rect[measurement] / 100 * value;
	  } else if (unit === 'vh' || unit === 'vw') {
	    // if is a vh or vw, we calculate the size based on the viewport
	    var size = void 0;

	    if (unit === 'vh') {
	      size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
	    } else {
	      size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
	    }

	    return size / 100 * value;
	  } else {
	    // if is an explicit pixel unit, we get rid of the unit and keep the value
	    // if is an implicit unit, it's px, and we return just the value
	    return value;
	  }
	}
	/**
	 * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
	 * @function
	 * @memberof {modifiers~offset}
	 * @private
	 * @argument {String} offset
	 * @argument {Object} popperOffsets
	 * @argument {Object} referenceOffsets
	 * @argument {String} basePlacement
	 * @returns {Array} a two cells array with x and y offsets in numbers
	 */


	function parseOffset(offset, popperOffsets, referenceOffsets, basePlacement) {
	  var offsets = [0, 0]; // Use height if placement is left or right and index is 0 otherwise use width
	  // in this way the first offset will use an axis and the second one
	  // will use the other one

	  var useHeight = ['right', 'left'].indexOf(basePlacement) !== -1; // Split the offset string to obtain a list of values and operands
	  // The regex addresses values with the plus or minus sign in front (+10, -20, etc)

	  var fragments = offset.split(/(\+|\-)/).map(function (frag) {
	    return frag.trim();
	  }); // Detect if the offset string contains a pair of values or a single one
	  // they could be separated by comma or space

	  var divider = fragments.indexOf(find(fragments, function (frag) {
	    return frag.search(/,|\s/) !== -1;
	  }));

	  if (fragments[divider] && fragments[divider].indexOf(',') === -1) {
	    console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');
	  } // If divider is found, we divide the list of values and operands to divide
	  // them by ofset X and Y.


	  var splitRegex = /\s*,\s*|\s+/;
	  var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments]; // Convert the values with units to absolute pixels to allow our computations

	  ops = ops.map(function (op, index) {
	    // Most of the units rely on the orientation of the popper
	    var measurement = (index === 1 ? !useHeight : useHeight) ? 'height' : 'width';
	    var mergeWithPrevious = false;
	    return op // This aggregates any `+` or `-` sign that aren't considered operators
	    // e.g.: 10 + +5 => [10, +, +5]
	    .reduce(function (a, b) {
	      if (a[a.length - 1] === '' && ['+', '-'].indexOf(b) !== -1) {
	        a[a.length - 1] = b;
	        mergeWithPrevious = true;
	        return a;
	      } else if (mergeWithPrevious) {
	        a[a.length - 1] += b;
	        mergeWithPrevious = false;
	        return a;
	      } else {
	        return a.concat(b);
	      }
	    }, []) // Here we convert the string values into number values (in px)
	    .map(function (str) {
	      return toValue(str, measurement, popperOffsets, referenceOffsets);
	    });
	  }); // Loop trough the offsets arrays and execute the operations

	  ops.forEach(function (op, index) {
	    op.forEach(function (frag, index2) {
	      if (isNumeric(frag)) {
	        offsets[index] += frag * (op[index2 - 1] === '-' ? -1 : 1);
	      }
	    });
	  });
	  return offsets;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @argument {Number|String} options.offset=0
	 * The offset value as described in the modifier description
	 * @returns {Object} The data object, properly modified
	 */


	function offset(data, _ref) {
	  var offset = _ref.offset;
	  var placement = data.placement,
	      _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var basePlacement = placement.split('-')[0];
	  var offsets = void 0;

	  if (isNumeric(+offset)) {
	    offsets = [+offset, 0];
	  } else {
	    offsets = parseOffset(offset, popper, reference, basePlacement);
	  }

	  if (basePlacement === 'left') {
	    popper.top += offsets[0];
	    popper.left -= offsets[1];
	  } else if (basePlacement === 'right') {
	    popper.top += offsets[0];
	    popper.left += offsets[1];
	  } else if (basePlacement === 'top') {
	    popper.left += offsets[0];
	    popper.top -= offsets[1];
	  } else if (basePlacement === 'bottom') {
	    popper.left += offsets[0];
	    popper.top += offsets[1];
	  }

	  data.popper = popper;
	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function preventOverflow(data, options) {
	  var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper); // If offsetParent is the reference element, we really want to
	  // go one step up and use the next offsetParent as reference to
	  // avoid to make this modifier completely useless and look like broken

	  if (data.instance.reference === boundariesElement) {
	    boundariesElement = getOffsetParent(boundariesElement);
	  } // NOTE: DOM access here
	  // resets the popper's position so that the document size can be calculated excluding
	  // the size of the popper element itself


	  var transformProp = getSupportedPropertyName('transform');
	  var popperStyles = data.instance.popper.style; // assignment to help minification

	  var top = popperStyles.top,
	      left = popperStyles.left,
	      transform = popperStyles[transformProp];
	  popperStyles.top = '';
	  popperStyles.left = '';
	  popperStyles[transformProp] = '';
	  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed); // NOTE: DOM access here
	  // restores the original style properties after the offsets have been computed

	  popperStyles.top = top;
	  popperStyles.left = left;
	  popperStyles[transformProp] = transform;
	  options.boundaries = boundaries;
	  var order = options.priority;
	  var popper = data.offsets.popper;
	  var check = {
	    primary: function primary(placement) {
	      var value = popper[placement];

	      if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
	        value = Math.max(popper[placement], boundaries[placement]);
	      }

	      return defineProperty$3({}, placement, value);
	    },
	    secondary: function secondary(placement) {
	      var mainSide = placement === 'right' ? 'left' : 'top';
	      var value = popper[mainSide];

	      if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
	        value = Math.min(popper[mainSide], boundaries[placement] - (placement === 'right' ? popper.width : popper.height));
	      }

	      return defineProperty$3({}, mainSide, value);
	    }
	  };
	  order.forEach(function (placement) {
	    var side = ['left', 'top'].indexOf(placement) !== -1 ? 'primary' : 'secondary';
	    popper = _extends({}, popper, check[side](placement));
	  });
	  data.offsets.popper = popper;
	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function shift(data) {
	  var placement = data.placement;
	  var basePlacement = placement.split('-')[0];
	  var shiftvariation = placement.split('-')[1]; // if shift shiftvariation is specified, run the modifier

	  if (shiftvariation) {
	    var _data$offsets = data.offsets,
	        reference = _data$offsets.reference,
	        popper = _data$offsets.popper;
	    var isVertical = ['bottom', 'top'].indexOf(basePlacement) !== -1;
	    var side = isVertical ? 'left' : 'top';
	    var measurement = isVertical ? 'width' : 'height';
	    var shiftOffsets = {
	      start: defineProperty$3({}, side, reference[side]),
	      end: defineProperty$3({}, side, reference[side] + reference[measurement] - popper[measurement])
	    };
	    data.offsets.popper = _extends({}, popper, shiftOffsets[shiftvariation]);
	  }

	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function hide(data) {
	  if (!isModifierRequired(data.instance.modifiers, 'hide', 'preventOverflow')) {
	    return data;
	  }

	  var refRect = data.offsets.reference;
	  var bound = find(data.instance.modifiers, function (modifier) {
	    return modifier.name === 'preventOverflow';
	  }).boundaries;

	  if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
	    // Avoid unnecessary DOM access if visibility hasn't changed
	    if (data.hide === true) {
	      return data;
	    }

	    data.hide = true;
	    data.attributes['x-out-of-boundaries'] = '';
	  } else {
	    // Avoid unnecessary DOM access if visibility hasn't changed
	    if (data.hide === false) {
	      return data;
	    }

	    data.hide = false;
	    data.attributes['x-out-of-boundaries'] = false;
	  }

	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function inner(data) {
	  var placement = data.placement;
	  var basePlacement = placement.split('-')[0];
	  var _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var isHoriz = ['left', 'right'].indexOf(basePlacement) !== -1;
	  var subtractLength = ['top', 'left'].indexOf(basePlacement) === -1;
	  popper[isHoriz ? 'left' : 'top'] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? 'width' : 'height'] : 0);
	  data.placement = getOppositePlacement(placement);
	  data.offsets.popper = getClientRect(popper);
	  return data;
	}
	/**
	 * Modifier function, each modifier can have a function of this type assigned
	 * to its `fn` property.<br />
	 * These functions will be called on each update, this means that you must
	 * make sure they are performant enough to avoid performance bottlenecks.
	 *
	 * @function ModifierFn
	 * @argument {dataObject} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {dataObject} The data object, properly modified
	 */

	/**
	 * Modifiers are plugins used to alter the behavior of your poppers.<br />
	 * Popper.js uses a set of 9 modifiers to provide all the basic functionalities
	 * needed by the library.
	 *
	 * Usually you don't want to override the `order`, `fn` and `onLoad` props.
	 * All the other properties are configurations that could be tweaked.
	 * @namespace modifiers
	 */


	var modifiers = {
	  /**
	   * Modifier used to shift the popper on the start or end of its reference
	   * element.<br />
	   * It will read the variation of the `placement` property.<br />
	   * It can be one either `-end` or `-start`.
	   * @memberof modifiers
	   * @inner
	   */
	  shift: {
	    /** @prop {number} order=100 - Index used to define the order of execution */
	    order: 100,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: shift
	  },

	  /**
	   * The `offset` modifier can shift your popper on both its axis.
	   *
	   * It accepts the following units:
	   * - `px` or unit-less, interpreted as pixels
	   * - `%` or `%r`, percentage relative to the length of the reference element
	   * - `%p`, percentage relative to the length of the popper element
	   * - `vw`, CSS viewport width unit
	   * - `vh`, CSS viewport height unit
	   *
	   * For length is intended the main axis relative to the placement of the popper.<br />
	   * This means that if the placement is `top` or `bottom`, the length will be the
	   * `width`. In case of `left` or `right`, it will be the `height`.
	   *
	   * You can provide a single value (as `Number` or `String`), or a pair of values
	   * as `String` divided by a comma or one (or more) white spaces.<br />
	   * The latter is a deprecated method because it leads to confusion and will be
	   * removed in v2.<br />
	   * Additionally, it accepts additions and subtractions between different units.
	   * Note that multiplications and divisions aren't supported.
	   *
	   * Valid examples are:
	   * ```
	   * 10
	   * '10%'
	   * '10, 10'
	   * '10%, 10'
	   * '10 + 10%'
	   * '10 - 5vh + 3%'
	   * '-10px + 5vh, 5px - 6%'
	   * ```
	   * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
	   * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
	   * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
	   *
	   * @memberof modifiers
	   * @inner
	   */
	  offset: {
	    /** @prop {number} order=200 - Index used to define the order of execution */
	    order: 200,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: offset,

	    /** @prop {Number|String} offset=0
	     * The offset value as described in the modifier description
	     */
	    offset: 0
	  },

	  /**
	   * Modifier used to prevent the popper from being positioned outside the boundary.
	   *
	   * A scenario exists where the reference itself is not within the boundaries.<br />
	   * We can say it has "escaped the boundaries" — or just "escaped".<br />
	   * In this case we need to decide whether the popper should either:
	   *
	   * - detach from the reference and remain "trapped" in the boundaries, or
	   * - if it should ignore the boundary and "escape with its reference"
	   *
	   * When `escapeWithReference` is set to`true` and reference is completely
	   * outside its boundaries, the popper will overflow (or completely leave)
	   * the boundaries in order to remain attached to the edge of the reference.
	   *
	   * @memberof modifiers
	   * @inner
	   */
	  preventOverflow: {
	    /** @prop {number} order=300 - Index used to define the order of execution */
	    order: 300,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: preventOverflow,

	    /**
	     * @prop {Array} [priority=['left','right','top','bottom']]
	     * Popper will try to prevent overflow following these priorities by default,
	     * then, it could overflow on the left and on top of the `boundariesElement`
	     */
	    priority: ['left', 'right', 'top', 'bottom'],

	    /**
	     * @prop {number} padding=5
	     * Amount of pixel used to define a minimum distance between the boundaries
	     * and the popper. This makes sure the popper always has a little padding
	     * between the edges of its container
	     */
	    padding: 5,

	    /**
	     * @prop {String|HTMLElement} boundariesElement='scrollParent'
	     * Boundaries used by the modifier. Can be `scrollParent`, `window`,
	     * `viewport` or any DOM element.
	     */
	    boundariesElement: 'scrollParent'
	  },

	  /**
	   * Modifier used to make sure the reference and its popper stay near each other
	   * without leaving any gap between the two. Especially useful when the arrow is
	   * enabled and you want to ensure that it points to its reference element.
	   * It cares only about the first axis. You can still have poppers with margin
	   * between the popper and its reference element.
	   * @memberof modifiers
	   * @inner
	   */
	  keepTogether: {
	    /** @prop {number} order=400 - Index used to define the order of execution */
	    order: 400,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: keepTogether
	  },

	  /**
	   * This modifier is used to move the `arrowElement` of the popper to make
	   * sure it is positioned between the reference element and its popper element.
	   * It will read the outer size of the `arrowElement` node to detect how many
	   * pixels of conjunction are needed.
	   *
	   * It has no effect if no `arrowElement` is provided.
	   * @memberof modifiers
	   * @inner
	   */
	  arrow: {
	    /** @prop {number} order=500 - Index used to define the order of execution */
	    order: 500,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: arrow,

	    /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
	    element: '[x-arrow]'
	  },

	  /**
	   * Modifier used to flip the popper's placement when it starts to overlap its
	   * reference element.
	   *
	   * Requires the `preventOverflow` modifier before it in order to work.
	   *
	   * **NOTE:** this modifier will interrupt the current update cycle and will
	   * restart it if it detects the need to flip the placement.
	   * @memberof modifiers
	   * @inner
	   */
	  flip: {
	    /** @prop {number} order=600 - Index used to define the order of execution */
	    order: 600,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: flip,

	    /**
	     * @prop {String|Array} behavior='flip'
	     * The behavior used to change the popper's placement. It can be one of
	     * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
	     * placements (with optional variations)
	     */
	    behavior: 'flip',

	    /**
	     * @prop {number} padding=5
	     * The popper will flip if it hits the edges of the `boundariesElement`
	     */
	    padding: 5,

	    /**
	     * @prop {String|HTMLElement} boundariesElement='viewport'
	     * The element which will define the boundaries of the popper position.
	     * The popper will never be placed outside of the defined boundaries
	     * (except if `keepTogether` is enabled)
	     */
	    boundariesElement: 'viewport',

	    /**
	     * @prop {Boolean} flipVariations=false
	     * The popper will switch placement variation between `-start` and `-end` when
	     * the reference element overlaps its boundaries.
	     *
	     * The original placement should have a set variation.
	     */
	    flipVariations: false,

	    /**
	     * @prop {Boolean} flipVariationsByContent=false
	     * The popper will switch placement variation between `-start` and `-end` when
	     * the popper element overlaps its reference boundaries.
	     *
	     * The original placement should have a set variation.
	     */
	    flipVariationsByContent: false
	  },

	  /**
	   * Modifier used to make the popper flow toward the inner of the reference element.
	   * By default, when this modifier is disabled, the popper will be placed outside
	   * the reference element.
	   * @memberof modifiers
	   * @inner
	   */
	  inner: {
	    /** @prop {number} order=700 - Index used to define the order of execution */
	    order: 700,

	    /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
	    enabled: false,

	    /** @prop {ModifierFn} */
	    fn: inner
	  },

	  /**
	   * Modifier used to hide the popper when its reference element is outside of the
	   * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
	   * be used to hide with a CSS selector the popper when its reference is
	   * out of boundaries.
	   *
	   * Requires the `preventOverflow` modifier before it in order to work.
	   * @memberof modifiers
	   * @inner
	   */
	  hide: {
	    /** @prop {number} order=800 - Index used to define the order of execution */
	    order: 800,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: hide
	  },

	  /**
	   * Computes the style that will be applied to the popper element to gets
	   * properly positioned.
	   *
	   * Note that this modifier will not touch the DOM, it just prepares the styles
	   * so that `applyStyle` modifier can apply it. This separation is useful
	   * in case you need to replace `applyStyle` with a custom implementation.
	   *
	   * This modifier has `850` as `order` value to maintain backward compatibility
	   * with previous versions of Popper.js. Expect the modifiers ordering method
	   * to change in future major versions of the library.
	   *
	   * @memberof modifiers
	   * @inner
	   */
	  computeStyle: {
	    /** @prop {number} order=850 - Index used to define the order of execution */
	    order: 850,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: computeStyle,

	    /**
	     * @prop {Boolean} gpuAcceleration=true
	     * If true, it uses the CSS 3D transformation to position the popper.
	     * Otherwise, it will use the `top` and `left` properties
	     */
	    gpuAcceleration: true,

	    /**
	     * @prop {string} [x='bottom']
	     * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
	     * Change this if your popper should grow in a direction different from `bottom`
	     */
	    x: 'bottom',

	    /**
	     * @prop {string} [x='left']
	     * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
	     * Change this if your popper should grow in a direction different from `right`
	     */
	    y: 'right'
	  },

	  /**
	   * Applies the computed styles to the popper element.
	   *
	   * All the DOM manipulations are limited to this modifier. This is useful in case
	   * you want to integrate Popper.js inside a framework or view library and you
	   * want to delegate all the DOM manipulations to it.
	   *
	   * Note that if you disable this modifier, you must make sure the popper element
	   * has its position set to `absolute` before Popper.js can do its work!
	   *
	   * Just disable this modifier and define your own to achieve the desired effect.
	   *
	   * @memberof modifiers
	   * @inner
	   */
	  applyStyle: {
	    /** @prop {number} order=900 - Index used to define the order of execution */
	    order: 900,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: applyStyle,

	    /** @prop {Function} */
	    onLoad: applyStyleOnLoad,

	    /**
	     * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
	     * @prop {Boolean} gpuAcceleration=true
	     * If true, it uses the CSS 3D transformation to position the popper.
	     * Otherwise, it will use the `top` and `left` properties
	     */
	    gpuAcceleration: undefined
	  }
	};
	/**
	 * The `dataObject` is an object containing all the information used by Popper.js.
	 * This object is passed to modifiers and to the `onCreate` and `onUpdate` callbacks.
	 * @name dataObject
	 * @property {Object} data.instance The Popper.js instance
	 * @property {String} data.placement Placement applied to popper
	 * @property {String} data.originalPlacement Placement originally defined on init
	 * @property {Boolean} data.flipped True if popper has been flipped by flip modifier
	 * @property {Boolean} data.hide True if the reference element is out of boundaries, useful to know when to hide the popper
	 * @property {HTMLElement} data.arrowElement Node used as arrow by arrow modifier
	 * @property {Object} data.styles Any CSS property defined here will be applied to the popper. It expects the JavaScript nomenclature (eg. `marginBottom`)
	 * @property {Object} data.arrowStyles Any CSS property defined here will be applied to the popper arrow. It expects the JavaScript nomenclature (eg. `marginBottom`)
	 * @property {Object} data.boundaries Offsets of the popper boundaries
	 * @property {Object} data.offsets The measurements of popper, reference and arrow elements
	 * @property {Object} data.offsets.popper `top`, `left`, `width`, `height` values
	 * @property {Object} data.offsets.reference `top`, `left`, `width`, `height` values
	 * @property {Object} data.offsets.arrow] `top` and `left` offsets, only one of them will be different from 0
	 */

	/**
	 * Default options provided to Popper.js constructor.<br />
	 * These can be overridden using the `options` argument of Popper.js.<br />
	 * To override an option, simply pass an object with the same
	 * structure of the `options` object, as the 3rd argument. For example:
	 * ```
	 * new Popper(ref, pop, {
	 *   modifiers: {
	 *     preventOverflow: { enabled: false }
	 *   }
	 * })
	 * ```
	 * @type {Object}
	 * @static
	 * @memberof Popper
	 */

	var Defaults = {
	  /**
	   * Popper's placement.
	   * @prop {Popper.placements} placement='bottom'
	   */
	  placement: 'bottom',

	  /**
	   * Set this to true if you want popper to position it self in 'fixed' mode
	   * @prop {Boolean} positionFixed=false
	   */
	  positionFixed: false,

	  /**
	   * Whether events (resize, scroll) are initially enabled.
	   * @prop {Boolean} eventsEnabled=true
	   */
	  eventsEnabled: true,

	  /**
	   * Set to true if you want to automatically remove the popper when
	   * you call the `destroy` method.
	   * @prop {Boolean} removeOnDestroy=false
	   */
	  removeOnDestroy: false,

	  /**
	   * Callback called when the popper is created.<br />
	   * By default, it is set to no-op.<br />
	   * Access Popper.js instance with `data.instance`.
	   * @prop {onCreate}
	   */
	  onCreate: function onCreate() {},

	  /**
	   * Callback called when the popper is updated. This callback is not called
	   * on the initialization/creation of the popper, but only on subsequent
	   * updates.<br />
	   * By default, it is set to no-op.<br />
	   * Access Popper.js instance with `data.instance`.
	   * @prop {onUpdate}
	   */
	  onUpdate: function onUpdate() {},

	  /**
	   * List of modifiers used to modify the offsets before they are applied to the popper.
	   * They provide most of the functionalities of Popper.js.
	   * @prop {modifiers}
	   */
	  modifiers: modifiers
	};
	/**
	 * @callback onCreate
	 * @param {dataObject} data
	 */

	/**
	 * @callback onUpdate
	 * @param {dataObject} data
	 */
	// Utils
	// Methods

	var Popper = function () {
	  /**
	   * Creates a new Popper.js instance.
	   * @class Popper
	   * @param {Element|referenceObject} reference - The reference element used to position the popper
	   * @param {Element} popper - The HTML / XML element used as the popper
	   * @param {Object} options - Your custom options to override the ones defined in [Defaults](#defaults)
	   * @return {Object} instance - The generated Popper.js instance
	   */
	  function Popper(reference, popper) {
	    var _this = this;

	    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	    classCallCheck(this, Popper);

	    this.scheduleUpdate = function () {
	      return requestAnimationFrame(_this.update);
	    }; // make update() debounced, so that it only runs at most once-per-tick


	    this.update = debounce(this.update.bind(this)); // with {} we create a new object with the options inside it

	    this.options = _extends({}, Popper.Defaults, options); // init state

	    this.state = {
	      isDestroyed: false,
	      isCreated: false,
	      scrollParents: []
	    }; // get reference and popper elements (allow jQuery wrappers)

	    this.reference = reference && reference.jquery ? reference[0] : reference;
	    this.popper = popper && popper.jquery ? popper[0] : popper; // Deep merge modifiers options

	    this.options.modifiers = {};
	    Object.keys(_extends({}, Popper.Defaults.modifiers, options.modifiers)).forEach(function (name) {
	      _this.options.modifiers[name] = _extends({}, Popper.Defaults.modifiers[name] || {}, options.modifiers ? options.modifiers[name] : {});
	    }); // Refactoring modifiers' list (Object => Array)

	    this.modifiers = Object.keys(this.options.modifiers).map(function (name) {
	      return _extends({
	        name: name
	      }, _this.options.modifiers[name]);
	    }) // sort the modifiers by order
	    .sort(function (a, b) {
	      return a.order - b.order;
	    }); // modifiers have the ability to execute arbitrary code when Popper.js get inited
	    // such code is executed in the same order of its modifier
	    // they could add new properties to their options configuration
	    // BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!

	    this.modifiers.forEach(function (modifierOptions) {
	      if (modifierOptions.enabled && isFunction$1(modifierOptions.onLoad)) {
	        modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
	      }
	    }); // fire the first update to position the popper in the right place

	    this.update();
	    var eventsEnabled = this.options.eventsEnabled;

	    if (eventsEnabled) {
	      // setup event listeners, they will take care of update the position in specific situations
	      this.enableEventListeners();
	    }

	    this.state.eventsEnabled = eventsEnabled;
	  } // We can't use class properties because they don't get listed in the
	  // class prototype and break stuff like Sinon stubs


	  createClass(Popper, [{
	    key: 'update',
	    value: function update$$1() {
	      return update.call(this);
	    }
	  }, {
	    key: 'destroy',
	    value: function destroy$$1() {
	      return destroy.call(this);
	    }
	  }, {
	    key: 'enableEventListeners',
	    value: function enableEventListeners$$1() {
	      return enableEventListeners.call(this);
	    }
	  }, {
	    key: 'disableEventListeners',
	    value: function disableEventListeners$$1() {
	      return disableEventListeners.call(this);
	    }
	    /**
	     * Schedules an update. It will run on the next UI update available.
	     * @method scheduleUpdate
	     * @memberof Popper
	     */

	    /**
	     * Collection of utilities useful when writing custom modifiers.
	     * Starting from version 1.7, this method is available only if you
	     * include `popper-utils.js` before `popper.js`.
	     *
	     * **DEPRECATION**: This way to access PopperUtils is deprecated
	     * and will be removed in v2! Use the PopperUtils module directly instead.
	     * Due to the high instability of the methods contained in Utils, we can't
	     * guarantee them to follow semver. Use them at your own risk!
	     * @static
	     * @private
	     * @type {Object}
	     * @deprecated since version 1.8
	     * @member Utils
	     * @memberof Popper
	     */

	  }]);
	  return Popper;
	}();
	/**
	 * The `referenceObject` is an object that provides an interface compatible with Popper.js
	 * and lets you use it as replacement of a real DOM node.<br />
	 * You can use this method to position a popper relatively to a set of coordinates
	 * in case you don't have a DOM node to use as reference.
	 *
	 * ```
	 * new Popper(referenceObject, popperNode);
	 * ```
	 *
	 * NB: This feature isn't supported in Internet Explorer 10.
	 * @name referenceObject
	 * @property {Function} data.getBoundingClientRect
	 * A function that returns a set of coordinates compatible with the native `getBoundingClientRect` method.
	 * @property {number} data.clientWidth
	 * An ES6 getter that will return the width of the virtual reference element.
	 * @property {number} data.clientHeight
	 * An ES6 getter that will return the height of the virtual reference element.
	 */


	Popper.Utils = (typeof window !== 'undefined' ? window : global).PopperUtils;
	Popper.placements = placements;
	Popper.Defaults = Defaults;

	var key = '__global_unique_id__';

	var gud = function () {
	  return commonjsGlobal[key] = (commonjsGlobal[key] || 0) + 1;
	};

	/**
	 * Copyright (c) 2014-present, Facebook, Inc.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */

	var warning = function () {};

	{
	  var printWarning = function printWarning(format, args) {
	    var len = arguments.length;
	    args = new Array(len > 1 ? len - 1 : 0);

	    for (var key = 1; key < len; key++) {
	      args[key - 1] = arguments[key];
	    }

	    var argIndex = 0;
	    var message = 'Warning: ' + format.replace(/%s/g, function () {
	      return args[argIndex++];
	    });

	    if (typeof console !== 'undefined') {
	      console.error(message);
	    }

	    try {
	      // --- Welcome to debugging React ---
	      // This error was thrown as a convenience so that you can use this stack
	      // to find the callsite that caused this warning to fire.
	      throw new Error(message);
	    } catch (x) {}
	  };

	  warning = function (condition, format, args) {
	    var len = arguments.length;
	    args = new Array(len > 2 ? len - 2 : 0);

	    for (var key = 2; key < len; key++) {
	      args[key - 2] = arguments[key];
	    }

	    if (format === undefined) {
	      throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'message argument');
	    }

	    if (!condition) {
	      printWarning.apply(null, [format].concat(args));
	    }
	  };
	}

	var warning_1 = warning;

	var implementation$4 = createCommonjsModule(function (module, exports) {

	  exports.__esModule = true;

	  var _react2 = _interopRequireDefault(React__default);

	  var _propTypes2 = _interopRequireDefault(PropTypes);

	  var _gud2 = _interopRequireDefault(gud);

	  var _warning2 = _interopRequireDefault(warning_1);

	  function _interopRequireDefault(obj) {
	    return obj && obj.__esModule ? obj : {
	      default: obj
	    };
	  }

	  function _classCallCheck(instance, Constructor) {
	    if (!(instance instanceof Constructor)) {
	      throw new TypeError("Cannot call a class as a function");
	    }
	  }

	  function _possibleConstructorReturn(self, call) {
	    if (!self) {
	      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	    }

	    return call && (typeof call === "object" || typeof call === "function") ? call : self;
	  }

	  function _inherits(subClass, superClass) {
	    if (typeof superClass !== "function" && superClass !== null) {
	      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
	    }

	    subClass.prototype = Object.create(superClass && superClass.prototype, {
	      constructor: {
	        value: subClass,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	    if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	  }

	  var MAX_SIGNED_31_BIT_INT = 1073741823; // Inlined Object.is polyfill.
	  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is

	  function objectIs(x, y) {
	    if (x === y) {
	      return x !== 0 || 1 / x === 1 / y;
	    } else {
	      return x !== x && y !== y;
	    }
	  }

	  function createEventEmitter(value) {
	    var handlers = [];
	    return {
	      on: function on(handler) {
	        handlers.push(handler);
	      },
	      off: function off(handler) {
	        handlers = handlers.filter(function (h) {
	          return h !== handler;
	        });
	      },
	      get: function get() {
	        return value;
	      },
	      set: function set(newValue, changedBits) {
	        value = newValue;
	        handlers.forEach(function (handler) {
	          return handler(value, changedBits);
	        });
	      }
	    };
	  }

	  function onlyChild(children) {
	    return Array.isArray(children) ? children[0] : children;
	  }

	  function createReactContext(defaultValue, calculateChangedBits) {
	    var _Provider$childContex, _Consumer$contextType;

	    var contextProp = '__create-react-context-' + (0, _gud2.default)() + '__';

	    var Provider = function (_Component) {
	      _inherits(Provider, _Component);

	      function Provider() {
	        var _temp, _this, _ret;

	        _classCallCheck(this, Provider);

	        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
	          args[_key] = arguments[_key];
	        }

	        return _ret = (_temp = (_this = _possibleConstructorReturn(this, _Component.call.apply(_Component, [this].concat(args))), _this), _this.emitter = createEventEmitter(_this.props.value), _temp), _possibleConstructorReturn(_this, _ret);
	      }

	      Provider.prototype.getChildContext = function getChildContext() {
	        var _ref;

	        return _ref = {}, _ref[contextProp] = this.emitter, _ref;
	      };

	      Provider.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
	        if (this.props.value !== nextProps.value) {
	          var oldValue = this.props.value;
	          var newValue = nextProps.value;
	          var changedBits = void 0;

	          if (objectIs(oldValue, newValue)) {
	            changedBits = 0; // No change
	          } else {
	            changedBits = typeof calculateChangedBits === 'function' ? calculateChangedBits(oldValue, newValue) : MAX_SIGNED_31_BIT_INT;

	            {
	              (0, _warning2.default)((changedBits & MAX_SIGNED_31_BIT_INT) === changedBits, 'calculateChangedBits: Expected the return value to be a ' + '31-bit integer. Instead received: %s', changedBits);
	            }

	            changedBits |= 0;

	            if (changedBits !== 0) {
	              this.emitter.set(nextProps.value, changedBits);
	            }
	          }
	        }
	      };

	      Provider.prototype.render = function render() {
	        return this.props.children;
	      };

	      return Provider;
	    }(React__default.Component);

	    Provider.childContextTypes = (_Provider$childContex = {}, _Provider$childContex[contextProp] = _propTypes2.default.object.isRequired, _Provider$childContex);

	    var Consumer = function (_Component2) {
	      _inherits(Consumer, _Component2);

	      function Consumer() {
	        var _temp2, _this2, _ret2;

	        _classCallCheck(this, Consumer);

	        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
	          args[_key2] = arguments[_key2];
	        }

	        return _ret2 = (_temp2 = (_this2 = _possibleConstructorReturn(this, _Component2.call.apply(_Component2, [this].concat(args))), _this2), _this2.state = {
	          value: _this2.getValue()
	        }, _this2.onUpdate = function (newValue, changedBits) {
	          var observedBits = _this2.observedBits | 0;

	          if ((observedBits & changedBits) !== 0) {
	            _this2.setState({
	              value: _this2.getValue()
	            });
	          }
	        }, _temp2), _possibleConstructorReturn(_this2, _ret2);
	      }

	      Consumer.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
	        var observedBits = nextProps.observedBits;
	        this.observedBits = observedBits === undefined || observedBits === null ? MAX_SIGNED_31_BIT_INT // Subscribe to all changes by default
	        : observedBits;
	      };

	      Consumer.prototype.componentDidMount = function componentDidMount() {
	        if (this.context[contextProp]) {
	          this.context[contextProp].on(this.onUpdate);
	        }

	        var observedBits = this.props.observedBits;
	        this.observedBits = observedBits === undefined || observedBits === null ? MAX_SIGNED_31_BIT_INT // Subscribe to all changes by default
	        : observedBits;
	      };

	      Consumer.prototype.componentWillUnmount = function componentWillUnmount() {
	        if (this.context[contextProp]) {
	          this.context[contextProp].off(this.onUpdate);
	        }
	      };

	      Consumer.prototype.getValue = function getValue() {
	        if (this.context[contextProp]) {
	          return this.context[contextProp].get();
	        } else {
	          return defaultValue;
	        }
	      };

	      Consumer.prototype.render = function render() {
	        return onlyChild(this.props.children)(this.state.value);
	      };

	      return Consumer;
	    }(React__default.Component);

	    Consumer.contextTypes = (_Consumer$contextType = {}, _Consumer$contextType[contextProp] = _propTypes2.default.object, _Consumer$contextType);
	    return {
	      Provider: Provider,
	      Consumer: Consumer
	    };
	  }

	  exports.default = createReactContext;
	  module.exports = exports['default'];
	});
	unwrapExports(implementation$4);

	var lib = createCommonjsModule(function (module, exports) {

	  exports.__esModule = true;

	  var _react2 = _interopRequireDefault(React__default);

	  var _implementation2 = _interopRequireDefault(implementation$4);

	  function _interopRequireDefault(obj) {
	    return obj && obj.__esModule ? obj : {
	      default: obj
	    };
	  }

	  exports.default = _react2.default.createContext || _implementation2.default;
	  module.exports = exports['default'];
	});
	var createContext = unwrapExports(lib);

	var ManagerReferenceNodeContext = createContext();
	var ManagerReferenceNodeSetterContext = createContext();

	var Manager = /*#__PURE__*/function (_React$Component) {
	  inheritsLoose(Manager, _React$Component);

	  function Manager() {
	    var _this;

	    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }

	    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;

	    defineProperty(assertThisInitialized(_this), "referenceNode", void 0);

	    defineProperty(assertThisInitialized(_this), "setReferenceNode", function (newReferenceNode) {
	      if (newReferenceNode && _this.referenceNode !== newReferenceNode) {
	        _this.referenceNode = newReferenceNode;

	        _this.forceUpdate();
	      }
	    });

	    return _this;
	  }

	  var _proto = Manager.prototype;

	  _proto.componentWillUnmount = function componentWillUnmount() {
	    this.referenceNode = null;
	  };

	  _proto.render = function render() {
	    return /*#__PURE__*/React.createElement(ManagerReferenceNodeContext.Provider, {
	      value: this.referenceNode
	    }, /*#__PURE__*/React.createElement(ManagerReferenceNodeSetterContext.Provider, {
	      value: this.setReferenceNode
	    }, this.props.children));
	  };

	  return Manager;
	}(React.Component);

	/**
	 * Takes an argument and if it's an array, returns the first item in the array,
	 * otherwise returns the argument. Used for Preact compatibility.
	 */
	var unwrapArray = function unwrapArray(arg) {
	  return Array.isArray(arg) ? arg[0] : arg;
	};
	/**
	 * Takes a maybe-undefined function and arbitrary args and invokes the function
	 * only if it is defined.
	 */

	var safeInvoke = function safeInvoke(fn) {
	  if (typeof fn === "function") {
	    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	      args[_key - 1] = arguments[_key];
	    }

	    return fn.apply(void 0, args);
	  }
	};
	/**
	 * Does a shallow equality check of two objects by comparing the reference
	 * equality of each value.
	 */

	var shallowEqual = function shallowEqual(objA, objB) {
	  var aKeys = Object.keys(objA);
	  var bKeys = Object.keys(objB);

	  if (bKeys.length !== aKeys.length) {
	    return false;
	  }

	  for (var i = 0; i < bKeys.length; i++) {
	    var key = aKeys[i];

	    if (objA[key] !== objB[key]) {
	      return false;
	    }
	  }

	  return true;
	};
	/**
	 * Sets a ref using either a ref callback or a ref object
	 */

	var setRef = function setRef(ref, node) {
	  // if its a function call it
	  if (typeof ref === "function") {
	    return safeInvoke(ref, node);
	  } // otherwise we should treat it as a ref object
	  else if (ref != null) {
	      ref.current = node;
	    }
	};

	var initialStyle = {
	  position: 'absolute',
	  top: 0,
	  left: 0,
	  opacity: 0,
	  pointerEvents: 'none'
	};
	var initialArrowStyle = {};
	var InnerPopper = /*#__PURE__*/function (_React$Component) {
	  inheritsLoose(InnerPopper, _React$Component);

	  function InnerPopper() {
	    var _this;

	    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }

	    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;

	    defineProperty(assertThisInitialized(_this), "state", {
	      data: undefined,
	      placement: undefined
	    });

	    defineProperty(assertThisInitialized(_this), "popperInstance", void 0);

	    defineProperty(assertThisInitialized(_this), "popperNode", null);

	    defineProperty(assertThisInitialized(_this), "arrowNode", null);

	    defineProperty(assertThisInitialized(_this), "setPopperNode", function (popperNode) {
	      if (!popperNode || _this.popperNode === popperNode) return;
	      setRef(_this.props.innerRef, popperNode);
	      _this.popperNode = popperNode;

	      _this.updatePopperInstance();
	    });

	    defineProperty(assertThisInitialized(_this), "setArrowNode", function (arrowNode) {
	      _this.arrowNode = arrowNode;
	    });

	    defineProperty(assertThisInitialized(_this), "updateStateModifier", {
	      enabled: true,
	      order: 900,
	      fn: function fn(data) {
	        var placement = data.placement;

	        _this.setState({
	          data: data,
	          placement: placement
	        });

	        return data;
	      }
	    });

	    defineProperty(assertThisInitialized(_this), "getOptions", function () {
	      return {
	        placement: _this.props.placement,
	        eventsEnabled: _this.props.eventsEnabled,
	        positionFixed: _this.props.positionFixed,
	        modifiers: _extends_1({}, _this.props.modifiers, {
	          arrow: _extends_1({}, _this.props.modifiers && _this.props.modifiers.arrow, {
	            enabled: !!_this.arrowNode,
	            element: _this.arrowNode
	          }),
	          applyStyle: {
	            enabled: false
	          },
	          updateStateModifier: _this.updateStateModifier
	        })
	      };
	    });

	    defineProperty(assertThisInitialized(_this), "getPopperStyle", function () {
	      return !_this.popperNode || !_this.state.data ? initialStyle : _extends_1({
	        position: _this.state.data.offsets.popper.position
	      }, _this.state.data.styles);
	    });

	    defineProperty(assertThisInitialized(_this), "getPopperPlacement", function () {
	      return !_this.state.data ? undefined : _this.state.placement;
	    });

	    defineProperty(assertThisInitialized(_this), "getArrowStyle", function () {
	      return !_this.arrowNode || !_this.state.data ? initialArrowStyle : _this.state.data.arrowStyles;
	    });

	    defineProperty(assertThisInitialized(_this), "getOutOfBoundariesState", function () {
	      return _this.state.data ? _this.state.data.hide : undefined;
	    });

	    defineProperty(assertThisInitialized(_this), "destroyPopperInstance", function () {
	      if (!_this.popperInstance) return;

	      _this.popperInstance.destroy();

	      _this.popperInstance = null;
	    });

	    defineProperty(assertThisInitialized(_this), "updatePopperInstance", function () {
	      _this.destroyPopperInstance();

	      var _assertThisInitialize = assertThisInitialized(_this),
	          popperNode = _assertThisInitialize.popperNode;

	      var referenceElement = _this.props.referenceElement;
	      if (!referenceElement || !popperNode) return;
	      _this.popperInstance = new Popper(referenceElement, popperNode, _this.getOptions());
	    });

	    defineProperty(assertThisInitialized(_this), "scheduleUpdate", function () {
	      if (_this.popperInstance) {
	        _this.popperInstance.scheduleUpdate();
	      }
	    });

	    return _this;
	  }

	  var _proto = InnerPopper.prototype;

	  _proto.componentDidUpdate = function componentDidUpdate(prevProps, prevState) {
	    // If the Popper.js options have changed, update the instance (destroy + create)
	    if (this.props.placement !== prevProps.placement || this.props.referenceElement !== prevProps.referenceElement || this.props.positionFixed !== prevProps.positionFixed || !deepEqual_1(this.props.modifiers, prevProps.modifiers, {
	      strict: true
	    })) {
	      // develop only check that modifiers isn't being updated needlessly
	      {
	        if (this.props.modifiers !== prevProps.modifiers && this.props.modifiers != null && prevProps.modifiers != null && shallowEqual(this.props.modifiers, prevProps.modifiers)) {
	          console.warn("'modifiers' prop reference updated even though all values appear the same.\nConsider memoizing the 'modifiers' object to avoid needless rendering.");
	        }
	      }

	      this.updatePopperInstance();
	    } else if (this.props.eventsEnabled !== prevProps.eventsEnabled && this.popperInstance) {
	      this.props.eventsEnabled ? this.popperInstance.enableEventListeners() : this.popperInstance.disableEventListeners();
	    } // A placement difference in state means popper determined a new placement
	    // apart from the props value. By the time the popper element is rendered with
	    // the new position Popper has already measured it, if the place change triggers
	    // a size change it will result in a misaligned popper. So we schedule an update to be sure.


	    if (prevState.placement !== this.state.placement) {
	      this.scheduleUpdate();
	    }
	  };

	  _proto.componentWillUnmount = function componentWillUnmount() {
	    setRef(this.props.innerRef, null);
	    this.destroyPopperInstance();
	  };

	  _proto.render = function render() {
	    return unwrapArray(this.props.children)({
	      ref: this.setPopperNode,
	      style: this.getPopperStyle(),
	      placement: this.getPopperPlacement(),
	      outOfBoundaries: this.getOutOfBoundariesState(),
	      scheduleUpdate: this.scheduleUpdate,
	      arrowProps: {
	        ref: this.setArrowNode,
	        style: this.getArrowStyle()
	      }
	    });
	  };

	  return InnerPopper;
	}(React.Component);

	defineProperty(InnerPopper, "defaultProps", {
	  placement: 'bottom',
	  eventsEnabled: true,
	  referenceElement: undefined,
	  positionFixed: false
	});
	function Popper$1(_ref) {
	  var referenceElement = _ref.referenceElement,
	      props = objectWithoutPropertiesLoose(_ref, ["referenceElement"]);

	  return /*#__PURE__*/React.createElement(ManagerReferenceNodeContext.Consumer, null, function (referenceNode) {
	    return /*#__PURE__*/React.createElement(InnerPopper, _extends_1({
	      referenceElement: referenceElement !== undefined ? referenceElement : referenceNode
	    }, props));
	  });
	}

	var InnerReference = /*#__PURE__*/function (_React$Component) {
	  inheritsLoose(InnerReference, _React$Component);

	  function InnerReference() {
	    var _this;

	    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }

	    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;

	    defineProperty(assertThisInitialized(_this), "refHandler", function (node) {
	      setRef(_this.props.innerRef, node);
	      safeInvoke(_this.props.setReferenceNode, node);
	    });

	    return _this;
	  }

	  var _proto = InnerReference.prototype;

	  _proto.componentWillUnmount = function componentWillUnmount() {
	    setRef(this.props.innerRef, null);
	  };

	  _proto.render = function render() {
	    warning_1(Boolean(this.props.setReferenceNode), '`Reference` should not be used outside of a `Manager` component.');
	    return unwrapArray(this.props.children)({
	      ref: this.refHandler
	    });
	  };

	  return InnerReference;
	}(React.Component);

	function Reference(props) {
	  return /*#__PURE__*/React.createElement(ManagerReferenceNodeSetterContext.Consumer, null, function (setReferenceNode) {
	    return /*#__PURE__*/React.createElement(InnerReference, _extends_1({
	      setReferenceNode: setReferenceNode
	    }, props));
	  });
	}

	function oe(e) {
	  return (oe = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (e) {
	    return typeof e;
	  } : function (e) {
	    return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;
	  })(e);
	}

	function ae(e, t) {
	  if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function");
	}

	function se(e, t) {
	  for (var r = 0; r < t.length; r++) {
	    var n = t[r];
	    n.enumerable = n.enumerable || !1, n.configurable = !0, "value" in n && (n.writable = !0), Object.defineProperty(e, n.key, n);
	  }
	}

	function pe(e, t, r) {
	  return t && se(e.prototype, t), r && se(e, r), e;
	}

	function ie(e, t, r) {
	  return t in e ? Object.defineProperty(e, t, {
	    value: r,
	    enumerable: !0,
	    configurable: !0,
	    writable: !0
	  }) : e[t] = r, e;
	}

	function ce() {
	  return (ce = Object.assign || function (e) {
	    for (var t = 1; t < arguments.length; t++) {
	      var r = arguments[t];

	      for (var n in r) Object.prototype.hasOwnProperty.call(r, n) && (e[n] = r[n]);
	    }

	    return e;
	  }).apply(this, arguments);
	}

	function le(e, t) {
	  var r = Object.keys(e);

	  if (Object.getOwnPropertySymbols) {
	    var n = Object.getOwnPropertySymbols(e);
	    t && (n = n.filter(function (t) {
	      return Object.getOwnPropertyDescriptor(e, t).enumerable;
	    })), r.push.apply(r, n);
	  }

	  return r;
	}

	function de(e) {
	  for (var t = 1; t < arguments.length; t++) {
	    var r = null != arguments[t] ? arguments[t] : {};
	    t % 2 ? le(Object(r), !0).forEach(function (t) {
	      ie(e, t, r[t]);
	    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(r)) : le(Object(r)).forEach(function (t) {
	      Object.defineProperty(e, t, Object.getOwnPropertyDescriptor(r, t));
	    });
	  }

	  return e;
	}

	function ue(e, t) {
	  if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function");
	  e.prototype = Object.create(t && t.prototype, {
	    constructor: {
	      value: e,
	      writable: !0,
	      configurable: !0
	    }
	  }), t && me(e, t);
	}

	function he(e) {
	  return (he = Object.setPrototypeOf ? Object.getPrototypeOf : function (e) {
	    return e.__proto__ || Object.getPrototypeOf(e);
	  })(e);
	}

	function me(e, t) {
	  return (me = Object.setPrototypeOf || function (e, t) {
	    return e.__proto__ = t, e;
	  })(e, t);
	}

	function fe(e) {
	  if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  return e;
	}

	function ye(e, t) {
	  return !t || "object" != typeof t && "function" != typeof t ? fe(e) : t;
	}

	function ve(e) {
	  var t = function () {
	    if ("undefined" == typeof Reflect || !Reflect.construct) return !1;
	    if (Reflect.construct.sham) return !1;
	    if ("function" == typeof Proxy) return !0;

	    try {
	      return Date.prototype.toString.call(Reflect.construct(Date, [], function () {})), !0;
	    } catch (e) {
	      return !1;
	    }
	  }();

	  return function () {
	    var r,
	        n = he(e);

	    if (t) {
	      var o = he(this).constructor;
	      r = Reflect.construct(n, arguments, o);
	    } else r = n.apply(this, arguments);

	    return ye(this, r);
	  };
	}

	function De(e, t) {
	  switch (e) {
	    case "P":
	      return t.date({
	        width: "short"
	      });

	    case "PP":
	      return t.date({
	        width: "medium"
	      });

	    case "PPP":
	      return t.date({
	        width: "long"
	      });

	    case "PPPP":
	    default:
	      return t.date({
	        width: "full"
	      });
	  }
	}

	function we(e, t) {
	  switch (e) {
	    case "p":
	      return t.time({
	        width: "short"
	      });

	    case "pp":
	      return t.time({
	        width: "medium"
	      });

	    case "ppp":
	      return t.time({
	        width: "long"
	      });

	    case "pppp":
	    default:
	      return t.time({
	        width: "full"
	      });
	  }
	}

	var ke = {
	  p: we,
	  P: function (e, t) {
	    var r,
	        n = e.match(/(P+)(p+)?/),
	        o = n[1],
	        a = n[2];
	    if (!a) return De(e, t);

	    switch (o) {
	      case "P":
	        r = t.dateTime({
	          width: "short"
	        });
	        break;

	      case "PP":
	        r = t.dateTime({
	          width: "medium"
	        });
	        break;

	      case "PPP":
	        r = t.dateTime({
	          width: "long"
	        });
	        break;

	      case "PPPP":
	      default:
	        r = t.dateTime({
	          width: "full"
	        });
	    }

	    return r.replace("{{date}}", De(o, t)).replace("{{time}}", we(a, t));
	  }
	},
	    ge = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;

	function be(e) {
	  var t = e ? "string" == typeof e || e instanceof String ? parseISO(e) : toDate(e) : new Date();
	  return _e(t) ? t : null;
	}

	function Ce(e, t, r, n) {
	  var a = null,
	      s = He(r) || je(),
	      p = !0;
	  return Array.isArray(t) ? (t.forEach(function (t) {
	    var r = parse(e, t, new Date(), {
	      locale: s
	    });
	    n && (p = _e(r) && e === format(r, t, {
	      awareOfUnicodeTokens: !0
	    })), _e(r) && p && (a = r);
	  }), a) : (a = parse(e, t, new Date(), {
	    locale: s
	  }), n ? p = _e(a) && e === format(a, t, {
	    awareOfUnicodeTokens: !0
	  }) : _e(a) || (t = t.match(ge).map(function (e) {
	    var t = e[0];
	    return "p" === t || "P" === t ? s ? (0, ke[t])(e, s.formatLong) : t : e;
	  }).join(""), e.length > 0 && (a = parse(e, t.slice(0, e.length), new Date())), _e(a) || (a = new Date(e))), _e(a) && p ? a : null);
	}

	function _e(e) {
	  return isValid(e) && isAfter(e, new Date("1/1/1000"));
	}

	function Se(e, t, r) {
	  if ("en" === r) return format(e, t, {
	    awareOfUnicodeTokens: !0
	  });
	  var n = He(r);
	  return r && !n && console.warn('A locale object was not found for the provided string ["'.concat(r, '"].')), !n && je() && He(je()) && (n = He(je())), format(e, t, {
	    locale: n || null,
	    awareOfUnicodeTokens: !0
	  });
	}

	function Me(e, t) {
	  var r = t.hour,
	      n = void 0 === r ? 0 : r,
	      o = t.minute,
	      a = void 0 === o ? 0 : o,
	      s = t.second;
	  return setHours(setMinutes(setSeconds(e, void 0 === s ? 0 : s), a), n);
	}

	function Pe(e, t) {
	  var r = t && He(t) || je() && He(je());
	  return getWeek(e, r ? {
	    locale: r
	  } : null);
	}

	function Ee(e, t) {
	  return Se(e, "ddd", t);
	}

	function Ne(e) {
	  return startOfDay(e);
	}

	function Oe(e, t) {
	  var r = He(t || je());
	  return startOfWeek(e, {
	    locale: r
	  });
	}

	function xe(e) {
	  return startOfMonth(e);
	}

	function Te(e) {
	  return startOfYear(e);
	}

	function Ye(e) {
	  return startOfQuarter(e);
	}

	function Ie(e, t) {
	  return e && t ? isSameYear(e, t) : !e && !t;
	}

	function Le(e, t) {
	  return e && t ? isSameMonth(e, t) : !e && !t;
	}

	function Re(e, t) {
	  return e && t ? isSameQuarter(e, t) : !e && !t;
	}

	function Fe(e, t) {
	  return e && t ? isSameDay(e, t) : !e && !t;
	}

	function Ae(e, t) {
	  return e && t ? isEqual(e, t) : !e && !t;
	}

	function We(e, t, r) {
	  var n,
	      o = startOfDay(t),
	      a = endOfDay(r);

	  try {
	    n = isWithinInterval(e, {
	      start: o,
	      end: a
	    });
	  } catch (e) {
	    n = !1;
	  }

	  return n;
	}

	function je() {
	  return ("undefined" != typeof window ? window : global).__localeId__;
	}

	function He(e) {
	  if ("string" == typeof e) {
	    var t = "undefined" != typeof window ? window : global;
	    return t.__localeData__ ? t.__localeData__[e] : null;
	  }

	  return e;
	}

	function Qe(e, t) {
	  return Se(setMonth(be(), e), "LLLL", t);
	}

	function Ve(e, t) {
	  return Se(setMonth(be(), e), "LLL", t);
	}

	function qe(e, t) {
	  return Se(setQuarter(be(), e), "QQQ", t);
	}

	function Ue(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.minDate,
	      n = t.maxDate,
	      o = t.excludeDates,
	      a = t.includeDates,
	      s = t.filterDate;
	  return et(e, {
	    minDate: r,
	    maxDate: n
	  }) || o && o.some(function (t) {
	    return Fe(e, t);
	  }) || a && !a.some(function (t) {
	    return Fe(e, t);
	  }) || s && !s(be(e)) || !1;
	}

	function $e(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.excludeDates;
	  return r && r.some(function (t) {
	    return Fe(e, t);
	  }) || !1;
	}

	function ze(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.minDate,
	      n = t.maxDate,
	      o = t.excludeDates,
	      a = t.includeDates,
	      s = t.filterDate;
	  return et(e, {
	    minDate: r,
	    maxDate: n
	  }) || o && o.some(function (t) {
	    return Le(e, t);
	  }) || a && !a.some(function (t) {
	    return Le(e, t);
	  }) || s && !s(be(e)) || !1;
	}

	function Ge(e, t, r, n) {
	  var o = getYear(e),
	      a = getMonth(e),
	      s = getYear(t),
	      p = getMonth(t),
	      i = getYear(n);
	  return o === s && o === i ? a <= r && r <= p : o < s ? i === o && a <= r || i === s && p >= r || i < s && i > o : void 0;
	}

	function Je(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.minDate,
	      n = t.maxDate,
	      o = t.excludeDates,
	      a = t.includeDates,
	      s = t.filterDate;
	  return et(e, {
	    minDate: r,
	    maxDate: n
	  }) || o && o.some(function (t) {
	    return Re(e, t);
	  }) || a && !a.some(function (t) {
	    return Re(e, t);
	  }) || s && !s(be(e)) || !1;
	}

	function Xe(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.minDate,
	      n = t.maxDate,
	      o = new Date(e, 0, 1);
	  return et(o, {
	    minDate: r,
	    maxDate: n
	  }) || !1;
	}

	function Ze(e, t, r, n) {
	  var o = getYear(e),
	      a = getQuarter(e),
	      s = getYear(t),
	      p = getQuarter(t),
	      i = getYear(n);
	  return o === s && o === i ? a <= r && r <= p : o < s ? i === o && a <= r || i === s && p >= r || i < s && i > o : void 0;
	}

	function et(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.minDate,
	      n = t.maxDate;
	  return r && differenceInCalendarDays(e, r) < 0 || n && differenceInCalendarDays(e, n) > 0;
	}

	function tt(e, t) {
	  return t.some(function (t) {
	    return getHours(t) === getHours(e) && getMinutes(t) === getMinutes(e);
	  });
	}

	function rt(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.excludeTimes,
	      n = t.includeTimes,
	      o = t.filterTime;
	  return r && tt(e, r) || n && !tt(e, n) || o && !o(e) || !1;
	}

	function nt(e, t) {
	  var r = t.minTime,
	      n = t.maxTime;
	  if (!r || !n) throw new Error("Both minTime and maxTime props required");
	  var o,
	      a = be(),
	      s = setHours(setMinutes(a, getMinutes(e)), getHours(e)),
	      p = setHours(setMinutes(a, getMinutes(r)), getHours(r)),
	      i = setHours(setMinutes(a, getMinutes(n)), getHours(n));

	  try {
	    o = !isWithinInterval(s, {
	      start: p,
	      end: i
	    });
	  } catch (e) {
	    o = !1;
	  }

	  return o;
	}

	function ot(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.minDate,
	      n = t.includeDates,
	      o = subMonths(e, 1);
	  return r && differenceInCalendarMonths(r, o) > 0 || n && n.every(function (e) {
	    return differenceInCalendarMonths(e, o) > 0;
	  }) || !1;
	}

	function at(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.maxDate,
	      n = t.includeDates,
	      o = addMonths(e, 1);
	  return r && differenceInCalendarMonths(o, r) > 0 || n && n.every(function (e) {
	    return differenceInCalendarMonths(o, e) > 0;
	  }) || !1;
	}

	function st(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.minDate,
	      n = t.includeDates,
	      o = subYears(e, 1);
	  return r && differenceInCalendarYears(r, o) > 0 || n && n.every(function (e) {
	    return differenceInCalendarYears(e, o) > 0;
	  }) || !1;
	}

	function pt(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	      r = t.maxDate,
	      n = t.includeDates,
	      o = addYears(e, 1);
	  return r && differenceInCalendarYears(o, r) > 0 || n && n.every(function (e) {
	    return differenceInCalendarYears(o, e) > 0;
	  }) || !1;
	}

	function it(e) {
	  var t = e.minDate,
	      r = e.includeDates;

	  if (r && t) {
	    var n = r.filter(function (e) {
	      return differenceInCalendarDays(e, t) >= 0;
	    });
	    return min(n);
	  }

	  return r ? min(r) : t;
	}

	function ct(e) {
	  var t = e.maxDate,
	      r = e.includeDates;

	  if (r && t) {
	    var n = r.filter(function (e) {
	      return differenceInCalendarDays(e, t) <= 0;
	    });
	    return max(n);
	  }

	  return r ? max(r) : t;
	}

	function lt() {
	  for (var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [], t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : "react-datepicker__day--highlighted", n = new Map(), o = 0, a = e.length; o < a; o++) {
	    var s = e[o];

	    if (isDate(s)) {
	      var p = Se(s, "MM.dd.yyyy"),
	          i = n.get(p) || [];
	      i.includes(t) || (i.push(t), n.set(p, i));
	    } else if ("object" === oe(s)) {
	      var c = Object.keys(s),
	          l = c[0],
	          d = s[c[0]];
	      if ("string" == typeof l && d.constructor === Array) for (var u = 0, h = d.length; u < h; u++) {
	        var m = Se(d[u], "MM.dd.yyyy"),
	            f = n.get(m) || [];
	        f.includes(l) || (f.push(l), n.set(m, f));
	      }
	    }
	  }

	  return n;
	}

	function dt(e, t, r, n, o) {
	  for (var p = o.length, i = [], c = 0; c < p; c++) {
	    var l = addMinutes(addHours(e, getHours(o[c])), getMinutes(o[c])),
	        d = addMinutes(e, (r + 1) * n);
	    isAfter(l, t) && isBefore(l, d) && i.push(o[c]);
	  }

	  return i;
	}

	function ut(e) {
	  return e < 10 ? "0".concat(e) : "".concat(e);
	}

	function ht(e) {
	  var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 12,
	      r = Math.ceil(getYear(e) / t) * t,
	      n = r - (t - 1);
	  return {
	    startPeriod: n,
	    endPeriod: r
	  };
	}

	function mt(e, t, r, n) {
	  for (var o = [], a = 0; a < 2 * t + 1; a++) {
	    var s = e + t - a,
	        p = !0;
	    r && (p = getYear(r) <= s), n && p && (p = getYear(n) >= s), p && o.push(s);
	  }

	  return o;
	}

	var ft = onClickOutsideHOC(function (r) {
	  ue(o, React__default.Component);
	  var n = ve(o);

	  function o(t) {
	    var r;
	    ae(this, o), ie(fe(r = n.call(this, t)), "renderOptions", function () {
	      var t = r.props.year,
	          n = r.state.yearsList.map(function (n) {
	        return /*#__PURE__*/React__default.createElement("div", {
	          className: t === n ? "react-datepicker__year-option react-datepicker__year-option--selected_year" : "react-datepicker__year-option",
	          key: n,
	          onClick: r.onChange.bind(fe(r), n)
	        }, t === n ? /*#__PURE__*/React__default.createElement("span", {
	          className: "react-datepicker__year-option--selected"
	        }, "✓") : "", n);
	      }),
	          o = r.props.minDate ? getYear(r.props.minDate) : null,
	          a = r.props.maxDate ? getYear(r.props.maxDate) : null;
	      return a && r.state.yearsList.find(function (e) {
	        return e === a;
	      }) || n.unshift( /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__year-option",
	        key: "upcoming",
	        onClick: r.incrementYears
	      }, /*#__PURE__*/React__default.createElement("a", {
	        className: "react-datepicker__navigation react-datepicker__navigation--years react-datepicker__navigation--years-upcoming"
	      }))), o && r.state.yearsList.find(function (e) {
	        return e === o;
	      }) || n.push( /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__year-option",
	        key: "previous",
	        onClick: r.decrementYears
	      }, /*#__PURE__*/React__default.createElement("a", {
	        className: "react-datepicker__navigation react-datepicker__navigation--years react-datepicker__navigation--years-previous"
	      }))), n;
	    }), ie(fe(r), "onChange", function (e) {
	      r.props.onChange(e);
	    }), ie(fe(r), "handleClickOutside", function () {
	      r.props.onCancel();
	    }), ie(fe(r), "shiftYears", function (e) {
	      var t = r.state.yearsList.map(function (t) {
	        return t + e;
	      });
	      r.setState({
	        yearsList: t
	      });
	    }), ie(fe(r), "incrementYears", function () {
	      return r.shiftYears(1);
	    }), ie(fe(r), "decrementYears", function () {
	      return r.shiftYears(-1);
	    });
	    var a = t.yearDropdownItemNumber,
	        s = t.scrollableYearDropdown,
	        p = a || (s ? 10 : 5);
	    return r.state = {
	      yearsList: mt(r.props.year, p, r.props.minDate, r.props.maxDate)
	    }, r;
	  }

	  return pe(o, [{
	    key: "render",
	    value: function () {
	      var r = classnames({
	        "react-datepicker__year-dropdown": !0,
	        "react-datepicker__year-dropdown--scrollable": this.props.scrollableYearDropdown
	      });
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: r
	      }, this.renderOptions());
	    }
	  }]), o;
	}()),
	    yt = function (t) {
	  ue(n, React__default.Component);
	  var r = ve(n);

	  function n() {
	    var t;
	    ae(this, n);

	    for (var o = arguments.length, a = new Array(o), s = 0; s < o; s++) a[s] = arguments[s];

	    return ie(fe(t = r.call.apply(r, [this].concat(a))), "state", {
	      dropdownVisible: !1
	    }), ie(fe(t), "renderSelectOptions", function () {
	      for (var r = t.props.minDate ? getYear(t.props.minDate) : 1900, n = t.props.maxDate ? getYear(t.props.maxDate) : 2100, o = [], a = r; a <= n; a++) o.push( /*#__PURE__*/React__default.createElement("option", {
	        key: a,
	        value: a
	      }, a));

	      return o;
	    }), ie(fe(t), "onSelectChange", function (e) {
	      t.onChange(e.target.value);
	    }), ie(fe(t), "renderSelectMode", function () {
	      return /*#__PURE__*/React__default.createElement("select", {
	        value: t.props.year,
	        className: "react-datepicker__year-select",
	        onChange: t.onSelectChange
	      }, t.renderSelectOptions());
	    }), ie(fe(t), "renderReadView", function (r) {
	      return /*#__PURE__*/React__default.createElement("div", {
	        key: "read",
	        style: {
	          visibility: r ? "visible" : "hidden"
	        },
	        className: "react-datepicker__year-read-view",
	        onClick: function (e) {
	          return t.toggleDropdown(e);
	        }
	      }, /*#__PURE__*/React__default.createElement("span", {
	        className: "react-datepicker__year-read-view--down-arrow"
	      }), /*#__PURE__*/React__default.createElement("span", {
	        className: "react-datepicker__year-read-view--selected-year"
	      }, t.props.year));
	    }), ie(fe(t), "renderDropdown", function () {
	      return /*#__PURE__*/React__default.createElement(ft, {
	        key: "dropdown",
	        year: t.props.year,
	        onChange: t.onChange,
	        onCancel: t.toggleDropdown,
	        minDate: t.props.minDate,
	        maxDate: t.props.maxDate,
	        scrollableYearDropdown: t.props.scrollableYearDropdown,
	        yearDropdownItemNumber: t.props.yearDropdownItemNumber
	      });
	    }), ie(fe(t), "renderScrollMode", function () {
	      var e = t.state.dropdownVisible,
	          r = [t.renderReadView(!e)];
	      return e && r.unshift(t.renderDropdown()), r;
	    }), ie(fe(t), "onChange", function (e) {
	      t.toggleDropdown(), e !== t.props.year && t.props.onChange(e);
	    }), ie(fe(t), "toggleDropdown", function (e) {
	      t.setState({
	        dropdownVisible: !t.state.dropdownVisible
	      }, function () {
	        t.props.adjustDateOnChange && t.handleYearChange(t.props.date, e);
	      });
	    }), ie(fe(t), "handleYearChange", function (e, r) {
	      t.onSelect(e, r), t.setOpen();
	    }), ie(fe(t), "onSelect", function (e, r) {
	      t.props.onSelect && t.props.onSelect(e, r);
	    }), ie(fe(t), "setOpen", function () {
	      t.props.setOpen && t.props.setOpen(!0);
	    }), t;
	  }

	  return pe(n, [{
	    key: "render",
	    value: function () {
	      var t;

	      switch (this.props.dropdownMode) {
	        case "scroll":
	          t = this.renderScrollMode();
	          break;

	        case "select":
	          t = this.renderSelectMode();
	      }

	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__year-dropdown-container react-datepicker__year-dropdown-container--".concat(this.props.dropdownMode)
	      }, t);
	    }
	  }]), n;
	}(),
	    vt = onClickOutsideHOC(function (t) {
	  ue(n, React__default.Component);
	  var r = ve(n);

	  function n() {
	    var t;
	    ae(this, n);

	    for (var o = arguments.length, a = new Array(o), s = 0; s < o; s++) a[s] = arguments[s];

	    return ie(fe(t = r.call.apply(r, [this].concat(a))), "renderOptions", function () {
	      return t.props.monthNames.map(function (r, n) {
	        return /*#__PURE__*/React__default.createElement("div", {
	          className: t.props.month === n ? "react-datepicker__month-option react-datepicker__month-option--selected_month" : "react-datepicker__month-option",
	          key: r,
	          onClick: t.onChange.bind(fe(t), n)
	        }, t.props.month === n ? /*#__PURE__*/React__default.createElement("span", {
	          className: "react-datepicker__month-option--selected"
	        }, "✓") : "", r);
	      });
	    }), ie(fe(t), "onChange", function (e) {
	      return t.props.onChange(e);
	    }), ie(fe(t), "handleClickOutside", function () {
	      return t.props.onCancel();
	    }), t;
	  }

	  return pe(n, [{
	    key: "render",
	    value: function () {
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__month-dropdown"
	      }, this.renderOptions());
	    }
	  }]), n;
	}()),
	    Dt = function (t) {
	  ue(n, React__default.Component);
	  var r = ve(n);

	  function n() {
	    var t;
	    ae(this, n);

	    for (var o = arguments.length, a = new Array(o), s = 0; s < o; s++) a[s] = arguments[s];

	    return ie(fe(t = r.call.apply(r, [this].concat(a))), "state", {
	      dropdownVisible: !1
	    }), ie(fe(t), "renderSelectOptions", function (t) {
	      return t.map(function (t, r) {
	        return /*#__PURE__*/React__default.createElement("option", {
	          key: r,
	          value: r
	        }, t);
	      });
	    }), ie(fe(t), "renderSelectMode", function (r) {
	      return /*#__PURE__*/React__default.createElement("select", {
	        value: t.props.month,
	        className: "react-datepicker__month-select",
	        onChange: function (e) {
	          return t.onChange(e.target.value);
	        }
	      }, t.renderSelectOptions(r));
	    }), ie(fe(t), "renderReadView", function (r, n) {
	      return /*#__PURE__*/React__default.createElement("div", {
	        key: "read",
	        style: {
	          visibility: r ? "visible" : "hidden"
	        },
	        className: "react-datepicker__month-read-view",
	        onClick: t.toggleDropdown
	      }, /*#__PURE__*/React__default.createElement("span", {
	        className: "react-datepicker__month-read-view--down-arrow"
	      }), /*#__PURE__*/React__default.createElement("span", {
	        className: "react-datepicker__month-read-view--selected-month"
	      }, n[t.props.month]));
	    }), ie(fe(t), "renderDropdown", function (r) {
	      return /*#__PURE__*/React__default.createElement(vt, {
	        key: "dropdown",
	        month: t.props.month,
	        monthNames: r,
	        onChange: t.onChange,
	        onCancel: t.toggleDropdown
	      });
	    }), ie(fe(t), "renderScrollMode", function (e) {
	      var r = t.state.dropdownVisible,
	          n = [t.renderReadView(!r, e)];
	      return r && n.unshift(t.renderDropdown(e)), n;
	    }), ie(fe(t), "onChange", function (e) {
	      t.toggleDropdown(), e !== t.props.month && t.props.onChange(e);
	    }), ie(fe(t), "toggleDropdown", function () {
	      return t.setState({
	        dropdownVisible: !t.state.dropdownVisible
	      });
	    }), t;
	  }

	  return pe(n, [{
	    key: "render",
	    value: function () {
	      var t,
	          r = this,
	          n = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11].map(this.props.useShortMonthInDropdown ? function (e) {
	        return Ve(e, r.props.locale);
	      } : function (e) {
	        return Qe(e, r.props.locale);
	      });

	      switch (this.props.dropdownMode) {
	        case "scroll":
	          t = this.renderScrollMode(n);
	          break;

	        case "select":
	          t = this.renderSelectMode(n);
	      }

	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__month-dropdown-container react-datepicker__month-dropdown-container--".concat(this.props.dropdownMode)
	      }, t);
	    }
	  }]), n;
	}();

	function wt(e, t) {
	  for (var r = [], n = xe(e), o = xe(t); !isAfter(n, o);) r.push(be(n)), n = addMonths(n, 1);

	  return r;
	}

	var kt = onClickOutsideHOC(function (r) {
	  ue(o, React__default.Component);
	  var n = ve(o);

	  function o(t) {
	    var r;
	    return ae(this, o), ie(fe(r = n.call(this, t)), "renderOptions", function () {
	      return r.state.monthYearsList.map(function (t) {
	        var n = getTime(t),
	            o = Ie(r.props.date, t) && Le(r.props.date, t);

	        return /*#__PURE__*/React__default.createElement("div", {
	          className: o ? "react-datepicker__month-year-option --selected_month-year" : "react-datepicker__month-year-option",
	          key: n,
	          onClick: r.onChange.bind(fe(r), n)
	        }, o ? /*#__PURE__*/React__default.createElement("span", {
	          className: "react-datepicker__month-year-option--selected"
	        }, "✓") : "", Se(t, r.props.dateFormat));
	      });
	    }), ie(fe(r), "onChange", function (e) {
	      return r.props.onChange(e);
	    }), ie(fe(r), "handleClickOutside", function () {
	      r.props.onCancel();
	    }), r.state = {
	      monthYearsList: wt(r.props.minDate, r.props.maxDate)
	    }, r;
	  }

	  return pe(o, [{
	    key: "render",
	    value: function () {
	      var r = classnames({
	        "react-datepicker__month-year-dropdown": !0,
	        "react-datepicker__month-year-dropdown--scrollable": this.props.scrollableMonthYearDropdown
	      });
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: r
	      }, this.renderOptions());
	    }
	  }]), o;
	}()),
	    gt = function (t) {
	  ue(n, React__default.Component);
	  var r = ve(n);

	  function n() {
	    var t;
	    ae(this, n);

	    for (var o = arguments.length, a = new Array(o), s = 0; s < o; s++) a[s] = arguments[s];

	    return ie(fe(t = r.call.apply(r, [this].concat(a))), "state", {
	      dropdownVisible: !1
	    }), ie(fe(t), "renderSelectOptions", function () {
	      for (var r = xe(t.props.minDate), n = xe(t.props.maxDate), o = []; !isAfter(r, n);) {
	        var a = getTime(r);

	        o.push( /*#__PURE__*/React__default.createElement("option", {
	          key: a,
	          value: a
	        }, Se(r, t.props.dateFormat, t.props.locale))), r = addMonths(r, 1);
	      }

	      return o;
	    }), ie(fe(t), "onSelectChange", function (e) {
	      t.onChange(e.target.value);
	    }), ie(fe(t), "renderSelectMode", function () {
	      return /*#__PURE__*/React__default.createElement("select", {
	        value: getTime(xe(t.props.date)),
	        className: "react-datepicker__month-year-select",
	        onChange: t.onSelectChange
	      }, t.renderSelectOptions());
	    }), ie(fe(t), "renderReadView", function (r) {
	      var n = Se(t.props.date, t.props.dateFormat, t.props.locale);
	      return /*#__PURE__*/React__default.createElement("div", {
	        key: "read",
	        style: {
	          visibility: r ? "visible" : "hidden"
	        },
	        className: "react-datepicker__month-year-read-view",
	        onClick: function (e) {
	          return t.toggleDropdown(e);
	        }
	      }, /*#__PURE__*/React__default.createElement("span", {
	        className: "react-datepicker__month-year-read-view--down-arrow"
	      }), /*#__PURE__*/React__default.createElement("span", {
	        className: "react-datepicker__month-year-read-view--selected-month-year"
	      }, n));
	    }), ie(fe(t), "renderDropdown", function () {
	      return /*#__PURE__*/React__default.createElement(kt, {
	        key: "dropdown",
	        date: t.props.date,
	        dateFormat: t.props.dateFormat,
	        onChange: t.onChange,
	        onCancel: t.toggleDropdown,
	        minDate: t.props.minDate,
	        maxDate: t.props.maxDate,
	        scrollableMonthYearDropdown: t.props.scrollableMonthYearDropdown
	      });
	    }), ie(fe(t), "renderScrollMode", function () {
	      var e = t.state.dropdownVisible,
	          r = [t.renderReadView(!e)];
	      return e && r.unshift(t.renderDropdown()), r;
	    }), ie(fe(t), "onChange", function (e) {
	      t.toggleDropdown();
	      var r = be(parseInt(e));
	      Ie(t.props.date, r) && Le(t.props.date, r) || t.props.onChange(r);
	    }), ie(fe(t), "toggleDropdown", function () {
	      return t.setState({
	        dropdownVisible: !t.state.dropdownVisible
	      });
	    }), t;
	  }

	  return pe(n, [{
	    key: "render",
	    value: function () {
	      var t;

	      switch (this.props.dropdownMode) {
	        case "scroll":
	          t = this.renderScrollMode();
	          break;

	        case "select":
	          t = this.renderSelectMode();
	      }

	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__month-year-dropdown-container react-datepicker__month-year-dropdown-container--".concat(this.props.dropdownMode)
	      }, t);
	    }
	  }]), n;
	}(),
	    bt = function (r) {
	  ue(o, React__default.Component);
	  var n = ve(o);

	  function o() {
	    var r;
	    ae(this, o);

	    for (var a = arguments.length, s = new Array(a), p = 0; p < a; p++) s[p] = arguments[p];

	    return ie(fe(r = n.call.apply(n, [this].concat(s))), "dayEl", /*#__PURE__*/React__default.createRef()), ie(fe(r), "handleClick", function (e) {
	      !r.isDisabled() && r.props.onClick && r.props.onClick(e);
	    }), ie(fe(r), "handleMouseEnter", function (e) {
	      !r.isDisabled() && r.props.onMouseEnter && r.props.onMouseEnter(e);
	    }), ie(fe(r), "handleOnKeyDown", function (e) {
	      " " === e.key && (e.preventDefault(), e.key = "Enter"), r.props.handleOnKeyDown(e);
	    }), ie(fe(r), "isSameDay", function (e) {
	      return Fe(r.props.day, e);
	    }), ie(fe(r), "isKeyboardSelected", function () {
	      return !r.props.disabledKeyboardNavigation && !r.isSameDay(r.props.selected) && r.isSameDay(r.props.preSelection);
	    }), ie(fe(r), "isDisabled", function () {
	      return Ue(r.props.day, r.props);
	    }), ie(fe(r), "isExcluded", function () {
	      return $e(r.props.day, r.props);
	    }), ie(fe(r), "getHighLightedClass", function (e) {
	      var t = r.props,
	          n = t.day,
	          o = t.highlightDates;
	      if (!o) return !1;
	      var a = Se(n, "MM.dd.yyyy");
	      return o.get(a);
	    }), ie(fe(r), "isInRange", function () {
	      var e = r.props,
	          t = e.day,
	          n = e.startDate,
	          o = e.endDate;
	      return !(!n || !o) && We(t, n, o);
	    }), ie(fe(r), "isInSelectingRange", function () {
	      var e = r.props,
	          t = e.day,
	          n = e.selectsStart,
	          o = e.selectsEnd,
	          a = e.selectsRange,
	          s = e.selectingDate,
	          p = e.startDate,
	          i = e.endDate;
	      return !(!(n || o || a) || !s || r.isDisabled()) && (n && i && (isBefore(s, i) || Ae(s, i)) ? We(t, s, i) : (o && p && (isAfter(s, p) || Ae(s, p)) || !(!a || !p || i || !isAfter(s, p) && !Ae(s, p))) && We(t, p, s));
	    }), ie(fe(r), "isSelectingRangeStart", function () {
	      if (!r.isInSelectingRange()) return !1;
	      var e = r.props,
	          t = e.day,
	          n = e.selectingDate,
	          o = e.startDate;
	      return Fe(t, e.selectsStart ? n : o);
	    }), ie(fe(r), "isSelectingRangeEnd", function () {
	      if (!r.isInSelectingRange()) return !1;
	      var e = r.props,
	          t = e.day,
	          n = e.selectingDate,
	          o = e.endDate;
	      return Fe(t, e.selectsEnd ? n : o);
	    }), ie(fe(r), "isRangeStart", function () {
	      var e = r.props,
	          t = e.day,
	          n = e.startDate,
	          o = e.endDate;
	      return !(!n || !o) && Fe(n, t);
	    }), ie(fe(r), "isRangeEnd", function () {
	      var e = r.props,
	          t = e.day,
	          n = e.startDate,
	          o = e.endDate;
	      return !(!n || !o) && Fe(o, t);
	    }), ie(fe(r), "isWeekend", function () {
	      var e = getDay(r.props.day);
	      return 0 === e || 6 === e;
	    }), ie(fe(r), "isOutsideMonth", function () {
	      return void 0 !== r.props.month && r.props.month !== getMonth(r.props.day);
	    }), ie(fe(r), "getClassNames", function (e) {
	      var n = r.props.dayClassName ? r.props.dayClassName(e) : void 0;
	      return classnames("react-datepicker__day", n, "react-datepicker__day--" + Ee(r.props.day), {
	        "react-datepicker__day--disabled": r.isDisabled(),
	        "react-datepicker__day--excluded": r.isExcluded(),
	        "react-datepicker__day--selected": r.isSameDay(r.props.selected),
	        "react-datepicker__day--keyboard-selected": r.isKeyboardSelected(),
	        "react-datepicker__day--range-start": r.isRangeStart(),
	        "react-datepicker__day--range-end": r.isRangeEnd(),
	        "react-datepicker__day--in-range": r.isInRange(),
	        "react-datepicker__day--in-selecting-range": r.isInSelectingRange(),
	        "react-datepicker__day--selecting-range-start": r.isSelectingRangeStart(),
	        "react-datepicker__day--selecting-range-end": r.isSelectingRangeEnd(),
	        "react-datepicker__day--today": r.isSameDay(be()),
	        "react-datepicker__day--weekend": r.isWeekend(),
	        "react-datepicker__day--outside-month": r.isOutsideMonth()
	      }, r.getHighLightedClass("react-datepicker__day--highlighted"));
	    }), ie(fe(r), "getAriaLabel", function () {
	      var e = r.props,
	          t = e.day,
	          n = e.ariaLabelPrefixWhenEnabled,
	          o = void 0 === n ? "Choose" : n,
	          a = e.ariaLabelPrefixWhenDisabled,
	          s = void 0 === a ? "Not available" : a,
	          p = r.isDisabled() || r.isExcluded() ? s : o;
	      return "".concat(p, " ").concat(Se(t, "PPPP"));
	    }), ie(fe(r), "getTabIndex", function (e, t) {
	      var n = e || r.props.selected,
	          o = t || r.props.preSelection;
	      return r.isKeyboardSelected() || r.isSameDay(n) && Fe(o, n) ? 0 : -1;
	    }), ie(fe(r), "handleFocusDay", function () {
	      var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {},
	          t = !1;
	      0 === r.getTabIndex() && !e.isInputFocused && r.isSameDay(r.props.preSelection) && (document.activeElement && document.activeElement !== document.body || r.props.inline || (t = !0), r.props.containerRef && r.props.containerRef.current && r.props.containerRef.current.contains(document.activeElement) && document.activeElement.classList.contains("react-datepicker__day") && (t = !0)), t && r.dayEl.current.focus({
	        preventScroll: !0
	      });
	    }), ie(fe(r), "renderDayContents", function () {
	      if (r.isOutsideMonth()) {
	        if (r.props.monthShowsDuplicateDaysEnd && getDate(r.props.day) < 10) return null;
	        if (r.props.monthShowsDuplicateDaysStart && getDate(r.props.day) > 20) return null;
	      }

	      return r.props.renderDayContents ? r.props.renderDayContents(getDate(r.props.day), r.props.day) : getDate(r.props.day);
	    }), ie(fe(r), "render", function () {
	      return /*#__PURE__*/React__default.createElement("div", {
	        ref: r.dayEl,
	        className: r.getClassNames(r.props.day),
	        onKeyDown: r.handleOnKeyDown,
	        onClick: r.handleClick,
	        onMouseEnter: r.handleMouseEnter,
	        tabIndex: r.getTabIndex(),
	        "aria-label": r.getAriaLabel(),
	        role: "button",
	        "aria-disabled": r.isDisabled()
	      }, r.renderDayContents());
	    }), r;
	  }

	  return pe(o, [{
	    key: "componentDidMount",
	    value: function () {
	      this.handleFocusDay();
	    }
	  }, {
	    key: "componentDidUpdate",
	    value: function (e) {
	      this.handleFocusDay(e);
	    }
	  }]), o;
	}(),
	    Ct = function (r) {
	  ue(o, React__default.Component);
	  var n = ve(o);

	  function o() {
	    var e;
	    ae(this, o);

	    for (var t = arguments.length, r = new Array(t), a = 0; a < t; a++) r[a] = arguments[a];

	    return ie(fe(e = n.call.apply(n, [this].concat(r))), "handleClick", function (t) {
	      e.props.onClick && e.props.onClick(t);
	    }), e;
	  }

	  return pe(o, [{
	    key: "render",
	    value: function () {
	      var r = this.props,
	          n = r.weekNumber,
	          o = r.ariaLabelPrefix,
	          a = void 0 === o ? "week " : o,
	          s = {
	        "react-datepicker__week-number": !0,
	        "react-datepicker__week-number--clickable": !!r.onClick
	      };
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: classnames(s),
	        "aria-label": "".concat(a, " ").concat(this.props.weekNumber),
	        onClick: this.handleClick
	      }, n);
	    }
	  }]), o;
	}(),
	    _t = function (t) {
	  ue(n, React__default.Component);
	  var r = ve(n);

	  function n() {
	    var t;
	    ae(this, n);

	    for (var o = arguments.length, a = new Array(o), s = 0; s < o; s++) a[s] = arguments[s];

	    return ie(fe(t = r.call.apply(r, [this].concat(a))), "handleDayClick", function (e, r) {
	      t.props.onDayClick && t.props.onDayClick(e, r);
	    }), ie(fe(t), "handleDayMouseEnter", function (e) {
	      t.props.onDayMouseEnter && t.props.onDayMouseEnter(e);
	    }), ie(fe(t), "handleWeekClick", function (e, r, n) {
	      "function" == typeof t.props.onWeekSelect && t.props.onWeekSelect(e, r, n), t.props.shouldCloseOnSelect && t.props.setOpen(!1);
	    }), ie(fe(t), "formatWeekNumber", function (e) {
	      return t.props.formatWeekNumber ? t.props.formatWeekNumber(e) : Pe(e, t.props.locale);
	    }), ie(fe(t), "renderDays", function () {
	      var r = Oe(t.props.day, t.props.locale),
	          n = [],
	          o = t.formatWeekNumber(r);

	      if (t.props.showWeekNumber) {
	        var a = t.props.onWeekSelect ? t.handleWeekClick.bind(fe(t), r, o) : void 0;
	        n.push( /*#__PURE__*/React__default.createElement(Ct, {
	          key: "W",
	          weekNumber: o,
	          onClick: a,
	          ariaLabelPrefix: t.props.ariaLabelPrefix
	        }));
	      }

	      return n.concat([0, 1, 2, 3, 4, 5, 6].map(function (n) {
	        var o = addDays(r, n);
	        return /*#__PURE__*/React__default.createElement(bt, {
	          ariaLabelPrefixWhenEnabled: t.props.chooseDayAriaLabelPrefix,
	          ariaLabelPrefixWhenDisabled: t.props.disabledDayAriaLabelPrefix,
	          key: o.valueOf(),
	          day: o,
	          month: t.props.month,
	          onClick: t.handleDayClick.bind(fe(t), o),
	          onMouseEnter: t.handleDayMouseEnter.bind(fe(t), o),
	          minDate: t.props.minDate,
	          maxDate: t.props.maxDate,
	          excludeDates: t.props.excludeDates,
	          includeDates: t.props.includeDates,
	          highlightDates: t.props.highlightDates,
	          selectingDate: t.props.selectingDate,
	          filterDate: t.props.filterDate,
	          preSelection: t.props.preSelection,
	          selected: t.props.selected,
	          selectsStart: t.props.selectsStart,
	          selectsEnd: t.props.selectsEnd,
	          selectsRange: t.props.selectsRange,
	          startDate: t.props.startDate,
	          endDate: t.props.endDate,
	          dayClassName: t.props.dayClassName,
	          renderDayContents: t.props.renderDayContents,
	          disabledKeyboardNavigation: t.props.disabledKeyboardNavigation,
	          handleOnKeyDown: t.props.handleOnKeyDown,
	          isInputFocused: t.props.isInputFocused,
	          containerRef: t.props.containerRef,
	          inline: t.props.inline,
	          monthShowsDuplicateDaysEnd: t.props.monthShowsDuplicateDaysEnd,
	          monthShowsDuplicateDaysStart: t.props.monthShowsDuplicateDaysStart
	        });
	      }));
	    }), t;
	  }

	  return pe(n, [{
	    key: "render",
	    value: function () {
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__week"
	      }, this.renderDays());
	    }
	  }], [{
	    key: "defaultProps",
	    get: function () {
	      return {
	        shouldCloseOnSelect: !0
	      };
	    }
	  }]), n;
	}(),
	    St = function (r) {
	  ue(o, React__default.Component);
	  var n = ve(o);

	  function o() {
	    var r;
	    ae(this, o);

	    for (var a = arguments.length, s = new Array(a), l = 0; l < a; l++) s[l] = arguments[l];

	    return ie(fe(r = n.call.apply(n, [this].concat(s))), "MONTH_REFS", Array(12).fill().map(function () {
	      return /*#__PURE__*/React__default.createRef();
	    })), ie(fe(r), "isDisabled", function (e) {
	      return Ue(e, r.props);
	    }), ie(fe(r), "isExcluded", function (e) {
	      return $e(e, r.props);
	    }), ie(fe(r), "handleDayClick", function (e, t) {
	      r.props.onDayClick && r.props.onDayClick(e, t, r.props.orderInDisplay);
	    }), ie(fe(r), "handleDayMouseEnter", function (e) {
	      r.props.onDayMouseEnter && r.props.onDayMouseEnter(e);
	    }), ie(fe(r), "handleMouseLeave", function () {
	      r.props.onMouseLeave && r.props.onMouseLeave();
	    }), ie(fe(r), "isRangeStartMonth", function (e) {
	      var t = r.props,
	          n = t.day,
	          o = t.startDate,
	          a = t.endDate;
	      return !(!o || !a) && Le(setMonth(n, e), o);
	    }), ie(fe(r), "isRangeStartQuarter", function (e) {
	      var t = r.props,
	          n = t.day,
	          o = t.startDate,
	          a = t.endDate;
	      return !(!o || !a) && Re(setQuarter(n, e), o);
	    }), ie(fe(r), "isRangeEndMonth", function (e) {
	      var t = r.props,
	          n = t.day,
	          o = t.startDate,
	          a = t.endDate;
	      return !(!o || !a) && Le(setMonth(n, e), a);
	    }), ie(fe(r), "isRangeEndQuarter", function (e) {
	      var t = r.props,
	          n = t.day,
	          o = t.startDate,
	          a = t.endDate;
	      return !(!o || !a) && Re(setQuarter(n, e), a);
	    }), ie(fe(r), "isWeekInMonth", function (e) {
	      var t = r.props.day,
	          n = addDays(e, 6);
	      return Le(e, t) || Le(n, t);
	    }), ie(fe(r), "renderWeeks", function () {
	      for (var t = [], n = r.props.fixedHeight, o = Oe(xe(r.props.day), r.props.locale), a = 0, s = !1; t.push( /*#__PURE__*/React__default.createElement(_t, {
	        ariaLabelPrefix: r.props.weekAriaLabelPrefix,
	        chooseDayAriaLabelPrefix: r.props.chooseDayAriaLabelPrefix,
	        disabledDayAriaLabelPrefix: r.props.disabledDayAriaLabelPrefix,
	        key: a,
	        day: o,
	        month: getMonth(r.props.day),
	        onDayClick: r.handleDayClick,
	        onDayMouseEnter: r.handleDayMouseEnter,
	        onWeekSelect: r.props.onWeekSelect,
	        formatWeekNumber: r.props.formatWeekNumber,
	        locale: r.props.locale,
	        minDate: r.props.minDate,
	        maxDate: r.props.maxDate,
	        excludeDates: r.props.excludeDates,
	        includeDates: r.props.includeDates,
	        inline: r.props.inline,
	        highlightDates: r.props.highlightDates,
	        selectingDate: r.props.selectingDate,
	        filterDate: r.props.filterDate,
	        preSelection: r.props.preSelection,
	        selected: r.props.selected,
	        selectsStart: r.props.selectsStart,
	        selectsEnd: r.props.selectsEnd,
	        selectsRange: r.props.selectsRange,
	        showWeekNumber: r.props.showWeekNumbers,
	        startDate: r.props.startDate,
	        endDate: r.props.endDate,
	        dayClassName: r.props.dayClassName,
	        setOpen: r.props.setOpen,
	        shouldCloseOnSelect: r.props.shouldCloseOnSelect,
	        disabledKeyboardNavigation: r.props.disabledKeyboardNavigation,
	        renderDayContents: r.props.renderDayContents,
	        handleOnKeyDown: r.props.handleOnKeyDown,
	        isInputFocused: r.props.isInputFocused,
	        containerRef: r.props.containerRef,
	        monthShowsDuplicateDaysEnd: r.props.monthShowsDuplicateDaysEnd,
	        monthShowsDuplicateDaysStart: r.props.monthShowsDuplicateDaysStart
	      })), !s;) {
	        a++, o = addWeeks(o, 1);
	        var p = n && a >= 6,
	            c = !n && !r.isWeekInMonth(o);

	        if (p || c) {
	          if (!r.props.peekNextMonth) break;
	          s = !0;
	        }
	      }

	      return t;
	    }), ie(fe(r), "onMonthClick", function (e, t) {
	      r.handleDayClick(xe(setMonth(r.props.day, t)), e);
	    }), ie(fe(r), "handleMonthNavigation", function (e, t) {
	      r.isDisabled(t) || r.isExcluded(t) || (r.props.setPreSelection(t), r.MONTH_REFS[e].current && r.MONTH_REFS[e].current.focus());
	    }), ie(fe(r), "onMonthKeyDown", function (e, t) {
	      var n = e.key;
	      if (!r.props.disabledKeyboardNavigation) switch (n) {
	        case "Enter":
	          r.onMonthClick(e, t), r.props.setPreSelection(r.props.selected);
	          break;

	        case "ArrowRight":
	          r.handleMonthNavigation(11 === t ? 0 : t + 1, addMonths(r.props.preSelection, 1));
	          break;

	        case "ArrowLeft":
	          r.handleMonthNavigation(0 === t ? 11 : t - 1, subMonths(r.props.preSelection, 1));
	      }
	    }), ie(fe(r), "onQuarterClick", function (e, t) {
	      r.handleDayClick(Ye(setQuarter(r.props.day, t)), e);
	    }), ie(fe(r), "getMonthClassNames", function (e) {
	      var n = r.props,
	          o = n.day,
	          a = n.startDate,
	          s = n.endDate,
	          p = n.selected,
	          i = n.minDate,
	          c = n.maxDate,
	          l = n.preSelection;
	      return classnames("react-datepicker__month-text", "react-datepicker__month-".concat(e), {
	        "react-datepicker__month--disabled": (i || c) && ze(setMonth(o, e), r.props),
	        "react-datepicker__month--selected": getMonth(o) === e && getYear(o) === getYear(p),
	        "react-datepicker__month-text--keyboard-selected": getMonth(l) === e,
	        "react-datepicker__month--in-range": Ge(a, s, e, o),
	        "react-datepicker__month--range-start": r.isRangeStartMonth(e),
	        "react-datepicker__month--range-end": r.isRangeEndMonth(e)
	      });
	    }), ie(fe(r), "getTabIndex", function (e) {
	      var t = getMonth(r.props.preSelection);
	      return r.props.disabledKeyboardNavigation || e !== t ? "-1" : "0";
	    }), ie(fe(r), "getAriaLabel", function (e) {
	      var t = r.props,
	          n = t.ariaLabelPrefix,
	          o = void 0 === n ? "Choose" : n,
	          a = t.disabledDayAriaLabelPrefix,
	          s = void 0 === a ? "Not available" : a,
	          p = t.day,
	          i = setMonth(p, e),
	          c = r.isDisabled(i) || r.isExcluded(i) ? s : o;
	      return "".concat(c, " ").concat(Se(i, "MMMM yyyy"));
	    }), ie(fe(r), "getQuarterClassNames", function (e) {
	      var n = r.props,
	          o = n.day,
	          a = n.startDate,
	          s = n.endDate,
	          p = n.selected,
	          i = n.minDate,
	          c = n.maxDate;
	      return classnames("react-datepicker__quarter-text", "react-datepicker__quarter-".concat(e), {
	        "react-datepicker__quarter--disabled": (i || c) && Je(setQuarter(o, e), r.props),
	        "react-datepicker__quarter--selected": getQuarter(o) === e && getYear(o) === getYear(p),
	        "react-datepicker__quarter--in-range": Ze(a, s, e, o),
	        "react-datepicker__quarter--range-start": r.isRangeStartQuarter(e),
	        "react-datepicker__quarter--range-end": r.isRangeEndQuarter(e)
	      });
	    }), ie(fe(r), "renderMonths", function () {
	      var t = r.props,
	          n = t.showFullMonthYearPicker,
	          o = t.showTwoColumnMonthYearPicker,
	          a = t.locale;
	      return (o ? [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9], [10, 11]] : [[0, 1, 2], [3, 4, 5], [6, 7, 8], [9, 10, 11]]).map(function (t, o) {
	        return /*#__PURE__*/React__default.createElement("div", {
	          className: "react-datepicker__month-wrapper",
	          key: o
	        }, t.map(function (t, o) {
	          return /*#__PURE__*/React__default.createElement("div", {
	            ref: r.MONTH_REFS[t],
	            key: o,
	            onClick: function (e) {
	              r.onMonthClick(e, t);
	            },
	            onKeyDown: function (e) {
	              r.onMonthKeyDown(e, t);
	            },
	            tabIndex: r.getTabIndex(t),
	            className: r.getMonthClassNames(t),
	            role: "button",
	            "aria-label": r.getAriaLabel(t)
	          }, n ? Qe(t, a) : Ve(t, a));
	        }));
	      });
	    }), ie(fe(r), "renderQuarters", function () {
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__quarter-wrapper"
	      }, [1, 2, 3, 4].map(function (t, n) {
	        return /*#__PURE__*/React__default.createElement("div", {
	          key: n,
	          onClick: function (e) {
	            r.onQuarterClick(e, t);
	          },
	          className: r.getQuarterClassNames(t)
	        }, qe(t, r.props.locale));
	      }));
	    }), ie(fe(r), "getClassNames", function () {
	      var e = r.props,
	          n = e.day,
	          o = e.selectingDate,
	          a = e.selectsStart,
	          s = e.selectsEnd,
	          p = e.showMonthYearPicker,
	          i = e.showQuarterYearPicker,
	          c = e.monthClassName,
	          l = c ? c(n) : void 0;
	      return classnames("react-datepicker__month", l, {
	        "react-datepicker__month--selecting-range": o && (a || s)
	      }, {
	        "react-datepicker__monthPicker": p
	      }, {
	        "react-datepicker__quarterPicker": i
	      });
	    }), r;
	  }

	  return pe(o, [{
	    key: "render",
	    value: function () {
	      var t = this.props,
	          r = t.showMonthYearPicker,
	          n = t.showQuarterYearPicker,
	          o = t.day,
	          a = t.ariaLabelPrefix,
	          s = void 0 === a ? "month " : a;
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: this.getClassNames(),
	        onMouseLeave: this.handleMouseLeave,
	        "aria-label": "".concat(s, " ").concat(Se(o, "yyyy-MM"))
	      }, r ? this.renderMonths() : n ? this.renderQuarters() : this.renderWeeks());
	    }
	  }]), o;
	}(),
	    Mt = function (t) {
	  ue(n, React__default.Component);
	  var r = ve(n);

	  function n() {
	    var t;
	    ae(this, n);

	    for (var o = arguments.length, s = new Array(o), p = 0; p < o; p++) s[p] = arguments[p];

	    return ie(fe(t = r.call.apply(r, [this].concat(s))), "state", {
	      height: null
	    }), ie(fe(t), "handleClick", function (e) {
	      (t.props.minTime || t.props.maxTime) && nt(e, t.props) || (t.props.excludeTimes || t.props.includeTimes || t.props.filterTime) && rt(e, t.props) || t.props.onChange(e);
	    }), ie(fe(t), "liClasses", function (e, r, n) {
	      var o = ["react-datepicker__time-list-item", t.props.timeClassName ? t.props.timeClassName(e, r, n) : void 0];
	      return t.props.selected && r === getHours(e) && n === getMinutes(e) && o.push("react-datepicker__time-list-item--selected"), ((t.props.minTime || t.props.maxTime) && nt(e, t.props) || (t.props.excludeTimes || t.props.includeTimes || t.props.filterTime) && rt(e, t.props)) && o.push("react-datepicker__time-list-item--disabled"), t.props.injectTimes && (60 * getHours(e) + getMinutes(e)) % t.props.intervals != 0 && o.push("react-datepicker__time-list-item--injected"), o.join(" ");
	    }), ie(fe(t), "renderTimes", function () {
	      for (var r = [], n = t.props.format ? t.props.format : "p", o = t.props.intervals, s = Ne(be()), p = 1440 / o, i = t.props.injectTimes && t.props.injectTimes.sort(function (e, t) {
	        return e - t;
	      }), c = t.props.selected || t.props.openToDate || be(), l = getHours(c), d = getMinutes(c), u = setHours(setMinutes(s, d), l), h = 0; h < p; h++) {
	        var m = addMinutes(s, h * o);

	        if (r.push(m), i) {
	          var f = dt(s, m, h, o, i);
	          r = r.concat(f);
	        }
	      }

	      return r.map(function (r, o) {
	        return /*#__PURE__*/React__default.createElement("li", {
	          key: o,
	          onClick: t.handleClick.bind(fe(t), r),
	          className: t.liClasses(r, l, d),
	          ref: function (e) {
	            (isBefore(r, u) || Ae(r, u)) && (t.centerLi = e);
	          }
	        }, Se(r, n, t.props.locale));
	      });
	    }), t;
	  }

	  return pe(n, [{
	    key: "componentDidMount",
	    value: function () {
	      this.list.scrollTop = n.calcCenterPosition(this.props.monthRef ? this.props.monthRef.clientHeight - this.header.clientHeight : this.list.clientHeight, this.centerLi), this.props.monthRef && this.header && this.setState({
	        height: this.props.monthRef.clientHeight - this.header.clientHeight
	      });
	    }
	  }, {
	    key: "render",
	    value: function () {
	      var t = this,
	          r = this.state.height;
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__time-container ".concat(this.props.todayButton ? "react-datepicker__time-container--with-today-button" : "")
	      }, /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__header react-datepicker__header--time ".concat(this.props.showTimeSelectOnly ? "react-datepicker__header--time--only" : ""),
	        ref: function (e) {
	          t.header = e;
	        }
	      }, /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker-time__header"
	      }, this.props.timeCaption)), /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__time"
	      }, /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__time-box"
	      }, /*#__PURE__*/React__default.createElement("ul", {
	        className: "react-datepicker__time-list",
	        ref: function (e) {
	          t.list = e;
	        },
	        style: r ? {
	          height: r
	        } : {}
	      }, this.renderTimes()))));
	    }
	  }], [{
	    key: "defaultProps",
	    get: function () {
	      return {
	        intervals: 30,
	        onTimeChange: function () {},
	        todayButton: null,
	        timeCaption: "Time"
	      };
	    }
	  }]), n;
	}();

	ie(Mt, "calcCenterPosition", function (e, t) {
	  return t.offsetTop - (e / 2 - t.clientHeight / 2);
	});

	var Pt = function (r) {
	  ue(o, React__default.Component);
	  var n = ve(o);

	  function o(e) {
	    var r;
	    return ae(this, o), ie(fe(r = n.call(this, e)), "handleYearClick", function (e, t) {
	      r.props.onDayClick && r.props.onDayClick(e, t);
	    }), ie(fe(r), "isSameDay", function (e, t) {
	      return Fe(e, t);
	    }), ie(fe(r), "isKeyboardSelected", function (e) {
	      var t = Te(setYear(r.props.date, e));
	      return !r.props.disabledKeyboardNavigation && !r.props.inline && !Fe(t, Te(r.props.selected)) && Fe(t, Te(r.props.preSelection));
	    }), ie(fe(r), "onYearClick", function (e, t) {
	      var n = r.props.date;
	      r.handleYearClick(Te(setYear(n, t)), e);
	    }), ie(fe(r), "getYearClassNames", function (e) {
	      var n = r.props,
	          o = n.minDate,
	          a = n.maxDate,
	          s = n.selected;
	      return classnames("react-datepicker__year-text", {
	        "react-datepicker__year-text--selected": e === getYear(s),
	        "react-datepicker__year-text--disabled": (o || a) && Xe(e, r.props),
	        "react-datepicker__year-text--keyboard-selected": r.isKeyboardSelected(e),
	        "react-datepicker__year-text--today": e === getYear(be())
	      });
	    }), r;
	  }

	  return pe(o, [{
	    key: "render",
	    value: function () {
	      for (var t = this, r = [], n = this.props, o = ht(n.date, n.yearItemNumber), a = o.startPeriod, s = o.endPeriod, p = function (n) {
	        r.push( /*#__PURE__*/React__default.createElement("div", {
	          onClick: function (e) {
	            t.onYearClick(e, n);
	          },
	          className: t.getYearClassNames(n),
	          key: n
	        }, n));
	      }, i = a; i <= s; i++) p(i);

	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__year"
	      }, /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__year-wrapper"
	      }, r));
	    }
	  }]), o;
	}(),
	    Et = function (t) {
	  ue(n, React__default.Component);
	  var r = ve(n);

	  function n(t) {
	    var o;
	    return ae(this, n), ie(fe(o = r.call(this, t)), "onTimeChange", function (e) {
	      o.setState({
	        time: e
	      });
	      var t = new Date();
	      t.setHours(e.split(":")[0]), t.setMinutes(e.split(":")[1]), o.props.onChange(t);
	    }), ie(fe(o), "renderTimeInput", function () {
	      var t = o.state.time,
	          r = o.props,
	          n = r.date,
	          a = r.timeString,
	          s = r.customTimeInput;
	      return s ? /*#__PURE__*/React__default.cloneElement(s, {
	        date: n,
	        value: t,
	        onChange: o.onTimeChange
	      }) : /*#__PURE__*/React__default.createElement("input", {
	        type: "time",
	        className: "react-datepicker-time__input",
	        placeholder: "Time",
	        name: "time-input",
	        required: !0,
	        value: t,
	        onChange: function (e) {
	          o.onTimeChange(e.target.value || a);
	        }
	      });
	    }), o.state = {
	      time: o.props.timeString
	    }, o;
	  }

	  return pe(n, [{
	    key: "render",
	    value: function () {
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__input-time-container"
	      }, /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker-time__caption"
	      }, this.props.timeInputLabel), /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker-time__input-container"
	      }, /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker-time__input"
	      }, this.renderTimeInput())));
	    }
	  }]), n;
	}();

	function Nt(t) {
	  var r = t.className,
	      n = t.children,
	      o = t.showPopperArrow,
	      a = t.arrowProps,
	      s = void 0 === a ? {} : a;
	  return /*#__PURE__*/React__default.createElement("div", {
	    className: r
	  }, o && /*#__PURE__*/React__default.createElement("div", ce({
	    className: "react-datepicker__triangle"
	  }, s)), n);
	}

	var Ot = ["react-datepicker__year-select", "react-datepicker__month-select", "react-datepicker__month-year-select"],
	    xt = function (r) {
	  ue(o, React__default.Component);
	  var n = ve(o);

	  function o(r) {
	    var a;
	    return ae(this, o), ie(fe(a = n.call(this, r)), "handleClickOutside", function (e) {
	      a.props.onClickOutside(e);
	    }), ie(fe(a), "setClickOutsideRef", function () {
	      return a.containerRef.current;
	    }), ie(fe(a), "handleDropdownFocus", function (e) {
	      (function () {
	        var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {},
	            t = (e.className || "").split(/\s+/);
	        return Ot.some(function (e) {
	          return t.indexOf(e) >= 0;
	        });
	      })(e.target) && a.props.onDropdownFocus();
	    }), ie(fe(a), "getDateInView", function () {
	      var e = a.props,
	          t = e.preSelection,
	          r = e.selected,
	          n = e.openToDate,
	          o = it(a.props),
	          s = ct(a.props),
	          p = be(),
	          i = n || r || t;
	      return i || (o && isBefore(p, o) ? o : s && isAfter(p, s) ? s : p);
	    }), ie(fe(a), "increaseMonth", function () {
	      a.setState(function (e) {
	        var t = e.date;
	        return {
	          date: addMonths(t, 1)
	        };
	      }, function () {
	        return a.handleMonthChange(a.state.date);
	      });
	    }), ie(fe(a), "decreaseMonth", function () {
	      a.setState(function (e) {
	        var t = e.date;
	        return {
	          date: subMonths(t, 1)
	        };
	      }, function () {
	        return a.handleMonthChange(a.state.date);
	      });
	    }), ie(fe(a), "handleDayClick", function (e, t, r) {
	      a.props.onSelect(e, t, r), a.props.setPreSelection && a.props.setPreSelection(e);
	    }), ie(fe(a), "handleDayMouseEnter", function (e) {
	      a.setState({
	        selectingDate: e
	      }), a.props.onDayMouseEnter && a.props.onDayMouseEnter(e);
	    }), ie(fe(a), "handleMonthMouseLeave", function () {
	      a.setState({
	        selectingDate: null
	      }), a.props.onMonthMouseLeave && a.props.onMonthMouseLeave();
	    }), ie(fe(a), "handleYearChange", function (e) {
	      a.props.onYearChange && a.props.onYearChange(e), a.props.adjustDateOnChange && (a.props.onSelect && a.props.onSelect(e), a.props.setOpen && a.props.setOpen(!0)), a.props.setPreSelection && a.props.setPreSelection(e);
	    }), ie(fe(a), "handleMonthChange", function (e) {
	      a.props.onMonthChange && a.props.onMonthChange(e), a.props.adjustDateOnChange && (a.props.onSelect && a.props.onSelect(e), a.props.setOpen && a.props.setOpen(!0)), a.props.setPreSelection && a.props.setPreSelection(e);
	    }), ie(fe(a), "handleMonthYearChange", function (e) {
	      a.handleYearChange(e), a.handleMonthChange(e);
	    }), ie(fe(a), "changeYear", function (e) {
	      a.setState(function (t) {
	        var r = t.date;
	        return {
	          date: setYear(r, e)
	        };
	      }, function () {
	        return a.handleYearChange(a.state.date);
	      });
	    }), ie(fe(a), "changeMonth", function (e) {
	      a.setState(function (t) {
	        var r = t.date;
	        return {
	          date: setMonth(r, e)
	        };
	      }, function () {
	        return a.handleMonthChange(a.state.date);
	      });
	    }), ie(fe(a), "changeMonthYear", function (e) {
	      a.setState(function (t) {
	        var r = t.date;
	        return {
	          date: setYear(setMonth(r, getMonth(e)), getYear(e))
	        };
	      }, function () {
	        return a.handleMonthYearChange(a.state.date);
	      });
	    }), ie(fe(a), "header", function () {
	      var r = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : a.state.date,
	          n = Oe(r, a.props.locale),
	          o = [];
	      return a.props.showWeekNumbers && o.push( /*#__PURE__*/React__default.createElement("div", {
	        key: "W",
	        className: "react-datepicker__day-name"
	      }, a.props.weekLabel || "#")), o.concat([0, 1, 2, 3, 4, 5, 6].map(function (r) {
	        var o = addDays(n, r),
	            s = a.formatWeekday(o, a.props.locale),
	            i = a.props.weekDayClassName ? a.props.weekDayClassName(o) : void 0;
	        return /*#__PURE__*/React__default.createElement("div", {
	          key: r,
	          className: classnames("react-datepicker__day-name", i)
	        }, s);
	      }));
	    }), ie(fe(a), "formatWeekday", function (e, t) {
	      return a.props.formatWeekDay ? function (e, t, r) {
	        return t(Se(e, "EEEE", r));
	      }(e, a.props.formatWeekDay, t) : a.props.useWeekdaysShort ? function (e, t) {
	        return Se(e, "EEE", t);
	      }(e, t) : function (e, t) {
	        return Se(e, "EEEEEE", t);
	      }(e, t);
	    }), ie(fe(a), "decreaseYear", function () {
	      a.setState(function (e) {
	        var t = e.date;
	        return {
	          date: subYears(t, a.props.showYearPicker ? a.props.yearItemNumber : 1)
	        };
	      }, function () {
	        return a.handleYearChange(a.state.date);
	      });
	    }), ie(fe(a), "renderPreviousButton", function () {
	      if (!a.props.renderCustomHeader) {
	        var t;

	        switch (!0) {
	          case a.props.showMonthYearPicker:
	            t = st(a.state.date, a.props);
	            break;

	          case a.props.showYearPicker:
	            t = function (e) {
	              var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	                  r = t.minDate,
	                  n = t.yearItemNumber,
	                  o = void 0 === n ? 12 : n,
	                  a = Te(subYears(e, o)),
	                  s = ht(a, o),
	                  p = s.endPeriod,
	                  i = r && getYear(r);
	              return i && i > p || !1;
	            }(a.state.date, a.props);

	            break;

	          default:
	            t = ot(a.state.date, a.props);
	        }

	        if ((a.props.forceShowMonthNavigation || a.props.showDisabledMonthNavigation || !t) && !a.props.showTimeSelectOnly) {
	          var r = ["react-datepicker__navigation", "react-datepicker__navigation--previous"],
	              n = a.decreaseMonth;
	          (a.props.showMonthYearPicker || a.props.showQuarterYearPicker || a.props.showYearPicker) && (n = a.decreaseYear), t && a.props.showDisabledMonthNavigation && (r.push("react-datepicker__navigation--previous--disabled"), n = null);
	          var o = a.props.showMonthYearPicker || a.props.showQuarterYearPicker || a.props.showYearPicker,
	              s = a.props,
	              p = s.previousMonthAriaLabel,
	              i = void 0 === p ? "Previous Month" : p,
	              c = s.previousYearAriaLabel,
	              l = void 0 === c ? "Previous Year" : c;
	          return /*#__PURE__*/React__default.createElement("button", {
	            type: "button",
	            className: r.join(" "),
	            onClick: n,
	            "aria-label": o ? l : i
	          }, o ? a.props.previousYearButtonLabel : a.props.previousMonthButtonLabel);
	        }
	      }
	    }), ie(fe(a), "increaseYear", function () {
	      a.setState(function (e) {
	        var t = e.date;
	        return {
	          date: addYears(t, a.props.showYearPicker ? a.props.yearItemNumber : 1)
	        };
	      }, function () {
	        return a.handleYearChange(a.state.date);
	      });
	    }), ie(fe(a), "renderNextButton", function () {
	      if (!a.props.renderCustomHeader) {
	        var t;

	        switch (!0) {
	          case a.props.showMonthYearPicker:
	            t = pt(a.state.date, a.props);
	            break;

	          case a.props.showYearPicker:
	            t = function (e) {
	              var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
	                  r = t.maxDate,
	                  n = t.yearItemNumber,
	                  o = void 0 === n ? 12 : n,
	                  a = addYears(e, o),
	                  s = ht(a, o),
	                  p = s.startPeriod,
	                  i = r && getYear(r);
	              return i && i < p || !1;
	            }(a.state.date, a.props);

	            break;

	          default:
	            t = at(a.state.date, a.props);
	        }

	        if ((a.props.forceShowMonthNavigation || a.props.showDisabledMonthNavigation || !t) && !a.props.showTimeSelectOnly) {
	          var r = ["react-datepicker__navigation", "react-datepicker__navigation--next"];
	          a.props.showTimeSelect && r.push("react-datepicker__navigation--next--with-time"), a.props.todayButton && r.push("react-datepicker__navigation--next--with-today-button");
	          var n = a.increaseMonth;
	          (a.props.showMonthYearPicker || a.props.showQuarterYearPicker || a.props.showYearPicker) && (n = a.increaseYear), t && a.props.showDisabledMonthNavigation && (r.push("react-datepicker__navigation--next--disabled"), n = null);
	          var o = a.props.showMonthYearPicker || a.props.showQuarterYearPicker || a.props.showYearPicker,
	              s = a.props,
	              p = s.nextMonthAriaLabel,
	              i = void 0 === p ? "Next Month" : p,
	              c = s.nextYearAriaLabel,
	              d = void 0 === c ? "Next Year" : c;
	          return /*#__PURE__*/React__default.createElement("button", {
	            type: "button",
	            className: r.join(" "),
	            onClick: n,
	            "aria-label": o ? d : i
	          }, o ? a.props.nextYearButtonLabel : a.props.nextMonthButtonLabel);
	        }
	      }
	    }), ie(fe(a), "renderCurrentMonth", function () {
	      var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : a.state.date,
	          r = ["react-datepicker__current-month"];
	      return a.props.showYearDropdown && r.push("react-datepicker__current-month--hasYearDropdown"), a.props.showMonthDropdown && r.push("react-datepicker__current-month--hasMonthDropdown"), a.props.showMonthYearDropdown && r.push("react-datepicker__current-month--hasMonthYearDropdown"), /*#__PURE__*/React__default.createElement("div", {
	        className: r.join(" ")
	      }, Se(t, a.props.dateFormat, a.props.locale));
	    }), ie(fe(a), "renderYearDropdown", function () {
	      var t = arguments.length > 0 && void 0 !== arguments[0] && arguments[0];
	      if (a.props.showYearDropdown && !t) return /*#__PURE__*/React__default.createElement(yt, {
	        adjustDateOnChange: a.props.adjustDateOnChange,
	        date: a.state.date,
	        onSelect: a.props.onSelect,
	        setOpen: a.props.setOpen,
	        dropdownMode: a.props.dropdownMode,
	        onChange: a.changeYear,
	        minDate: a.props.minDate,
	        maxDate: a.props.maxDate,
	        year: getYear(a.state.date),
	        scrollableYearDropdown: a.props.scrollableYearDropdown,
	        yearDropdownItemNumber: a.props.yearDropdownItemNumber
	      });
	    }), ie(fe(a), "renderMonthDropdown", function () {
	      var t = arguments.length > 0 && void 0 !== arguments[0] && arguments[0];
	      if (a.props.showMonthDropdown && !t) return /*#__PURE__*/React__default.createElement(Dt, {
	        dropdownMode: a.props.dropdownMode,
	        locale: a.props.locale,
	        onChange: a.changeMonth,
	        month: getMonth(a.state.date),
	        useShortMonthInDropdown: a.props.useShortMonthInDropdown
	      });
	    }), ie(fe(a), "renderMonthYearDropdown", function () {
	      var t = arguments.length > 0 && void 0 !== arguments[0] && arguments[0];
	      if (a.props.showMonthYearDropdown && !t) return /*#__PURE__*/React__default.createElement(gt, {
	        dropdownMode: a.props.dropdownMode,
	        locale: a.props.locale,
	        dateFormat: a.props.dateFormat,
	        onChange: a.changeMonthYear,
	        minDate: a.props.minDate,
	        maxDate: a.props.maxDate,
	        date: a.state.date,
	        scrollableMonthYearDropdown: a.props.scrollableMonthYearDropdown
	      });
	    }), ie(fe(a), "renderTodayButton", function () {
	      if (a.props.todayButton && !a.props.showTimeSelectOnly) return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__today-button",
	        onClick: function (e) {
	          return a.props.onSelect(startOfDay(be()), e);
	        }
	      }, a.props.todayButton);
	    }), ie(fe(a), "renderDefaultHeader", function (t) {
	      var r = t.monthDate,
	          n = t.i;
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__header ".concat(a.props.showTimeSelect ? "react-datepicker__header--has-time-select" : "")
	      }, a.renderCurrentMonth(r), /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__header__dropdown react-datepicker__header__dropdown--".concat(a.props.dropdownMode),
	        onFocus: a.handleDropdownFocus
	      }, a.renderMonthDropdown(0 !== n), a.renderMonthYearDropdown(0 !== n), a.renderYearDropdown(0 !== n)), /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__day-names"
	      }, a.header(r)));
	    }), ie(fe(a), "renderCustomHeader", function () {
	      var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {},
	          r = t.monthDate,
	          n = t.i;
	      if (0 !== n && void 0 !== n) return null;
	      var o = ot(a.state.date, a.props),
	          s = at(a.state.date, a.props),
	          p = st(a.state.date, a.props),
	          i = pt(a.state.date, a.props),
	          c = !a.props.showMonthYearPicker && !a.props.showQuarterYearPicker && !a.props.showYearPicker;
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__header react-datepicker__header--custom",
	        onFocus: a.props.onDropdownFocus
	      }, a.props.renderCustomHeader(de(de({}, a.state), {}, {
	        changeMonth: a.changeMonth,
	        changeYear: a.changeYear,
	        decreaseMonth: a.decreaseMonth,
	        increaseMonth: a.increaseMonth,
	        decreaseYear: a.decreaseYear,
	        increaseYear: a.increaseYear,
	        prevMonthButtonDisabled: o,
	        nextMonthButtonDisabled: s,
	        prevYearButtonDisabled: p,
	        nextYearButtonDisabled: i
	      })), c && /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__day-names"
	      }, a.header(r)));
	    }), ie(fe(a), "renderYearHeader", function () {
	      var t = a.state.date,
	          r = a.props,
	          n = r.showYearPicker,
	          o = ht(t, r.yearItemNumber),
	          s = o.startPeriod,
	          p = o.endPeriod;
	      return /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__header react-datepicker-year-header"
	      }, n ? "".concat(s, " - ").concat(p) : getYear(t));
	    }), ie(fe(a), "renderHeader", function (e) {
	      switch (!0) {
	        case void 0 !== a.props.renderCustomHeader:
	          return a.renderCustomHeader(e);

	        case a.props.showMonthYearPicker || a.props.showQuarterYearPicker || a.props.showYearPicker:
	          return a.renderYearHeader(e);

	        default:
	          return a.renderDefaultHeader(e);
	      }
	    }), ie(fe(a), "renderMonths", function () {
	      if (!a.props.showTimeSelectOnly && !a.props.showYearPicker) {
	        for (var t = [], r = a.props.showPreviousMonths ? a.props.monthsShown - 1 : 0, n = subMonths(a.state.date, r), o = 0; o < a.props.monthsShown; ++o) {
	          var s = o - a.props.monthSelectedIn,
	              p = addMonths(n, s),
	              i = "month-".concat(o),
	              l = o < a.props.monthsShown - 1,
	              d = o > 0;
	          t.push( /*#__PURE__*/React__default.createElement("div", {
	            key: i,
	            ref: function (e) {
	              a.monthContainer = e;
	            },
	            className: "react-datepicker__month-container"
	          }, a.renderHeader({
	            monthDate: p,
	            i: o
	          }), /*#__PURE__*/React__default.createElement(St, {
	            chooseDayAriaLabelPrefix: a.props.chooseDayAriaLabelPrefix,
	            disabledDayAriaLabelPrefix: a.props.disabledDayAriaLabelPrefix,
	            weekAriaLabelPrefix: a.props.weekAriaLabelPrefix,
	            onChange: a.changeMonthYear,
	            day: p,
	            dayClassName: a.props.dayClassName,
	            monthClassName: a.props.monthClassName,
	            onDayClick: a.handleDayClick,
	            handleOnKeyDown: a.props.handleOnKeyDown,
	            onDayMouseEnter: a.handleDayMouseEnter,
	            onMouseLeave: a.handleMonthMouseLeave,
	            onWeekSelect: a.props.onWeekSelect,
	            orderInDisplay: o,
	            formatWeekNumber: a.props.formatWeekNumber,
	            locale: a.props.locale,
	            minDate: a.props.minDate,
	            maxDate: a.props.maxDate,
	            excludeDates: a.props.excludeDates,
	            highlightDates: a.props.highlightDates,
	            selectingDate: a.state.selectingDate,
	            includeDates: a.props.includeDates,
	            inline: a.props.inline,
	            fixedHeight: a.props.fixedHeight,
	            filterDate: a.props.filterDate,
	            preSelection: a.props.preSelection,
	            setPreSelection: a.props.setPreSelection,
	            selected: a.props.selected,
	            selectsStart: a.props.selectsStart,
	            selectsEnd: a.props.selectsEnd,
	            selectsRange: a.props.selectsRange,
	            showWeekNumbers: a.props.showWeekNumbers,
	            startDate: a.props.startDate,
	            endDate: a.props.endDate,
	            peekNextMonth: a.props.peekNextMonth,
	            setOpen: a.props.setOpen,
	            shouldCloseOnSelect: a.props.shouldCloseOnSelect,
	            renderDayContents: a.props.renderDayContents,
	            disabledKeyboardNavigation: a.props.disabledKeyboardNavigation,
	            showMonthYearPicker: a.props.showMonthYearPicker,
	            showFullMonthYearPicker: a.props.showFullMonthYearPicker,
	            showTwoColumnMonthYearPicker: a.props.showTwoColumnMonthYearPicker,
	            showYearPicker: a.props.showYearPicker,
	            showQuarterYearPicker: a.props.showQuarterYearPicker,
	            isInputFocused: a.props.isInputFocused,
	            containerRef: a.containerRef,
	            monthShowsDuplicateDaysEnd: l,
	            monthShowsDuplicateDaysStart: d
	          })));
	        }

	        return t;
	      }
	    }), ie(fe(a), "renderYears", function () {
	      if (!a.props.showTimeSelectOnly) return a.props.showYearPicker ? /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__year--container"
	      }, a.renderHeader(), /*#__PURE__*/React__default.createElement(Pt, ce({
	        onDayClick: a.handleDayClick,
	        date: a.state.date
	      }, a.props))) : void 0;
	    }), ie(fe(a), "renderTimeSection", function () {
	      if (a.props.showTimeSelect && (a.state.monthContainer || a.props.showTimeSelectOnly)) return /*#__PURE__*/React__default.createElement(Mt, {
	        selected: a.props.selected,
	        openToDate: a.props.openToDate,
	        onChange: a.props.onTimeChange,
	        timeClassName: a.props.timeClassName,
	        format: a.props.timeFormat,
	        includeTimes: a.props.includeTimes,
	        intervals: a.props.timeIntervals,
	        minTime: a.props.minTime,
	        maxTime: a.props.maxTime,
	        excludeTimes: a.props.excludeTimes,
	        filterTime: a.props.filterTime,
	        timeCaption: a.props.timeCaption,
	        todayButton: a.props.todayButton,
	        showMonthDropdown: a.props.showMonthDropdown,
	        showMonthYearDropdown: a.props.showMonthYearDropdown,
	        showYearDropdown: a.props.showYearDropdown,
	        withPortal: a.props.withPortal,
	        monthRef: a.state.monthContainer,
	        injectTimes: a.props.injectTimes,
	        locale: a.props.locale,
	        showTimeSelectOnly: a.props.showTimeSelectOnly
	      });
	    }), ie(fe(a), "renderInputTimeSection", function () {
	      var t = new Date(a.props.selected),
	          r = _e(t) && Boolean(a.props.selected) ? "".concat(ut(t.getHours()), ":").concat(ut(t.getMinutes())) : "";
	      if (a.props.showTimeInput) return /*#__PURE__*/React__default.createElement(Et, {
	        date: t,
	        timeString: r,
	        timeInputLabel: a.props.timeInputLabel,
	        onChange: a.props.onTimeChange,
	        customTimeInput: a.props.customTimeInput
	      });
	    }), a.containerRef = /*#__PURE__*/React__default.createRef(), a.state = {
	      date: a.getDateInView(),
	      selectingDate: null,
	      monthContainer: null
	    }, a;
	  }

	  return pe(o, null, [{
	    key: "defaultProps",
	    get: function () {
	      return {
	        onDropdownFocus: function () {},
	        monthsShown: 1,
	        monthSelectedIn: 0,
	        forceShowMonthNavigation: !1,
	        timeCaption: "Time",
	        previousYearButtonLabel: "Previous Year",
	        nextYearButtonLabel: "Next Year",
	        previousMonthButtonLabel: "Previous Month",
	        nextMonthButtonLabel: "Next Month",
	        customTimeInput: null,
	        yearItemNumber: 12
	      };
	    }
	  }]), pe(o, [{
	    key: "componentDidMount",
	    value: function () {
	      var e = this;
	      this.props.showTimeSelect && (this.assignMonthContainer = void e.setState({
	        monthContainer: e.monthContainer
	      }));
	    }
	  }, {
	    key: "componentDidUpdate",
	    value: function (e) {
	      this.props.preSelection && !Fe(this.props.preSelection, e.preSelection) ? this.setState({
	        date: this.props.preSelection
	      }) : this.props.openToDate && !Fe(this.props.openToDate, e.openToDate) && this.setState({
	        date: this.props.openToDate
	      });
	    }
	  }, {
	    key: "render",
	    value: function () {
	      var r = this.props.container || Nt;
	      return /*#__PURE__*/React__default.createElement("div", {
	        ref: this.containerRef
	      }, /*#__PURE__*/React__default.createElement(r, {
	        className: classnames("react-datepicker", this.props.className, {
	          "react-datepicker--time-only": this.props.showTimeSelectOnly
	        }),
	        showPopperArrow: this.props.showPopperArrow,
	        arrowProps: this.props.arrowProps
	      }, this.renderPreviousButton(), this.renderNextButton(), this.renderMonths(), this.renderYears(), this.renderTodayButton(), this.renderTimeSection(), this.renderInputTimeSection(), this.props.children));
	    }
	  }]), o;
	}(),
	    Tt = function (e) {
	  return !e.disabled && -1 !== e.tabIndex;
	},
	    Yt = function (t) {
	  ue(n, React__default.Component);
	  var r = ve(n);

	  function n(t) {
	    var o;
	    return ae(this, n), ie(fe(o = r.call(this, t)), "getTabChildren", function () {
	      return Array.prototype.slice.call(o.tabLoopRef.current.querySelectorAll("[tabindex], a, button, input, select, textarea"), 1, -1).filter(Tt);
	    }), ie(fe(o), "handleFocusStart", function (e) {
	      var t = o.getTabChildren();
	      t && t.length > 1 && t[t.length - 1].focus();
	    }), ie(fe(o), "handleFocusEnd", function (e) {
	      var t = o.getTabChildren();
	      t && t.length > 1 && t[0].focus();
	    }), o.tabLoopRef = /*#__PURE__*/React__default.createRef(), o;
	  }

	  return pe(n, null, [{
	    key: "defaultProps",
	    get: function () {
	      return {
	        enableTabLoop: !0
	      };
	    }
	  }]), pe(n, [{
	    key: "render",
	    value: function () {
	      return this.props.enableTabLoop ? /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__tab-loop",
	        ref: this.tabLoopRef
	      }, /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__tab-loop__start",
	        tabIndex: "0",
	        onFocus: this.handleFocusStart
	      }), this.props.children, /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__tab-loop__end",
	        tabIndex: "0",
	        onFocus: this.handleFocusEnd
	      })) : this.props.children;
	    }
	  }]), n;
	}(),
	    It = function (t) {
	  ue(n, React__default.Component);
	  var r = ve(n);

	  function n(e) {
	    var t;
	    return ae(this, n), (t = r.call(this, e)).el = document.createElement("div"), t;
	  }

	  return pe(n, [{
	    key: "componentDidMount",
	    value: function () {
	      this.portalRoot = document.getElementById(this.props.portalId), this.portalRoot || (this.portalRoot = document.createElement("div"), this.portalRoot.setAttribute("id", this.props.portalId), document.body.appendChild(this.portalRoot)), this.portalRoot.appendChild(this.el);
	    }
	  }, {
	    key: "componentWillUnmount",
	    value: function () {
	      this.portalRoot.removeChild(this.el);
	    }
	  }, {
	    key: "render",
	    value: function () {
	      return /*#__PURE__*/ne__default.createPortal(this.props.children, this.el);
	    }
	  }]), n;
	}(),
	    Lt = function (r) {
	  ue(o, React__default.Component);
	  var n = ve(o);

	  function o() {
	    return ae(this, o), n.apply(this, arguments);
	  }

	  return pe(o, [{
	    key: "render",
	    value: function () {
	      var r,
	          n = this.props,
	          o = n.className,
	          a = n.wrapperClassName,
	          s = n.hidePopper,
	          p = n.popperComponent,
	          i = n.popperModifiers,
	          c = n.popperPlacement,
	          l = n.popperProps,
	          d = n.targetComponent,
	          u = n.enableTabLoop,
	          h = n.popperOnKeyDown,
	          m = n.portalId;

	      if (!s) {
	        var f = classnames("react-datepicker-popper", o);
	        r = /*#__PURE__*/React__default.createElement(Popper$1, ce({
	          modifiers: i,
	          placement: c
	        }, l), function (t) {
	          var r = t.ref,
	              n = t.style,
	              o = t.placement,
	              a = t.arrowProps;
	          return /*#__PURE__*/React__default.createElement(Yt, {
	            enableTabLoop: u
	          }, /*#__PURE__*/React__default.createElement("div", ce({
	            ref: r,
	            style: n
	          }, {
	            className: f,
	            "data-placement": o,
	            onKeyDown: h
	          }), /*#__PURE__*/React__default.cloneElement(p, {
	            arrowProps: a
	          })));
	        });
	      }

	      this.props.popperContainer && (r = /*#__PURE__*/React__default.createElement(this.props.popperContainer, {}, r)), m && !s && (r = /*#__PURE__*/React__default.createElement(It, {
	        portalId: m
	      }, r));
	      var y = classnames("react-datepicker-wrapper", a);
	      return /*#__PURE__*/React__default.createElement(Manager, {
	        className: "react-datepicker-manager"
	      }, /*#__PURE__*/React__default.createElement(Reference, null, function (t) {
	        var r = t.ref;
	        return /*#__PURE__*/React__default.createElement("div", {
	          ref: r,
	          className: y
	        }, d);
	      }), r);
	    }
	  }], [{
	    key: "defaultProps",
	    get: function () {
	      return {
	        hidePopper: !0,
	        popperModifiers: {
	          preventOverflow: {
	            enabled: !0,
	            escapeWithReference: !0,
	            boundariesElement: "viewport"
	          }
	        },
	        popperProps: {},
	        popperPlacement: "bottom-start"
	      };
	    }
	  }]), o;
	}(),
	    Rt = onClickOutsideHOC(xt);

	var Ft = function (n) {
	  ue(a, React__default.Component);
	  var o = ve(a);

	  function a(n) {
	    var s;
	    return ae(this, a), ie(fe(s = o.call(this, n)), "getPreSelection", function () {
	      return s.props.openToDate ? s.props.openToDate : s.props.selectsEnd && s.props.startDate ? s.props.startDate : s.props.selectsStart && s.props.endDate ? s.props.endDate : be();
	    }), ie(fe(s), "calcInitialState", function () {
	      var e = s.getPreSelection(),
	          t = it(s.props),
	          r = ct(s.props),
	          n = t && isBefore(e, t) ? t : r && isAfter(e, r) ? r : e;
	      return {
	        open: s.props.startOpen || !1,
	        preventFocus: !1,
	        preSelection: s.props.selected ? s.props.selected : n,
	        highlightDates: lt(s.props.highlightDates),
	        focused: !1
	      };
	    }), ie(fe(s), "clearPreventFocusTimeout", function () {
	      s.preventFocusTimeout && clearTimeout(s.preventFocusTimeout);
	    }), ie(fe(s), "setFocus", function () {
	      s.input && s.input.focus && s.input.focus({
	        preventScroll: !0
	      });
	    }), ie(fe(s), "setBlur", function () {
	      s.input && s.input.blur && s.input.blur(), s.cancelFocusInput();
	    }), ie(fe(s), "setOpen", function (e) {
	      var t = arguments.length > 1 && void 0 !== arguments[1] && arguments[1];
	      s.setState({
	        open: e,
	        preSelection: e && s.state.open ? s.state.preSelection : s.calcInitialState().preSelection,
	        lastPreSelectChange: Wt
	      }, function () {
	        e || s.setState(function (e) {
	          return {
	            focused: !!t && e.focused
	          };
	        }, function () {
	          !t && s.setBlur(), s.setState({
	            inputValue: null
	          });
	        });
	      });
	    }), ie(fe(s), "inputOk", function () {
	      return isDate(s.state.preSelection);
	    }), ie(fe(s), "isCalendarOpen", function () {
	      return void 0 === s.props.open ? s.state.open && !s.props.disabled && !s.props.readOnly : s.props.open;
	    }), ie(fe(s), "handleFocus", function (e) {
	      s.state.preventFocus || (s.props.onFocus(e), s.props.preventOpenOnFocus || s.props.readOnly || s.setOpen(!0)), s.setState({
	        focused: !0
	      });
	    }), ie(fe(s), "cancelFocusInput", function () {
	      clearTimeout(s.inputFocusTimeout), s.inputFocusTimeout = null;
	    }), ie(fe(s), "deferFocusInput", function () {
	      s.cancelFocusInput(), s.inputFocusTimeout = setTimeout(function () {
	        return s.setFocus();
	      }, 1);
	    }), ie(fe(s), "handleDropdownFocus", function () {
	      s.cancelFocusInput();
	    }), ie(fe(s), "handleBlur", function (e) {
	      (!s.state.open || s.props.withPortal || s.props.showTimeInput) && s.props.onBlur(e), s.setState({
	        focused: !1
	      });
	    }), ie(fe(s), "handleCalendarClickOutside", function (e) {
	      s.props.inline || s.setOpen(!1), s.props.onClickOutside(e), s.props.withPortal && e.preventDefault();
	    }), ie(fe(s), "handleChange", function () {
	      for (var e = arguments.length, t = new Array(e), r = 0; r < e; r++) t[r] = arguments[r];

	      var n = t[0];

	      if (!s.props.onChangeRaw || (s.props.onChangeRaw.apply(fe(s), t), "function" == typeof n.isDefaultPrevented && !n.isDefaultPrevented())) {
	        s.setState({
	          inputValue: n.target.value,
	          lastPreSelectChange: At
	        });
	        var o = Ce(n.target.value, s.props.dateFormat, s.props.locale, s.props.strictParsing);
	        !o && n.target.value || s.setSelected(o, n, !0);
	      }
	    }), ie(fe(s), "handleSelect", function (e, t, r) {
	      s.setState({
	        preventFocus: !0
	      }, function () {
	        return s.preventFocusTimeout = setTimeout(function () {
	          return s.setState({
	            preventFocus: !1
	          });
	        }, 50), s.preventFocusTimeout;
	      }), s.props.onChangeRaw && s.props.onChangeRaw(t), s.setSelected(e, t, !1, r), !s.props.shouldCloseOnSelect || s.props.showTimeSelect ? s.setPreSelection(e) : s.props.inline || s.setOpen(!1);
	    }), ie(fe(s), "setSelected", function (e, t, r, n) {
	      var o = e;

	      if (null === o || !Ue(o, s.props)) {
	        var a = s.props,
	            p = a.onChange,
	            i = a.selectsRange,
	            c = a.startDate,
	            l = a.endDate;
	        if (!Ae(s.props.selected, o) || s.props.allowSameDay || i) if (null !== o && (!s.props.selected || r && (s.props.showTimeSelect || s.props.showTimeSelectOnly || s.props.showTimeInput) || (o = Me(o, {
	          hour: getHours(s.props.selected),
	          minute: getMinutes(s.props.selected),
	          second: getSeconds(s.props.selected)
	        })), s.props.inline || s.setState({
	          preSelection: o
	        }), s.props.focusSelectedMonth || s.setState({
	          monthSelectedIn: n
	        })), i) {
	          var d = c && !l,
	              u = c && l;
	          !c && !l ? p([o, null], t) : d && (isBefore(o, c) ? p([o, null], t) : p([c, o], t)), u && p([o, null], t);
	        } else p(o, t);
	        r || (s.props.onSelect(o, t), s.setState({
	          inputValue: null
	        }));
	      }
	    }), ie(fe(s), "setPreSelection", function (e) {
	      var t = void 0 !== s.props.minDate,
	          r = void 0 !== s.props.maxDate,
	          n = !0;
	      e && (t && r ? n = We(e, s.props.minDate, s.props.maxDate) : t ? n = isAfter(e, s.props.minDate) : r && (n = isBefore(e, s.props.maxDate))), n && s.setState({
	        preSelection: e
	      });
	    }), ie(fe(s), "handleTimeChange", function (e) {
	      var t = Me(s.props.selected ? s.props.selected : s.getPreSelection(), {
	        hour: getHours(e),
	        minute: getMinutes(e)
	      });
	      s.setState({
	        preSelection: t
	      }), s.props.onChange(t), s.props.shouldCloseOnSelect && s.setOpen(!1), s.props.showTimeInput && s.setOpen(!0), s.setState({
	        inputValue: null
	      });
	    }), ie(fe(s), "onInputClick", function () {
	      s.props.disabled || s.props.readOnly || s.setOpen(!0), s.props.onInputClick();
	    }), ie(fe(s), "onInputKeyDown", function (e) {
	      s.props.onKeyDown(e);
	      var t = e.key;

	      if (s.state.open || s.props.inline || s.props.preventOpenOnFocus) {
	        if (s.state.open) {
	          if ("ArrowDown" === t || "ArrowUp" === t) {
	            e.preventDefault();
	            var r = s.calendar.componentNode && s.calendar.componentNode.querySelector('.react-datepicker__day[tabindex="0"]');
	            return void (r && r.focus({
	              preventScroll: !0
	            }));
	          }

	          var n = be(s.state.preSelection);
	          "Enter" === t ? (e.preventDefault(), s.inputOk() && s.state.lastPreSelectChange === Wt ? (s.handleSelect(n, e), !s.props.shouldCloseOnSelect && s.setPreSelection(n)) : s.setOpen(!1)) : "Escape" === t && (e.preventDefault(), s.setOpen(!1)), s.inputOk() || s.props.onInputError({
	            code: 1,
	            msg: "Date input not valid."
	          });
	        }
	      } else "ArrowDown" !== t && "ArrowUp" !== t && "Enter" !== t || s.onInputClick();
	    }), ie(fe(s), "onDayKeyDown", function (e) {
	      s.props.onKeyDown(e);
	      var t = e.key,
	          r = be(s.state.preSelection);
	      if ("Enter" === t) e.preventDefault(), s.handleSelect(r, e), !s.props.shouldCloseOnSelect && s.setPreSelection(r);else if ("Escape" === t) e.preventDefault(), s.setOpen(!1), s.inputOk() || s.props.onInputError({
	        code: 1,
	        msg: "Date input not valid."
	      });else if (!s.props.disabledKeyboardNavigation) {
	        var n;

	        switch (t) {
	          case "ArrowLeft":
	            n = subDays(r, 1);
	            break;

	          case "ArrowRight":
	            n = addDays(r, 1);
	            break;

	          case "ArrowUp":
	            n = subWeeks(r, 1);
	            break;

	          case "ArrowDown":
	            n = addWeeks(r, 1);
	            break;

	          case "PageUp":
	            n = subMonths(r, 1);
	            break;

	          case "PageDown":
	            n = addMonths(r, 1);
	            break;

	          case "Home":
	            n = subYears(r, 1);
	            break;

	          case "End":
	            n = addYears(r, 1);
	        }

	        if (!n) return void (s.props.onInputError && s.props.onInputError({
	          code: 1,
	          msg: "Date input not valid."
	        }));
	        e.preventDefault(), s.setState({
	          lastPreSelectChange: Wt
	        }), s.props.adjustDateOnChange && s.setSelected(n), s.setPreSelection(n);
	      }
	    }), ie(fe(s), "onPopperKeyDown", function (e) {
	      "Escape" === e.key && (e.preventDefault(), s.setState({
	        preventFocus: !0
	      }, function () {
	        s.setOpen(!1), setTimeout(function () {
	          s.setFocus(), s.setState({
	            preventFocus: !1
	          });
	        });
	      }));
	    }), ie(fe(s), "onClearClick", function (e) {
	      e && e.preventDefault && e.preventDefault(), s.props.onChange(null, e), s.setState({
	        inputValue: null
	      });
	    }), ie(fe(s), "clear", function () {
	      s.onClearClick();
	    }), ie(fe(s), "onScroll", function (e) {
	      "boolean" == typeof s.props.closeOnScroll && s.props.closeOnScroll ? e.target !== document && e.target !== document.documentElement && e.target !== document.body || s.setOpen(!1) : "function" == typeof s.props.closeOnScroll && s.props.closeOnScroll(e) && s.setOpen(!1);
	    }), ie(fe(s), "renderCalendar", function () {
	      return s.props.inline || s.isCalendarOpen() ? /*#__PURE__*/React__default.createElement(Rt, {
	        ref: function (e) {
	          s.calendar = e;
	        },
	        locale: s.props.locale,
	        chooseDayAriaLabelPrefix: s.props.chooseDayAriaLabelPrefix,
	        disabledDayAriaLabelPrefix: s.props.disabledDayAriaLabelPrefix,
	        weekAriaLabelPrefix: s.props.weekAriaLabelPrefix,
	        adjustDateOnChange: s.props.adjustDateOnChange,
	        setOpen: s.setOpen,
	        shouldCloseOnSelect: s.props.shouldCloseOnSelect,
	        dateFormat: s.props.dateFormatCalendar,
	        useWeekdaysShort: s.props.useWeekdaysShort,
	        formatWeekDay: s.props.formatWeekDay,
	        dropdownMode: s.props.dropdownMode,
	        selected: s.props.selected,
	        preSelection: s.state.preSelection,
	        onSelect: s.handleSelect,
	        onWeekSelect: s.props.onWeekSelect,
	        openToDate: s.props.openToDate,
	        minDate: s.props.minDate,
	        maxDate: s.props.maxDate,
	        selectsStart: s.props.selectsStart,
	        selectsEnd: s.props.selectsEnd,
	        selectsRange: s.props.selectsRange,
	        startDate: s.props.startDate,
	        endDate: s.props.endDate,
	        excludeDates: s.props.excludeDates,
	        filterDate: s.props.filterDate,
	        onClickOutside: s.handleCalendarClickOutside,
	        formatWeekNumber: s.props.formatWeekNumber,
	        highlightDates: s.state.highlightDates,
	        includeDates: s.props.includeDates,
	        includeTimes: s.props.includeTimes,
	        injectTimes: s.props.injectTimes,
	        inline: s.props.inline,
	        peekNextMonth: s.props.peekNextMonth,
	        showMonthDropdown: s.props.showMonthDropdown,
	        showPreviousMonths: s.props.showPreviousMonths,
	        useShortMonthInDropdown: s.props.useShortMonthInDropdown,
	        showMonthYearDropdown: s.props.showMonthYearDropdown,
	        showWeekNumbers: s.props.showWeekNumbers,
	        showYearDropdown: s.props.showYearDropdown,
	        withPortal: s.props.withPortal,
	        forceShowMonthNavigation: s.props.forceShowMonthNavigation,
	        showDisabledMonthNavigation: s.props.showDisabledMonthNavigation,
	        scrollableYearDropdown: s.props.scrollableYearDropdown,
	        scrollableMonthYearDropdown: s.props.scrollableMonthYearDropdown,
	        todayButton: s.props.todayButton,
	        weekLabel: s.props.weekLabel,
	        outsideClickIgnoreClass: "react-datepicker-ignore-onclickoutside",
	        fixedHeight: s.props.fixedHeight,
	        monthsShown: s.props.monthsShown,
	        monthSelectedIn: s.state.monthSelectedIn,
	        onDropdownFocus: s.handleDropdownFocus,
	        onMonthChange: s.props.onMonthChange,
	        onYearChange: s.props.onYearChange,
	        dayClassName: s.props.dayClassName,
	        weekDayClassName: s.props.weekDayClassName,
	        monthClassName: s.props.monthClassName,
	        timeClassName: s.props.timeClassName,
	        showTimeSelect: s.props.showTimeSelect,
	        showTimeSelectOnly: s.props.showTimeSelectOnly,
	        onTimeChange: s.handleTimeChange,
	        timeFormat: s.props.timeFormat,
	        timeIntervals: s.props.timeIntervals,
	        minTime: s.props.minTime,
	        maxTime: s.props.maxTime,
	        excludeTimes: s.props.excludeTimes,
	        filterTime: s.props.filterTime,
	        timeCaption: s.props.timeCaption,
	        className: s.props.calendarClassName,
	        container: s.props.calendarContainer,
	        yearItemNumber: s.props.yearItemNumber,
	        yearDropdownItemNumber: s.props.yearDropdownItemNumber,
	        previousMonthButtonLabel: s.props.previousMonthButtonLabel,
	        nextMonthButtonLabel: s.props.nextMonthButtonLabel,
	        previousYearButtonLabel: s.props.previousYearButtonLabel,
	        nextYearButtonLabel: s.props.nextYearButtonLabel,
	        timeInputLabel: s.props.timeInputLabel,
	        disabledKeyboardNavigation: s.props.disabledKeyboardNavigation,
	        renderCustomHeader: s.props.renderCustomHeader,
	        popperProps: s.props.popperProps,
	        renderDayContents: s.props.renderDayContents,
	        onDayMouseEnter: s.props.onDayMouseEnter,
	        onMonthMouseLeave: s.props.onMonthMouseLeave,
	        showTimeInput: s.props.showTimeInput,
	        showMonthYearPicker: s.props.showMonthYearPicker,
	        showFullMonthYearPicker: s.props.showFullMonthYearPicker,
	        showTwoColumnMonthYearPicker: s.props.showTwoColumnMonthYearPicker,
	        showYearPicker: s.props.showYearPicker,
	        showQuarterYearPicker: s.props.showQuarterYearPicker,
	        showPopperArrow: s.props.showPopperArrow,
	        excludeScrollbar: s.props.excludeScrollbar,
	        handleOnKeyDown: s.onDayKeyDown,
	        isInputFocused: s.state.focused,
	        customTimeInput: s.props.customTimeInput,
	        setPreSelection: s.setPreSelection
	      }, s.props.children) : null;
	    }), ie(fe(s), "renderDateInput", function () {
	      var r,
	          n,
	          o,
	          a,
	          p,
	          i = classnames(s.props.className, ie({}, "react-datepicker-ignore-onclickoutside", s.state.open)),
	          c = s.props.customInput || /*#__PURE__*/React__default.createElement("input", {
	        type: "text"
	      }),
	          l = s.props.customInputRef || "ref",
	          d = "string" == typeof s.props.value ? s.props.value : "string" == typeof s.state.inputValue ? s.state.inputValue : (n = s.props.selected, o = s.props, a = o.dateFormat, p = o.locale, n && Se(n, Array.isArray(a) ? a[0] : a, p) || "");
	      return /*#__PURE__*/React__default.cloneElement(c, (ie(r = {}, l, function (e) {
	        s.input = e;
	      }), ie(r, "value", d), ie(r, "onBlur", s.handleBlur), ie(r, "onChange", s.handleChange), ie(r, "onClick", s.onInputClick), ie(r, "onFocus", s.handleFocus), ie(r, "onKeyDown", s.onInputKeyDown), ie(r, "id", s.props.id), ie(r, "name", s.props.name), ie(r, "autoFocus", s.props.autoFocus), ie(r, "placeholder", s.props.placeholderText), ie(r, "disabled", s.props.disabled), ie(r, "autoComplete", s.props.autoComplete), ie(r, "className", classnames(c.props.className, i)), ie(r, "title", s.props.title), ie(r, "readOnly", s.props.readOnly), ie(r, "required", s.props.required), ie(r, "tabIndex", s.props.tabIndex), ie(r, "aria-labelledby", s.props.ariaLabelledBy), r));
	    }), ie(fe(s), "renderClearButton", function () {
	      var t = s.props,
	          r = t.isClearable,
	          n = t.selected,
	          o = t.clearButtonTitle,
	          a = t.ariaLabelClose,
	          p = void 0 === a ? "Close" : a;
	      return r && null != n ? /*#__PURE__*/React__default.createElement("button", {
	        type: "button",
	        className: "react-datepicker__close-icon",
	        "aria-label": p,
	        onClick: s.onClearClick,
	        title: o,
	        tabIndex: -1
	      }) : null;
	    }), s.state = s.calcInitialState(), s;
	  }

	  return pe(a, null, [{
	    key: "defaultProps",
	    get: function () {
	      return {
	        allowSameDay: !1,
	        dateFormat: "MM/dd/yyyy",
	        dateFormatCalendar: "LLLL yyyy",
	        onChange: function () {},
	        disabled: !1,
	        disabledKeyboardNavigation: !1,
	        dropdownMode: "scroll",
	        onFocus: function () {},
	        onBlur: function () {},
	        onKeyDown: function () {},
	        onInputClick: function () {},
	        onSelect: function () {},
	        onClickOutside: function () {},
	        onMonthChange: function () {},
	        onCalendarOpen: function () {},
	        onCalendarClose: function () {},
	        preventOpenOnFocus: !1,
	        onYearChange: function () {},
	        onInputError: function () {},
	        monthsShown: 1,
	        readOnly: !1,
	        withPortal: !1,
	        shouldCloseOnSelect: !0,
	        showTimeSelect: !1,
	        showTimeInput: !1,
	        showPreviousMonths: !1,
	        showMonthYearPicker: !1,
	        showFullMonthYearPicker: !1,
	        showTwoColumnMonthYearPicker: !1,
	        showYearPicker: !1,
	        showQuarterYearPicker: !1,
	        strictParsing: !1,
	        timeIntervals: 30,
	        timeCaption: "Time",
	        previousMonthButtonLabel: "Previous Month",
	        nextMonthButtonLabel: "Next Month",
	        previousYearButtonLabel: "Previous Year",
	        nextYearButtonLabel: "Next Year",
	        timeInputLabel: "Time",
	        enableTabLoop: !0,
	        yearItemNumber: 12,
	        renderDayContents: function (e) {
	          return e;
	        },
	        focusSelectedMonth: !1,
	        showPopperArrow: !0,
	        excludeScrollbar: !0,
	        customTimeInput: null
	      };
	    }
	  }]), pe(a, [{
	    key: "componentDidMount",
	    value: function () {
	      window.addEventListener("scroll", this.onScroll, !0);
	    }
	  }, {
	    key: "componentDidUpdate",
	    value: function (e, t) {
	      var r, n;
	      e.inline && (r = e.selected, n = this.props.selected, r && n ? getMonth(r) !== getMonth(n) || getYear(r) !== getYear(n) : r !== n) && this.setPreSelection(this.props.selected), void 0 !== this.state.monthSelectedIn && e.monthsShown !== this.props.monthsShown && this.setState({
	        monthSelectedIn: 0
	      }), e.highlightDates !== this.props.highlightDates && this.setState({
	        highlightDates: lt(this.props.highlightDates)
	      }), t.focused || Ae(e.selected, this.props.selected) || this.setState({
	        inputValue: null
	      }), t.open !== this.state.open && (!1 === t.open && !0 === this.state.open && this.props.onCalendarOpen(), !0 === t.open && !1 === this.state.open && this.props.onCalendarClose());
	    }
	  }, {
	    key: "componentWillUnmount",
	    value: function () {
	      this.clearPreventFocusTimeout(), window.removeEventListener("scroll", this.onScroll, !0);
	    }
	  }, {
	    key: "render",
	    value: function () {
	      var t = this.renderCalendar();
	      return this.props.inline && !this.props.withPortal ? t : this.props.withPortal ? /*#__PURE__*/React__default.createElement("div", null, this.props.inline ? null : /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__input-container"
	      }, this.renderDateInput(), this.renderClearButton()), this.state.open || this.props.inline ? /*#__PURE__*/React__default.createElement("div", {
	        className: "react-datepicker__portal"
	      }, t) : null) : /*#__PURE__*/React__default.createElement(Lt, {
	        className: this.props.popperClassName,
	        wrapperClassName: this.props.wrapperClassName,
	        hidePopper: !this.isCalendarOpen(),
	        portalId: this.props.portalId,
	        popperModifiers: this.props.popperModifiers,
	        targetComponent: /*#__PURE__*/React__default.createElement("div", {
	          className: "react-datepicker__input-container"
	        }, this.renderDateInput(), this.renderClearButton()),
	        popperContainer: this.props.popperContainer,
	        popperComponent: t,
	        popperPlacement: this.props.popperPlacement,
	        popperProps: this.props.popperProps,
	        popperOnKeyDown: this.onPopperKeyDown,
	        enableTabLoop: this.props.enableTabLoop
	      });
	    }
	  }]), a;
	}(),
	    At = "input",
	    Wt = "navigate";

	function _defineProperty$1(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	function ownKeys(object, enumerableOnly) {
	  var keys = Object.keys(object);

	  if (Object.getOwnPropertySymbols) {
	    var symbols = Object.getOwnPropertySymbols(object);
	    if (enumerableOnly) symbols = symbols.filter(function (sym) {
	      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
	    });
	    keys.push.apply(keys, symbols);
	  }

	  return keys;
	}

	function _objectSpread2(target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments[i] != null ? arguments[i] : {};

	    if (i % 2) {
	      ownKeys(Object(source), true).forEach(function (key) {
	        _defineProperty$1(target, key, source[key]);
	      });
	    } else if (Object.getOwnPropertyDescriptors) {
	      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
	    } else {
	      ownKeys(Object(source)).forEach(function (key) {
	        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
	      });
	    }
	  }

	  return target;
	}

	function _objectWithoutPropertiesLoose$1(source, excluded) {
	  if (source == null) return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i;

	  for (i = 0; i < sourceKeys.length; i++) {
	    key = sourceKeys[i];
	    if (excluded.indexOf(key) >= 0) continue;
	    target[key] = source[key];
	  }

	  return target;
	}

	function _objectWithoutProperties$1(source, excluded) {
	  if (source == null) return {};

	  var target = _objectWithoutPropertiesLoose$1(source, excluded);

	  var key, i;

	  if (Object.getOwnPropertySymbols) {
	    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

	    for (i = 0; i < sourceSymbolKeys.length; i++) {
	      key = sourceSymbolKeys[i];
	      if (excluded.indexOf(key) >= 0) continue;
	      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
	      target[key] = source[key];
	    }
	  }

	  return target;
	}
	/**
	 * Copyright IBM Corp. 2018, 2018
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 */


	var defaultAttributes = {
	  // Reference:
	  // https://github.com/IBM/carbon-components-react/issues/1392
	  // https://github.com/PolymerElements/iron-iconset-svg/pull/47
	  // `focusable` is a string attribute which is why we do not use a boolean here
	  focusable: 'false',
	  preserveAspectRatio: 'xMidYMid meet'
	};
	/**
	 * Get supplementary HTML attributes for a given <svg> element based on existing
	 * attributes.
	 */

	function getAttributes() {
	  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
	      width = _ref.width,
	      height = _ref.height,
	      _ref$viewBox = _ref.viewBox,
	      viewBox = _ref$viewBox === void 0 ? "0 0 ".concat(width, " ").concat(height) : _ref$viewBox,
	      attributes = _objectWithoutProperties$1(_ref, ["width", "height", "viewBox"]);

	  var tabindex = attributes.tabindex,
	      rest = _objectWithoutProperties$1(attributes, ["tabindex"]);

	  var iconAttributes = _objectSpread2(_objectSpread2(_objectSpread2({}, defaultAttributes), rest), {}, {
	    width: width,
	    height: height,
	    viewBox: viewBox
	  }); // TODO: attributes.title assumes that the consumer will implement <title> and
	  // correctly set `aria-labelledby`.


	  if (iconAttributes['aria-label'] || iconAttributes['aria-labelledby'] || iconAttributes.title) {
	    iconAttributes.role = 'img'; // Reference:
	    // https://allyjs.io/tutorials/focusing-in-svg.html

	    if (tabindex !== undefined && tabindex !== null) {
	      iconAttributes.focusable = 'true';
	      iconAttributes.tabindex = tabindex;
	    }
	  } else {
	    iconAttributes['aria-hidden'] = true;
	  }

	  return iconAttributes;
	}

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	function _defineProperty$2(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	function _extends$1() {
	  _extends$1 = Object.assign || function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];

	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }

	    return target;
	  };

	  return _extends$1.apply(this, arguments);
	}

	function ownKeys$1(object, enumerableOnly) {
	  var keys = Object.keys(object);

	  if (Object.getOwnPropertySymbols) {
	    var symbols = Object.getOwnPropertySymbols(object);
	    if (enumerableOnly) symbols = symbols.filter(function (sym) {
	      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
	    });
	    keys.push.apply(keys, symbols);
	  }

	  return keys;
	}

	function _objectSpread2$1(target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments[i] != null ? arguments[i] : {};

	    if (i % 2) {
	      ownKeys$1(Object(source), true).forEach(function (key) {
	        _defineProperty$2(target, key, source[key]);
	      });
	    } else if (Object.getOwnPropertyDescriptors) {
	      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
	    } else {
	      ownKeys$1(Object(source)).forEach(function (key) {
	        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
	      });
	    }
	  }

	  return target;
	}

	function _objectWithoutPropertiesLoose$2(source, excluded) {
	  if (source == null) return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i;

	  for (i = 0; i < sourceKeys.length; i++) {
	    key = sourceKeys[i];
	    if (excluded.indexOf(key) >= 0) continue;
	    target[key] = source[key];
	  }

	  return target;
	}

	function _objectWithoutProperties$2(source, excluded) {
	  if (source == null) return {};

	  var target = _objectWithoutPropertiesLoose$2(source, excluded);

	  var key, i;

	  if (Object.getOwnPropertySymbols) {
	    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

	    for (i = 0; i < sourceSymbolKeys.length; i++) {
	      key = sourceSymbolKeys[i];
	      if (excluded.indexOf(key) >= 0) continue;
	      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
	      target[key] = source[key];
	    }
	  }

	  return target;
	}

	var Icon = /*#__PURE__*/React__default.forwardRef(function Icon(_ref, ref) {
	  var className = _ref.className,
	      children = _ref.children,
	      tabIndex = _ref.tabIndex,
	      rest = _objectWithoutProperties$2(_ref, ["className", "children", "tabIndex"]);

	  var _getAttributes = getAttributes(_objectSpread2$1(_objectSpread2$1({}, rest), {}, {
	    tabindex: tabIndex
	  })),
	      tabindex = _getAttributes.tabindex,
	      props = _objectWithoutProperties$2(_getAttributes, ["tabindex"]);

	  if (className) {
	    props.className = className;
	  }

	  if (tabindex !== undefined && tabindex !== null) {
	    props.tabIndex = tabindex;
	  }

	  if (ref) {
	    props.ref = ref;
	  }

	  return /*#__PURE__*/React__default.createElement('svg', props, children);
	});
	Icon.displayName = 'Icon';
	Icon.propTypes = {
	  'aria-hidden': PropTypes.string,
	  'aria-label': PropTypes.string,
	  'aria-labelledby': PropTypes.string,
	  className: PropTypes.string,
	  children: PropTypes.node,
	  height: PropTypes.number,
	  preserveAspectRatio: PropTypes.string,
	  tabIndex: PropTypes.string,
	  viewBox: PropTypes.string,
	  width: PropTypes.number,
	  xmlns: PropTypes.string
	};
	Icon.defaultProps = {
	  xmlns: 'http://www.w3.org/2000/svg',
	  preserveAspectRatio: 'xMidYMid meet'
	};

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13 4L4 4 4 13.01 6 13.01 6 6 13 6 13 4zM29.49 13.12l-9-5a1 1 0 00-1 0l-9 5A1 1 0 0010 14V24a1 1 0 00.52.87l9 5A1 1 0 0020 30a1.05 1.05 0 00.49-.13l9-5A1 1 0 0030 24V14A1 1 0 0029.49 13.12zM19 27.3l-7-3.89V15.69l7 3.89zm1-9.45L13.06 14 20 10.14 26.94 14zm8 5.56L21 27.3V19.58l7-3.89z"
	});

	var WatsonHealth3DCursor32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCursor32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13 4L4 4 4 13.01 6 13.01 6 6 13 6 13 4zM29.49 13.12l-9-5a1 1 0 00-1 0l-9 5A1 1 0 0010 14V24a1 1 0 00.52.87l9 5A1 1 0 0020 30a1.05 1.05 0 00.49-.13l9-5A1 1 0 0030 24V14A1 1 0 0029.49 13.12zM19 27.3l-7-3.89V15.69l7 3.89zm1-9.45L13.06 14 20 10.14 26.94 14zm8 5.56L21 27.3V19.58l7-3.89z"
	});

	var WatsonHealth3DCursor24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCursor24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13 4L4 4 4 13.01 6 13.01 6 6 13 6 13 4zM29.49 13.12l-9-5a1 1 0 00-1 0l-9 5A1 1 0 0010 14V24a1 1 0 00.52.87l9 5A1 1 0 0020 30a1.05 1.05 0 00.49-.13l9-5A1 1 0 0030 24V14A1 1 0 0029.49 13.12zM19 27.3l-7-3.89V15.69l7 3.89zm1-9.45L13.06 14 20 10.14 26.94 14zm8 5.56L21 27.3V19.58l7-3.89z"
	});

	var WatsonHealth3DCursor20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCursor20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13 4L4 4 4 13.01 6 13.01 6 6 13 6 13 4zM29.49 13.12l-9-5a1 1 0 00-1 0l-9 5A1 1 0 0010 14V24a1 1 0 00.52.87l9 5A1 1 0 0020 30a1.05 1.05 0 00.49-.13l9-5A1 1 0 0030 24V14A1 1 0 0029.49 13.12zM19 27.3l-7-3.89V15.69l7 3.89zm1-9.45L13.06 14 20 10.14 26.94 14zm8 5.56L21 27.3V19.58l7-3.89z"
	});

	var WatsonHealth3DCursor16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCursor16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var _ref3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 7H17V14H15zM7 15H14V17H7zM15 18H17V25H15zM18 15H25V17H18z"
	});

	var WatsonHealth3DCursorAlt32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCursorAlt32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4, _ref3, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var _ref3$1 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 7H17V14H15zM7 15H14V17H7zM15 18H17V25H15zM18 15H25V17H18z"
	});

	var WatsonHealth3DCursorAlt24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCursorAlt24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5, _ref3$1, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var _ref3$2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 7H17V14H15zM7 15H14V17H7zM15 18H17V25H15zM18 15H25V17H18z"
	});

	var WatsonHealth3DCursorAlt20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCursorAlt20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6, _ref3$2, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$7 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var _ref3$3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 7H17V14H15zM7 15H14V17H7zM15 18H17V25H15zM18 15H25V17H18z"
	});

	var WatsonHealth3DCursorAlt16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCursorAlt16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$7, _ref3$3, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$8 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M9.5,8H20.1a5,5,0,1,0,0-2H9.5a5.5,5.5,0,0,0,0,11h11a3.5,3.5,0,0,1,0,7H11.9a5,5,0,1,0,0,2h8.6a5.5,5.5,0,0,0,0-11H9.5a3.5,3.5,0,0,1,0-7ZM25,4a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
	});

	var WatsonHealth3DCurveAutoColon32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveAutoColon32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$8, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$9 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M9.5,8H20.1a5,5,0,1,0,0-2H9.5a5.5,5.5,0,0,0,0,11h11a3.5,3.5,0,0,1,0,7H11.9a5,5,0,1,0,0,2h8.6a5.5,5.5,0,0,0,0-11H9.5a3.5,3.5,0,0,1,0-7ZM25,4a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
	});

	var WatsonHealth3DCurveAutoColon24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveAutoColon24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$9, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M9.5,8H20.1a5,5,0,1,0,0-2H9.5a5.5,5.5,0,0,0,0,11h11a3.5,3.5,0,0,1,0,7H11.9a5,5,0,1,0,0,2h8.6a5.5,5.5,0,0,0,0-11H9.5a3.5,3.5,0,0,1,0-7ZM25,4a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
	});

	var WatsonHealth3DCurveAutoColon20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveAutoColon20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$a, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M9.5,8H20.1a5,5,0,1,0,0-2H9.5a5.5,5.5,0,0,0,0,11h11a3.5,3.5,0,0,1,0,7H11.9a5,5,0,1,0,0,2h8.6a5.5,5.5,0,0,0,0-11H9.5a3.5,3.5,0,0,1,0-7ZM25,4a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
	});

	var WatsonHealth3DCurveAutoColon16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveAutoColon16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$b, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17,11a3,3,0,0,1,3-3h.1a5,5,0,1,0,0-2H20a5,5,0,0,0-5,5v1H13a3,3,0,0,1-3-3V7A5,5,0,0,0,5,2H4V4H5A3,3,0,0,1,8,7V9a5,5,0,0,0,5,5h2v7a3,3,0,0,1-3,3h-.1a5,5,0,1,0,0,2H12a5,5,0,0,0,5-5h2.5A2.5,2.5,0,0,1,22,23.5,4.51,4.51,0,0,0,26.5,28H28V26H26.5A2.5,2.5,0,0,1,24,23.5,4.51,4.51,0,0,0,19.5,19H17Zm8-7a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
	});

	var WatsonHealth3DCurveAutoVessels32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveAutoVessels32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$c, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17,11a3,3,0,0,1,3-3h.1a5,5,0,1,0,0-2H20a5,5,0,0,0-5,5v1H13a3,3,0,0,1-3-3V7A5,5,0,0,0,5,2H4V4H5A3,3,0,0,1,8,7V9a5,5,0,0,0,5,5h2v7a3,3,0,0,1-3,3h-.1a5,5,0,1,0,0,2H12a5,5,0,0,0,5-5h2.5A2.5,2.5,0,0,1,22,23.5,4.51,4.51,0,0,0,26.5,28H28V26H26.5A2.5,2.5,0,0,1,24,23.5,4.51,4.51,0,0,0,19.5,19H17Zm8-7a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
	});

	var WatsonHealth3DCurveAutoVessels24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveAutoVessels24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$d, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17,11a3,3,0,0,1,3-3h.1a5,5,0,1,0,0-2H20a5,5,0,0,0-5,5v1H13a3,3,0,0,1-3-3V7A5,5,0,0,0,5,2H4V4H5A3,3,0,0,1,8,7V9a5,5,0,0,0,5,5h2v7a3,3,0,0,1-3,3h-.1a5,5,0,1,0,0,2H12a5,5,0,0,0,5-5h2.5A2.5,2.5,0,0,1,22,23.5,4.51,4.51,0,0,0,26.5,28H28V26H26.5A2.5,2.5,0,0,1,24,23.5,4.51,4.51,0,0,0,19.5,19H17Zm8-7a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
	});

	var WatsonHealth3DCurveAutoVessels20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveAutoVessels20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$e, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17,11a3,3,0,0,1,3-3h.1a5,5,0,1,0,0-2H20a5,5,0,0,0-5,5v1H13a3,3,0,0,1-3-3V7A5,5,0,0,0,5,2H4V4H5A3,3,0,0,1,8,7V9a5,5,0,0,0,5,5h2v7a3,3,0,0,1-3,3h-.1a5,5,0,1,0,0,2H12a5,5,0,0,0,5-5h2.5A2.5,2.5,0,0,1,22,23.5,4.51,4.51,0,0,0,26.5,28H28V26H26.5A2.5,2.5,0,0,1,24,23.5,4.51,4.51,0,0,0,19.5,19H17Zm8-7a3,3,0,1,1-3,3A3,3,0,0,1,25,4ZM7,28a3,3,0,1,1,3-3A3,3,0,0,1,7,28Z"
	});

	var WatsonHealth3DCurveAutoVessels16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveAutoVessels16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$f, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 21a3 3 0 01-3 3h-.1a5 5 0 100 2H12a5 5 0 005-5zM7 28a3 3 0 113-3A3 3 0 017 28zM15 13H17V19H15zM25 2a5 5 0 00-4.9 4H20a5 5 0 00-5 5h2a3 3 0 013-3h.1A5 5 0 1025 2zm0 8a3 3 0 113-3A3 3 0 0125 10z"
	});

	var WatsonHealth3DCurveManual32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveManual32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$g, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 21a3 3 0 01-3 3h-.1a5 5 0 100 2H12a5 5 0 005-5zM7 28a3 3 0 113-3A3 3 0 017 28zM15 13H17V19H15zM25 2a5 5 0 00-4.9 4H20a5 5 0 00-5 5h2a3 3 0 013-3h.1A5 5 0 1025 2zm0 8a3 3 0 113-3A3 3 0 0125 10z"
	});

	var WatsonHealth3DCurveManual24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveManual24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$h, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 21a3 3 0 01-3 3h-.1a5 5 0 100 2H12a5 5 0 005-5zM7 28a3 3 0 113-3A3 3 0 017 28zM15 13H17V19H15zM25 2a5 5 0 00-4.9 4H20a5 5 0 00-5 5h2a3 3 0 013-3h.1A5 5 0 1025 2zm0 8a3 3 0 113-3A3 3 0 0125 10z"
	});

	var WatsonHealth3DCurveManual20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveManual20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$i, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 21a3 3 0 01-3 3h-.1a5 5 0 100 2H12a5 5 0 005-5zM7 28a3 3 0 113-3A3 3 0 017 28zM15 13H17V19H15zM25 2a5 5 0 00-4.9 4H20a5 5 0 00-5 5h2a3 3 0 013-3h.1A5 5 0 1025 2zm0 8a3 3 0 113-3A3 3 0 0125 10z"
	});

	var WatsonHealth3DCurveManual16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DCurveManual16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$j, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 14H10a2 2 0 01-2-2V4a2 2 0 01.59-1.42A3.57 3.57 0 0110 2h5V4H10v8h5zM4 6H6V14H4zM4 2H6V4H4zM27.45 19.11l-6-3a1 1 0 00-.9 0l-6 3A1 1 0 0014 20v7a1 1 0 00.55.89l6 3a1 1 0 00.9 0l6-3A1 1 0 0028 27V20A1 1 0 0027.45 19.11zm-6.45-1L24.76 20 21 21.88 17.24 20zm-5 3.5l4 2v4.76l-4-2zm6 6.76V23.62l4-2v4.76zM23 2H19a2 2 0 00-2 2V14h2V10h4v4h2V4A2 2 0 0023 2zM19 8V4h4V8z"
	});

	var WatsonHealth3DICa32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DICa32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$k, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 14H10a2 2 0 01-2-2V4a2 2 0 01.59-1.42A3.57 3.57 0 0110 2h5V4H10v8h5zM4 6H6V14H4zM4 2H6V4H4zM27.45 19.11l-6-3a1 1 0 00-.9 0l-6 3A1 1 0 0014 20v7a1 1 0 00.55.89l6 3a1 1 0 00.9 0l6-3A1 1 0 0028 27V20A1 1 0 0027.45 19.11zm-6.45-1L24.76 20 21 21.88 17.24 20zm-5 3.5l4 2v4.76l-4-2zm6 6.76V23.62l4-2v4.76zM23 2H19a2 2 0 00-2 2V14h2V10h4v4h2V4A2 2 0 0023 2zM19 8V4h4V8z"
	});

	var WatsonHealth3DICa24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DICa24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$l, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 14H10a2 2 0 01-2-2V4a2 2 0 01.59-1.42A3.57 3.57 0 0110 2h5V4H10v8h5zM4 6H6V14H4zM4 2H6V4H4zM27.45 19.11l-6-3a1 1 0 00-.9 0l-6 3A1 1 0 0014 20v7a1 1 0 00.55.89l6 3a1 1 0 00.9 0l6-3A1 1 0 0028 27V20A1 1 0 0027.45 19.11zm-6.45-1L24.76 20 21 21.88 17.24 20zm-5 3.5l4 2v4.76l-4-2zm6 6.76V23.62l4-2v4.76zM23 2H19a2 2 0 00-2 2V14h2V10h4v4h2V4A2 2 0 0023 2zM19 8V4h4V8z"
	});

	var WatsonHealth3DICa20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DICa20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$m, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 14H10a2 2 0 01-2-2V4a2 2 0 01.59-1.42A3.57 3.57 0 0110 2h5V4H10v8h5zM4 6H6V14H4zM4 2H6V4H4zM27.45 19.11l-6-3a1 1 0 00-.9 0l-6 3A1 1 0 0014 20v7a1 1 0 00.55.89l6 3a1 1 0 00.9 0l6-3A1 1 0 0028 27V20A1 1 0 0027.45 19.11zm-6.45-1L24.76 20 21 21.88 17.24 20zm-5 3.5l4 2v4.76l-4-2zm6 6.76V23.62l4-2v4.76zM23 2H19a2 2 0 00-2 2V14h2V10h4v4h2V4A2 2 0 0023 2zM19 8V4h4V8z"
	});

	var WatsonHealth3DICa16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DICa16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$n, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 2L2 2 2 11 4 11 4 4 11 4 11 2zM2 21L2 30 11 30 11 28 4 28 4 21 2 21zM30 11L30 2 21 2 21 4 28 4 28 11 30 11zM21 30L30 30 30 21 28 21 28 28 21 28 21 30zM25.49 10.13l-9-5a1 1 0 00-1 0l-9 5A1 1 0 006 11V21a1 1 0 00.51.87l9 5a1 1 0 001 0l9-5A1 1 0 0026 21V11A1 1 0 0025.49 10.13zM16 7.14L22.94 11 16 14.86 9.06 11zM8 12.7l7 3.89V24.3L8 20.41zm9 11.6V16.59l7-3.89v7.71z"
	});

	var WatsonHealth3DMprToggle32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DMprToggle32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$o, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 2L2 2 2 11 4 11 4 4 11 4 11 2zM2 21L2 30 11 30 11 28 4 28 4 21 2 21zM30 11L30 2 21 2 21 4 28 4 28 11 30 11zM21 30L30 30 30 21 28 21 28 28 21 28 21 30zM25.49 10.13l-9-5a1 1 0 00-1 0l-9 5A1 1 0 006 11V21a1 1 0 00.51.87l9 5a1 1 0 001 0l9-5A1 1 0 0026 21V11A1 1 0 0025.49 10.13zM16 7.14L22.94 11 16 14.86 9.06 11zM8 12.7l7 3.89V24.3L8 20.41zm9 11.6V16.59l7-3.89v7.71z"
	});

	var WatsonHealth3DMprToggle24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DMprToggle24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$p, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 2L2 2 2 11 4 11 4 4 11 4 11 2zM2 21L2 30 11 30 11 28 4 28 4 21 2 21zM30 11L30 2 21 2 21 4 28 4 28 11 30 11zM21 30L30 30 30 21 28 21 28 28 21 28 21 30zM25.49 10.13l-9-5a1 1 0 00-1 0l-9 5A1 1 0 006 11V21a1 1 0 00.51.87l9 5a1 1 0 001 0l9-5A1 1 0 0026 21V11A1 1 0 0025.49 10.13zM16 7.14L22.94 11 16 14.86 9.06 11zM8 12.7l7 3.89V24.3L8 20.41zm9 11.6V16.59l7-3.89v7.71z"
	});

	var WatsonHealth3DMprToggle20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DMprToggle20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 2L2 2 2 11 4 11 4 4 11 4 11 2zM2 21L2 30 11 30 11 28 4 28 4 21 2 21zM30 11L30 2 21 2 21 4 28 4 28 11 30 11zM21 30L30 30 30 21 28 21 28 28 21 28 21 30zM25.49 10.13l-9-5a1 1 0 00-1 0l-9 5A1 1 0 006 11V21a1 1 0 00.51.87l9 5a1 1 0 001 0l9-5A1 1 0 0026 21V11A1 1 0 0025.49 10.13zM16 7.14L22.94 11 16 14.86 9.06 11zM8 12.7l7 3.89V24.3L8 20.41zm9 11.6V16.59l7-3.89v7.71z"
	});

	var WatsonHealth3DMprToggle16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DMprToggle16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$r, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M29.9761,15.7832l-2-9a.9992.9992,0,0,0-.4214-.6152l-6-4A1.0008,1.0008,0,0,0,21,2H11a1.0008,1.0008,0,0,0-.5547.168l-6,4a.9992.9992,0,0,0-.4214.6152l-2,9a1.0019,1.0019,0,0,0,.0181.5039l3,10a1,1,0,0,0,.6709.6709l10,3,.0051.0005a.9789.9789,0,0,0,.564,0l.0051-.0005,10-3a1,1,0,0,0,.6709-.6709l3-10A1.0019,1.0019,0,0,0,29.9761,15.7832Zm-19.05.833L7.0168,8.7974l7.2815,2.6479ZM16,12.4971,19.5889,18H12.4111ZM19.3818,20,16,26.7637,12.6182,20Zm-1.68-8.5547,7.2815-2.6479-3.91,7.8188ZM18.19,9.14l3.0961-4.747,3.5152,2.3432ZM16,8.8364,12.8459,4h6.3082Zm-2.19.3032L7.1992,6.7358l3.5152-2.3432Zm-4.8439,8.03-4.802-1.8007L5.3652,9.9668ZM14.07,27.377,7.5679,25.4263l3.1284-4.7969Zm7.2334-6.7476,3.1284,4.7969L17.93,27.377ZM26.6348,9.9668l1.2006,5.4019-4.802,1.8007ZM4.5374,17.6445l4.5944,1.7227L6.3391,23.65ZM25.6609,23.65l-2.7927-4.2827,4.5944-1.7227Z"
	});

	var WatsonHealth3DPrintMesh32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DPrintMesh32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$s, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M29.9761,15.7832l-2-9a.9992.9992,0,0,0-.4214-.6152l-6-4A1.0008,1.0008,0,0,0,21,2H11a1.0008,1.0008,0,0,0-.5547.168l-6,4a.9992.9992,0,0,0-.4214.6152l-2,9a1.0019,1.0019,0,0,0,.0181.5039l3,10a1,1,0,0,0,.6709.6709l10,3,.0051.0005a.9789.9789,0,0,0,.564,0l.0051-.0005,10-3a1,1,0,0,0,.6709-.6709l3-10A1.0019,1.0019,0,0,0,29.9761,15.7832Zm-19.05.833L7.0168,8.7974l7.2815,2.6479ZM16,12.4971,19.5889,18H12.4111ZM19.3818,20,16,26.7637,12.6182,20Zm-1.68-8.5547,7.2815-2.6479-3.91,7.8188ZM18.19,9.14l3.0961-4.747,3.5152,2.3432ZM16,8.8364,12.8459,4h6.3082Zm-2.19.3032L7.1992,6.7358l3.5152-2.3432Zm-4.8439,8.03-4.802-1.8007L5.3652,9.9668ZM14.07,27.377,7.5679,25.4263l3.1284-4.7969Zm7.2334-6.7476,3.1284,4.7969L17.93,27.377ZM26.6348,9.9668l1.2006,5.4019-4.802,1.8007ZM4.5374,17.6445l4.5944,1.7227L6.3391,23.65ZM25.6609,23.65l-2.7927-4.2827,4.5944-1.7227Z"
	});

	var WatsonHealth3DPrintMesh24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DPrintMesh24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$t, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M29.9761,15.7832l-2-9a.9992.9992,0,0,0-.4214-.6152l-6-4A1.0008,1.0008,0,0,0,21,2H11a1.0008,1.0008,0,0,0-.5547.168l-6,4a.9992.9992,0,0,0-.4214.6152l-2,9a1.0019,1.0019,0,0,0,.0181.5039l3,10a1,1,0,0,0,.6709.6709l10,3,.0051.0005a.9789.9789,0,0,0,.564,0l.0051-.0005,10-3a1,1,0,0,0,.6709-.6709l3-10A1.0019,1.0019,0,0,0,29.9761,15.7832Zm-19.05.833L7.0168,8.7974l7.2815,2.6479ZM16,12.4971,19.5889,18H12.4111ZM19.3818,20,16,26.7637,12.6182,20Zm-1.68-8.5547,7.2815-2.6479-3.91,7.8188ZM18.19,9.14l3.0961-4.747,3.5152,2.3432ZM16,8.8364,12.8459,4h6.3082Zm-2.19.3032L7.1992,6.7358l3.5152-2.3432Zm-4.8439,8.03-4.802-1.8007L5.3652,9.9668ZM14.07,27.377,7.5679,25.4263l3.1284-4.7969Zm7.2334-6.7476,3.1284,4.7969L17.93,27.377ZM26.6348,9.9668l1.2006,5.4019-4.802,1.8007ZM4.5374,17.6445l4.5944,1.7227L6.3391,23.65ZM25.6609,23.65l-2.7927-4.2827,4.5944-1.7227Z"
	});

	var WatsonHealth3DPrintMesh20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DPrintMesh20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$u, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M29.9761,15.7832l-2-9a.9992.9992,0,0,0-.4214-.6152l-6-4A1.0008,1.0008,0,0,0,21,2H11a1.0008,1.0008,0,0,0-.5547.168l-6,4a.9992.9992,0,0,0-.4214.6152l-2,9a1.0019,1.0019,0,0,0,.0181.5039l3,10a1,1,0,0,0,.6709.6709l10,3,.0051.0005a.9789.9789,0,0,0,.564,0l.0051-.0005,10-3a1,1,0,0,0,.6709-.6709l3-10A1.0019,1.0019,0,0,0,29.9761,15.7832Zm-19.05.833L7.0168,8.7974l7.2815,2.6479ZM16,12.4971,19.5889,18H12.4111ZM19.3818,20,16,26.7637,12.6182,20Zm-1.68-8.5547,7.2815-2.6479-3.91,7.8188ZM18.19,9.14l3.0961-4.747,3.5152,2.3432ZM16,8.8364,12.8459,4h6.3082Zm-2.19.3032L7.1992,6.7358l3.5152-2.3432Zm-4.8439,8.03-4.802-1.8007L5.3652,9.9668ZM14.07,27.377,7.5679,25.4263l3.1284-4.7969Zm7.2334-6.7476,3.1284,4.7969L17.93,27.377ZM26.6348,9.9668l1.2006,5.4019-4.802,1.8007ZM4.5374,17.6445l4.5944,1.7227L6.3391,23.65ZM25.6609,23.65l-2.7927-4.2827,4.5944-1.7227Z"
	});

	var WatsonHealth3DPrintMesh16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DPrintMesh16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$v, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.49 13.1151l-9-5a1 1 0 00-1 0l-9 5A1.0078 1.0078 0 002 14v9.9951a1 1 0 00.52.87l9 5A1.0045 1.0045 0 0012 30a1.0559 1.0559 0 00.49-.1349l9-5A.9923.9923 0 0022 24V14A1.0079 1.0079 0 0021.49 13.1151zM11 27.2951l-7-3.89v-7.72l7 3.89zm1-9.45L5.06 14 12 10.1351l6.94 3.86zm8 5.56l-7 3.89v-7.72l7-3.89zM30 6L26 6 26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6z"
	});

	var WatsonHealth3DSoftware32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DSoftware32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$w, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.49 13.1151l-9-5a1 1 0 00-1 0l-9 5A1.0078 1.0078 0 002 14v9.9951a1 1 0 00.52.87l9 5A1.0045 1.0045 0 0012 30a1.0559 1.0559 0 00.49-.1349l9-5A.9923.9923 0 0022 24V14A1.0079 1.0079 0 0021.49 13.1151zM11 27.2951l-7-3.89v-7.72l7 3.89zm1-9.45L5.06 14 12 10.1351l6.94 3.86zm8 5.56l-7 3.89v-7.72l7-3.89zM30 6L26 6 26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6z"
	});

	var WatsonHealth3DSoftware24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DSoftware24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$x, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.49 13.1151l-9-5a1 1 0 00-1 0l-9 5A1.0078 1.0078 0 002 14v9.9951a1 1 0 00.52.87l9 5A1.0045 1.0045 0 0012 30a1.0559 1.0559 0 00.49-.1349l9-5A.9923.9923 0 0022 24V14A1.0079 1.0079 0 0021.49 13.1151zM11 27.2951l-7-3.89v-7.72l7 3.89zm1-9.45L5.06 14 12 10.1351l6.94 3.86zm8 5.56l-7 3.89v-7.72l7-3.89zM30 6L26 6 26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6z"
	});

	var WatsonHealth3DSoftware20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DSoftware20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.49 13.1151l-9-5a1 1 0 00-1 0l-9 5A1.0078 1.0078 0 002 14v9.9951a1 1 0 00.52.87l9 5A1.0045 1.0045 0 0012 30a1.0559 1.0559 0 00.49-.1349l9-5A.9923.9923 0 0022 24V14A1.0079 1.0079 0 0021.49 13.1151zM11 27.2951l-7-3.89v-7.72l7 3.89zm1-9.45L5.06 14 12 10.1351l6.94 3.86zm8 5.56l-7 3.89v-7.72l7-3.89zM30 6L26 6 26 2 24 2 24 6 20 6 20 8 24 8 24 12 26 12 26 8 30 8 30 6z"
	});

	var WatsonHealth3DSoftware16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3DSoftware16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$A =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM16,20a4,4,0,1,1,4-4A4,4,0,0,1,16,20Z"
	});

	var WatsonHealth3rdPartyConnected32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3rdPartyConnected32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$A, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$B =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM16,20a4,4,0,1,1,4-4A4,4,0,0,1,16,20Z"
	});

	var WatsonHealth3rdPartyConnected24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3rdPartyConnected24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$B, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$C =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM16,20a4,4,0,1,1,4-4A4,4,0,0,1,16,20Z"
	});

	var WatsonHealth3rdPartyConnected20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3rdPartyConnected20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$C, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$D =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM16,20a4,4,0,1,1,4-4A4,4,0,0,1,16,20Z"
	});

	var WatsonHealth3rdPartyConnected16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealth3rdPartyConnected16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$D, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$E =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12 11.03L12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03zM24.19 11.03L22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03z"
	});

	var _ref3$4 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"
	});

	var _4K32 = /*#__PURE__*/React__default.forwardRef(function _4K32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$E, _ref3$4, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$F =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12 11.03L12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03zM24.19 11.03L22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03z"
	});

	var _ref3$5 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"
	});

	var _4K24 = /*#__PURE__*/React__default.forwardRef(function _4K24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$F, _ref3$5, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$G =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12 11.03L12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03zM24.19 11.03L22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03z"
	});

	var _ref3$6 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"
	});

	var _4K20 = /*#__PURE__*/React__default.forwardRef(function _4K20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$G, _ref3$6, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$H =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12 11.03L12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03zM24.19 11.03L22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03z"
	});

	var _ref3$7 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"
	});

	var _4K16 = /*#__PURE__*/React__default.forwardRef(function _4K16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$H, _ref3$7, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$I =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"
	});

	var _4KFilled32 = /*#__PURE__*/React__default.forwardRef(function _4KFilled32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$I, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$J =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"
	});

	var _4KFilled24 = /*#__PURE__*/React__default.forwardRef(function _4KFilled24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$J, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$K =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"
	});

	var _4KFilled20 = /*#__PURE__*/React__default.forwardRef(function _4KFilled20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$K, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$L =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"
	});

	var _4KFilled16 = /*#__PURE__*/React__default.forwardRef(function _4KFilled16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$L, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$M =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M29.55 26.11L26.5 27.63 23.66 21H15a2 2 0 01-2-2V13a2 2 0 014 0v4h7V15H19V13a4 4 0 00-8 0v1a9 9 0 108.77 11H17.71A7 7 0 1111 16v3a4 4 0 004 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1119 4.5 3.5 3.5 0 0115.5 8zm0-5A1.5 1.5 0 1017 4.5 1.5 1.5 0 0015.5 3z"
	});

	var Accessibility32 = /*#__PURE__*/React__default.forwardRef(function Accessibility32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$M, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$N =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M29.55 26.11L26.5 27.63 23.66 21H15a2 2 0 01-2-2V13a2 2 0 014 0v4h7V15H19V13a4 4 0 00-8 0v1a9 9 0 108.77 11H17.71A7 7 0 1111 16v3a4 4 0 004 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1119 4.5 3.5 3.5 0 0115.5 8zm0-5A1.5 1.5 0 1017 4.5 1.5 1.5 0 0015.5 3z"
	});

	var Accessibility24 = /*#__PURE__*/React__default.forwardRef(function Accessibility24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$N, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$O =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M29.55 26.11L26.5 27.63 23.66 21H15a2 2 0 01-2-2V13a2 2 0 014 0v4h7V15H19V13a4 4 0 00-8 0v1a9 9 0 108.77 11H17.71A7 7 0 1111 16v3a4 4 0 004 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1119 4.5 3.5 3.5 0 0115.5 8zm0-5A1.5 1.5 0 1017 4.5 1.5 1.5 0 0015.5 3z"
	});

	var Accessibility20 = /*#__PURE__*/React__default.forwardRef(function Accessibility20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$O, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$P =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M29.55 26.11L26.5 27.63 23.66 21H15a2 2 0 01-2-2V13a2 2 0 014 0v4h7V15H19V13a4 4 0 00-8 0v1a9 9 0 108.77 11H17.71A7 7 0 1111 16v3a4 4 0 004 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1119 4.5 3.5 3.5 0 0115.5 8zm0-5A1.5 1.5 0 1017 4.5 1.5 1.5 0 0015.5 3z"
	});

	var Accessibility16 = /*#__PURE__*/React__default.forwardRef(function Accessibility16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$P, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$Q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23 14L23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14z"
	});

	var _ref3$8 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "16",
	  cy: "9",
	  r: "2"
	});

	var _ref4 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var AccessibilityAlt32 = /*#__PURE__*/React__default.forwardRef(function AccessibilityAlt32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$Q, _ref3$8, _ref4, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$R =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23 14L23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14z"
	});

	var _ref3$9 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "16",
	  cy: "9",
	  r: "2"
	});

	var _ref4$1 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var AccessibilityAlt24 = /*#__PURE__*/React__default.forwardRef(function AccessibilityAlt24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$R, _ref3$9, _ref4$1, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$S =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23 14L23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14z"
	});

	var _ref3$a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "16",
	  cy: "9",
	  r: "2"
	});

	var _ref4$2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var AccessibilityAlt20 = /*#__PURE__*/React__default.forwardRef(function AccessibilityAlt20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$S, _ref3$a, _ref4$2, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$T =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23 14L23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14z"
	});

	var _ref3$b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "16",
	  cy: "9",
	  r: "2"
	});

	var _ref4$3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var AccessibilityAlt16 = /*#__PURE__*/React__default.forwardRef(function AccessibilityAlt16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$T, _ref3$b, _ref4$3, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$U =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
	});

	var _ref3$c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
	});

	var _ref4$4 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var AccessibilityColor32 = /*#__PURE__*/React__default.forwardRef(function AccessibilityColor32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$U, _ref3$c, _ref4$4, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$V =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
	});

	var _ref3$d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
	});

	var _ref4$5 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var AccessibilityColor24 = /*#__PURE__*/React__default.forwardRef(function AccessibilityColor24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$V, _ref3$d, _ref4$5, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$W =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
	});

	var _ref3$e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
	});

	var _ref4$6 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var AccessibilityColor20 = /*#__PURE__*/React__default.forwardRef(function AccessibilityColor20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$W, _ref3$e, _ref4$6, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$X =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
	});

	var _ref3$f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
	});

	var _ref4$7 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
	});

	var AccessibilityColor16 = /*#__PURE__*/React__default.forwardRef(function AccessibilityColor16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$X, _ref3$f, _ref4$7, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$Y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"
	});

	var _ref3$g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"
	});

	var _ref4$8 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "16",
	  cy: "16",
	  r: "2"
	});

	var _ref5 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
	});

	var _ref6 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
	});

	var AccessibilityColorFilled32 = /*#__PURE__*/React__default.forwardRef(function AccessibilityColorFilled32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$Y, _ref3$g, _ref4$8, _ref5, _ref6, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$Z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"
	});

	var _ref3$h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"
	});

	var _ref4$9 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "16",
	  cy: "16",
	  r: "2"
	});

	var _ref5$1 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
	});

	var _ref6$1 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
	});

	var AccessibilityColorFilled24 = /*#__PURE__*/React__default.forwardRef(function AccessibilityColorFilled24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$Z, _ref3$h, _ref4$9, _ref5$1, _ref6$1, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$_ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"
	});

	var _ref3$i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"
	});

	var _ref4$a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "16",
	  cy: "16",
	  r: "2"
	});

	var _ref5$2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
	});

	var _ref6$2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
	});

	var AccessibilityColorFilled20 = /*#__PURE__*/React__default.forwardRef(function AccessibilityColorFilled20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$_, _ref3$i, _ref4$a, _ref5$2, _ref6$2, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$$ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"
	});

	var _ref3$j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"
	});

	var _ref4$b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "16",
	  cy: "16",
	  r: "2"
	});

	var _ref5$3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"
	});

	var _ref6$3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"
	});

	var AccessibilityColorFilled16 = /*#__PURE__*/React__default.forwardRef(function AccessibilityColorFilled16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$$, _ref3$j, _ref4$b, _ref5$3, _ref6$3, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$10 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8,14H19v2H8Zm0,5H21v2H8Z"
	});

	var _ref3$k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"
	});

	var Account32 = /*#__PURE__*/React__default.forwardRef(function Account32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$10, _ref3$k, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$11 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8,14H19v2H8Zm0,5H21v2H8Z"
	});

	var _ref3$l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"
	});

	var Account24 = /*#__PURE__*/React__default.forwardRef(function Account24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$11, _ref3$l, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$12 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8,14H19v2H8Zm0,5H21v2H8Z"
	});

	var _ref3$m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"
	});

	var Account20 = /*#__PURE__*/React__default.forwardRef(function Account20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$12, _ref3$m, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$13 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8,14H19v2H8Zm0,5H21v2H8Z"
	});

	var _ref3$n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"
	});

	var Account16 = /*#__PURE__*/React__default.forwardRef(function Account16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$13, _ref3$n, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$14 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"
	});

	var Activity32 = /*#__PURE__*/React__default.forwardRef(function Activity32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$14, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$15 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"
	});

	var Activity24 = /*#__PURE__*/React__default.forwardRef(function Activity24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$15, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$16 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"
	});

	var Activity20 = /*#__PURE__*/React__default.forwardRef(function Activity20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$16, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$17 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"
	});

	var Activity16 = /*#__PURE__*/React__default.forwardRef(function Activity16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$17, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$18 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17 15L17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17 24 15z"
	});

	var Add32 = /*#__PURE__*/React__default.forwardRef(function Add32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$18, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$19 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17 15L17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17 24 15z"
	});

	var Add24 = /*#__PURE__*/React__default.forwardRef(function Add24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$19, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17 15L17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17 24 15z"
	});

	var Add20 = /*#__PURE__*/React__default.forwardRef(function Add20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1a, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17 15L17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17 24 15z"
	});

	var Add16 = /*#__PURE__*/React__default.forwardRef(function Add16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1b, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"
	});

	var _ref3$o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 15L17 15 17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17z"
	});

	var AddAlt32 = /*#__PURE__*/React__default.forwardRef(function AddAlt32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1c, _ref3$o, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"
	});

	var _ref3$p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 15L17 15 17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17z"
	});

	var AddAlt24 = /*#__PURE__*/React__default.forwardRef(function AddAlt24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1d, _ref3$p, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"
	});

	var _ref3$q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 15L17 15 17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17z"
	});

	var AddAlt20 = /*#__PURE__*/React__default.forwardRef(function AddAlt20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1e, _ref3$q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"
	});

	var _ref3$r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 15L17 15 17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17z"
	});

	var AddAlt16 = /*#__PURE__*/React__default.forwardRef(function AddAlt16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1f, _ref3$r, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2C8.4,2,2,8.4,2,16s6.4,14,14,14s14-6.4,14-14S23.6,2,16,2z M24,17h-7v7h-2v-7H8v-2h7V8h2v7h7V17z"
	});

	var _ref3$s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M24 17L17 17 17 24 15 24 15 17 8 17 8 15 15 15 15 8 17 8 17 15 24 15z",
	  "data-icon-path": "inner-path"
	});

	var AddFilled32 = /*#__PURE__*/React__default.forwardRef(function AddFilled32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1g, _ref3$s, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2C8.4,2,2,8.4,2,16s6.4,14,14,14s14-6.4,14-14S23.6,2,16,2z M24,17h-7v7h-2v-7H8v-2h7V8h2v7h7V17z"
	});

	var _ref3$t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M24 17L17 17 17 24 15 24 15 17 8 17 8 15 15 15 15 8 17 8 17 15 24 15z",
	  "data-icon-path": "inner-path"
	});

	var AddFilled24 = /*#__PURE__*/React__default.forwardRef(function AddFilled24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1h, _ref3$t, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2C8.4,2,2,8.4,2,16s6.4,14,14,14s14-6.4,14-14S23.6,2,16,2z M24,17h-7v7h-2v-7H8v-2h7V8h2v7h7V17z"
	});

	var _ref3$u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M24 17L17 17 17 24 15 24 15 17 8 17 8 15 15 15 15 8 17 8 17 15 24 15z",
	  "data-icon-path": "inner-path"
	});

	var AddFilled20 = /*#__PURE__*/React__default.forwardRef(function AddFilled20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1i, _ref3$u, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2C8.4,2,2,8.4,2,16s6.4,14,14,14s14-6.4,14-14S23.6,2,16,2z M24,17h-7v7h-2v-7H8v-2h7V8h2v7h7V17z"
	});

	var _ref3$v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  fill: "none",
	  d: "M24 17L17 17 17 24 15 24 15 17 8 17 8 15 15 15 15 8 17 8 17 15 24 15z",
	  "data-icon-path": "inner-path"
	});

	var AddFilled16 = /*#__PURE__*/React__default.forwardRef(function AddFilled16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1j, _ref3$v, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
	});

	var _ref3$w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17 9L15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9z"
	});

	var AddComment32 = /*#__PURE__*/React__default.forwardRef(function AddComment32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1k, _ref3$w, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
	});

	var _ref3$x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17 9L15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9z"
	});

	var AddComment24 = /*#__PURE__*/React__default.forwardRef(function AddComment24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1l, _ref3$x, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
	});

	var _ref3$y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17 9L15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9z"
	});

	var AddComment20 = /*#__PURE__*/React__default.forwardRef(function AddComment20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1m, _ref3$y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"
	});

	var _ref3$z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M17 9L15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9z"
	});

	var AddComment16 = /*#__PURE__*/React__default.forwardRef(function AddComment16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1n, _ref3$z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 8a5.9908 5.9908 0 009.4712 4.8853L28.586 16 30 14.586l-3.115-3.1148A5.997 5.997 0 1016 8zm2 0a4 4 0 114 4A4.0045 4.0045 0 0118 8zM11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0055 8.0055 0 016-7.7373L13.6138 2.3A10.0088 10.0088 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.0493 16a9.5991 9.5991 0 01-1.8716 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857a10.9664 10.9664 0 002.3686-2.8331z"
	});

	var WatsonHealthAiResults32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResults32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1o, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 8a5.9908 5.9908 0 009.4712 4.8853L28.586 16 30 14.586l-3.115-3.1148A5.997 5.997 0 1016 8zm2 0a4 4 0 114 4A4.0045 4.0045 0 0118 8zM11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0055 8.0055 0 016-7.7373L13.6138 2.3A10.0088 10.0088 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.0493 16a9.5991 9.5991 0 01-1.8716 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857a10.9664 10.9664 0 002.3686-2.8331z"
	});

	var WatsonHealthAiResults24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResults24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1p, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 8a5.9908 5.9908 0 009.4712 4.8853L28.586 16 30 14.586l-3.115-3.1148A5.997 5.997 0 1016 8zm2 0a4 4 0 114 4A4.0045 4.0045 0 0118 8zM11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0055 8.0055 0 016-7.7373L13.6138 2.3A10.0088 10.0088 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.0493 16a9.5991 9.5991 0 01-1.8716 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857a10.9664 10.9664 0 002.3686-2.8331z"
	});

	var WatsonHealthAiResults20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResults20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 8a5.9908 5.9908 0 009.4712 4.8853L28.586 16 30 14.586l-3.115-3.1148A5.997 5.997 0 1016 8zm2 0a4 4 0 114 4A4.0045 4.0045 0 0118 8zM11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0055 8.0055 0 016-7.7373L13.6138 2.3A10.0088 10.0088 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.0493 16a9.5991 9.5991 0 01-1.8716 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857a10.9664 10.9664 0 002.3686-2.8331z"
	});

	var WatsonHealthAiResults16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResults16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1r, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.9279 7.9279 0 013.69.9106l.8958-1.791A9.99 9.99 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4zM29 14H19a1 1 0 01-.8945-1.4473l5-10a1 1 0 011.7888 0l5 10A1 1 0 0129 14zm-8.3818-2h6.7636L24 5.2361z"
	});

	var WatsonHealthAiResultsHigh32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsHigh32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1s, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.9279 7.9279 0 013.69.9106l.8958-1.791A9.99 9.99 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4zM29 14H19a1 1 0 01-.8945-1.4473l5-10a1 1 0 011.7888 0l5 10A1 1 0 0129 14zm-8.3818-2h6.7636L24 5.2361z"
	});

	var WatsonHealthAiResultsHigh24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsHigh24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1t, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.9279 7.9279 0 013.69.9106l.8958-1.791A9.99 9.99 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4zM29 14H19a1 1 0 01-.8945-1.4473l5-10a1 1 0 011.7888 0l5 10A1 1 0 0129 14zm-8.3818-2h6.7636L24 5.2361z"
	});

	var WatsonHealthAiResultsHigh20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsHigh20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1u, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.9279 7.9279 0 013.69.9106l.8958-1.791A9.99 9.99 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4zM29 14H19a1 1 0 01-.8945-1.4473l5-10a1 1 0 011.7888 0l5 10A1 1 0 0129 14zm-8.3818-2h6.7636L24 5.2361z"
	});

	var WatsonHealthAiResultsHigh16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsHigh16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1v, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM24 14a6 6 0 116-6A6.0067 6.0067 0 0124 14zM24 4a4 4 0 104 4A4.0045 4.0045 0 0024 4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsLow32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsLow32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1w, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM24 14a6 6 0 116-6A6.0067 6.0067 0 0124 14zM24 4a4 4 0 104 4A4.0045 4.0045 0 0024 4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsLow24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsLow24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1x, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM24 14a6 6 0 116-6A6.0067 6.0067 0 0124 14zM24 4a4 4 0 104 4A4.0045 4.0045 0 0024 4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsLow20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsLow20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM24 14a6 6 0 116-6A6.0067 6.0067 0 0124 14zM24 4a4 4 0 104 4A4.0045 4.0045 0 0024 4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsLow16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsLow16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1A =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM28 14H20a2.0021 2.0021 0 01-2-2V4a2.0021 2.0021 0 012-2h8a2.0021 2.0021 0 012 2v8A2.0021 2.0021 0 0128 14zM20 4v8h8V4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsMedium32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsMedium32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1A, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1B =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM28 14H20a2.0021 2.0021 0 01-2-2V4a2.0021 2.0021 0 012-2h8a2.0021 2.0021 0 012 2v8A2.0021 2.0021 0 0128 14zM20 4v8h8V4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsMedium24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsMedium24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1B, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1C =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM28 14H20a2.0021 2.0021 0 01-2-2V4a2.0021 2.0021 0 012-2h8a2.0021 2.0021 0 012 2v8A2.0021 2.0021 0 0128 14zM20 4v8h8V4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsMedium20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsMedium20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1C, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1D =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM28 14H20a2.0021 2.0021 0 01-2-2V4a2.0021 2.0021 0 012-2h8a2.0021 2.0021 0 012 2v8A2.0021 2.0021 0 0128 14zM20 4v8h8V4zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsMedium16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsMedium16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1D, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1E =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM20 2H22V9H20zM21 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0021 11zM26 2H28V9H26zM27 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0027 11zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsUrgent32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsUrgent32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1E, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1F =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM20 2H22V9H20zM21 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0021 11zM26 2H28V9H26zM27 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0027 11zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsUrgent24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsUrgent24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1F, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1G =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM20 2H22V9H20zM21 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0021 11zM26 2H28V9H26zM27 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0027 11zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsUrgent20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsUrgent20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1G, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1H =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM20 2H22V9H20zM21 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0021 11zM26 2H28V9H26zM27 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0027 11zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16z"
	});

	var WatsonHealthAiResultsUrgent16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsUrgent16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1H, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1I =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 2H26V9H24zM25 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0025 11zM11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.94 7.94 0 014 1.0825V2.8408A9.9887 9.9887 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4z"
	});

	var WatsonHealthAiResultsVeryHigh32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsVeryHigh32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1I, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1J =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 2H26V9H24zM25 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0025 11zM11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.94 7.94 0 014 1.0825V2.8408A9.9887 9.9887 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4z"
	});

	var WatsonHealthAiResultsVeryHigh24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsVeryHigh24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1J, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1K =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 2H26V9H24zM25 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0025 11zM11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.94 7.94 0 014 1.0825V2.8408A9.9887 9.9887 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4z"
	});

	var WatsonHealthAiResultsVeryHigh20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsVeryHigh20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1K, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1L =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 2H26V9H24zM25 11a1.5 1.5 0 101.5 1.5A1.5 1.5 0 0025 11zM11 24H21V26H11zM13 28H19V30H13zM23.0488 16a9.6136 9.6136 0 01-1.8711 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9886 9.9886 0 0025.2815 16zM16 4a7.94 7.94 0 014 1.0825V2.8408A9.9887 9.9887 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2c0-1.84-1.1108-2.8662-2.1855-3.8594A7.1851 7.1851 0 018 12 8.0092 8.0092 0 0116 4z"
	});

	var WatsonHealthAiResultsVeryHigh16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiResultsVeryHigh16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1L, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1M =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM20 14a1 1 0 01-.8945-.5527L17.3818 10H14V8h4a1 1 0 01.8945.5527L20 10.7639l3.1055-6.2112a1.0416 1.0416 0 011.789 0L26.6182 8H30v2H26a1 1 0 01-.8945-.5527L24 7.2361l-3.1055 6.2112A1 1 0 0120 14z"
	});

	var _ref3$A =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10.8145,18.1406A7.1851,7.1851,0,0,1,8,12a8.0092,8.0092,0,0,1,8-8V2A10.0111,10.0111,0,0,0,6,12a9.1793,9.1793,0,0,0,3.46,7.6162C10.4717,20.5508,11,21.0815,11,22h2C13,20.16,11.8892,19.1338,10.8145,18.1406Z"
	});

	var WatsonHealthAiStatus32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatus32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1M, _ref3$A, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1N =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM20 14a1 1 0 01-.8945-.5527L17.3818 10H14V8h4a1 1 0 01.8945.5527L20 10.7639l3.1055-6.2112a1.0416 1.0416 0 011.789 0L26.6182 8H30v2H26a1 1 0 01-.8945-.5527L24 7.2361l-3.1055 6.2112A1 1 0 0120 14z"
	});

	var _ref3$B =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10.8145,18.1406A7.1851,7.1851,0,0,1,8,12a8.0092,8.0092,0,0,1,8-8V2A10.0111,10.0111,0,0,0,6,12a9.1793,9.1793,0,0,0,3.46,7.6162C10.4717,20.5508,11,21.0815,11,22h2C13,20.16,11.8892,19.1338,10.8145,18.1406Z"
	});

	var WatsonHealthAiStatus24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatus24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1N, _ref3$B, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1O =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM20 14a1 1 0 01-.8945-.5527L17.3818 10H14V8h4a1 1 0 01.8945.5527L20 10.7639l3.1055-6.2112a1.0416 1.0416 0 011.789 0L26.6182 8H30v2H26a1 1 0 01-.8945-.5527L24 7.2361l-3.1055 6.2112A1 1 0 0120 14z"
	});

	var _ref3$C =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10.8145,18.1406A7.1851,7.1851,0,0,1,8,12a8.0092,8.0092,0,0,1,8-8V2A10.0111,10.0111,0,0,0,6,12a9.1793,9.1793,0,0,0,3.46,7.6162C10.4717,20.5508,11,21.0815,11,22h2C13,20.16,11.8892,19.1338,10.8145,18.1406Z"
	});

	var WatsonHealthAiStatus20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatus20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1O, _ref3$C, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1P =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM20 14a1 1 0 01-.8945-.5527L17.3818 10H14V8h4a1 1 0 01.8945.5527L20 10.7639l3.1055-6.2112a1.0416 1.0416 0 011.789 0L26.6182 8H30v2H26a1 1 0 01-.8945-.5527L24 7.2361l-3.1055 6.2112A1 1 0 0120 14z"
	});

	var _ref3$D =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10.8145,18.1406A7.1851,7.1851,0,0,1,8,12a8.0092,8.0092,0,0,1,8-8V2A10.0111,10.0111,0,0,0,6,12a9.1793,9.1793,0,0,0,3.46,7.6162C10.4717,20.5508,11,21.0815,11,22h2C13,20.16,11.8892,19.1338,10.8145,18.1406Z"
	});

	var WatsonHealthAiStatus16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatus16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1P, _ref3$D, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1Q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21 9.59L17.41 6 16 7.41 21 12.41 30 3.41 28.59 2 21 9.59zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14z"
	});

	var WatsonHealthAiStatusComplete32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusComplete32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1Q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1R =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21 9.59L17.41 6 16 7.41 21 12.41 30 3.41 28.59 2 21 9.59zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14z"
	});

	var WatsonHealthAiStatusComplete24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusComplete24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1R, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1S =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21 9.59L17.41 6 16 7.41 21 12.41 30 3.41 28.59 2 21 9.59zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14z"
	});

	var WatsonHealthAiStatusComplete20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusComplete20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1S, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1T =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21 9.59L17.41 6 16 7.41 21 12.41 30 3.41 28.59 2 21 9.59zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14z"
	});

	var WatsonHealthAiStatusComplete16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusComplete16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1T, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1U =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14zM30 3.41L28.59 2 25 5.59 21.41 2 20 3.41 23.59 7 20 10.59 21.41 12 25 8.41 28.59 12 30 10.59 26.41 7 30 3.41z"
	});

	var WatsonHealthAiStatusFailed32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusFailed32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1U, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1V =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14zM30 3.41L28.59 2 25 5.59 21.41 2 20 3.41 23.59 7 20 10.59 21.41 12 25 8.41 28.59 12 30 10.59 26.41 7 30 3.41z"
	});

	var WatsonHealthAiStatusFailed24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusFailed24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1V, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1W =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14zM30 3.41L28.59 2 25 5.59 21.41 2 20 3.41 23.59 7 20 10.59 21.41 12 25 8.41 28.59 12 30 10.59 26.41 7 30 3.41z"
	});

	var WatsonHealthAiStatusFailed20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusFailed20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1W, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1X =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.8 14a7.28 7.28 0 01-2.6219 4.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.1426 9.1426 0 0025.8389 14zM30 3.41L28.59 2 25 5.59 21.41 2 20 3.41 23.59 7 20 10.59 21.41 12 25 8.41 28.59 12 30 10.59 26.41 7 30 3.41z"
	});

	var WatsonHealthAiStatusFailed16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusFailed16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1X, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1Y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426z"
	});

	var _ref3$E =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "18.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var _ref4$c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "28.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var _ref5$4 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "23.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var WatsonHealthAiStatusInProgress32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusInProgress32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1Y, _ref3$E, _ref4$c, _ref5$4, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1Z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426z"
	});

	var _ref3$F =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "18.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var _ref4$d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "28.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var _ref5$5 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "23.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var WatsonHealthAiStatusInProgress24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusInProgress24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1Z, _ref3$F, _ref4$d, _ref5$5, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1_ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426z"
	});

	var _ref3$G =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "18.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var _ref4$e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "28.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var _ref5$6 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "23.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var WatsonHealthAiStatusInProgress20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusInProgress20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1_, _ref3$G, _ref4$e, _ref5$6, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$1$ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426z"
	});

	var _ref3$H =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "18.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var _ref4$f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "28.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var _ref5$7 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "23.5",
	  cy: "7.5",
	  r: "1.5"
	});

	var WatsonHealthAiStatusInProgress16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusInProgress16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$1$, _ref3$H, _ref4$f, _ref5$7, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$20 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426zM18 6H28V8H18z"
	});

	var WatsonHealthAiStatusQueued32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusQueued32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$20, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$21 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426zM18 6H28V8H18z"
	});

	var WatsonHealthAiStatusQueued24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusQueued24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$21, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$22 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426zM18 6H28V8H18z"
	});

	var WatsonHealthAiStatusQueued20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusQueued20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$22, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$23 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM21.1777 18.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.193 9.193 0 0026 12H24A7.2032 7.2032 0 0121.1777 18.1426zM18 6H28V8H18z"
	});

	var WatsonHealthAiStatusQueued16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusQueued16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$23, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$24 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM30 8a6 6 0 10-6 6A6.0066 6.0066 0 0030 8zM28 8a3.9521 3.9521 0 01-.5669 2.019L21.981 4.5669A3.9529 3.9529 0 0124 4 4.0045 4.0045 0 0128 8zM20 8a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 12 4.0045 4.0045 0 0120 8z"
	});

	var WatsonHealthAiStatusRejected32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusRejected32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$24, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$25 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM30 8a6 6 0 10-6 6A6.0066 6.0066 0 0030 8zM28 8a3.9521 3.9521 0 01-.5669 2.019L21.981 4.5669A3.9529 3.9529 0 0124 4 4.0045 4.0045 0 0128 8zM20 8a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 12 4.0045 4.0045 0 0120 8z"
	});

	var WatsonHealthAiStatusRejected24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusRejected24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$25, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$26 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM30 8a6 6 0 10-6 6A6.0066 6.0066 0 0030 8zM28 8a3.9521 3.9521 0 01-.5669 2.019L21.981 4.5669A3.9529 3.9529 0 0124 4 4.0045 4.0045 0 0128 8zM20 8a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 12 4.0045 4.0045 0 0120 8z"
	});

	var WatsonHealthAiStatusRejected20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusRejected20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$26, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$27 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 24H21V26H11zM13 28H19V30H13zM10.8145 18.1406A7.1851 7.1851 0 018 12a8.0092 8.0092 0 018-8V2A10.0111 10.0111 0 006 12a9.1793 9.1793 0 003.46 7.6162C10.4717 20.5508 11 21.0815 11 22h2C13 20.16 11.8892 19.1338 10.8145 18.1406zM23.04 16a9.4858 9.4858 0 01-1.8623 2.1426C20.1069 19.1348 19 20.1611 19 22h2c0-.9194.5264-1.45 1.5352-2.3857A9.9838 9.9838 0 0025.2756 16zM30 8a6 6 0 10-6 6A6.0066 6.0066 0 0030 8zM28 8a3.9521 3.9521 0 01-.5669 2.019L21.981 4.5669A3.9529 3.9529 0 0124 4 4.0045 4.0045 0 0128 8zM20 8a3.9521 3.9521 0 01.5669-2.019l5.4521 5.4521A3.9529 3.9529 0 0124 12 4.0045 4.0045 0 0120 8z"
	});

	var WatsonHealthAiStatusRejected16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAiStatusRejected16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$27, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$28 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$I =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18.59 21L15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21z"
	});

	var _ref4$g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref5$8 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var Alarm32 = /*#__PURE__*/React__default.forwardRef(function Alarm32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$28, _ref3$I, _ref4$g, _ref5$8, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$29 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$J =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18.59 21L15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21z"
	});

	var _ref4$h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref5$9 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var Alarm24 = /*#__PURE__*/React__default.forwardRef(function Alarm24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$29, _ref3$J, _ref4$h, _ref5$9, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$K =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18.59 21L15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21z"
	});

	var _ref4$i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref5$a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var Alarm20 = /*#__PURE__*/React__default.forwardRef(function Alarm20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2a, _ref3$K, _ref4$i, _ref5$a, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$L =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18.59 21L15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21z"
	});

	var _ref4$j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref5$b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var Alarm16 = /*#__PURE__*/React__default.forwardRef(function Alarm16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2b, _ref3$L, _ref4$j, _ref5$b, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$M =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref4$k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var _ref5$c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21 16L17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16z"
	});

	var AlarmAdd32 = /*#__PURE__*/React__default.forwardRef(function AlarmAdd32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2c, _ref3$M, _ref4$k, _ref5$c, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$N =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref4$l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var _ref5$d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21 16L17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16z"
	});

	var AlarmAdd24 = /*#__PURE__*/React__default.forwardRef(function AlarmAdd24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2d, _ref3$N, _ref4$l, _ref5$d, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$O =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref4$m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var _ref5$e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21 16L17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16z"
	});

	var AlarmAdd20 = /*#__PURE__*/React__default.forwardRef(function AlarmAdd20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2e, _ref3$O, _ref4$m, _ref5$e, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$P =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref4$n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var _ref5$f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21 16L17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16z"
	});

	var AlarmAdd16 = /*#__PURE__*/React__default.forwardRef(function AlarmAdd16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2f, _ref3$P, _ref4$n, _ref5$f, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$Q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref4$o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var _ref5$g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 16H21V18H11z"
	});

	var AlarmSubtract32 = /*#__PURE__*/React__default.forwardRef(function AlarmSubtract32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2g, _ref3$Q, _ref4$o, _ref5$g, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$R =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref4$p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var _ref5$h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 16H21V18H11z"
	});

	var AlarmSubtract24 = /*#__PURE__*/React__default.forwardRef(function AlarmSubtract24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2h, _ref3$R, _ref4$p, _ref5$h, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$S =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref4$q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var _ref5$i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 16H21V18H11z"
	});

	var AlarmSubtract20 = /*#__PURE__*/React__default.forwardRef(function AlarmSubtract20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2i, _ref3$S, _ref4$q, _ref5$i, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"
	});

	var _ref3$T =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.96 5.5H9.030000000000001V7.5H3.96z",
	  transform: "rotate(-45.06 6.502 6.497)"
	});

	var _ref4$r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.5 3.96H26.5V9.030000000000001H24.5z",
	  transform: "rotate(-44.94 25.5 6.498)"
	});

	var _ref5$j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 16H21V18H11z"
	});

	var AlarmSubtract16 = /*#__PURE__*/React__default.forwardRef(function AlarmSubtract16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2j, _ref3$T, _ref4$r, _ref5$j, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"
	});

	var AlignHorizontalCenter32 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalCenter32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2k, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"
	});

	var AlignHorizontalCenter24 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalCenter24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2l, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"
	});

	var AlignHorizontalCenter20 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalCenter20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2m, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"
	});

	var AlignHorizontalCenter16 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalCenter16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2n, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 26H11a2.0023 2.0023 0 01-2-2V20a2.0023 2.0023 0 012-2H26a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0126 26zm0-6.0012L11 20v4H26zM18 14H11a2.0023 2.0023 0 01-2-2V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0118 14zm0-6.0012L11 8v4h7zM4 2H6V30H4z"
	});

	var AlignHorizontalLeft32 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalLeft32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2o, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 26H11a2.0023 2.0023 0 01-2-2V20a2.0023 2.0023 0 012-2H26a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0126 26zm0-6.0012L11 20v4H26zM18 14H11a2.0023 2.0023 0 01-2-2V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0118 14zm0-6.0012L11 8v4h7zM4 2H6V30H4z"
	});

	var AlignHorizontalLeft24 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalLeft24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2p, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 26H11a2.0023 2.0023 0 01-2-2V20a2.0023 2.0023 0 012-2H26a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0126 26zm0-6.0012L11 20v4H26zM18 14H11a2.0023 2.0023 0 01-2-2V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0118 14zm0-6.0012L11 8v4h7zM4 2H6V30H4z"
	});

	var AlignHorizontalLeft20 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalLeft20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 26H11a2.0023 2.0023 0 01-2-2V20a2.0023 2.0023 0 012-2H26a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0126 26zm0-6.0012L11 20v4H26zM18 14H11a2.0023 2.0023 0 01-2-2V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4A2.0023 2.0023 0 0118 14zm0-6.0012L11 8v4h7zM4 2H6V30H4z"
	});

	var AlignHorizontalLeft16 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalLeft16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2r, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 24V20a2.0023 2.0023 0 012-2H21a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H6A2.0023 2.0023 0 014 24zm2 0H21V20L6 19.9988zM12 12V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14A2.0023 2.0023 0 0112 12zm2 0h7V8l-7-.0012z"
	});

	var _ref3$U =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 2H28V30H26z",
	  transform: "rotate(-180 27 16)"
	});

	var AlignHorizontalRight32 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalRight32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2s, _ref3$U, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 24V20a2.0023 2.0023 0 012-2H21a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H6A2.0023 2.0023 0 014 24zm2 0H21V20L6 19.9988zM12 12V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14A2.0023 2.0023 0 0112 12zm2 0h7V8l-7-.0012z"
	});

	var _ref3$V =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 2H28V30H26z",
	  transform: "rotate(-180 27 16)"
	});

	var AlignHorizontalRight24 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalRight24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2t, _ref3$V, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 24V20a2.0023 2.0023 0 012-2H21a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H6A2.0023 2.0023 0 014 24zm2 0H21V20L6 19.9988zM12 12V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14A2.0023 2.0023 0 0112 12zm2 0h7V8l-7-.0012z"
	});

	var _ref3$W =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 2H28V30H26z",
	  transform: "rotate(-180 27 16)"
	});

	var AlignHorizontalRight20 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalRight20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2u, _ref3$W, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 24V20a2.0023 2.0023 0 012-2H21a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H6A2.0023 2.0023 0 014 24zm2 0H21V20L6 19.9988zM12 12V8a2.0023 2.0023 0 012-2h7a2.0023 2.0023 0 012 2v4a2.0023 2.0023 0 01-2 2H14A2.0023 2.0023 0 0112 12zm2 0h7V8l-7-.0012z"
	});

	var _ref3$X =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 2H28V30H26z",
	  transform: "rotate(-180 27 16)"
	});

	var AlignHorizontalRight16 = /*#__PURE__*/React__default.forwardRef(function AlignHorizontalRight16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2v, _ref3$X, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 26H30V28H2zM24 23H20a2.0023 2.0023 0 01-2-2V14a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 23zm-4-9v7h4.0012L24 14zM12 23H8a2.0023 2.0023 0 01-2-2V6A2.0023 2.0023 0 018 4h4a2.0023 2.0023 0 012 2V21A2.0023 2.0023 0 0112 23zM8 6V21h4.0012L12 6z"
	});

	var AlignVerticalBottom32 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalBottom32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2w, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 26H30V28H2zM24 23H20a2.0023 2.0023 0 01-2-2V14a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 23zm-4-9v7h4.0012L24 14zM12 23H8a2.0023 2.0023 0 01-2-2V6A2.0023 2.0023 0 018 4h4a2.0023 2.0023 0 012 2V21A2.0023 2.0023 0 0112 23zM8 6V21h4.0012L12 6z"
	});

	var AlignVerticalBottom24 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalBottom24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2x, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 26H30V28H2zM24 23H20a2.0023 2.0023 0 01-2-2V14a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 23zm-4-9v7h4.0012L24 14zM12 23H8a2.0023 2.0023 0 01-2-2V6A2.0023 2.0023 0 018 4h4a2.0023 2.0023 0 012 2V21A2.0023 2.0023 0 0112 23zM8 6V21h4.0012L12 6z"
	});

	var AlignVerticalBottom20 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalBottom20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 26H30V28H2zM24 23H20a2.0023 2.0023 0 01-2-2V14a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 23zm-4-9v7h4.0012L24 14zM12 23H8a2.0023 2.0023 0 01-2-2V6A2.0023 2.0023 0 018 4h4a2.0023 2.0023 0 012 2V21A2.0023 2.0023 0 0112 23zM8 6V21h4.0012L12 6z"
	});

	var AlignVerticalBottom16 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalBottom16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2A =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"
	});

	var AlignVerticalCenter32 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalCenter32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2A, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2B =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"
	});

	var AlignVerticalCenter24 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalCenter24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2B, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2C =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"
	});

	var AlignVerticalCenter20 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalCenter20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2C, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2D =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"
	});

	var AlignVerticalCenter16 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalCenter16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2D, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2E =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 20H20a2.0023 2.0023 0 01-2-2V11a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 20zm-4-9v7h4.0012L24 11zM12 28H8a2.0023 2.0023 0 01-2-2V11A2.0023 2.0023 0 018 9h4a2.0023 2.0023 0 012 2V26A2.0023 2.0023 0 0112 28zM8 11V26h4.0012L12 11zM2 4H30V6H2z"
	});

	var AlignVerticalTop32 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalTop32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2E, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2F =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 20H20a2.0023 2.0023 0 01-2-2V11a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 20zm-4-9v7h4.0012L24 11zM12 28H8a2.0023 2.0023 0 01-2-2V11A2.0023 2.0023 0 018 9h4a2.0023 2.0023 0 012 2V26A2.0023 2.0023 0 0112 28zM8 11V26h4.0012L12 11zM2 4H30V6H2z"
	});

	var AlignVerticalTop24 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalTop24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2F, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2G =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 20H20a2.0023 2.0023 0 01-2-2V11a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 20zm-4-9v7h4.0012L24 11zM12 28H8a2.0023 2.0023 0 01-2-2V11A2.0023 2.0023 0 018 9h4a2.0023 2.0023 0 012 2V26A2.0023 2.0023 0 0112 28zM8 11V26h4.0012L12 11zM2 4H30V6H2z"
	});

	var AlignVerticalTop20 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalTop20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2G, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2H =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24 20H20a2.0023 2.0023 0 01-2-2V11a2.0023 2.0023 0 012-2h4a2.0023 2.0023 0 012 2v7A2.0023 2.0023 0 0124 20zm-4-9v7h4.0012L24 11zM12 28H8a2.0023 2.0023 0 01-2-2V11A2.0023 2.0023 0 018 9h4a2.0023 2.0023 0 012 2V26A2.0023 2.0023 0 0112 28zM8 11V26h4.0012L12 11zM2 4H30V6H2z"
	});

	var AlignVerticalTop16 = /*#__PURE__*/React__default.forwardRef(function AlignVerticalTop16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2H, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2I =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"
	});

	var _ref3$Y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"
	});

	var Analytics32 = /*#__PURE__*/React__default.forwardRef(function Analytics32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2I, _ref3$Y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2J =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"
	});

	var _ref3$Z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"
	});

	var Analytics24 = /*#__PURE__*/React__default.forwardRef(function Analytics24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2J, _ref3$Z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2K =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"
	});

	var _ref3$_ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"
	});

	var Analytics20 = /*#__PURE__*/React__default.forwardRef(function Analytics20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2K, _ref3$_, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2L =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"
	});

	var _ref3$$ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"
	});

	var Analytics16 = /*#__PURE__*/React__default.forwardRef(function Analytics16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2L, _ref3$$, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2M =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L8 14.5858 9.4142 16 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2zM16 28H30V30H16zM2 2H4V16H2z"
	});

	var AnalyticsReference32 = /*#__PURE__*/React__default.forwardRef(function AnalyticsReference32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2M, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2N =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L8 14.5858 9.4142 16 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2zM16 28H30V30H16zM2 2H4V16H2z"
	});

	var AnalyticsReference24 = /*#__PURE__*/React__default.forwardRef(function AnalyticsReference24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2N, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2O =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L8 14.5858 9.4142 16 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2zM16 28H30V30H16zM2 2H4V16H2z"
	});

	var AnalyticsReference20 = /*#__PURE__*/React__default.forwardRef(function AnalyticsReference20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2O, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2P =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 20L4 22 8.586 22 2 28.586 3.414 30 10 23.414 10 28 12 28 12 20 4 20zM30 4H23V6h3.5859L19 13.5859 14.707 9.293a1 1 0 00-1.414 0L8 14.5858 9.4142 16 14 11.4141l4.293 4.2929a1 1 0 001.414 0L28 7.4141V11h2zM16 28H30V30H16zM2 2H4V16H2z"
	});

	var AnalyticsReference16 = /*#__PURE__*/React__default.forwardRef(function AnalyticsReference16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2P, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2Q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M9,24a3.51,3.51,0,0,0-.88-1.86L17.65,5.56l-1.73-1L6.35,21.12A3.06,3.06,0,0,0,5.5,21a3.5,3.5,0,1,0,3.15,5H28V24ZM5.5,26A1.5,1.5,0,1,1,7,24.5,1.5,1.5,0,0,1,5.5,26Z"
	});

	var _ref3$10 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22,21h2a13,13,0,0,0-5.42-10.56l-1.16,1.62A11,11,0,0,1,22,21Z"
	});

	var WatsonHealthAngle32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAngle32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2Q, _ref3$10, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2R =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M9,24a3.51,3.51,0,0,0-.88-1.86L17.65,5.56l-1.73-1L6.35,21.12A3.06,3.06,0,0,0,5.5,21a3.5,3.5,0,1,0,3.15,5H28V24ZM5.5,26A1.5,1.5,0,1,1,7,24.5,1.5,1.5,0,0,1,5.5,26Z"
	});

	var _ref3$11 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22,21h2a13,13,0,0,0-5.42-10.56l-1.16,1.62A11,11,0,0,1,22,21Z"
	});

	var WatsonHealthAngle24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAngle24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2R, _ref3$11, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2S =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M9,24a3.51,3.51,0,0,0-.88-1.86L17.65,5.56l-1.73-1L6.35,21.12A3.06,3.06,0,0,0,5.5,21a3.5,3.5,0,1,0,3.15,5H28V24ZM5.5,26A1.5,1.5,0,1,1,7,24.5,1.5,1.5,0,0,1,5.5,26Z"
	});

	var _ref3$12 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22,21h2a13,13,0,0,0-5.42-10.56l-1.16,1.62A11,11,0,0,1,22,21Z"
	});

	var WatsonHealthAngle20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAngle20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2S, _ref3$12, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2T =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M9,24a3.51,3.51,0,0,0-.88-1.86L17.65,5.56l-1.73-1L6.35,21.12A3.06,3.06,0,0,0,5.5,21a3.5,3.5,0,1,0,3.15,5H28V24ZM5.5,26A1.5,1.5,0,1,1,7,24.5,1.5,1.5,0,0,1,5.5,26Z"
	});

	var _ref3$13 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22,21h2a13,13,0,0,0-5.42-10.56l-1.16,1.62A11,11,0,0,1,22,21Z"
	});

	var WatsonHealthAngle16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAngle16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2T, _ref3$13, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2U =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,22H4V6H28Z"
	});

	var _ref3$14 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21 20H13a3.51 3.51 0 00-.88-1.86l3.8-6.64-1.74-1-3.78 6.62A3.35 3.35 0 009.5 17a3.5 3.5 0 103.15 5H21zM9.5 22A1.5 1.5 0 1111 20.5 1.5 1.5 0 019.5 22zM19 8H26V10H19zM19 12H23V14H19z"
	});

	var WatsonHealthAnnotationVisibility32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAnnotationVisibility32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2U, _ref3$14, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2V =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,22H4V6H28Z"
	});

	var _ref3$15 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21 20H13a3.51 3.51 0 00-.88-1.86l3.8-6.64-1.74-1-3.78 6.62A3.35 3.35 0 009.5 17a3.5 3.5 0 103.15 5H21zM9.5 22A1.5 1.5 0 1111 20.5 1.5 1.5 0 019.5 22zM19 8H26V10H19zM19 12H23V14H19z"
	});

	var WatsonHealthAnnotationVisibility24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAnnotationVisibility24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2V, _ref3$15, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2W =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,22H4V6H28Z"
	});

	var _ref3$16 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21 20H13a3.51 3.51 0 00-.88-1.86l3.8-6.64-1.74-1-3.78 6.62A3.35 3.35 0 009.5 17a3.5 3.5 0 103.15 5H21zM9.5 22A1.5 1.5 0 1111 20.5 1.5 1.5 0 019.5 22zM19 8H26V10H19zM19 12H23V14H19z"
	});

	var WatsonHealthAnnotationVisibility20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAnnotationVisibility20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2W, _ref3$16, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2X =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,22H4V6H28Z"
	});

	var _ref3$17 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21 20H13a3.51 3.51 0 00-.88-1.86l3.8-6.64-1.74-1-3.78 6.62A3.35 3.35 0 009.5 17a3.5 3.5 0 103.15 5H21zM9.5 22A1.5 1.5 0 1111 20.5 1.5 1.5 0 019.5 22zM19 8H26V10H19zM19 12H23V14H19z"
	});

	var WatsonHealthAnnotationVisibility16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAnnotationVisibility16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2X, _ref3$17, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2Y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"
	});

	var Aperture32 = /*#__PURE__*/React__default.forwardRef(function Aperture32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2Y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2Z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"
	});

	var Aperture24 = /*#__PURE__*/React__default.forwardRef(function Aperture24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2Z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2_ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"
	});

	var Aperture20 = /*#__PURE__*/React__default.forwardRef(function Aperture20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2_, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$2$ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"
	});

	var Aperture16 = /*#__PURE__*/React__default.forwardRef(function Aperture16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$2$, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$30 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"
	});

	var Api32 = /*#__PURE__*/React__default.forwardRef(function Api32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$30, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$31 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"
	});

	var Api24 = /*#__PURE__*/React__default.forwardRef(function Api24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$31, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$32 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"
	});

	var Api20 = /*#__PURE__*/React__default.forwardRef(function Api20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$32, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$33 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"
	});

	var Api16 = /*#__PURE__*/React__default.forwardRef(function Api16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$33, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$34 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8 9H4a2 2 0 00-2 2V23H4V18H8v5h2V11A2 2 0 008 9zM4 16V11H8v5zM22 11L25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11zM14 23H12V9h6a2 2 0 012 2v5a2 2 0 01-2 2H14zm0-7h4V11H14z"
	});

	var Api_132 = /*#__PURE__*/React__default.forwardRef(function Api_132(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$34, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$35 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8 9H4a2 2 0 00-2 2V23H4V18H8v5h2V11A2 2 0 008 9zM4 16V11H8v5zM22 11L25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11zM14 23H12V9h6a2 2 0 012 2v5a2 2 0 01-2 2H14zm0-7h4V11H14z"
	});

	var Api_124 = /*#__PURE__*/React__default.forwardRef(function Api_124(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$35, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$36 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8 9H4a2 2 0 00-2 2V23H4V18H8v5h2V11A2 2 0 008 9zM4 16V11H8v5zM22 11L25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11zM14 23H12V9h6a2 2 0 012 2v5a2 2 0 01-2 2H14zm0-7h4V11H14z"
	});

	var Api_120 = /*#__PURE__*/React__default.forwardRef(function Api_120(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$36, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$37 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8 9H4a2 2 0 00-2 2V23H4V18H8v5h2V11A2 2 0 008 9zM4 16V11H8v5zM22 11L25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11zM14 23H12V9h6a2 2 0 012 2v5a2 2 0 01-2 2H14zm0-7h4V11H14z"
	});

	var Api_116 = /*#__PURE__*/React__default.forwardRef(function Api_116(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$37, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$38 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28 10H22V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0028 10zm-4 8V12h4v6zM18 10H12V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0018 10zm-4 8V12h4v6zM8 10H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V12A2.0023 2.0023 0 008 10zm0 8H4V16H8z"
	});

	var App32 = /*#__PURE__*/React__default.forwardRef(function App32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$38, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$39 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28 10H22V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0028 10zm-4 8V12h4v6zM18 10H12V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0018 10zm-4 8V12h4v6zM8 10H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V12A2.0023 2.0023 0 008 10zm0 8H4V16H8z"
	});

	var App24 = /*#__PURE__*/React__default.forwardRef(function App24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$39, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28 10H22V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0028 10zm-4 8V12h4v6zM18 10H12V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0018 10zm-4 8V12h4v6zM8 10H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V12A2.0023 2.0023 0 008 10zm0 8H4V16H8z"
	});

	var App20 = /*#__PURE__*/React__default.forwardRef(function App20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3a, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28 10H22V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0028 10zm-4 8V12h4v6zM18 10H12V24h2V20h4a2.0027 2.0027 0 002-2V12A2.0023 2.0023 0 0018 10zm-4 8V12h4v6zM8 10H3v2H8v2H4a2 2 0 00-2 2v2a2 2 0 002 2h6V12A2.0023 2.0023 0 008 10zm0 8H4V16H8z"
	});

	var App16 = /*#__PURE__*/React__default.forwardRef(function App16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3b, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,14h8a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2H9A2.0023,2.0023,0,0,0,7,6v4H4a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H6v4a2.0023,2.0023,0,0,0,2,2H18a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V20a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2v6H8V22h4a2.0023,2.0023,0,0,0,2-2V12a2.0023,2.0023,0,0,0-2-2H9V6h9v6A2.0023,2.0023,0,0,0,20,14Zm0,14V24h8v4Zm8-8,0,2H20V20ZM4,20V16h8v4Zm8.0005-6H4V12h8ZM20,12V8h8v4Zm8-8,0,2H20V4Z"
	});

	var AppConnectivity32 = /*#__PURE__*/React__default.forwardRef(function AppConnectivity32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3c, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,14h8a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2H9A2.0023,2.0023,0,0,0,7,6v4H4a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H6v4a2.0023,2.0023,0,0,0,2,2H18a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V20a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2v6H8V22h4a2.0023,2.0023,0,0,0,2-2V12a2.0023,2.0023,0,0,0-2-2H9V6h9v6A2.0023,2.0023,0,0,0,20,14Zm0,14V24h8v4Zm8-8,0,2H20V20ZM4,20V16h8v4Zm8.0005-6H4V12h8ZM20,12V8h8v4Zm8-8,0,2H20V4Z"
	});

	var AppConnectivity24 = /*#__PURE__*/React__default.forwardRef(function AppConnectivity24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3d, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,14h8a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2H9A2.0023,2.0023,0,0,0,7,6v4H4a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H6v4a2.0023,2.0023,0,0,0,2,2H18a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V20a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2v6H8V22h4a2.0023,2.0023,0,0,0,2-2V12a2.0023,2.0023,0,0,0-2-2H9V6h9v6A2.0023,2.0023,0,0,0,20,14Zm0,14V24h8v4Zm8-8,0,2H20V20ZM4,20V16h8v4Zm8.0005-6H4V12h8ZM20,12V8h8v4Zm8-8,0,2H20V4Z"
	});

	var AppConnectivity20 = /*#__PURE__*/React__default.forwardRef(function AppConnectivity20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3e, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,14h8a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2H9A2.0023,2.0023,0,0,0,7,6v4H4a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2H6v4a2.0023,2.0023,0,0,0,2,2H18a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V20a2.0023,2.0023,0,0,0-2-2H20a2.0023,2.0023,0,0,0-2,2v6H8V22h4a2.0023,2.0023,0,0,0,2-2V12a2.0023,2.0023,0,0,0-2-2H9V6h9v6A2.0023,2.0023,0,0,0,20,14Zm0,14V24h8v4Zm8-8,0,2H20V20ZM4,20V16h8v4Zm8.0005-6H4V12h8ZM20,12V8h8v4Zm8-8,0,2H20V4Z"
	});

	var AppConnectivity16 = /*#__PURE__*/React__default.forwardRef(function AppConnectivity16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3f, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation = false;

	var _ref2$3g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14 4H18V8H14zM4 4H8V8H4zM24 4H28V8H24zM14 14H18V18H14zM4 14H8V18H4zM24 14H28V18H24zM14 24H18V28H14zM4 24H8V28H4zM24 24H28V28H24z"
	});

	var AppSwitcher32 = /*#__PURE__*/React__default.forwardRef(function AppSwitcher32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation) {
	      didWarnAboutDeprecation = true;
	      console.warn("The AppSwitcher32 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3g, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$1 = false;

	var _ref2$3h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14 4H18V8H14zM4 4H8V8H4zM24 4H28V8H24zM14 14H18V18H14zM4 14H8V18H4zM24 14H28V18H24zM14 24H18V28H14zM4 24H8V28H4zM24 24H28V28H24z"
	});

	var AppSwitcher24 = /*#__PURE__*/React__default.forwardRef(function AppSwitcher24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$1) {
	      didWarnAboutDeprecation$1 = true;
	      console.warn("The AppSwitcher24 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3h, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$2 = false;

	var _ref2$3i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14 4H18V8H14zM4 4H8V8H4zM24 4H28V8H24zM14 14H18V18H14zM4 14H8V18H4zM24 14H28V18H24zM14 24H18V28H14zM4 24H8V28H4zM24 24H28V28H24z"
	});

	var AppSwitcher20 = /*#__PURE__*/React__default.forwardRef(function AppSwitcher20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$2) {
	      didWarnAboutDeprecation$2 = true;
	      console.warn("The AppSwitcher20 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3i, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$3 = false;

	var _ref2$3j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14 4H18V8H14zM4 4H8V8H4zM24 4H28V8H24zM14 14H18V18H14zM4 14H8V18H4zM24 14H28V18H24zM14 24H18V28H14zM4 24H8V28H4zM24 24H28V28H24z"
	});

	var AppSwitcher16 = /*#__PURE__*/React__default.forwardRef(function AppSwitcher16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$3) {
	      didWarnAboutDeprecation$3 = true;
	      console.warn("The AppSwitcher16 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3j, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"
	});

	var _ref3$18 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"
	});

	var Apple32 = /*#__PURE__*/React__default.forwardRef(function Apple32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3k, _ref3$18, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"
	});

	var _ref3$19 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"
	});

	var Apple24 = /*#__PURE__*/React__default.forwardRef(function Apple24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3l, _ref3$19, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"
	});

	var _ref3$1a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"
	});

	var Apple20 = /*#__PURE__*/React__default.forwardRef(function Apple20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3m, _ref3$1a, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"
	});

	var _ref3$1b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"
	});

	var Apple16 = /*#__PURE__*/React__default.forwardRef(function Apple16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3n, _ref3$1b, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 18H6a2 2 0 01-2-2V6A2 2 0 016 4H16a2 2 0 012 2V16A2 2 0 0116 18zM6 6V16H16V6zM26 12v4H22V12h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V12a2 2 0 00-2-2zM26 22v4H22V22h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2zM16 22v4H12V22h4m0-2H12a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2z"
	});

	var Application32 = /*#__PURE__*/React__default.forwardRef(function Application32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3o, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 18H6a2 2 0 01-2-2V6A2 2 0 016 4H16a2 2 0 012 2V16A2 2 0 0116 18zM6 6V16H16V6zM26 12v4H22V12h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V12a2 2 0 00-2-2zM26 22v4H22V22h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2zM16 22v4H12V22h4m0-2H12a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2z"
	});

	var Application24 = /*#__PURE__*/React__default.forwardRef(function Application24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3p, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 18H6a2 2 0 01-2-2V6A2 2 0 016 4H16a2 2 0 012 2V16A2 2 0 0116 18zM6 6V16H16V6zM26 12v4H22V12h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V12a2 2 0 00-2-2zM26 22v4H22V22h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2zM16 22v4H12V22h4m0-2H12a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2z"
	});

	var Application20 = /*#__PURE__*/React__default.forwardRef(function Application20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 18H6a2 2 0 01-2-2V6A2 2 0 016 4H16a2 2 0 012 2V16A2 2 0 0116 18zM6 6V16H16V6zM26 12v4H22V12h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V12a2 2 0 00-2-2zM26 22v4H22V22h4m0-2H22a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2zM16 22v4H12V22h4m0-2H12a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V22a2 2 0 00-2-2z"
	});

	var Application16 = /*#__PURE__*/React__default.forwardRef(function Application16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3r, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8,4v4H4V4H8z M10,2H2v8h8V2z M18,4v4h-4V4H18z M20,2h-8v8h8V2z M28,4v4h-4V4H28z M30,2h-8v8h8V2z M8,14v4H4v-4H8z M10,12H2\tv8h8V12z M18,14v4h-4v-4H18z M20,12h-8v8h8V12z M28,14v4h-4v-4H28z M30,12h-8v8h8V12z M8,24v4H4v-4H8z M10,22H2v8h8V22z M18,24v4h-4\tv-4H18z M20,22h-8v8h8V22z M28,24v4h-4v-4H28z M30,22h-8v8h8V22z"
	});

	var Apps32 = /*#__PURE__*/React__default.forwardRef(function Apps32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3s, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8,4v4H4V4H8z M10,2H2v8h8V2z M18,4v4h-4V4H18z M20,2h-8v8h8V2z M28,4v4h-4V4H28z M30,2h-8v8h8V2z M8,14v4H4v-4H8z M10,12H2\tv8h8V12z M18,14v4h-4v-4H18z M20,12h-8v8h8V12z M28,14v4h-4v-4H28z M30,12h-8v8h8V12z M8,24v4H4v-4H8z M10,22H2v8h8V22z M18,24v4h-4\tv-4H18z M20,22h-8v8h8V22z M28,24v4h-4v-4H28z M30,22h-8v8h8V22z"
	});

	var Apps24 = /*#__PURE__*/React__default.forwardRef(function Apps24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3t, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8,4v4H4V4H8z M10,2H2v8h8V2z M18,4v4h-4V4H18z M20,2h-8v8h8V2z M28,4v4h-4V4H28z M30,2h-8v8h8V2z M8,14v4H4v-4H8z M10,12H2\tv8h8V12z M18,14v4h-4v-4H18z M20,12h-8v8h8V12z M28,14v4h-4v-4H28z M30,12h-8v8h8V12z M8,24v4H4v-4H8z M10,22H2v8h8V22z M18,24v4h-4\tv-4H18z M20,22h-8v8h8V22z M28,24v4h-4v-4H28z M30,22h-8v8h8V22z"
	});

	var Apps20 = /*#__PURE__*/React__default.forwardRef(function Apps20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3u, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 2v2H2V2h2zm1-1H1v4h4V1zM9 2v2H7V2h2zm1-1H6v4h4V1zM14 2v2h-2V2h2zm1-1h-4v4h4V1zM4 7v2H2V7h2zm1-1H1v4h4V6zM9 7v2H7V7h2zm1-1H6v4h4V6zM14 7v2h-2V7h2zm1-1h-4v4h4V6zM4 12v2H2v-2h2zm1-1H1v4h4v-4zM9 12v2H7v-2h2zm1-1H6v4h4v-4zM14 12v2h-2v-2h2zm1-1h-4v4h4v-4z"
	});

	var Apps16 = /*#__PURE__*/React__default.forwardRef(function Apps16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 16 16",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3v, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14 19H18V21H14z"
	});

	var _ref3$1c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"
	});

	var Archive32 = /*#__PURE__*/React__default.forwardRef(function Archive32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3w, _ref3$1c, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14 19H18V21H14z"
	});

	var _ref3$1d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"
	});

	var Archive24 = /*#__PURE__*/React__default.forwardRef(function Archive24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3x, _ref3$1d, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14 19H18V21H14z"
	});

	var _ref3$1e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"
	});

	var Archive20 = /*#__PURE__*/React__default.forwardRef(function Archive20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3y, _ref3$1e, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14 19H18V21H14z"
	});

	var _ref3$1f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"
	});

	var Archive16 = /*#__PURE__*/React__default.forwardRef(function Archive16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3z, _ref3$1f, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3A =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 28H30V30H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0127 20.62a1.88 1.88 0 01-1.37 1.52 2 2 0 01-1 0l-18.7-5a1.89 1.89 0 01-1.33-2.3L6.35 8.34l1.44.38L8.4 13.9l6 1.62L17.21 5.23m-1-2.2a1 1 0 00-.68.69L13 13.07l-2.81-.75L9.69 7.79A1 1 0 009 7L5.87 6.14a.94.94 0 00-.5 0 1 1 0 00-.68.68l-2 7.49a3.87 3.87 0 002.74 4.74l18.71 5A3.87 3.87 0 0029 21a4 4 0 00-3-4.42l-4.52-1.21L20.53 4.71a1 1 0 00-.72-.85L16.73 3a1.06 1.06 0 00-.5 0z"
	});

	var Arrival32 = /*#__PURE__*/React__default.forwardRef(function Arrival32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3A, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3B =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 28H30V30H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0127 20.62a1.88 1.88 0 01-1.37 1.52 2 2 0 01-1 0l-18.7-5a1.89 1.89 0 01-1.33-2.3L6.35 8.34l1.44.38L8.4 13.9l6 1.62L17.21 5.23m-1-2.2a1 1 0 00-.68.69L13 13.07l-2.81-.75L9.69 7.79A1 1 0 009 7L5.87 6.14a.94.94 0 00-.5 0 1 1 0 00-.68.68l-2 7.49a3.87 3.87 0 002.74 4.74l18.71 5A3.87 3.87 0 0029 21a4 4 0 00-3-4.42l-4.52-1.21L20.53 4.71a1 1 0 00-.72-.85L16.73 3a1.06 1.06 0 00-.5 0z"
	});

	var Arrival24 = /*#__PURE__*/React__default.forwardRef(function Arrival24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3B, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3C =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 28H30V30H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0127 20.62a1.88 1.88 0 01-1.37 1.52 2 2 0 01-1 0l-18.7-5a1.89 1.89 0 01-1.33-2.3L6.35 8.34l1.44.38L8.4 13.9l6 1.62L17.21 5.23m-1-2.2a1 1 0 00-.68.69L13 13.07l-2.81-.75L9.69 7.79A1 1 0 009 7L5.87 6.14a.94.94 0 00-.5 0 1 1 0 00-.68.68l-2 7.49a3.87 3.87 0 002.74 4.74l18.71 5A3.87 3.87 0 0029 21a4 4 0 00-3-4.42l-4.52-1.21L20.53 4.71a1 1 0 00-.72-.85L16.73 3a1.06 1.06 0 00-.5 0z"
	});

	var Arrival20 = /*#__PURE__*/React__default.forwardRef(function Arrival20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3C, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3D =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 28H30V30H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0127 20.62a1.88 1.88 0 01-1.37 1.52 2 2 0 01-1 0l-18.7-5a1.89 1.89 0 01-1.33-2.3L6.35 8.34l1.44.38L8.4 13.9l6 1.62L17.21 5.23m-1-2.2a1 1 0 00-.68.69L13 13.07l-2.81-.75L9.69 7.79A1 1 0 009 7L5.87 6.14a.94.94 0 00-.5 0 1 1 0 00-.68.68l-2 7.49a3.87 3.87 0 002.74 4.74l18.71 5A3.87 3.87 0 0029 21a4 4 0 00-3-4.42l-4.52-1.21L20.53 4.71a1 1 0 00-.72-.85L16.73 3a1.06 1.06 0 00-.5 0z"
	});

	var Arrival16 = /*#__PURE__*/React__default.forwardRef(function Arrival16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3D, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3E =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13.71 12.29L7.42 6 14 6 14 4 4 4 4 13.99 6 14.01 6 7.41 12.29 13.7 13.71 12.29zM28 10H18v2H28V28H12V18H10V28a2 2 0 002 2H28a2 2 0 002-2V12A2 2 0 0028 10z"
	});

	var _ref3$1g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M19 25L21 25 21 18 24 18 24 16 16 16 16 18 19 18 19 25z"
	});

	var WatsonHealthArrowAnnotation32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthArrowAnnotation32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3E, _ref3$1g, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3F =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13.71 12.29L7.42 6 14 6 14 4 4 4 4 13.99 6 14.01 6 7.41 12.29 13.7 13.71 12.29zM28 10H18v2H28V28H12V18H10V28a2 2 0 002 2H28a2 2 0 002-2V12A2 2 0 0028 10z"
	});

	var _ref3$1h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M19 25L21 25 21 18 24 18 24 16 16 16 16 18 19 18 19 25z"
	});

	var WatsonHealthArrowAnnotation24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthArrowAnnotation24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3F, _ref3$1h, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3G =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13.71 12.29L7.42 6 14 6 14 4 4 4 4 13.99 6 14.01 6 7.41 12.29 13.7 13.71 12.29zM28 10H18v2H28V28H12V18H10V28a2 2 0 002 2H28a2 2 0 002-2V12A2 2 0 0028 10z"
	});

	var _ref3$1i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M19 25L21 25 21 18 24 18 24 16 16 16 16 18 19 18 19 25z"
	});

	var WatsonHealthArrowAnnotation20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthArrowAnnotation20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3G, _ref3$1i, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3H =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13.71 12.29L7.42 6 14 6 14 4 4 4 4 13.99 6 14.01 6 7.41 12.29 13.7 13.71 12.29zM28 10H18v2H28V28H12V18H10V28a2 2 0 002 2H28a2 2 0 002-2V12A2 2 0 0028 10z"
	});

	var _ref3$1j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M19 25L21 25 21 18 24 18 24 16 16 16 16 18 19 18 19 25z"
	});

	var WatsonHealthArrowAnnotation16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthArrowAnnotation16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3H, _ref3$1j, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3I =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.59 16.59L17 24.17 17 2 15 2 15 24.17 7.41 16.59 6 18 16 28 26 18 24.59 16.59z"
	});

	var ArrowDown32 = /*#__PURE__*/React__default.forwardRef(function ArrowDown32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3I, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3J =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.59 16.59L17 24.17 17 2 15 2 15 24.17 7.41 16.59 6 18 16 28 26 18 24.59 16.59z"
	});

	var ArrowDown24 = /*#__PURE__*/React__default.forwardRef(function ArrowDown24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3J, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3K =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24.59 16.59L17 24.17 17 2 15 2 15 24.17 7.41 16.59 6 18 16 28 26 18 24.59 16.59z"
	});

	var ArrowDown20 = /*#__PURE__*/React__default.forwardRef(function ArrowDown20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3K, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3L =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12.3 9.3L8.5 13.1 8.5 1 7.5 1 7.5 13.1 3.7 9.3 3 10 8 15 13 10z"
	});

	var ArrowDown16 = /*#__PURE__*/React__default.forwardRef(function ArrowDown16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 16 16",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3L, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3M =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22 26L22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26z"
	});

	var ArrowDownLeft32 = /*#__PURE__*/React__default.forwardRef(function ArrowDownLeft32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3M, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3N =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22 26L22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26z"
	});

	var ArrowDownLeft24 = /*#__PURE__*/React__default.forwardRef(function ArrowDownLeft24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3N, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3O =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22 26L22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26z"
	});

	var ArrowDownLeft20 = /*#__PURE__*/React__default.forwardRef(function ArrowDownLeft20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3O, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3P =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22 26L22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26z"
	});

	var ArrowDownLeft16 = /*#__PURE__*/React__default.forwardRef(function ArrowDownLeft16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3P, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3Q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10 26L10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26z"
	});

	var ArrowDownRight32 = /*#__PURE__*/React__default.forwardRef(function ArrowDownRight32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3Q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3R =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10 26L10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26z"
	});

	var ArrowDownRight24 = /*#__PURE__*/React__default.forwardRef(function ArrowDownRight24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3R, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3S =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10 26L10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26z"
	});

	var ArrowDownRight20 = /*#__PURE__*/React__default.forwardRef(function ArrowDownRight20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3S, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3T =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10 26L10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26z"
	});

	var ArrowDownRight16 = /*#__PURE__*/React__default.forwardRef(function ArrowDownRight16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3T, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3U =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13 26L14.41 24.59 6.83 17 29 17 29 15 6.83 15 14.41 7.41 13 6 3 16 13 26z"
	});

	var ArrowLeft32 = /*#__PURE__*/React__default.forwardRef(function ArrowLeft32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3U, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3V =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13 26L14.41 24.59 6.83 17 29 17 29 15 6.83 15 14.41 7.41 13 6 3 16 13 26z"
	});

	var ArrowLeft24 = /*#__PURE__*/React__default.forwardRef(function ArrowLeft24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3V, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3W =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13 26L14.41 24.59 6.83 17 29 17 29 15 6.83 15 14.41 7.41 13 6 3 16 13 26z"
	});

	var ArrowLeft20 = /*#__PURE__*/React__default.forwardRef(function ArrowLeft20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3W, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3X =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6.7 12.3L2.9 8.5 15 8.5 15 7.5 2.9 7.5 6.7 3.7 6 3 1 8 6 13z"
	});

	var ArrowLeft16 = /*#__PURE__*/React__default.forwardRef(function ArrowLeft16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 16 16",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3X, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3Y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18 6L16.6 7.4 24.1 15 3 15 3 17 24.1 17 16.6 24.6 18 26 28 16z"
	});

	var ArrowRight32 = /*#__PURE__*/React__default.forwardRef(function ArrowRight32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3Y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3Z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14 4L12.9 5.1 18.9 11.2 2 11.2 2 12.8 18.9 12.8 12.9 18.9 14 20 22 12z"
	});

	var ArrowRight24 = /*#__PURE__*/React__default.forwardRef(function ArrowRight24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 24 24",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3Z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3_ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11.8 2.8L10.8 3.8 16.2 9.3 1 9.3 1 10.7 16.2 10.7 10.8 16.2 11.8 17.2 19 10z"
	});

	var ArrowRight20 = /*#__PURE__*/React__default.forwardRef(function ArrowRight20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 20 20",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3_, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$3$ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M9.3 3.7L13.1 7.5 1 7.5 1 8.5 13.1 8.5 9.3 12.3 10 13 15 8 10 3z"
	});

	var ArrowRight16 = /*#__PURE__*/React__default.forwardRef(function ArrowRight16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 16 16",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$3$, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$40 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 4L6 14 7.41 15.41 15 7.83 15 30 17 30 17 7.83 24.59 15.41 26 14 16 4z"
	});

	var ArrowUp32 = /*#__PURE__*/React__default.forwardRef(function ArrowUp32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$40, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$41 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 4L6 14 7.41 15.41 15 7.83 15 30 17 30 17 7.83 24.59 15.41 26 14 16 4z"
	});

	var ArrowUp24 = /*#__PURE__*/React__default.forwardRef(function ArrowUp24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$41, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$42 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 4L6 14 7.41 15.41 15 7.83 15 30 17 30 17 7.83 24.59 15.41 26 14 16 4z"
	});

	var ArrowUp20 = /*#__PURE__*/React__default.forwardRef(function ArrowUp20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$42, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$43 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.7 6.7L7.5 2.9 7.5 15 8.5 15 8.5 2.9 12.3 6.7 13 6 8 1 3 6z"
	});

	var ArrowUp16 = /*#__PURE__*/React__default.forwardRef(function ArrowUp16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 16 16",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$43, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$44 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22 6L22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6z"
	});

	var ArrowUpLeft32 = /*#__PURE__*/React__default.forwardRef(function ArrowUpLeft32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$44, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$45 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22 6L22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6z"
	});

	var ArrowUpLeft24 = /*#__PURE__*/React__default.forwardRef(function ArrowUpLeft24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$45, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$46 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22 6L22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6z"
	});

	var ArrowUpLeft20 = /*#__PURE__*/React__default.forwardRef(function ArrowUpLeft20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$46, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$47 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22 6L22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6z"
	});

	var ArrowUpLeft16 = /*#__PURE__*/React__default.forwardRef(function ArrowUpLeft16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$47, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$48 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10 6L10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6z"
	});

	var ArrowUpRight32 = /*#__PURE__*/React__default.forwardRef(function ArrowUpRight32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$48, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$49 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10 6L10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6z"
	});

	var ArrowUpRight24 = /*#__PURE__*/React__default.forwardRef(function ArrowUpRight24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$49, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10 6L10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6z"
	});

	var ArrowUpRight20 = /*#__PURE__*/React__default.forwardRef(function ArrowUpRight20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4a, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10 6L10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6z"
	});

	var ArrowUpRight16 = /*#__PURE__*/React__default.forwardRef(function ArrowUpRight16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4b, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H21V6H11V18H6.4141Z"
	});

	var ArrowShiftDown32 = /*#__PURE__*/React__default.forwardRef(function ArrowShiftDown32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4c, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H21V6H11V18H6.4141Z"
	});

	var ArrowShiftDown24 = /*#__PURE__*/React__default.forwardRef(function ArrowShiftDown24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4d, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H21V6H11V18H6.4141Z"
	});

	var ArrowShiftDown20 = /*#__PURE__*/React__default.forwardRef(function ArrowShiftDown20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4e, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H21V6H11V18H6.4141Z"
	});

	var ArrowShiftDown16 = /*#__PURE__*/React__default.forwardRef(function ArrowShiftDown16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4f, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$4 = false;

	var _ref2$4g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
	});

	var Arrows32 = /*#__PURE__*/React__default.forwardRef(function Arrows32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$4) {
	      didWarnAboutDeprecation$4 = true;
	      console.warn("The Arrows32 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4g, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$5 = false;

	var _ref2$4h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
	});

	var Arrows24 = /*#__PURE__*/React__default.forwardRef(function Arrows24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$5) {
	      didWarnAboutDeprecation$5 = true;
	      console.warn("The Arrows24 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4h, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$6 = false;

	var _ref2$4i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
	});

	var Arrows20 = /*#__PURE__*/React__default.forwardRef(function Arrows20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$6) {
	      didWarnAboutDeprecation$6 = true;
	      console.warn("The Arrows20 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4i, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$7 = false;

	var _ref2$4j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
	});

	var Arrows16 = /*#__PURE__*/React__default.forwardRef(function Arrows16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$7) {
	      didWarnAboutDeprecation$7 = true;
	      console.warn("The Arrows16 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4j, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11.41 26.59L7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59zM28 10L22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10z"
	});

	var ArrowsHorizontal32 = /*#__PURE__*/React__default.forwardRef(function ArrowsHorizontal32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4k, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11.41 26.59L7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59zM28 10L22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10z"
	});

	var ArrowsHorizontal24 = /*#__PURE__*/React__default.forwardRef(function ArrowsHorizontal24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4l, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11.41 26.59L7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59zM28 10L22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10z"
	});

	var ArrowsHorizontal20 = /*#__PURE__*/React__default.forwardRef(function ArrowsHorizontal20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4m, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11.41 26.59L7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59zM28 10L22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10z"
	});

	var ArrowsHorizontal16 = /*#__PURE__*/React__default.forwardRef(function ArrowsHorizontal16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4n, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
	});

	var ArrowsVertical32 = /*#__PURE__*/React__default.forwardRef(function ArrowsVertical32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4o, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
	});

	var ArrowsVertical24 = /*#__PURE__*/React__default.forwardRef(function ArrowsVertical24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4p, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
	});

	var ArrowsVertical20 = /*#__PURE__*/React__default.forwardRef(function ArrowsVertical20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
	});

	var ArrowsVertical16 = /*#__PURE__*/React__default.forwardRef(function ArrowsVertical16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4r, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13.5025,5.4136A15.0755,15.0755,0,0,0,25.096,23.6082a11.1134,11.1134,0,0,1-7.9749,3.3893c-.1385,0-.2782.0051-.4178,0A11.0944,11.0944,0,0,1,13.5025,5.4136M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
	});

	var Asleep32 = /*#__PURE__*/React__default.forwardRef(function Asleep32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4s, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13.5025,5.4136A15.0755,15.0755,0,0,0,25.096,23.6082a11.1134,11.1134,0,0,1-7.9749,3.3893c-.1385,0-.2782.0051-.4178,0A11.0944,11.0944,0,0,1,13.5025,5.4136M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
	});

	var Asleep24 = /*#__PURE__*/React__default.forwardRef(function Asleep24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4t, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M13.5025,5.4136A15.0755,15.0755,0,0,0,25.096,23.6082a11.1134,11.1134,0,0,1-7.9749,3.3893c-.1385,0-.2782.0051-.4178,0A11.0944,11.0944,0,0,1,13.5025,5.4136M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
	});

	var Asleep20 = /*#__PURE__*/React__default.forwardRef(function Asleep20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4u, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M7.2,2.3c-1,4.4,1.7,8.7,6.1,9.8c0.1,0,0.1,0,0.2,0c-1.1,1.2-2.7,1.8-4.3,1.8c-0.1,0-0.2,0-0.2,0C5.6,13.8,3,11,3.2,7.7\tC3.2,5.3,4.8,3.1,7.2,2.3 M8,1L8,1C4.1,1.6,1.5,5.3,2.1,9.1c0.6,3.3,3.4,5.8,6.8,5.9c0.1,0,0.2,0,0.3,0c2.3,0,4.4-1.1,5.8-3\tc0.2-0.2,0.1-0.6-0.1-0.7c-0.1-0.1-0.2-0.1-0.3-0.1c-3.9-0.3-6.7-3.8-6.4-7.6C8.3,3,8.4,2.4,8.6,1.8c0.1-0.3,0-0.6-0.3-0.7\tC8.1,1,8.1,1,8,1z"
	});

	var Asleep16 = /*#__PURE__*/React__default.forwardRef(function Asleep16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 16 16",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4v, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
	});

	var AsleepFilled32 = /*#__PURE__*/React__default.forwardRef(function AsleepFilled32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4w, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
	});

	var AsleepFilled24 = /*#__PURE__*/React__default.forwardRef(function AsleepFilled24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4x, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
	});

	var AsleepFilled20 = /*#__PURE__*/React__default.forwardRef(function AsleepFilled20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"
	});

	var AsleepFilled16 = /*#__PURE__*/React__default.forwardRef(function AsleepFilled16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4A =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12.0752,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12.0752,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12.0752,18Z"
	});

	var _ref3$1k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"
	});

	var Asset32 = /*#__PURE__*/React__default.forwardRef(function Asset32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4A, _ref3$1k, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4B =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12.0752,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12.0752,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12.0752,18Z"
	});

	var _ref3$1l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"
	});

	var Asset24 = /*#__PURE__*/React__default.forwardRef(function Asset24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4B, _ref3$1l, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4C =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12.0752,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12.0752,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12.0752,18Z"
	});

	var _ref3$1m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"
	});

	var Asset20 = /*#__PURE__*/React__default.forwardRef(function Asset20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4C, _ref3$1m, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4D =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12.0752,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12.0752,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12.0752,18Z"
	});

	var _ref3$1n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"
	});

	var Asset16 = /*#__PURE__*/React__default.forwardRef(function Asset16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4D, _ref3$1n, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4E =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"
	});

	var At32 = /*#__PURE__*/React__default.forwardRef(function At32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4E, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4F =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"
	});

	var At24 = /*#__PURE__*/React__default.forwardRef(function At24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4F, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4G =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"
	});

	var At20 = /*#__PURE__*/React__default.forwardRef(function At20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4G, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4H =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"
	});

	var At16 = /*#__PURE__*/React__default.forwardRef(function At16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4H, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4I =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"
	});

	var Attachment32 = /*#__PURE__*/React__default.forwardRef(function Attachment32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4I, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4J =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"
	});

	var Attachment24 = /*#__PURE__*/React__default.forwardRef(function Attachment24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4J, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4K =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"
	});

	var Attachment20 = /*#__PURE__*/React__default.forwardRef(function Attachment20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4K, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4L =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"
	});

	var Attachment16 = /*#__PURE__*/React__default.forwardRef(function Attachment16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4L, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4M =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30 20H29V2H27V20H26a2.0027 2.0027 0 00-2 2v2a2.0027 2.0027 0 002 2h1v4h2V26h1a2.0027 2.0027 0 002-2V22A2.0027 2.0027 0 0030 20zm0 4H26V22h4zM22 14H21V2H19V14H18a2.002 2.002 0 00-2 2v2a2.0023 2.0023 0 002 2h1V30h2V20h1a2.0027 2.0027 0 002-2V16A2.0023 2.0023 0 0022 14zm0 4H18V16h4zM14 7H13V2H11V7H10A2.002 2.002 0 008 9v2a2.002 2.002 0 002 2h1V30h2V13h1a2.002 2.002 0 002-2V9A2.002 2.002 0 0014 7zm0 4H10V9h4zM6 21H5V2H3V21H2a2.0023 2.0023 0 00-2 2v2a2.0023 2.0023 0 002 2H3v3H5V27H6a2.0023 2.0023 0 002-2V23A2.0023 2.0023 0 006 21zm0 4H2V23l4-.001z",
	  transform: "translate(0 .005)"
	});

	var AudioConsole32 = /*#__PURE__*/React__default.forwardRef(function AudioConsole32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4M, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4N =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30 20H29V2H27V20H26a2.0027 2.0027 0 00-2 2v2a2.0027 2.0027 0 002 2h1v4h2V26h1a2.0027 2.0027 0 002-2V22A2.0027 2.0027 0 0030 20zm0 4H26V22h4zM22 14H21V2H19V14H18a2.002 2.002 0 00-2 2v2a2.0023 2.0023 0 002 2h1V30h2V20h1a2.0027 2.0027 0 002-2V16A2.0023 2.0023 0 0022 14zm0 4H18V16h4zM14 7H13V2H11V7H10A2.002 2.002 0 008 9v2a2.002 2.002 0 002 2h1V30h2V13h1a2.002 2.002 0 002-2V9A2.002 2.002 0 0014 7zm0 4H10V9h4zM6 21H5V2H3V21H2a2.0023 2.0023 0 00-2 2v2a2.0023 2.0023 0 002 2H3v3H5V27H6a2.0023 2.0023 0 002-2V23A2.0023 2.0023 0 006 21zm0 4H2V23l4-.001z",
	  transform: "translate(0 .005)"
	});

	var AudioConsole24 = /*#__PURE__*/React__default.forwardRef(function AudioConsole24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4N, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4O =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30 20H29V2H27V20H26a2.0027 2.0027 0 00-2 2v2a2.0027 2.0027 0 002 2h1v4h2V26h1a2.0027 2.0027 0 002-2V22A2.0027 2.0027 0 0030 20zm0 4H26V22h4zM22 14H21V2H19V14H18a2.002 2.002 0 00-2 2v2a2.0023 2.0023 0 002 2h1V30h2V20h1a2.0027 2.0027 0 002-2V16A2.0023 2.0023 0 0022 14zm0 4H18V16h4zM14 7H13V2H11V7H10A2.002 2.002 0 008 9v2a2.002 2.002 0 002 2h1V30h2V13h1a2.002 2.002 0 002-2V9A2.002 2.002 0 0014 7zm0 4H10V9h4zM6 21H5V2H3V21H2a2.0023 2.0023 0 00-2 2v2a2.0023 2.0023 0 002 2H3v3H5V27H6a2.0023 2.0023 0 002-2V23A2.0023 2.0023 0 006 21zm0 4H2V23l4-.001z",
	  transform: "translate(0 .005)"
	});

	var AudioConsole20 = /*#__PURE__*/React__default.forwardRef(function AudioConsole20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4O, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4P =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30 20H29V2H27V20H26a2.0027 2.0027 0 00-2 2v2a2.0027 2.0027 0 002 2h1v4h2V26h1a2.0027 2.0027 0 002-2V22A2.0027 2.0027 0 0030 20zm0 4H26V22h4zM22 14H21V2H19V14H18a2.002 2.002 0 00-2 2v2a2.0023 2.0023 0 002 2h1V30h2V20h1a2.0027 2.0027 0 002-2V16A2.0023 2.0023 0 0022 14zm0 4H18V16h4zM14 7H13V2H11V7H10A2.002 2.002 0 008 9v2a2.002 2.002 0 002 2h1V30h2V13h1a2.002 2.002 0 002-2V9A2.002 2.002 0 0014 7zm0 4H10V9h4zM6 21H5V2H3V21H2a2.0023 2.0023 0 00-2 2v2a2.0023 2.0023 0 002 2H3v3H5V27H6a2.0023 2.0023 0 002-2V23A2.0023 2.0023 0 006 21zm0 4H2V23l4-.001z",
	  transform: "translate(0 .005)"
	});

	var AudioConsole16 = /*#__PURE__*/React__default.forwardRef(function AudioConsole16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4P, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4Q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"
	});

	var _ref3$1o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "13.5",
	  cy: "24.5",
	  r: "1.5"
	});

	var _ref4$s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"
	});

	var AugmentedReality32 = /*#__PURE__*/React__default.forwardRef(function AugmentedReality32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4Q, _ref3$1o, _ref4$s, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4R =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"
	});

	var _ref3$1p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "13.5",
	  cy: "24.5",
	  r: "1.5"
	});

	var _ref4$t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"
	});

	var AugmentedReality24 = /*#__PURE__*/React__default.forwardRef(function AugmentedReality24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4R, _ref3$1p, _ref4$t, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4S =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"
	});

	var _ref3$1q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "13.5",
	  cy: "24.5",
	  r: "1.5"
	});

	var _ref4$u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"
	});

	var AugmentedReality20 = /*#__PURE__*/React__default.forwardRef(function AugmentedReality20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4S, _ref3$1q, _ref4$u, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4T =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"
	});

	var _ref3$1r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("circle", {
	  cx: "13.5",
	  cy: "24.5",
	  r: "1.5"
	});

	var _ref4$v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"
	});

	var AugmentedReality16 = /*#__PURE__*/React__default.forwardRef(function AugmentedReality16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4T, _ref3$1r, _ref4$v, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4U =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12 16a4 4 0 104-4A4 4 0 0012 16zm6 0a2 2 0 11-2-2A2 2 0 0118 16zM16 27.17L10.4 21.58 9 23 16 30 23 23 21.59 21.59 16 27.17zM16 4.83L21.58 10.4 23 9 16 2 9 9 10.41 10.41 16 4.83z"
	});

	var WatsonHealthAutoScroll32 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAutoScroll32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4U, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4V =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12 16a4 4 0 104-4A4 4 0 0012 16zm6 0a2 2 0 11-2-2A2 2 0 0118 16zM16 27.17L10.4 21.58 9 23 16 30 23 23 21.59 21.59 16 27.17zM16 4.83L21.58 10.4 23 9 16 2 9 9 10.41 10.41 16 4.83z"
	});

	var WatsonHealthAutoScroll24 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAutoScroll24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4V, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4W =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12 16a4 4 0 104-4A4 4 0 0012 16zm6 0a2 2 0 11-2-2A2 2 0 0118 16zM16 27.17L10.4 21.58 9 23 16 30 23 23 21.59 21.59 16 27.17zM16 4.83L21.58 10.4 23 9 16 2 9 9 10.41 10.41 16 4.83z"
	});

	var WatsonHealthAutoScroll20 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAutoScroll20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4W, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4X =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12 16a4 4 0 104-4A4 4 0 0012 16zm6 0a2 2 0 11-2-2A2 2 0 0118 16zM16 27.17L10.4 21.58 9 23 16 30 23 23 21.59 21.59 16 27.17zM16 4.83L21.58 10.4 23 9 16 2 9 9 10.41 10.41 16 4.83z"
	});

	var WatsonHealthAutoScroll16 = /*#__PURE__*/React__default.forwardRef(function WatsonHealthAutoScroll16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4X, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4Y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 16H22a2.002 2.002 0 00-2 2V30h2V25h4v5h2V18A2.002 2.002 0 0026 16zm-4 7V18h4v5zM16 27a10.9862 10.9862 0 01-9.2156-5H12V20H4v8H6V24.3149A13.0239 13.0239 0 0016 29zM20 10h5.2155A10.9973 10.9973 0 005 16H3A13.0048 13.0048 0 0126 7.6849V4h2v8H20z"
	});

	var Automatic32 = /*#__PURE__*/React__default.forwardRef(function Automatic32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4Y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4Z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 16H22a2.002 2.002 0 00-2 2V30h2V25h4v5h2V18A2.002 2.002 0 0026 16zm-4 7V18h4v5zM16 27a10.9862 10.9862 0 01-9.2156-5H12V20H4v8H6V24.3149A13.0239 13.0239 0 0016 29zM20 10h5.2155A10.9973 10.9973 0 005 16H3A13.0048 13.0048 0 0126 7.6849V4h2v8H20z"
	});

	var Automatic24 = /*#__PURE__*/React__default.forwardRef(function Automatic24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4Z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4_ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 16H22a2.002 2.002 0 00-2 2V30h2V25h4v5h2V18A2.002 2.002 0 0026 16zm-4 7V18h4v5zM16 27a10.9862 10.9862 0 01-9.2156-5H12V20H4v8H6V24.3149A13.0239 13.0239 0 0016 29zM20 10h5.2155A10.9973 10.9973 0 005 16H3A13.0048 13.0048 0 0126 7.6849V4h2v8H20z"
	});

	var Automatic20 = /*#__PURE__*/React__default.forwardRef(function Automatic20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4_, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$4$ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26 16H22a2.002 2.002 0 00-2 2V30h2V25h4v5h2V18A2.002 2.002 0 0026 16zm-4 7V18h4v5zM16 27a10.9862 10.9862 0 01-9.2156-5H12V20H4v8H6V24.3149A13.0239 13.0239 0 0016 29zM20 10h5.2155A10.9973 10.9973 0 005 16H3A13.0048 13.0048 0 0126 7.6849V4h2v8H20z"
	});

	var Automatic16 = /*#__PURE__*/React__default.forwardRef(function Automatic16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$4$, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$50 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 2H17V6.96H15z"
	});

	var _ref3$1s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.67 6.85H26.630000000000003V8.85H21.67z",
	  transform: "rotate(-45 24.142 7.85)"
	});

	var _ref4$w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M25.04 15H30V17H25.04z"
	});

	var _ref5$k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23.15 21.67H25.15V26.630000000000003H23.15z",
	  transform: "rotate(-45 24.152 24.146)"
	});

	var _ref6$4 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 25.04H17V30H15z"
	});

	var _ref7 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M5.37 23.15H10.33V25.15H5.37z",
	  transform: "rotate(-45 7.86 24.144)"
	});

	var _ref8 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 15H6.96V17H2z"
	});

	var _ref9 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6.85 5.37H8.85V10.33H6.85z",
	  transform: "rotate(-45 7.85 7.848)"
	});

	var _ref10 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,12a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"
	});

	var Awake32 = /*#__PURE__*/React__default.forwardRef(function Awake32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$50, _ref3$1s, _ref4$w, _ref5$k, _ref6$4, _ref7, _ref8, _ref9, _ref10, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$51 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 2H17V6.96H15z"
	});

	var _ref3$1t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.67 6.85H26.630000000000003V8.85H21.67z",
	  transform: "rotate(-45 24.142 7.85)"
	});

	var _ref4$x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M25.04 15H30V17H25.04z"
	});

	var _ref5$l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23.15 21.67H25.15V26.630000000000003H23.15z",
	  transform: "rotate(-45 24.152 24.146)"
	});

	var _ref6$5 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 25.04H17V30H15z"
	});

	var _ref7$1 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M5.37 23.15H10.33V25.15H5.37z",
	  transform: "rotate(-45 7.86 24.144)"
	});

	var _ref8$1 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 15H6.96V17H2z"
	});

	var _ref9$1 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6.85 5.37H8.85V10.33H6.85z",
	  transform: "rotate(-45 7.85 7.848)"
	});

	var _ref10$1 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,12a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"
	});

	var Awake24 = /*#__PURE__*/React__default.forwardRef(function Awake24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$51, _ref3$1t, _ref4$x, _ref5$l, _ref6$5, _ref7$1, _ref8$1, _ref9$1, _ref10$1, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$52 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 2H17V6.96H15z"
	});

	var _ref3$1u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.67 6.85H26.630000000000003V8.85H21.67z",
	  transform: "rotate(-45 24.142 7.85)"
	});

	var _ref4$y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M25.04 15H30V17H25.04z"
	});

	var _ref5$m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23.15 21.67H25.15V26.630000000000003H23.15z",
	  transform: "rotate(-45 24.152 24.146)"
	});

	var _ref6$6 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 25.04H17V30H15z"
	});

	var _ref7$2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M5.37 23.15H10.33V25.15H5.37z",
	  transform: "rotate(-45 7.86 24.144)"
	});

	var _ref8$2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2 15H6.96V17H2z"
	});

	var _ref9$2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6.85 5.37H8.85V10.33H6.85z",
	  transform: "rotate(-45 7.85 7.848)"
	});

	var _ref10$2 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,12a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"
	});

	var Awake20 = /*#__PURE__*/React__default.forwardRef(function Awake20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$52, _ref3$1u, _ref4$y, _ref5$m, _ref6$6, _ref7$2, _ref8$2, _ref9$2, _ref10$2, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$53 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M7.5 1H8.5V3.5H7.5z"
	});

	var _ref3$1v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M10.8 3.4H13.3V4.4H10.8z",
	  transform: "rotate(-45.001 12.074 3.922)"
	});

	var _ref4$z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M12.5 7.5H15V8.5H12.5z"
	});

	var _ref5$n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11.6 10.8H12.6V13.3H11.6z",
	  transform: "rotate(-45.001 12.077 12.075)"
	});

	var _ref6$7 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M7.5 12.5H8.5V15H7.5z"
	});

	var _ref7$3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M2.7 11.6H5.2V12.6H2.7z",
	  transform: "rotate(-45.001 3.929 12.078)"
	});

	var _ref8$3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M1 7.5H3.5V8.5H1z"
	});

	var _ref9$3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M3.4 2.7H4.4V5.2H3.4z",
	  transform: "rotate(-45.001 3.926 3.925)"
	});

	var _ref10$3 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8,6c1.1,0,2,0.9,2,2s-0.9,2-2,2S6,9.1,6,8S6.9,6,8,6 M8,5C6.3,5,5,6.3,5,8s1.3,3,3,3s3-1.3,3-3S9.7,5,8,5z"
	});

	var Awake16 = /*#__PURE__*/React__default.forwardRef(function Awake16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 16 16",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$53, _ref3$1v, _ref4$z, _ref5$n, _ref6$7, _ref7$3, _ref8$3, _ref9$3, _ref10$3, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$8 = false;

	var _ref2$54 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 14L6 24 7.4 25.4 16 16.8 24.6 25.4 26 24zM4 8H28V10H4z"
	});

	var BackToTop32 = /*#__PURE__*/React__default.forwardRef(function BackToTop32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$8) {
	      didWarnAboutDeprecation$8 = true;
	      console.warn("The BackToTop32 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$54, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$9 = false;

	var _ref2$55 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 14L6 24 7.4 25.4 16 16.8 24.6 25.4 26 24zM4 8H28V10H4z"
	});

	var BackToTop24 = /*#__PURE__*/React__default.forwardRef(function BackToTop24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$9) {
	      didWarnAboutDeprecation$9 = true;
	      console.warn("The BackToTop24 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$55, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$a = false;

	var _ref2$56 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 14L6 24 7.4 25.4 16 16.8 24.6 25.4 26 24zM4 8H28V10H4z"
	});

	var BackToTop20 = /*#__PURE__*/React__default.forwardRef(function BackToTop20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$a) {
	      didWarnAboutDeprecation$a = true;
	      console.warn("The BackToTop20 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$56, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */
	var didWarnAboutDeprecation$b = false;

	var _ref2$57 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 14L6 24 7.4 25.4 16 16.8 24.6 25.4 26 24zM4 8H28V10H4z"
	});

	var BackToTop16 = /*#__PURE__*/React__default.forwardRef(function BackToTop16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  {
	    if (!didWarnAboutDeprecation$b) {
	      didWarnAboutDeprecation$b = true;
	      console.warn("The BackToTop16 component has been deprecated and will be " + "removed in the next major version of @carbon/icons-react.");
	    }
	  }

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$57, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$58 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23 2L24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2z"
	});

	var _ref3$1w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"
	});

	var Badge32 = /*#__PURE__*/React__default.forwardRef(function Badge32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$58, _ref3$1w, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$59 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23 2L24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2z"
	});

	var _ref3$1x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"
	});

	var Badge24 = /*#__PURE__*/React__default.forwardRef(function Badge24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$59, _ref3$1x, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23 2L24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2z"
	});

	var _ref3$1y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"
	});

	var Badge20 = /*#__PURE__*/React__default.forwardRef(function Badge20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5a, _ref3$1y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M23 2L24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2z"
	});

	var _ref3$1z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"
	});

	var Badge16 = /*#__PURE__*/React__default.forwardRef(function Badge16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5b, _ref3$1z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"
	});

	var _ref3$1A =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"
	});

	var Bar32 = /*#__PURE__*/React__default.forwardRef(function Bar32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5c, _ref3$1A, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"
	});

	var _ref3$1B =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"
	});

	var Bar24 = /*#__PURE__*/React__default.forwardRef(function Bar24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5d, _ref3$1B, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"
	});

	var _ref3$1C =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"
	});

	var Bar20 = /*#__PURE__*/React__default.forwardRef(function Bar20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5e, _ref3$1C, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"
	});

	var _ref3$1D =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"
	});

	var Bar16 = /*#__PURE__*/React__default.forwardRef(function Bar16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5f, _ref3$1D, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 5H17V9H15zM15 11H17V15H15zM15 17H17V21H15zM15 23H17V27H15z"
	});

	var QBarrier32 = /*#__PURE__*/React__default.forwardRef(function QBarrier32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5g, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 5H17V9H15zM15 11H17V15H15zM15 17H17V21H15zM15 23H17V27H15z"
	});

	var QBarrier24 = /*#__PURE__*/React__default.forwardRef(function QBarrier24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5h, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 5H17V9H15zM15 11H17V15H15zM15 17H17V21H15zM15 23H17V27H15z"
	});

	var QBarrier20 = /*#__PURE__*/React__default.forwardRef(function QBarrier20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5i, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M15 5H17V9H15zM15 11H17V15H15zM15 17H17V21H15zM15 23H17V27H15z"
	});

	var QBarrier16 = /*#__PURE__*/React__default.forwardRef(function QBarrier16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5j, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"
	});

	var Basketball32 = /*#__PURE__*/React__default.forwardRef(function Basketball32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5k, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"
	});

	var Basketball24 = /*#__PURE__*/React__default.forwardRef(function Basketball24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5l, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"
	});

	var Basketball20 = /*#__PURE__*/React__default.forwardRef(function Basketball20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5m, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"
	});

	var Basketball16 = /*#__PURE__*/React__default.forwardRef(function Basketball16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5n, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27 11H26V10a2 2 0 00-2-2H20v2h4v3h3v6H24v3H19v2h5a2 2 0 002-2V21h1a2 2 0 002-2V13A2 2 0 0027 11zM11 22H6V10h6V8H6a2 2 0 00-2 2V22a2 2 0 002 2h5z"
	});

	var _ref3$1E =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14.81 23.58L13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58z"
	});

	var BatteryCharging32 = /*#__PURE__*/React__default.forwardRef(function BatteryCharging32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5o, _ref3$1E, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27 11H26V10a2 2 0 00-2-2H20v2h4v3h3v6H24v3H19v2h5a2 2 0 002-2V21h1a2 2 0 002-2V13A2 2 0 0027 11zM11 22H6V10h6V8H6a2 2 0 00-2 2V22a2 2 0 002 2h5z"
	});

	var _ref3$1F =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14.81 23.58L13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58z"
	});

	var BatteryCharging24 = /*#__PURE__*/React__default.forwardRef(function BatteryCharging24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5p, _ref3$1F, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27 11H26V10a2 2 0 00-2-2H20v2h4v3h3v6H24v3H19v2h5a2 2 0 002-2V21h1a2 2 0 002-2V13A2 2 0 0027 11zM11 22H6V10h6V8H6a2 2 0 00-2 2V22a2 2 0 002 2h5z"
	});

	var _ref3$1G =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14.81 23.58L13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58z"
	});

	var BatteryCharging20 = /*#__PURE__*/React__default.forwardRef(function BatteryCharging20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5q, _ref3$1G, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M27 11H26V10a2 2 0 00-2-2H20v2h4v3h3v6H24v3H19v2h5a2 2 0 002-2V21h1a2 2 0 002-2V13A2 2 0 0027 11zM11 22H6V10h6V8H6a2 2 0 00-2 2V22a2 2 0 002 2h5z"
	});

	var _ref3$1H =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M14.81 23.58L13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58z"
	});

	var BatteryCharging16 = /*#__PURE__*/React__default.forwardRef(function BatteryCharging16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5r, _ref3$1H, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var BatteryEmpty32 = /*#__PURE__*/React__default.forwardRef(function BatteryEmpty32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5s, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var BatteryEmpty24 = /*#__PURE__*/React__default.forwardRef(function BatteryEmpty24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5t, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var BatteryEmpty20 = /*#__PURE__*/React__default.forwardRef(function BatteryEmpty20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5u, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var BatteryEmpty16 = /*#__PURE__*/React__default.forwardRef(function BatteryEmpty16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5v, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1I =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 9H19V23H11z",
	  transform: "rotate(90 15 16)"
	});

	var BatteryFull32 = /*#__PURE__*/React__default.forwardRef(function BatteryFull32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5w, _ref3$1I, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1J =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 9H19V23H11z",
	  transform: "rotate(90 15 16)"
	});

	var BatteryFull24 = /*#__PURE__*/React__default.forwardRef(function BatteryFull24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5x, _ref3$1J, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1K =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 9H19V23H11z",
	  transform: "rotate(90 15 16)"
	});

	var BatteryFull20 = /*#__PURE__*/React__default.forwardRef(function BatteryFull20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5y, _ref3$1K, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1L =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M11 9H19V23H11z",
	  transform: "rotate(90 15 16)"
	});

	var BatteryFull16 = /*#__PURE__*/React__default.forwardRef(function BatteryFull16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5z, _ref3$1L, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5A =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1M =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8 12H16V20H8z",
	  transform: "rotate(90 12 16)"
	});

	var BatteryHalf32 = /*#__PURE__*/React__default.forwardRef(function BatteryHalf32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5A, _ref3$1M, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5B =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1N =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8 12H16V20H8z",
	  transform: "rotate(90 12 16)"
	});

	var BatteryHalf24 = /*#__PURE__*/React__default.forwardRef(function BatteryHalf24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5B, _ref3$1N, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5C =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1O =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8 12H16V20H8z",
	  transform: "rotate(90 12 16)"
	});

	var BatteryHalf20 = /*#__PURE__*/React__default.forwardRef(function BatteryHalf20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5C, _ref3$1O, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5D =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1P =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M8 12H16V20H8z",
	  transform: "rotate(90 12 16)"
	});

	var BatteryHalf16 = /*#__PURE__*/React__default.forwardRef(function BatteryHalf16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5D, _ref3$1P, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5E =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1Q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M5 15H13V17H5z",
	  transform: "rotate(90 9 16)"
	});

	var BatteryLow32 = /*#__PURE__*/React__default.forwardRef(function BatteryLow32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5E, _ref3$1Q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5F =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1R =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M5 15H13V17H5z",
	  transform: "rotate(90 9 16)"
	});

	var BatteryLow24 = /*#__PURE__*/React__default.forwardRef(function BatteryLow24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5F, _ref3$1R, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5G =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1S =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M5 15H13V17H5z",
	  transform: "rotate(90 9 16)"
	});

	var BatteryLow20 = /*#__PURE__*/React__default.forwardRef(function BatteryLow20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5G, _ref3$1S, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5H =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1T =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M5 15H13V17H5z",
	  transform: "rotate(90 9 16)"
	});

	var BatteryLow16 = /*#__PURE__*/React__default.forwardRef(function BatteryLow16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5H, _ref3$1T, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5I =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1U =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6 14H14V18H6z",
	  transform: "rotate(90 10 16)"
	});

	var BatteryQuarter32 = /*#__PURE__*/React__default.forwardRef(function BatteryQuarter32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5I, _ref3$1U, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5J =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1V =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6 14H14V18H6z",
	  transform: "rotate(90 10 16)"
	});

	var BatteryQuarter24 = /*#__PURE__*/React__default.forwardRef(function BatteryQuarter24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5J, _ref3$1V, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5K =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1W =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6 14H14V18H6z",
	  transform: "rotate(90 10 16)"
	});

	var BatteryQuarter20 = /*#__PURE__*/React__default.forwardRef(function BatteryQuarter20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5K, _ref3$1W, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5L =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"
	});

	var _ref3$1X =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6 14H14V18H6z",
	  transform: "rotate(90 10 16)"
	});

	var BatteryQuarter16 = /*#__PURE__*/React__default.forwardRef(function BatteryQuarter16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5L, _ref3$1X, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5M =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 10a6 6 0 00-6 6v8a6 6 0 0012 0V16A6 6 0 0016 10zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0111.75 24v-.13h8.5V24A4.27 4.27 0 0116 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 018.5 0zM30.66 19.21L24 13v9.1a4 4 0 008 0A3.83 3.83 0 0030.66 19.21zM28 24.35a2.25 2.25 0 01-2.25-2.25V17l3.72 3.47h0A2.05 2.05 0 0130.2 22 2.25 2.25 0 0128 24.35zM0 22.1a4 4 0 008 0V13L1.34 19.21A3.88 3.88 0 000 22.1zm2.48-1.56h0L6.25 17v5.1a2.25 2.25 0 01-4.5 0A2.05 2.05 0 012.48 20.54zM15 5.5A3.5 3.5 0 1011.5 9 3.5 3.5 0 0015 5.5zm-5.25 0A1.75 1.75 0 1111.5 7.25 1.77 1.77 0 019.75 5.5zM20.5 2A3.5 3.5 0 1024 5.5 3.5 3.5 0 0020.5 2zm0 5.25A1.75 1.75 0 1122.25 5.5 1.77 1.77 0 0120.5 7.25z"
	});

	var Bee32 = /*#__PURE__*/React__default.forwardRef(function Bee32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5M, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5N =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 10a6 6 0 00-6 6v8a6 6 0 0012 0V16A6 6 0 0016 10zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0111.75 24v-.13h8.5V24A4.27 4.27 0 0116 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 018.5 0zM30.66 19.21L24 13v9.1a4 4 0 008 0A3.83 3.83 0 0030.66 19.21zM28 24.35a2.25 2.25 0 01-2.25-2.25V17l3.72 3.47h0A2.05 2.05 0 0130.2 22 2.25 2.25 0 0128 24.35zM0 22.1a4 4 0 008 0V13L1.34 19.21A3.88 3.88 0 000 22.1zm2.48-1.56h0L6.25 17v5.1a2.25 2.25 0 01-4.5 0A2.05 2.05 0 012.48 20.54zM15 5.5A3.5 3.5 0 1011.5 9 3.5 3.5 0 0015 5.5zm-5.25 0A1.75 1.75 0 1111.5 7.25 1.77 1.77 0 019.75 5.5zM20.5 2A3.5 3.5 0 1024 5.5 3.5 3.5 0 0020.5 2zm0 5.25A1.75 1.75 0 1122.25 5.5 1.77 1.77 0 0120.5 7.25z"
	});

	var Bee24 = /*#__PURE__*/React__default.forwardRef(function Bee24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5N, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5O =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 10a6 6 0 00-6 6v8a6 6 0 0012 0V16A6 6 0 0016 10zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0111.75 24v-.13h8.5V24A4.27 4.27 0 0116 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 018.5 0zM30.66 19.21L24 13v9.1a4 4 0 008 0A3.83 3.83 0 0030.66 19.21zM28 24.35a2.25 2.25 0 01-2.25-2.25V17l3.72 3.47h0A2.05 2.05 0 0130.2 22 2.25 2.25 0 0128 24.35zM0 22.1a4 4 0 008 0V13L1.34 19.21A3.88 3.88 0 000 22.1zm2.48-1.56h0L6.25 17v5.1a2.25 2.25 0 01-4.5 0A2.05 2.05 0 012.48 20.54zM15 5.5A3.5 3.5 0 1011.5 9 3.5 3.5 0 0015 5.5zm-5.25 0A1.75 1.75 0 1111.5 7.25 1.77 1.77 0 019.75 5.5zM20.5 2A3.5 3.5 0 1024 5.5 3.5 3.5 0 0020.5 2zm0 5.25A1.75 1.75 0 1122.25 5.5 1.77 1.77 0 0120.5 7.25z"
	});

	var Bee20 = /*#__PURE__*/React__default.forwardRef(function Bee20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5O, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5P =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16 10a6 6 0 00-6 6v8a6 6 0 0012 0V16A6 6 0 0016 10zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0111.75 24v-.13h8.5V24A4.27 4.27 0 0116 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 018.5 0zM30.66 19.21L24 13v9.1a4 4 0 008 0A3.83 3.83 0 0030.66 19.21zM28 24.35a2.25 2.25 0 01-2.25-2.25V17l3.72 3.47h0A2.05 2.05 0 0130.2 22 2.25 2.25 0 0128 24.35zM0 22.1a4 4 0 008 0V13L1.34 19.21A3.88 3.88 0 000 22.1zm2.48-1.56h0L6.25 17v5.1a2.25 2.25 0 01-4.5 0A2.05 2.05 0 012.48 20.54zM15 5.5A3.5 3.5 0 1011.5 9 3.5 3.5 0 0015 5.5zm-5.25 0A1.75 1.75 0 1111.5 7.25 1.77 1.77 0 019.75 5.5zM20.5 2A3.5 3.5 0 1024 5.5 3.5 3.5 0 0020.5 2zm0 5.25A1.75 1.75 0 1122.25 5.5 1.77 1.77 0 0120.5 7.25z"
	});

	var Bee16 = /*#__PURE__*/React__default.forwardRef(function Bee16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5P, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5Q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"
	});

	var Bicycle32 = /*#__PURE__*/React__default.forwardRef(function Bicycle32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5Q, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5R =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"
	});

	var Bicycle24 = /*#__PURE__*/React__default.forwardRef(function Bicycle24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5R, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5S =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"
	});

	var Bicycle20 = /*#__PURE__*/React__default.forwardRef(function Bicycle20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5S, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5T =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"
	});

	var Bicycle16 = /*#__PURE__*/React__default.forwardRef(function Bicycle16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5T, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5U =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"
	});

	var Binoculars32 = /*#__PURE__*/React__default.forwardRef(function Binoculars32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5U, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5V =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"
	});

	var Binoculars24 = /*#__PURE__*/React__default.forwardRef(function Binoculars24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5V, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5W =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"
	});

	var Binoculars20 = /*#__PURE__*/React__default.forwardRef(function Binoculars20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5W, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5X =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"
	});

	var Binoculars16 = /*#__PURE__*/React__default.forwardRef(function Binoculars16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5X, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5Y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"
	});

	var _ref3$1Y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"
	});

	var QBlochSphere32 = /*#__PURE__*/React__default.forwardRef(function QBlochSphere32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5Y, _ref3$1Y, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5Z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"
	});

	var _ref3$1Z =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"
	});

	var QBlochSphere24 = /*#__PURE__*/React__default.forwardRef(function QBlochSphere24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5Z, _ref3$1Z, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5_ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"
	});

	var _ref3$1_ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"
	});

	var QBlochSphere20 = /*#__PURE__*/React__default.forwardRef(function QBlochSphere20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5_, _ref3$1_, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$5$ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"
	});

	var _ref3$1$ =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"
	});

	var QBlochSphere16 = /*#__PURE__*/React__default.forwardRef(function QBlochSphere16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$5$, _ref3$1$, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$60 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"
	});

	var Blockchain32 = /*#__PURE__*/React__default.forwardRef(function Blockchain32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$60, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$61 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"
	});

	var Blockchain24 = /*#__PURE__*/React__default.forwardRef(function Blockchain24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$61, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$62 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"
	});

	var Blockchain20 = /*#__PURE__*/React__default.forwardRef(function Blockchain20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$62, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$63 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"
	});

	var Blockchain16 = /*#__PURE__*/React__default.forwardRef(function Blockchain16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$63, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$64 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 24H14V26H4zM4 18H14V20H4zM26 14H6a2 2 0 01-2-2V6A2 2 0 016 4H26a2 2 0 012 2v6A2 2 0 0126 14zM6 6v6H26V6zM26 28H20a2 2 0 01-2-2V20a2 2 0 012-2h6a2 2 0 012 2v6A2 2 0 0126 28zm-6-8v6h6V20z"
	});

	var Blog32 = /*#__PURE__*/React__default.forwardRef(function Blog32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$64, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$65 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 24H14V26H4zM4 18H14V20H4zM26 14H6a2 2 0 01-2-2V6A2 2 0 016 4H26a2 2 0 012 2v6A2 2 0 0126 14zM6 6v6H26V6zM26 28H20a2 2 0 01-2-2V20a2 2 0 012-2h6a2 2 0 012 2v6A2 2 0 0126 28zm-6-8v6h6V20z"
	});

	var Blog24 = /*#__PURE__*/React__default.forwardRef(function Blog24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$65, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$66 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 24H14V26H4zM4 18H14V20H4zM26 14H6a2 2 0 01-2-2V6A2 2 0 016 4H26a2 2 0 012 2v6A2 2 0 0126 14zM6 6v6H26V6zM26 28H20a2 2 0 01-2-2V20a2 2 0 012-2h6a2 2 0 012 2v6A2 2 0 0126 28zm-6-8v6h6V20z"
	});

	var Blog20 = /*#__PURE__*/React__default.forwardRef(function Blog20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$66, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$67 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M4 24H14V26H4zM4 18H14V20H4zM26 14H6a2 2 0 01-2-2V6A2 2 0 016 4H26a2 2 0 012 2v6A2 2 0 0126 14zM6 6v6H26V6zM26 28H20a2 2 0 01-2-2V20a2 2 0 012-2h6a2 2 0 012 2v6A2 2 0 0126 28zm-6-8v6h6V20z"
	});

	var Blog16 = /*#__PURE__*/React__default.forwardRef(function Blog16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$67, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$68 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"
	});

	var Bluetooth32 = /*#__PURE__*/React__default.forwardRef(function Bluetooth32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$68, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$69 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"
	});

	var Bluetooth24 = /*#__PURE__*/React__default.forwardRef(function Bluetooth24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$69, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"
	});

	var Bluetooth20 = /*#__PURE__*/React__default.forwardRef(function Bluetooth20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6a, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"
	});

	var Bluetooth16 = /*#__PURE__*/React__default.forwardRef(function Bluetooth16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6b, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6c =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 00.58.91A1.06 1.06 0 0016 30a1 1 0 00.65-.24l6.3-5.4L26.59 28zm-11 .24V18.41l4.53 4.53zM17 12.75V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0024 9a1 1 0 00-.35-.72l-7-6a1 1 0 00-1.07-.15A1 1 0 0015 3v7.75z"
	});

	var BluetoothOff32 = /*#__PURE__*/React__default.forwardRef(function BluetoothOff32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6c, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6d =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 00.58.91A1.06 1.06 0 0016 30a1 1 0 00.65-.24l6.3-5.4L26.59 28zm-11 .24V18.41l4.53 4.53zM17 12.75V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0024 9a1 1 0 00-.35-.72l-7-6a1 1 0 00-1.07-.15A1 1 0 0015 3v7.75z"
	});

	var BluetoothOff24 = /*#__PURE__*/React__default.forwardRef(function BluetoothOff24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6d, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6e =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 00.58.91A1.06 1.06 0 0016 30a1 1 0 00.65-.24l6.3-5.4L26.59 28zm-11 .24V18.41l4.53 4.53zM17 12.75V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0024 9a1 1 0 00-.35-.72l-7-6a1 1 0 00-1.07-.15A1 1 0 0015 3v7.75z"
	});

	var BluetoothOff20 = /*#__PURE__*/React__default.forwardRef(function BluetoothOff20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6e, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6f =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 00.58.91A1.06 1.06 0 0016 30a1 1 0 00.65-.24l6.3-5.4L26.59 28zm-11 .24V18.41l4.53 4.53zM17 12.75V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0024 9a1 1 0 00-.35-.72l-7-6a1 1 0 00-1.07-.15A1 1 0 0015 3v7.75z"
	});

	var BluetoothOff16 = /*#__PURE__*/React__default.forwardRef(function BluetoothOff16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6f, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6g =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"
	});

	var Bookmark32 = /*#__PURE__*/React__default.forwardRef(function Bookmark32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6g, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6h =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"
	});

	var Bookmark24 = /*#__PURE__*/React__default.forwardRef(function Bookmark24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6h, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6i =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"
	});

	var Bookmark20 = /*#__PURE__*/React__default.forwardRef(function Bookmark20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6i, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6j =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"
	});

	var Bookmark16 = /*#__PURE__*/React__default.forwardRef(function Bookmark16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6j, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6k =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18 10H20V12H18zM12 10H14V12H12z"
	});

	var _ref3$20 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,20H21V18h1a2.0023,2.0023,0,0,0,2-2V12h2V10H24V8a2.0023,2.0023,0,0,0-2-2H20V2H18V6H14V2H12V6H10A2.0023,2.0023,0,0,0,8,8v2H6v2H8v4a2.0023,2.0023,0,0,0,2,2h1v2H6a2.0023,2.0023,0,0,0-2,2v8H6V22H26v8h2V22A2.0023,2.0023,0,0,0,26,20ZM10,8H22v8H10Zm3,10h6v2H13Z"
	});

	var Bot32 = /*#__PURE__*/React__default.forwardRef(function Bot32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6k, _ref3$20, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6l =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18 10H20V12H18zM12 10H14V12H12z"
	});

	var _ref3$21 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,20H21V18h1a2.0023,2.0023,0,0,0,2-2V12h2V10H24V8a2.0023,2.0023,0,0,0-2-2H20V2H18V6H14V2H12V6H10A2.0023,2.0023,0,0,0,8,8v2H6v2H8v4a2.0023,2.0023,0,0,0,2,2h1v2H6a2.0023,2.0023,0,0,0-2,2v8H6V22H26v8h2V22A2.0023,2.0023,0,0,0,26,20ZM10,8H22v8H10Zm3,10h6v2H13Z"
	});

	var Bot24 = /*#__PURE__*/React__default.forwardRef(function Bot24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6l, _ref3$21, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6m =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18 10H20V12H18zM12 10H14V12H12z"
	});

	var _ref3$22 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,20H21V18h1a2.0023,2.0023,0,0,0,2-2V12h2V10H24V8a2.0023,2.0023,0,0,0-2-2H20V2H18V6H14V2H12V6H10A2.0023,2.0023,0,0,0,8,8v2H6v2H8v4a2.0023,2.0023,0,0,0,2,2h1v2H6a2.0023,2.0023,0,0,0-2,2v8H6V22H26v8h2V22A2.0023,2.0023,0,0,0,26,20ZM10,8H22v8H10Zm3,10h6v2H13Z"
	});

	var Bot20 = /*#__PURE__*/React__default.forwardRef(function Bot20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6m, _ref3$22, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6n =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M18 10H20V12H18zM12 10H14V12H12z"
	});

	var _ref3$23 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,20H21V18h1a2.0023,2.0023,0,0,0,2-2V12h2V10H24V8a2.0023,2.0023,0,0,0-2-2H20V2H18V6H14V2H12V6H10A2.0023,2.0023,0,0,0,8,8v2H6v2H8v4a2.0023,2.0023,0,0,0,2,2h1v2H6a2.0023,2.0023,0,0,0-2,2v8H6V22H26v8h2V22A2.0023,2.0023,0,0,0,26,20ZM10,8H22v8H10Zm3,10h6v2H13Z"
	});

	var Bot16 = /*#__PURE__*/React__default.forwardRef(function Bot16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6n, _ref3$23, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6o =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"
	});

	var _ref3$24 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"
	});

	var Box32 = /*#__PURE__*/React__default.forwardRef(function Box32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6o, _ref3$24, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6p =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"
	});

	var _ref3$25 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"
	});

	var Box24 = /*#__PURE__*/React__default.forwardRef(function Box24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6p, _ref3$25, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6q =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"
	});

	var _ref3$26 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"
	});

	var Box20 = /*#__PURE__*/React__default.forwardRef(function Box20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6q, _ref3$26, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6r =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"
	});

	var _ref3$27 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"
	});

	var Box16 = /*#__PURE__*/React__default.forwardRef(function Box16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6r, _ref3$27, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6s =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22,6V4H12V6h4V8H12V20h4v2H12v2H22V22H18V20h4V8H18V6ZM14,18V15h6v3Zm6-5H14V10h6Z"
	});

	var _ref3$28 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
	});

	var BoxPlot32 = /*#__PURE__*/React__default.forwardRef(function BoxPlot32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6s, _ref3$28, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6t =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22,6V4H12V6h4V8H12V20h4v2H12v2H22V22H18V20h4V8H18V6ZM14,18V15h6v3Zm6-5H14V10h6Z"
	});

	var _ref3$29 =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
	});

	var BoxPlot24 = /*#__PURE__*/React__default.forwardRef(function BoxPlot24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6t, _ref3$29, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6u =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22,6V4H12V6h4V8H12V20h4v2H12v2H22V22H18V20h4V8H18V6ZM14,18V15h6v3Zm6-5H14V10h6Z"
	});

	var _ref3$2a =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
	});

	var BoxPlot20 = /*#__PURE__*/React__default.forwardRef(function BoxPlot20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6u, _ref3$2a, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6v =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M22,6V4H12V6h4V8H12V20h4v2H12v2H22V22H18V20h4V8H18V6ZM14,18V15h6v3Zm6-5H14V10h6Z"
	});

	var _ref3$2b =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"
	});

	var BoxPlot16 = /*#__PURE__*/React__default.forwardRef(function BoxPlot16(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 16,
	    height: 16,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6v, _ref3$2b, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6w =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"
	});

	var Branch32 = /*#__PURE__*/React__default.forwardRef(function Branch32(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 32,
	    height: 32,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6w, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6x =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"
	});

	var Branch24 = /*#__PURE__*/React__default.forwardRef(function Branch24(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 24,
	    height: 24,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6x, children);
	});

	/**
	 * Copyright IBM Corp. 2019, 2020
	 *
	 * This source code is licensed under the Apache-2.0 license found in the
	 * LICENSE file in the root directory of this source tree.
	 *
	 * Code generated by @carbon/icon-build-helpers. DO NOT EDIT.
	 */

	var _ref2$6y =
	/*#__PURE__*/

	/*#__PURE__*/
	React__default.createElement("path", {
	  d: "M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"
	});

	var Branch20 = /*#__PURE__*/React__default.forwardRef(function Branch20(_ref, ref) {
	  var children = _ref.children,
	      rest = _objectWithoutProperties$2(_ref, ["children"]);

	  return /*#__PURE__*/React__default.createElement(Icon, _extends$1({
	    width: 20,
	    height: 20,
	    viewBox: "0 0 32 32",
	    xmlns: "http://www.w3.org/2000/svg",
	    fill: "currentColor",
	    ref: ref
	  }, rest), _ref2$6y, children);
	});

	/**
	 * Copy